/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

var ofe_listeResponsable = new Arbre ("ComboListe/combo-responsables.tmpl","ofe-listeResponsable");
var ofe_listeAction = new Arbre ("ComboListe/combo-actionsTacheEvenement.tmpl","ofe-listeAction");

var globalEvenementProspectId = 0;
var globalEvenementContactId ="";
var modification = false;


function initofe_listeResponsable() {
	try {

		document.getElementById("ofe-listeResponsable").value = gProfil.getLoggedUser();
		setModifieEvent(false);

	} catch (e) {
		recup_erreur(e);
	}
}


function ofe_reporterDateDebut() {
	try {

		if (isEmpty(document.getElementById('ofe-DateFin').value)) {
			document.getElementById('ofe-DateFin').value = document.getElementById('ofe-DateDebut').value;
			document.getElementById('ofe-HeureFin').value = document.getElementById('ofe-HeureDebut').value;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ofeEnregistrer(quit) {
	try {
		var auth = false;
		var dateDebut = document.getElementById("ofe-DateDebut").value;
		var dateFin = document.getElementById("ofe-DateFin").value;
		var heureDebut = document.getElementById("ofe-HeureDebut").value;
		var heureFin = document.getElementById("ofe-HeureFin").value;

		if(dateDebut=="" || !isDate(dateDebut)) {
			showWarning("Date de d\u00E9but incorrecte");
		}else{
			if(dateFin=="" || !isDate(dateFin)) {
				showWarning("Date de fin incorrecte");
			}else{
				if(document.getElementById("ofe-Intitule").value=="") {
					showWarning("L'intitul\u00E9 ne peut \u00EAtre vide");
				}
				else{
					if(document.getElementById("ofe-Libelle").value=="") {
						showWarning("Le libell\u00E9 ne peut \u00EAtre vide");
					}else{
						if(globalEvenementProspectId==0) {
							showWarning("Veuillez s\u00E9lectionner un compte");
						}
						else {
							var dtDebut = convertXulDateTime(dateDebut, heureDebut);
							var dtFin = convertXulDateTime(dateFin, heureFin);

							if(!isStrictDateTimeInterval(dtDebut, dtFin)) {
								showWarning("La date de fin doit \u00EAtre ult\u00E9rieure \u00E0 la date de d\u00E9but");
							}else{
								auth = true;
							}
						}
					}
				}
			}
		}

		if(auth) {

			document.getElementById("bofe-Supprimer").disabled = false;
			var qSave = new QueryHttp("CRM/GestionTachesEvenements/saveEvenement.tmpl");

			qSave.setParam("Date_Debut",document.getElementById("ofe-DateDebut").value);
			qSave.setParam("Heure_Debut",document.getElementById("ofe-HeureDebut").value);
			qSave.setParam("Date_Fin",document.getElementById("ofe-DateFin").value);
			qSave.setParam("Heure_Fin",document.getElementById("ofe-HeureFin").value);
			qSave.setParam("Intitule",document.getElementById("ofe-Intitule").value);
			qSave.setParam("Myact",document.getElementById("ofe-listeAction").value);
			qSave.setParam("Libelle",document.getElementById("ofe-Libelle").value);
			qSave.setParam("Lieu",document.getElementById("ofe-Lieu").value);
			qSave.setParam("Responsable",document.getElementById("ofe-listeResponsable").value);
			qSave.setParam("EventId",globalEventId);
			qSave.setParam("Client_Id", globalEvenementProspectId);
			qSave.setParam("Contact_Id",globalEvenementContactId);

			var result = qSave.execute();
			globalEventId=result.responseXML.documentElement.getAttribute("Event_Id");
			document.getElementById("bofe-Supprimer").disabled= false;
			setModifieEvent(false);
			if(quit=="menu") {
				window.location = "chrome://opensi/content/crm/menu_principal.xul";
			}else if(quit=="liste") {
				window.location = "chrome://opensi/content/crm/gestion_tache_evenement/gestionTacheEvenement.xul";
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ofe_rechercherCompte() {
	try {

		var url = "chrome://opensi/content/crm/gestion_tache_evenement/popup-rechercheCompte.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', ofe_retourRechercherCompte);

	} catch (e) {
		recup_erreur(e);
	}
}


function ofe_retourRechercherCompte(clientId) {
	try {

		globalEvenementProspectId = clientId;
		globalEvenementContactId = "";
		document.getElementById("ofe-bRechercherContact").disabled = false;
		remplirInfoCompteEvent();
		initialiserContactEvent();
		setModifieEvent(true);

	} catch (e) {
		recup_erreur(e);
	}
}


function remplirInfoCompteEvent() {
	try {

		var qGetInfoCompte = new QueryHttp("CRM/GestionComptes/loadProspect.tmpl");
		qGetInfoCompte.setParam("Client_Id", globalEvenementProspectId);
		var result = qGetInfoCompte.execute();

		var contenu = result.responseXML.documentElement;

		document.getElementById("ofe-DenomCompte").value = contenu.getAttribute("Denomination");
		document.getElementById("ofe-adresse1-compte").value = contenu.getAttribute("Adresse_1");
		document.getElementById("ofe-adresse2-compte").value = contenu.getAttribute("Adresse_2");
		document.getElementById("ofe-adresse3-compte").value = contenu.getAttribute("Adresse_3");
		document.getElementById("ofe-CP-compte").value = contenu.getAttribute("Code_Postal");
		document.getElementById("ofe-Ville-compte").value = contenu.getAttribute("Ville");
		document.getElementById("ofe-Tel-compte").value = contenu.getAttribute("Tel");
		document.getElementById("ofe-Fax-compte").value = contenu.getAttribute("Fax");
		document.getElementById("ofe-Mail-compte").value = contenu.getAttribute("Email");
		document.getElementById("ofe-Pays-compte").value=contenu.getAttribute("Nom_Pays");

	} catch (e) {
		recup_erreur(e);
	}
}


function initialiserContactEvent() {
	try {

		document.getElementById("ofe-DenomContact").value = "";
		document.getElementById("ofe-adresse1-contact").value = "";
		document.getElementById("ofe-adresse2-contact").value = "";
		document.getElementById("ofe-adresse3-contact").value = "";
		document.getElementById("ofe-CP-contact").value = "";
		document.getElementById("ofe-Ville-contact").value = "";
		document.getElementById("ofe-Pays-contact").value = "";
		document.getElementById("ofe-Tel1-contact").value = "";
		document.getElementById("ofe-Tel2-contact").value = "";
		document.getElementById("ofe-Fax-contact").value = "";
		document.getElementById("ofe-Mail-contact").value = "";
		globalEvenementContactId ="";

	} catch (e) {
		recup_erreur(e);
	}
}


function ofe_rechercherContact() {
	try {

		var url = "chrome://opensi/content/crm/gestion_tache_evenement/popup-rechercheContact.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', ofe_retourRechercherContact, globalEvenementProspectId);

	} catch (e) {
		recup_erreur(e);
	}
}


function ofe_retourRechercherContact(contactId) {
	try {

		globalEvenementContactId = contactId;
		remplirContactEvenement();

	} catch (e) {
		recup_erreur(e);
	}
}


function remplirContactEvenement() {
	try {

		if(globalEvenementContactId!="") {
			var qLoad = new QueryHttp("CRM/GestionContacts/loadContactClient.tmpl");
			qLoad.setParam("Contact_Id", globalEvenementContactId);
			var result = qLoad.execute();

			var civilite = result.responseXML.documentElement.getAttribute("Civilite");
			if(civilite==1) {
				civilite="M.";
			} else {
				if(civilite==2) {
					civilite="Mme";
				} else {
					civilite = "Mlle";
				}
			}
			var nom = result.responseXML.documentElement.getAttribute("Nom");
			var prenom = result.responseXML.documentElement.getAttribute("Prenom");
			var denom = civilite+" "+nom+" "+prenom;

			document.getElementById("ofe-DenomContact").value=denom;
			document.getElementById("ofe-adresse1-contact").value=result.responseXML.documentElement.getAttribute("Adresse_1");
			document.getElementById("ofe-adresse2-contact").value=result.responseXML.documentElement.getAttribute("Adresse_2");
			document.getElementById("ofe-adresse3-contact").value=result.responseXML.documentElement.getAttribute("Adresse_3");
			document.getElementById("ofe-CP-contact").value=result.responseXML.documentElement.getAttribute("Code_Postal");
			document.getElementById("ofe-Ville-contact").value=result.responseXML.documentElement.getAttribute("Ville");
			document.getElementById("ofe-Tel1-contact").value=result.responseXML.documentElement.getAttribute("Tel_1");
			document.getElementById("ofe-Tel2-contact").value=result.responseXML.documentElement.getAttribute("Tel_2");
			document.getElementById("ofe-Fax-contact").value=result.responseXML.documentElement.getAttribute("Fax");
			document.getElementById("ofe-Mail-contact").value=result.responseXML.documentElement.getAttribute("Email");
			document.getElementById("ofe-Pays-contact").value = result.responseXML.documentElement.getAttribute("Pays");
			document.getElementById("ofe-bSupprimer").disabled = false;
			setModifieEvent(true);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ofepressOnSupprimer() {
	try {

		if (window.confirm("Voulez-vous supprimer cet \u00E9v\u00E8nement ?")) {
			var qDelete = new QueryHttp("CRM/GestionTachesEvenements/deleteEvenement.tmpl");
			qDelete.setParam("Event_Id",globalEventId);
			qDelete.execute(ofeNouvelEvenement);
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function ofeNouvelEvenement() {
	try {

		var go = true;
		if(modification) {
			go = window.confirm("Il y a des informations non sauvegard\u00E9es, voulez vous vraiment quitter ?");
		}
		if(go) {
			globalEventId="";
			globalEvenementProspectId = 0;
			globalEvenementContactId ="";
			document.getElementById("ofe-DateDebut").value = "";
			document.getElementById("ofe-HeureDebut").value = "12:00";
			document.getElementById("ofe-DateFin").value = "";
			document.getElementById("ofe-HeureFin").value = "12:00";
			document.getElementById("ofe-Intitule").value = "";
			document.getElementById("ofe-listeAction").value = "";
			document.getElementById("ofe-Lieu").value = "";
			document.getElementById("ofe-Libelle").value = "";
			document.getElementById("bofe-Supprimer").disabled=true;
			document.getElementById("StatBarofe-Creation-event").setAttribute("label", "");
			document.getElementById("StatBarofe-Modification-event").setAttribute("label", "");
			initialiserContactEvent();
			initialiserCompteEvent();
			setModifieEvent(false);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function initialiserCompteEvent() {
	try {

		document.getElementById("ofe-DenomCompte").value = "";
		document.getElementById("ofe-adresse1-compte").value = "";
		document.getElementById("ofe-adresse2-compte").value = "";
		document.getElementById("ofe-adresse3-compte").value = "";
		document.getElementById("ofe-CP-compte").value = "";
		document.getElementById("ofe-Ville-compte").value = "";
		document.getElementById("ofe-Tel-compte").value = "";
		document.getElementById("ofe-Fax-compte").value = "";
		document.getElementById("ofe-Mail-compte").value = "";
		document.getElementById("ofe-Pays-compte").value = "";
		globalEvenementProspectId="";
		document.getElementById("ofe-bRechercherContact").disabled=true;
		document.getElementById("ofe-bSupprimer").disabled=true;
		document.getElementById("bofe-Supprimer").disabled=true;

	} catch (e) {
  	recup_erreur(e);
	}
}


function setModifieEvent(m) {
	try {

		modification = m;
		if(m) {
  		document.getElementById('ofe-image-modif').setAttribute('src', 'chrome://opensi/content/design/icones/modified.png');
		}
		else {
  		document.getElementById('ofe-image-modif').setAttribute('src', '');
  	}

	} catch (e) {
		recup_erreur(e);
	}
}
