/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

var oft_listeResponsable = new Arbre ("ComboListe/combo-responsables.tmpl","oft-listeResponsable");
var	oft_listePays = new Arbre("ComboListe/combo-pays.tmpl","oft-listePays");
var oft_listeAction = new Arbre("ComboListe/combo-actionsTacheEvenement.tmpl","oft-listeAction");

var globalTacheProspectId = 0;
var globalTacheContactId ="";
var modifie = false;


function initoft_listeResponsable() {
	try {

		document.getElementById("oft-listeResponsable").value = respTache;
		setModifie(false);

	} catch (e) {
		recup_erreur(e);
	}
}


function initoft_listePays() {
	try {

		document.getElementById("oft-listePays").value = "FR";

	} catch (e) {
		recup_erreur(e);
	}
}


function oftEnregistrer(quit) {
	try {

		if (document.getElementById("oft-DateT").value=="" || !isDate(document.getElementById("oft-DateT").value)) {
			showWarning("Date incorrecte");
		}
		else if (document.getElementById("oft-Intitule").value=="" ) {
			showWarning("L'intitule ne doit pas \u00EAtre vide");
		}
		else if(document.getElementById("oft-DenomCompte").value=="") {
			showWarning("Veuillez choisir un compte associ\u00E9");
		}
		else {
			document.getElementById("boft-Supprimer").disabled = false;

			var qSave = new QueryHttp("CRM/GestionTachesEvenements/saveTache.tmpl");

			qSave.setParam("Etat", document.getElementById("oft-listeEtats").value);
			qSave.setParam("Responsable", document.getElementById("oft-listeResponsable").value);
			qSave.setParam("Date", document.getElementById("oft-DateT").value);
			qSave.setParam("Heure", document.getElementById("oft-HeureT").value);
			qSave.setParam("Priorite", document.getElementById("oft-listePriorite").value);
			qSave.setParam("Intitule", document.getElementById("oft-Intitule").value);
			qSave.setParam("var_Action", document.getElementById("oft-listeAction").value);
			qSave.setParam("Libelle", document.getElementById("oft-libelle").value);
			qSave.setParam("TacheId", globalTacheId);
			qSave.setParam("Client_Id", globalTacheProspectId);
			qSave.setParam("Contact", globalTacheContactId);

			var result = qSave.execute();
			setModifie(false);
			globalTacheId = result.responseXML.documentElement.getAttribute("Tache_Id");

			if (quit=="menu") {
				window.location = "chrome://opensi/content/crm/menu_principal.xul";
			}
			else if (quit=="liste") {
				window.location = "chrome://opensi/content/crm/gestion_tache_evenement/gestionTacheEvenement.xul";
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oftNouvelleTache() {
	try {

		if(!modifie) {
			document.getElementById("StatBaroft-Creation").setAttribute("label", "");
			document.getElementById("StatBaroft-Modification").setAttribute("label", "");

			globalTacheId = "";
			var globalTacheProspectId = 0;
			var globalTacheContactId ="";

			document.getElementById("oft-listeEtats").value = "N";
			document.getElementById("oft-listeResponsable").value = gProfil.getLoggedUser();
			document.getElementById("oft-DateT").value = "";
			document.getElementById("oft-HeureT").value = "12:00";
			document.getElementById("oft-listePriorite").value = "N";
			document.getElementById("oft-Intitule").value = "";
			document.getElementById("oft-listeAction").value = "";
			document.getElementById("oft-libelle").value = "";

			document.getElementById("oft-DenomCompte").value = "";
			document.getElementById("adresse1-compte").value = "";
			document.getElementById("adresse2-compte").value = "";
			document.getElementById("adresse3-compte").value = "";
			document.getElementById("CP-compte").value = "";
			document.getElementById("Ville-compte").value = "";
			document.getElementById("Pays-compte").value = "";
			document.getElementById("Tel-compte").value = "";
			document.getElementById("Fax-compte").value = "";
			document.getElementById("Mail-compte").value = "";

			document.getElementById("oft-DenomContact").value = "";
			document.getElementById("adresse1-contact").value = "";
			document.getElementById("CP-contact").value = "";
			document.getElementById("Ville-contact").value = "";
			document.getElementById("Pays-contact").value = "";
			document.getElementById("oft-DenomContact").value = "";
			document.getElementById("Tel1-contact").value = "";
			document.getElementById("Tel2-contact").value = "";
			document.getElementById("Fax-contact").value = "";
			document.getElementById("Mail-contact").value = "";

			setModifie(false);
			document.getElementById("boft-Supprimer").disabled = true;
		}
		else {
			if (window.confirm("Il y a des informations non sauvegard\u00E9es, voulez vous vraiment quitter ?")) {
				setModifie(false);
				oftNouvelleTache();
			}
		}

	} catch(e) {
		recup_erreur(e);
	}
}


function remplirInfoCompte() {
	try {

		var qGetInfoCompte = new QueryHttp("CRM/GestionComptes/loadProspect.tmpl");
		qGetInfoCompte.setParam("Client_Id", globalTacheProspectId);
		var result = qGetInfoCompte.execute();

		var contenu = result.responseXML.documentElement;

		document.getElementById("oft-DenomCompte").value = contenu.getAttribute("Denomination");
		document.getElementById("adresse1-compte").value = contenu.getAttribute("Adresse_1");
		document.getElementById("adresse2-compte").value = contenu.getAttribute("Adresse_2");
		document.getElementById("adresse3-compte").value = contenu.getAttribute("Adresse_3");
		document.getElementById("CP-compte").value = contenu.getAttribute("Code_Postal");
		document.getElementById("Ville-compte").value = contenu.getAttribute("Ville");
		document.getElementById("Tel-compte").value = contenu.getAttribute("Tel");
		document.getElementById("Fax-compte").value = contenu.getAttribute("Fax");
		document.getElementById("Mail-compte").value = contenu.getAttribute("Email");
		document.getElementById("Pays-compte").value = contenu.getAttribute("Nom_Pays");

	} catch(e) {
		recup_erreur(e);
	}
}


function initialiserContact() {
	try {

		document.getElementById("oft-DenomContact").value = "";
		document.getElementById("adresse1-contact").value = "";
		document.getElementById("adresse2-contact").value = "";
		document.getElementById("adresse3-contact").value = "";
		document.getElementById("CP-contact").value = "";
		document.getElementById("Ville-contact").value = "";
		document.getElementById("Pays-contact").value = "";
		document.getElementById("oft-DenomContact").value = "";
		document.getElementById("Tel1-contact").value = "";
		document.getElementById("Tel2-contact").value = "";
		document.getElementById("Fax-contact").value = "";
		document.getElementById("Mail-contact").value = "";

		globalTacheContactId = "";

	} catch (e) {
		recup_erreur(e);
	}
}


function oft_supprimerContact() {
	try {

		initialiserContact();
		globalTacheContactId = "";

	} catch (e) {
		recup_erreur(e);
	}
}


function remplirContact() {
	try {

		var qLoad = new QueryHttp("CRM/GestionContacts/loadContactClient.tmpl");
		qLoad.setParam("Contact_Id", globalTacheContactId);
		var result = qLoad.execute();

		var civilite = result.responseXML.documentElement.getAttribute("Civilite");
		if(civilite==1) {
			civilite="M.";
		} else {
			if(civilite==2) {
				civilite="Mme";
			} else {
				civilite = "Mlle";
			}
		}
		var nom = result.responseXML.documentElement.getAttribute("Nom");
		var prenom = result.responseXML.documentElement.getAttribute("Prenom");

		document.getElementById("oft-DenomContact").value = civilite +" "+ nom +" "+ prenom;
		document.getElementById("adresse1-contact").value=result.responseXML.documentElement.getAttribute("Adresse_1");
		document.getElementById("adresse2-contact").value=result.responseXML.documentElement.getAttribute("Adresse_2");
		document.getElementById("adresse3-contact").value=result.responseXML.documentElement.getAttribute("Adresse_3");
		document.getElementById("CP-contact").value=result.responseXML.documentElement.getAttribute("Code_Postal");
		document.getElementById("Ville-contact").value=result.responseXML.documentElement.getAttribute("Ville");
		document.getElementById("Tel1-contact").value=result.responseXML.documentElement.getAttribute("Tel_1");
		document.getElementById("Tel2-contact").value=result.responseXML.documentElement.getAttribute("Tel_2");
		document.getElementById("Fax-contact").value=result.responseXML.documentElement.getAttribute("Fax");
		document.getElementById("Mail-contact").value=result.responseXML.documentElement.getAttribute("Email");
		document.getElementById("Pays-contact").value = result.responseXML.documentElement.getAttribute("Pays");

	} catch (e) {
		recup_erreur(e);
	}
}


function oft_rechercherContact() {
	try {

		var url = "chrome://opensi/content/crm/gestion_tache_evenement/popup-rechercheContact.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', oft_retourRechercherContact, globalTacheProspectId);

	} catch (e) {
		recup_erreur(e);
	}
}


function oft_retourRechercherContact(contactId) {
	try {

		globalTacheContactId = contactId;
		setModifie(true);
		remplirContact();

	} catch (e) {
		recup_erreur(e);
	}
}


function oft_rechercherCompte() {
	try {

		var url = "chrome://opensi/content/crm/gestion_tache_evenement/popup-rechercheCompte.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oft_retourRechercherCompte);

	} catch (e) {
		recup_erreur(e);
	}
}


function oft_retourRechercherCompte(clientId) {
	try {

		globalTacheProspectId = clientId;
		document.getElementById("bRechercherContact").disabled = false;
		remplirInfoCompte();
		initialiserContact();
		setModifie(true);

	} catch (e) {
		recup_erreur(e);
	}
}


function oftpressOnSupprimer() {
	try {

		if (window.confirm("Voulez-vous supprimer cette t\u00E2che ?")) {
			var qDelete = new QueryHttp("CRM/GestionTachesEvenements/deleteTache.tmpl");
			qDelete.setParam("Tache_Id",globalTacheId);
			qDelete.execute(oftNouvelleTache);
			setModifie(false);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function setModifie(m) {
  try {

  	modifie = m;
  	if(m) {
  		document.getElementById('oft-image-modif').setAttribute('src', 'chrome://opensi/content/design/icones/modified.png');
  	}
		else {
  		document.getElementById('oft-image-modif').setAttribute('src', '');
  	}

	} catch (e) {
  	recup_erreur(e);
	}
}
