/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");


var aComptes = new Arbre("CRM/GestionComptes/list-prospect.tmpl", "listeComptes");

var qListCP = new QueryHttp("CRM/GestionComptes/getDataListCP.tmpl");

var pageCourante;
var nbPages;

var profil;



function init() {
	try {

		profil = getProfil();

		document.getElementById("denomination").focus();

		if (profil.isDirection()) {
			document.getElementById("labelListeResponsable").collapsed = false;
			document.getElementById("listeResponsable").collapsed = false;
		}
		else {
			document.getElementById("labelListeResponsable").collapsed = true;
			document.getElementById("listeResponsable").collapsed = true;
		}

		var aResp = new Arbre("ComboListe/combo-responsables.tmpl", "listeResponsable");
  	aResp.initTree(initResponsable);

		var aPays = new Arbre("ComboListe/combo-pays.tmpl", "listePays");
  	aPays.initTree();

		var atypes = new Arbre("ComboListe/combo-typesProspect.tmpl", "listeType");
		atypes.initTree();

	} catch(e) {
		recup_erreur(e);
	}
}


function initResponsable() {
	try {

		document.getElementById("listeResponsable").value = profil.getLoggedUser();

	} catch (e) {
		recup_erreur(e);
	}
}


function initCriteres() {
	try {

		document.getElementById("denomination").value = "";
		document.getElementById("codePostal").value = "";
		document.getElementById("numClient").value = "";
		document.getElementById("listeType").value = "";
		document.getElementById("listePays").value = "";
		document.getElementById("contact").value = "";
		document.getElementById("listeResponsable").value = profil.getLoggedUser();
		document.getElementById("actif").checked = true;

		listerComptes();

	} catch (e) {
		recup_erreur(e);
	}
}


function listerComptes() {
	try {

		var denomination = document.getElementById("denomination").value;
		var typeProspect = document.getElementById("listeType").value;
		var codePostal = document.getElementById("codePostal").value;
		var responsable = document.getElementById("listeResponsable").value;
		var codePays = document.getElementById("listePays").value;
		var numClient = document.getElementById("numClient").value;
		var contact = document.getElementById("contact").value;
		var actif = document.getElementById("actif").checked;
		var projet = "";
		var poleActivite = "";
		var nbLignesParPage = document.getElementById('nbLignesParPage').value;

		pageCourante = 1;
		nbPages = 1;
		document.getElementById('pageDeb').value = 1;
		document.getElementById('pageFin').value = 1;
		document.getElementById('bPrec').disabled = true;
		document.getElementById('bSuiv').disabled = true;

		document.getElementById('listeComptes').disabled = true;
		aComptes.deleteTree();

		qListCP.setParam("Denomination", denomination);
		qListCP.setParam("Type", typeProspect);
		qListCP.setParam("Code_Postal", codePostal);
		qListCP.setParam("Responsable", responsable);
		qListCP.setParam("Code_Pays", codePays);
		qListCP.setParam("Num_Client", numClient);
		qListCP.setParam("Contact", contact);
		qListCP.setParam("Actif", actif);
		qListCP.setParam("Projet", projet);
		qListCP.setParam("Pole_Activite", poleActivite);
		qListCP.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
		qListCP.setParam("Current_Page", pageCourante);

		var result = qListCP.execute();

		var contenu = result.responseXML.documentElement;

		nbPages = contenu.getAttribute("Nb_Pages");
		var listClientId = contenu.getAttribute("List_Client_Id");

		aComptes.setParam("List_Client_Id", listClientId);
		aComptes.initTree(initPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function initPagination() {
	try {

		document.getElementById('pageDeb').value = pageCourante;
		document.getElementById('pageFin').value = (nbPages>0?nbPages:1);
		document.getElementById('bPrec').disabled = (pageCourante==1);
		document.getElementById('bSuiv').disabled = (pageCourante>=nbPages); // peut se produire si nbPages=0

		afterMajPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnPagePrec() {
	try {

		pageCourante--;
		majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnPageSuiv() {
	try {

		pageCourante++;
		majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function majPagination() {
	try {

		document.getElementById('pageDeb').value = pageCourante;
		document.getElementById('bPrec').disabled = (pageCourante==1);
		document.getElementById('bSuiv').disabled = (pageCourante==nbPages);

		document.getElementById('listeComptes').disabled = true;

		qListCP.setParam("Current_Page", pageCourante);
		var result = qListCP.execute();
		var listClientId = result.responseXML.documentElement.getAttribute("List_Client_Id");

		aComptes.setParam("List_Client_Id", listClientId);
		aComptes.initTree(afterMajPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function afterMajPagination() {
	try {

		document.getElementById('listeComptes').disabled = false;

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnCritere(ev) {
  try {

		if (ev.keyCode==13) {
			listerComptes();
    }

	} catch (e) {
  	recup_erreur(e);
  }
}


function pressOnTree(ev) {
  try {

    if (ev.keyCode==13) {
			ouvrirCompte();
  	}

  } catch (e) {
    recup_erreur(e);
  }
}


function ouvrirCompte() {
	try {

		if (aComptes.isSelected()) {
			var clientId = aComptes.getSelectedCellText('Client_Id');
			window.arguments[0](clientId);
			setTimeout("window.close()",0); // pour fermeture si fonction appele d'un autre popup
		}

	}	catch (e) {
		recup_erreur(e);
	}
}
