/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

var omm_aModeles = new Arbre("Facturation/Abonnements/list-modeleAbonnement.tmpl", "omm-listeModeles");
var omm_aApercuModele = new Arbre("Facturation/Abonnements/list-apercuModeleAbonnement.tmpl", "omm-apercu");
var omm_qListMA = new QueryHttp("Facturation/Abonnements/getDataListMA.tmpl");

var omm_pageCourante;
var omm_nbPages;

var omm_restrictedPoleActivite = "";



function omm_init() {
  try {

		if (gProfil.isRestricAccCDVPA() && !isEmpty(gProfil.getPoleActivite())) {
			omm_restrictedPoleActivite = gProfil.getPoleActivite();
			document.getElementById('omm-poleActivite').disabled = true;
		}

		var aDurees = new Arbre("ComboListe/combo-dureesModeleAbonnement.tmpl", "omm-duree");
		aDurees.initTree();

		var aResponsables = new Arbre("ComboListe/combo-responsables.tmpl", "omm-responsable");
		aResponsables.initTree();

		var aPolesActivite = new Arbre("ComboListe/combo-polesActivite.tmpl", "omm-poleActivite");
		if (!isEmpty(omm_restrictedPoleActivite)) {
			aPolesActivite.setParam("Selection", omm_restrictedPoleActivite);
		}
		aPolesActivite.initTree(omm_initCriteres);

  } catch (e) {
  	recup_erreur(e);
  }
}


function omm_initCriteres() {
	try {

		document.getElementById('omm-refModele').value = "";
		document.getElementById('omm-duree').value = "";
		document.getElementById('omm-typeReconduction').value = "";
		document.getElementById('omm-refArticle').value = "";
		document.getElementById('omm-intitule').value = "";
		document.getElementById('omm-poleActivite').value = omm_restrictedPoleActivite;
		document.getElementById('omm-responsable').selectedIndex = 0;

		omm_listerModeles();

	} catch (e) {
		recup_erreur(e);
	}
}


function omm_listerModeles() {
	try {

		var refModele = document.getElementById('omm-refModele').value;
		var duree = document.getElementById('omm-duree').value;
		var typeReconduction = document.getElementById('omm-typeReconduction').value;
		var refArticle = document.getElementById('omm-refArticle').value;
		var poleActivite = document.getElementById('omm-poleActivite').value;
		var intitule = document.getElementById('omm-intitule').value;
		var responsable = document.getElementById('omm-responsable').value;
		var nbLignesParPage = document.getElementById('omm-nbLignesParPage').value;

		omm_pageCourante = 1;
		omm_nbPages = 1;
		document.getElementById('omm-pageDeb').value = 1;
		document.getElementById('omm-pageFin').value = 1;
		document.getElementById('omm-bPrec').disabled = true;
		document.getElementById('omm-bSuiv').disabled = true;

		document.getElementById('omm-listeModeles').disabled = true;
		document.getElementById('omm-bEditionCsv').disabled = true;
		document.getElementById('omm-refModeleSelect').value = "";
		omm_aApercuModele.deleteTree();
		omm_aModeles.deleteTree();

		omm_qListMA.setParam("Ref_Modele", refModele);
		omm_qListMA.setParam("Duree", duree);
		omm_qListMA.setParam("Type_Reconduction", typeReconduction);
		omm_qListMA.setParam("Ref_Article", refArticle);
		omm_qListMA.setParam("Intitule", intitule);
		omm_qListMA.setParam("Responsable", responsable);
		omm_qListMA.setParam("Pole_Activite", poleActivite);
		omm_qListMA.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
		omm_qListMA.setParam("Current_Page", omm_pageCourante);

		var result = omm_qListMA.execute();

		var contenu = result.responseXML.documentElement;

		omm_nbPages = contenu.getAttribute("Nb_Pages");
		var listModeleId = contenu.getAttribute("List_Modele_Id");

		omm_aModeles.setParam("List_Modele_Id", listModeleId);
		omm_aModeles.initTree(omm_initPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function omm_initPagination() {
	try {

		document.getElementById('omm-pageDeb').value = omm_pageCourante;
		document.getElementById('omm-pageFin').value = (omm_nbPages>0?omm_nbPages:1);
		document.getElementById('omm-bPrec').disabled = (omm_pageCourante==1);
		document.getElementById('omm-bSuiv').disabled = (omm_pageCourante>=omm_nbPages); // peut se produire si omm_nbPages=0

		omm_afterMajPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function omm_pressOnPagePrec() {
	try {

		omm_pageCourante--;
		omm_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function omm_pressOnPageSuiv() {
	try {

		omm_pageCourante++;
		omm_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function omm_majPagination() {
	try {

		document.getElementById('omm-pageDeb').value = omm_pageCourante;
		document.getElementById('omm-bPrec').disabled = (omm_pageCourante==1);
		document.getElementById('omm-bSuiv').disabled = (omm_pageCourante==omm_nbPages);

		document.getElementById('omm-refModeleSelect').value = "";

		document.getElementById('omm-listeModeles').disabled = true;
		document.getElementById('omm-bEditionCsv').disabled = true;
		omm_aApercuModele.deleteTree();

		omm_qListMA.setParam("Current_Page", omm_pageCourante);
		var result = omm_qListMA.execute();
		var listModeleId = result.responseXML.documentElement.getAttribute("List_Modele_Id");

		omm_aModeles.setParam("List_Modele_Id", listModeleId);
		omm_aModeles.initTree(omm_afterMajPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function omm_afterMajPagination() {
	try {

		document.getElementById('omm-listeModeles').disabled = false;
		document.getElementById('omm-bEditionCsv').disabled=(omm_aModeles.nbLignes()==0);

	} catch (e) {
		recup_erreur(e);
	}
}


function omm_selectOnListeModeles() {
	try {

		if (omm_aModeles.isSelected()) {
			var modeleId = omm_aModeles.getSelectedCellText('omm-colModeleId');
			document.getElementById('omm-refModeleSelect').value = omm_aModeles.getSelectedCellText('omm-colRefModele');
			omm_aApercuModele.setParam("Modele_Id", modeleId);
			omm_aApercuModele.initTree();

			var editionTTC = (omm_aModeles.getSelectedCellText("omm-colEditionTTC")=="true");
			document.getElementById('omm-amColMontant').setAttribute("label", editionTTC?"Montant TTC":"Montant HT");
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omm_pressOnNouveauModele() {
	try {

		document.getElementById('deck').selectedIndex = 3;
		document.getElementById('bMenuModeles').collapsed = false;
		document.getElementById('bMenuContrats').collapsed = true;
		document.getElementById('bMenuFacturation').collapsed = true;
		oem_nouveauModele();

	} catch (e) {
		recup_erreur(e);
	}
}


function omm_pressOnCritere(ev) {
  try {

		if (ev.keyCode==13) {
			omm_listerModeles();
    }

	} catch (e) {
  	recup_erreur(e);
  }
}


function omm_pressOnListeModeles(ev) {
  try {

		if (ev.keyCode==13) {
			omm_ouvrirModele();
    }

	} catch (e) {
  	recup_erreur(e);
  }
}


function omm_ouvrirModele() {
  try {

  	if (omm_aModeles.isSelected()) {
			oem_modeleId = omm_aModeles.getSelectedCellText('omm-colModeleId');
			oem_chargerModele();
			document.getElementById('bMenuModeles').collapsed = false;
			document.getElementById('bMenuContrats').collapsed = true;
			document.getElementById('bMenuFacturation').collapsed = true;
			document.getElementById('deck').selectedIndex = 3;
  	}

	} catch (e) {
  	recup_erreur(e);
  }
}


function omm_pressOnEditionCsv() {
	try {

		var refModele = document.getElementById('omm-refModele').value;
		var duree = document.getElementById('omm-duree').value;
		var typeReconduction = document.getElementById('omm-typeReconduction').value;
		var refArticle = document.getElementById('omm-refArticle').value;
		var poleActivite = document.getElementById('omm-poleActivite').value;
		var intitule = document.getElementById('omm-intitule').value;
		var responsable = document.getElementById('omm-responsable').value;

		var qEditionCsv = new QueryHttp("Facturation/Abonnements/csvModeleAbonnement.tmpl");

		qEditionCsv.setParam("Ref_Modele", refModele);
		qEditionCsv.setParam("Duree", duree);
		qEditionCsv.setParam("Type_Reconduction", typeReconduction);
		qEditionCsv.setParam("Ref_Article", refArticle);
		qEditionCsv.setParam("Intitule", intitule);
		qEditionCsv.setParam("Responsable", responsable);
		qEditionCsv.setParam("Pole_Activite", poleActivite);

		var result = qEditionCsv.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');

			var file = fileChooser("save", fichier);
			if (file!=null) {
				downloadFile(getDirBuffer()+ fichier, file);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omm_rechercherArticle() {
	try {

		var url = "chrome://opensi/content/facturation/user/articles/popup-rechercheArticle.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', omm_retourRechercherArticle);

	} catch (e) {
		recup_erreur(e);
	}
}


function omm_retourRechercherArticle(reference, articleId) {
	try {

  	document.getElementById('omm-refArticle').value = reference;
  	omm_listerModeles();

	} catch (e) {
		recup_erreur(e);
	}
}
