/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/lib_tva.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/calculDocument.js");


var etablissementDefaut;
var depotDefaut;

var gProfil;
var gReadOnly;
var gConfig;
var gShowFax;
var gAccesCoutAchat;



function init() {
  try {

  	window.parent.addEventListener("close", demandeEnregistrement, false);

		gProfil = getProfil();
		gReadOnly = gProfil.isReadOnlyGC_VAffaires();
		gAccesCoutAchat = gProfil.isAccesCoutAchat();

		gConfig = getConfig();
		gShowFax = gConfig.isShowFax();

		var qAttPrinc = new QueryHttp("Facturation/Commun/getAttributsPrincipaux.tmpl");
		var result = qAttPrinc.execute();

		var contenu = result.responseXML.documentElement;

		for (var i=1; i<=6; i++) {
			if (!isEmpty(contenu.getAttribute("Groupe_Id_"+ i))) {
				var intituleGroupe = contenu.getAttribute("Intitule_"+ i);
				document.getElementById("oec-colAttribut"+ i).setAttribute("label", intituleGroupe);
				document.getElementById("oef-colAttribut"+ i).setAttribute("label", intituleGroupe);
				document.getElementById("oea-colAttribut"+ i).setAttribute("label", intituleGroupe);
				document.getElementById("oeb-colAttribut"+ i +"Dev").setAttribute("label", intituleGroupe);
				document.getElementById("oer-colAttribut"+ i +"Dev").setAttribute("label", intituleGroupe);
			}
			else {
				document.getElementById("oec-colAttribut"+ i).collapsed = true;
				document.getElementById("oef-colAttribut"+ i).collapsed = true;
				document.getElementById("oea-colAttribut"+ i).collapsed = true;
				document.getElementById("oeb-colAttribut"+ i +"Dev").collapsed = true;
				document.getElementById("oer-colAttribut"+ i +"Dev").collapsed = true;
				document.getElementById("oec-colAttribut"+ i).setAttribute("ignoreincolumnpicker", true);
				document.getElementById("oef-colAttribut"+ i).setAttribute("ignoreincolumnpicker", true);
				document.getElementById("oea-colAttribut"+ i).setAttribute("ignoreincolumnpicker", true);
				document.getElementById("oeb-colAttribut"+ i +"Dev").setAttribute("ignoreincolumnpicker", true);
				document.getElementById("oer-colAttribut"+ i +"Dev").setAttribute("ignoreincolumnpicker", true);
			}
		}

		etablissementDefaut = gProfil.getEtabId();

		var qDepotDefaut = new QueryHttp("Facturation/Commun/getDepotDefautEts.tmpl");
		qDepotDefaut.setParam("Etablissement_Id", etablissementDefaut);
		result = qDepotDefaut.execute();
		depotDefaut = result.responseXML.documentElement.getAttribute('Depot_Defaut');

  	oma_init();
		ofa_init();
		oec_init();
		oeb_init();
		oer_init();
		oef_init();
		oea_init();
		document.getElementById('deck').selectedIndex = 0;

		if (!isEmpty(ParamValeur("Affaire_Id"))) {
			ofa_affaireId = ParamValeur("Affaire_Id");
			ofa_chargerAffaire();
			document.getElementById("bMenuAffaires").collapsed = false;
			document.getElementById("deck").selectedIndex = 1;
		}
		else if (!isEmpty(ParamValeur("Commande_Id"))) {
			oec_commandeId = ParamValeur("Commande_Id");
			oec_chargerCommande();
			document.getElementById("bMenuAffaires").collapsed = false;
			document.getElementById('bRetourAffaire').collapsed = false;
			document.getElementById('deck').selectedIndex = 2;
		}
		else if (!isEmpty(ParamValeur("Retour_Id"))) {
			oer_retourId = ParamValeur("Retour_Id");
			oer_chargerBon();
			document.getElementById("bMenuAffaires").collapsed = false;
			document.getElementById('bRetourAffaire').collapsed = false;
			document.getElementById('deck').selectedIndex = 7;
			if (ParamValeur("Origine")=="MenuRetours") {
				document.getElementById("bMenuRetours").collapsed = false;
			}
		}
		else if (!isEmpty(ParamValeur("Avoir_Id"))) {
			ofa_affaireId = ParamValeur("Avoir_Affaire_Id");
			oea_avoirId = ParamValeur("Avoir_Id");
			oea_chargerAvoir();
			document.getElementById("bMenuAffaires").collapsed = false;
			document.getElementById('bRetourAffaire').collapsed = false;
			document.getElementById('deck').selectedIndex = 6;
		}

		document.getElementById('bcAccesCoutAchat').collapsed = !gAccesCoutAchat;

		document.getElementById('deck').collapsed = false;

	} catch (e) {
    recup_erreur(e);
  }
}


function desinit() {
	try {

		window.parent.removeEventListener("close", demandeEnregistrement, false);

	} catch (e) {
    recup_erreur(e);
  }
}


function ouvrirLienMail(id) {
	try {

		window.location = 'mailto:'+ document.getElementById(id).value;

	} catch (e) {
		recup_erreur(e);
	}
}


function retourMenuAffaires() {
	try {

		resetAllPDF();
		document.getElementById('deck').selectedIndex = 0;
		document.getElementById('oma-deckMenuAffaires').selectedIndex = 0;
		document.getElementById('bRetourCommande').collapsed = true;
		document.getElementById('bRetourFacture').collapsed = true;
		document.getElementById('bRetourAvoir').collapsed = true;
		document.getElementById('bRetourAffaire').collapsed = true;
		document.getElementById('bMenuAffaires').collapsed = true;
		document.getElementById('bRetourExpedition').collapsed = true;
		document.getElementById('bRetourBonRetour').collapsed = true;
		document.getElementById('bMenuRetours').collapsed = true;

		document.activeElement.blur();
		oma_initStats();

		if (oma_currentIndex!=-1) {
			oma_majPagination();
		}
		else {
			oma_listerCommandes();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function retourFicheAffaire() {
  try {

		resetAllPDF();
    document.getElementById('deck').selectedIndex = 1;
    document.getElementById('bRetourCommande').collapsed = true;
    document.getElementById('bRetourFacture').collapsed = true;
    document.getElementById('bRetourAvoir').collapsed = true;
		document.getElementById('bRetourAffaire').collapsed = true;
		document.getElementById('bRetourExpedition').collapsed = true;
		document.getElementById('bRetourBonRetour').collapsed = true;

		document.activeElement.blur();
		ofa_chargerAffaire();

  } catch (e) {
    recup_erreur(e);
  }
}


function retourCommande() {
  try {

		document.getElementById('oec-rappelLoi').collapsed = true;
		document.getElementById('oec-pdfCommande').setAttribute("src", "");
  	oec_initVersion();
		document.getElementById('oec-deckCommande').selectedIndex = 0;
		document.getElementById('bRetourCommande').collapsed = true;

	} catch (e) {
    recup_erreur(e);
  }
}


function retourBonLivraison() {
  try {

		document.getElementById('oeb-pdfBonLivraison').setAttribute("src", "");
  	if (oeb_typeExpedition=="B") { oeb_initVersion(); }
		document.getElementById('deck').selectedIndex = 3;
		document.getElementById('oeb-deckBonLivraison').selectedIndex = 0;
		document.getElementById('oco-deckColisageEtiquettes').selectedIndex = 0;
		document.getElementById('bRetourExpedition').collapsed = true;
		document.getElementById('bRetourColisage').collapsed = true;
		oeb_chargerBon();

	} catch (e) {
    recup_erreur(e);
  }
}


function retourColisage() {
  try {

		document.getElementById('oco-pdfColisageEtiquettes').setAttribute("src", "");
		document.getElementById('oco-deckColisageEtiquettes').selectedIndex = 0;
		document.getElementById('bRetourColisage').collapsed = true;
		oco_init();

	} catch (e) {
    recup_erreur(e);
  }
}


function retourBonRetour() {
  try {

		document.getElementById('oer-pdfBonRetour').setAttribute("src", "");
  	oer_initVersion();
		document.getElementById('oer-deckBonRetour').selectedIndex = 0;
		document.getElementById('bRetourBonRetour').collapsed = true;

	} catch (e) {
    recup_erreur(e);
  }
}


function retourFacture() {
  try {

		document.getElementById('oef-pdfFacture').setAttribute("src", "");
		oef_chargerFacture();
		document.getElementById('oef-deckFacture').selectedIndex = 0;
		document.getElementById('bRetourFacture').collapsed = true;

	} catch (e) {
    recup_erreur(e);
  }
}


function retourAvoir() {
  try {

		document.getElementById('oea-pdfAvoir').setAttribute("src", "");
		oea_chargerAvoir();
		document.getElementById('oea-deckAvoir').selectedIndex = 0;
		document.getElementById('bRetourAvoir').collapsed = true;

	} catch (e) {
    recup_erreur(e);
  }
}


function retourMenuRetours() {
	try {

		window.location = "chrome://opensi/content/facturation/user/traitement_retours/gestionRetours.xul";

	} catch (e) {
    recup_erreur(e);
  }
}


function resetAllPDF() {
	try {

		document.getElementById('oec-rappelLoi').collapsed = true;

		document.getElementById('oea-pdfAvoir').setAttribute("src", "");
		document.getElementById('oef-pdfFacture').setAttribute("src", "");
		document.getElementById('oer-pdfBonRetour').setAttribute("src", "");
		document.getElementById('oco-pdfColisageEtiquettes').setAttribute("src", "");
		document.getElementById('oeb-pdfBonLivraison').setAttribute("src", "");
		document.getElementById('oec-pdfCommande').setAttribute("src", "");
		document.getElementById('oma-pdf').setAttribute("src", "");

	} catch (e) {
    recup_erreur(e);
  }
}


function pressOnWindow(ev) {
	try {

		var currentDeck = parseIntBis(document.getElementById('deck').selectedIndex);
		switch (currentDeck) {
			case 2: oec_pressOnWindow(ev);	break;
			case 5: oef_pressOnWindow(ev);	break;
			case 6: oea_pressOnWindow(ev);	break;
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function demandeEnregistrement() {
	try {

		var currentDeck = parseIntBis(document.getElementById('deck').selectedIndex);
		switch (currentDeck) {
			case 1: ofa_demandeEnregistrement(); break;
			case 2: oec_demandeEnregistrement(); break;
			case 3: oeb_demandeEnregistrement(); break;
			case 4: oco_demandeEnregistrement(); break;
			case 5: oef_demandeEnregistrement(); break;
			case 6: oea_demandeEnregistrement(); break;
			case 7: oer_demandeEnregistrement(); break;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function retourMenuPrincipal() {
	try {

		window.location = "chrome://opensi/content/facturation/user/menu_principal.xul";

	} catch (e) {
    recup_erreur(e);
  }
}
