/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var oea_avoirId;
var oea_modeLigne;
var oea_codeTVAPort = "";
var oea_zoneUE;
var oea_modeTarif;
var oea_mode;
var oea_defEditionTTC;
var oea_editionTTC;
var oea_assujettiTVA;
var oea_typeRistourne = 'P';
var oea_typeRemise;
var oea_typeRemiseFP;
var oea_chargerResponsable;
var oea_selPoleActivite;
var oea_selTarifVente;
var oea_currentIndex;
var oea_toSelectLigne = null;
var oea_montantHT;
var oea_montantTTC;
var oea_clientId = "";
var oea_typeLigne;
var oea_prixId = "";
var oea_ligneId;
var oea_libelle = "";
var oea_modified = false;
var oea_langueDefaut;
var oea_apercu;
var oea_actSuiviSerie;
var oea_actSuiviLot;
var oea_codesTvaInactifs = "";
var oea_uniteDefaut;
var oea_articleId;
var oea_modifElemFin;

var oea_aResponsables = new Arbre("ComboListe/combo-responsables.tmpl","oea-responsable");
var oea_aUnites = new Arbre("ComboListe/combo-unitesVente.tmpl", "oea-unite");
var oea_aTarifsVente = new Arbre("ComboListe/combo-tarifsVente.tmpl", "oea-tarifVente");
var oea_aPolesActivite = new Arbre("ComboListe/combo-polesActivite.tmpl", "oea-secteur");
var oea_aPaysFact = new Arbre("ComboListe/combo-pays.tmpl", "oea-codePaysFact");
var oea_aPaysLiv = new Arbre("ComboListe/combo-pays.tmpl", "oea-codePaysLiv");
var oea_aPaysEnvoi = new Arbre("ComboListe/combo-pays.tmpl", "oea-codePaysEnvoi");
var oea_aCodesTVA = new Arbre("ComboListe/combo-tauxTVA.tmpl", "oea-codeTVA");
var oea_aLignes = new Arbre("Facturation/Avoirs/list-ligneAvoirClient.tmpl", "oea-articles");
var oea_aVersion = new Arbre("Facturation/Avoirs/list-versionAvoirClient.tmpl","oea-listeVersion");
var oea_aLangues = new Arbre("ComboListe/combo-langues.tmpl", "oea-langueDefaut");
var oea_aCodesTVAFraisPort = new Arbre("ComboListe/combo-tauxTVA.tmpl", "oea-codeTVAFraisPort");


function oea_init() {
  try {

		oea_modifElemFin = gProfil.isModifElemFinDV();

		document.getElementById('oea-rowPrimeCEE').collapsed = !gConfig.isGDVPrimeCEE();
		document.getElementById('oea-rowPrimeCEEHT').collapsed = !gConfig.isGDVPrimeCEE();
		document.getElementById('oea-rowPrimeCEETTC').collapsed = !gConfig.isGDVPrimeCEE();

		document.getElementById('oea-rowFax').collapsed = !gShowFax;

		oea_defEditionTTC = gConfig.isVenteTTC();
		oea_actSuiviSerie = gConfig.isActSuiviSerie();
		document.getElementById('oea-bConsultSerieLigne').collapsed = !oea_actSuiviSerie;

		if (!gConfig.isActCodeStats()) {
			document.getElementById('oea-colCodeStats').collapsed = true;
			document.getElementById('oea-colCodeStats').setAttribute('ignoreincolumnpicker', true);
	  	document.getElementById('oea-actCodeStats').collapsed = true;
		}
		else {
			document.getElementById('oea-labelRef').setAttribute('style', 'margin-left:0px');
			document.getElementById('oea-reference').setAttribute('style', 'margin-left:0px');
		}

		oea_actSuiviLot = gConfig.isActSuiviLot();
		var actUnites = gConfig.isActUnites();
		var actNbPieces = gConfig.isActNbPieces();
		oea_uniteDefaut = gConfig.getUniteDefaut();

		if (!oea_actSuiviLot) {
			document.getElementById('oea-colNumLot').collapsed = true;
			document.getElementById('oea-colNumLot').setAttribute('ignoreincolumnpicker', true);
			document.getElementById('oea-colDatePeremption').collapsed = true;
			document.getElementById('oea-colDatePeremption').setAttribute('ignoreincolumnpicker', true);

			document.getElementById('oea-fieldNumLot').collapsed = true;
			document.getElementById('oea-fieldDLC').collapsed = true;
		}

		if (!actUnites) {
			document.getElementById('oea-colSymboleUnite').collapsed = true;
			document.getElementById('oea-colSymboleUnite').setAttribute('ignoreincolumnpicker', true);
			document.getElementById('oea-fieldUnite').collapsed = true;
		}

		if (!actNbPieces) {
			document.getElementById('oea-colNbPieces').collapsed = true;
			document.getElementById('oea-colNbPieces').setAttribute('ignoreincolumnpicker', true);
			document.getElementById('oea-fieldNbPieces').collapsed = true;
		}

		oea_modeTarif = gConfig.getModeTarif();
		if (oea_modeTarif=='Q') {
			document.getElementById('oea-rowTarif').collapsed = true;
		}

		oea_aUnites.initTree(oea_initUnite);

		if (gReadOnly) {
			document.getElementById('oea-bMoveDown').collapsed = true;
			document.getElementById('oea-bMoveUp').collapsed = true;
			document.getElementById('oea-bMoveFirst').collapsed = true;
			document.getElementById('oea-bMoveLast').collapsed = true;
			document.getElementById('oea-bMultiSuppression').collapsed = true;
			document.getElementById('oea-bEnregistrer').collapsed = true;
			document.getElementById('oea-bSupprimerAvoir').collapsed = true;
			document.getElementById('oea-gridLigneAvoir').collapsed = true;
			document.getElementById('oea-tabAvoir').setAttribute('tooltiptext', "Lecture seule");
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oea_initUnite() {
	try {

		document.getElementById('oea-unite').selectedIndex = 0;
    oea_aPaysFact.initTree(oea_initPaysFact);

	} catch (e) {
    recup_erreur(e);
  }
}

function oea_initPaysFact() {
	try {
		document.getElementById('oea-codePaysFact').value = "FR";
		oea_aPaysLiv.initTree(oea_initPaysLiv);
	} catch (e) {
    recup_erreur(e);
  }
}

function oea_initPaysLiv() {
	try {
		document.getElementById('oea-codePaysLiv').value = "FR";
		oea_aPaysEnvoi.initTree(oea_initPaysEnvoi);
	} catch (e) {
    recup_erreur(e);
  }
}

function oea_initPaysEnvoi() {
	try {
		document.getElementById('oea-codePaysEnvoi').value = "FR";
	} catch (e) {
    recup_erreur(e);
  }
}


function oea_chargerResponsables(selection) {
	try {
		oea_chargerResponsable = selection;
		oea_aResponsables.setParam("Selection", oea_chargerResponsable);
		oea_aResponsables.initTree(oea_initResponsable);
	} catch (e) {
		recup_erreur(e);
	}
}

function oea_initResponsable() {
  try {
		document.getElementById('oea-responsable').value = oea_chargerResponsable;
	} catch (e) {
  	recup_erreur(e);
	}
}


function oea_chargerPolesActivite(selection) {
	try {

		oea_selPoleActivite = selection;
		oea_aPolesActivite.setParam("Selection", oea_selPoleActivite);
		oea_aPolesActivite.initTree(oea_initPoleActivite);

	} catch (e) {
		recup_erreur(e);
	}
}


function oea_initPoleActivite() {
  try {

		document.getElementById('oea-secteur').value = oea_selPoleActivite;

	} catch (e) {
  	recup_erreur(e);
	}
}


function oea_reinitialiser() {
	try {

		oea_modeLigne = "C";
		oea_currentIndex = 0;
		oea_zoneUE = false;

		oea_assujettiTVA = false;
		oea_typeRemise = "P";
		oea_typeRemiseFP = "P";
		oea_editionTTC = oea_defEditionTTC;
		oea_chargerResponsable = "";
		oea_selPoleActivite = "";
		oea_montantHT = 0;
		oea_montantTTC = 0;
		oea_apercu = false;
		oea_codesTvaInactifs = "";
		oea_codeTVAPort = "";
		oea_typeRistourne = 'P';
		document.getElementById('oea-bRistourne').setAttribute("class", "bIcoPourcentage");

		document.getElementById('oea-deckAvoir').selectedIndex = 0;
		document.getElementById('oea-tabBoxAvoir').selectedIndex = 0;
		document.getElementById('oea-tabAvoir').setAttribute('image', gReadOnly?'chrome://opensi/content/design/icones/readonly.png':null);
		document.getElementById('oea-numAffaire').value = "";
		document.getElementById('oea-numAvoir').value = "";
		document.getElementById('oea-refAvoirWeb').value = "";
		document.getElementById('oea-rowRefAvoirWeb').collapsed = true;
		document.getElementById('oea-dateAvoir').value = "";
		document.getElementById('oea-modeEnvoiAvoir').selectedIndex=0;
		document.getElementById('oea-assujettiTVA').checked = false;
		document.getElementById('oea-numTVA').value = "";
		document.getElementById('oea-regimeTVA').selectedIndex=0;
		document.getElementById('oea-editionTTC').checked = oea_editionTTC;

		oea_aVersion.deleteTree();

		oea_clientId = "";
		document.getElementById('oea-numClient').value = "";

		oea_aResponsables.deleteTree();

		document.getElementById('oea-tabBoxAdresses').selectedIndex = 0;
		document.getElementById('oea-denominationFact').value = "";
		document.getElementById('oea-adresse1Fact').value = "";
		document.getElementById('oea-adresse2Fact').value = "";
		document.getElementById('oea-adresse3Fact').value = "";
		document.getElementById('oea-codePostalFact').value = "";
		document.getElementById('oea-villeFact').value = "";
		document.getElementById('oea-codePaysFact').value = "FR";
		document.getElementById('oea-civInterFact').selectedIndex = 0;
		document.getElementById('oea-nomInterFact').value = "";
		document.getElementById('oea-prenomInterFact').value = "";
		document.getElementById('oea-telInter1Fact').value = "";
		document.getElementById('oea-telInter2Fact').value = "";
		document.getElementById('oea-faxInterFact').value = "";
		document.getElementById('oea-emailInterFact').value = "";
		document.getElementById('oea-denominationLiv').value = "";
		document.getElementById('oea-adresse1Liv').value = "";
		document.getElementById('oea-adresse2Liv').value = "";
		document.getElementById('oea-adresse3Liv').value = "";
		document.getElementById('oea-codePostalLiv').value = "";
		document.getElementById('oea-villeLiv').value = "";
		document.getElementById('oea-codePaysLiv').value = "FR";
		document.getElementById('oea-civInterLiv').selectedIndex = 0;
		document.getElementById('oea-nomInterLiv').value = "";
		document.getElementById('oea-prenomInterLiv').value = "";
		document.getElementById('oea-telInter1Liv').value = "";
		document.getElementById('oea-telInter2Liv').value = "";
		document.getElementById('oea-faxInterLiv').value = "";
		document.getElementById('oea-emailInterLiv').value = "";
		document.getElementById('oea-denominationEnvoi').value = "";
		document.getElementById('oea-adresse1Envoi').value = "";
		document.getElementById('oea-adresse2Envoi').value = "";
		document.getElementById('oea-adresse3Envoi').value = "";
		document.getElementById('oea-codePostalEnvoi').value = "";
		document.getElementById('oea-villeEnvoi').value = "";
		document.getElementById('oea-codePaysEnvoi').value = "FR";
		document.getElementById('oea-civInterEnvoi').selectedIndex = 0;
		document.getElementById('oea-nomInterEnvoi').value = "";
		document.getElementById('oea-prenomInterEnvoi').value = "";
		document.getElementById('oea-telInter1Envoi').value = "";
		document.getElementById('oea-telInter2Envoi').value = "";
		document.getElementById('oea-faxInterEnvoi').value = "";
		document.getElementById('oea-emailInterEnvoi').value = "";

		document.getElementById('oea-codeStats').value = "";
		document.getElementById('oea-reference').value = "";
		document.getElementById('oea-designation').value = "";
		document.getElementById('oea-numLot').value = "";
		document.getElementById('oea-nbPieces').value = "";
		document.getElementById('oea-quantite').value = "";
		document.getElementById('oea-unite').value = oea_uniteDefaut;
		document.getElementById('oea-datePeremption').value = "";
		document.getElementById('oea-PU').value = "";
		document.getElementById('oea-ristourne').value = "";
		document.getElementById('oea-codeTVA').value = getCodeTvaNormal(document.getElementById('oea-codePaysLiv').value, oea_assujettiTVA, document.getElementById('oea-regimeTVA').value);

		document.getElementById('oea-commentairesFin').value = "";
		document.getElementById('oea-commentairesInt').value = "";
		document.getElementById('oea-bRemise').setAttribute('class', 'bIcoPourcentage');
		document.getElementById('oea-remise').value = "0.00";
		document.getElementById('oea-fraisPort').value = "0.00";
		document.getElementById('oea-bRemiseFP').setAttribute('class', 'bIcoPourcentage');
		document.getElementById('oea-remiseFP').value = "0.00";
		document.getElementById('oea-escompte').value = "0.00";
		document.getElementById('oea-primeCEE').value = "0.00";

		document.getElementById('oea-colTotal').setAttribute("label", oea_editionTTC?"Total TTC":"Total HT");
		document.getElementById('oea-colPU').setAttribute("label", oea_editionTTC?"P.U TTC":"P.U HT");
		document.getElementById('oea-lblFraisPort').value = (oea_editionTTC?"Frais de port (ttc) :":"Frais de port (ht) :");
		document.getElementById('oea-lblPU').value = (oea_editionTTC?"P.U TTC :":"P.U HT :");
		document.getElementById('oea-piedTTC').collapsed = !oea_editionTTC;
		document.getElementById('oea-piedHT').collapsed = oea_editionTTC;
		document.getElementById('oea-montantHT').value = "0.00";
		document.getElementById('oea-montantRemise').value = "0.00";
		document.getElementById('oea-montantFraisPort').value = "0.00";
		document.getElementById('oea-montantRemiseFP').value = "0.00";
		document.getElementById('oea-totalHT').value = "0.00";
		document.getElementById('oea-TVA').value = "0.00";
		document.getElementById('oea-montantEscompte').value = "0.00";
		document.getElementById('oea-montantPrimeCEE').value = "0.00";
		document.getElementById('oea-totalTTC').value = "0.00";
		document.getElementById('oea-pttcMontantTTC').value = "0.00";
		document.getElementById('oea-pttcMontantRemise').value = "0.00";
		document.getElementById('oea-pttcMontantFraisPort').value = "0.00";
		document.getElementById('oea-pttcMontantRemiseFP').value = "0.00";
		document.getElementById('oea-pttcTotalTTC').value = "0.00";
		document.getElementById('oea-pttcTVA').value = "0.00";
		document.getElementById('oea-pttcMontantEscompte').value = "0.00";
		document.getElementById('oea-pttcMontantPrimeCEE').value = "0.00";
		document.getElementById('oea-pttcNetTTC').value = "0.00";

		document.getElementById('oea-rowRemiseHT').collapsed = true;
		document.getElementById('oea-rowRemiseFPHT').collapsed = true;
		document.getElementById('oea-rowEscompteHT').collapsed = true;
		document.getElementById('oea-rowRemiseTTC').collapsed = true;
		document.getElementById('oea-rowRemiseFPTTC').collapsed = true;
		document.getElementById('oea-rowEscompteTTC').collapsed = true;

		document.getElementById('oea-rowNetCommercialHT').collapsed = true;
		document.getElementById('oea-rowEscompteTTC').collapsed = true;
		document.getElementById('oea-pttcNetCommercial').value = "0.00";
		document.getElementById('oea-netCommercial').value = "0.00";

		document.getElementById('oea-creation').setAttribute("label", "");
		document.getElementById('oea-modification').setAttribute("label", "");
		document.getElementById('oea-fiche').setAttribute("label", "");

		oea_typeLigne = "";
		oea_prixId = "";
		oea_ligneId = "";
		oea_libelle = "";
		oea_modified = false;

		document.getElementById('oea-modeEnvoiAvoir').disabled = true;
		document.getElementById('oea-responsable').disabled = true;
		document.getElementById('oea-secteur').disabled = true;
		document.getElementById('oea-assujettiTVA').disabled = true;
		document.getElementById('oea-numTVA').disabled = true;
		document.getElementById('oea-regimeTVA').disabled = true;
		document.getElementById('oea-editionTTC').disabled = true;
		document.getElementById('oea-bChercherAdrFact').disabled = true;
		document.getElementById('oea-bChercherInter').disabled = true;
		document.getElementById('oea-bCopierFactVersLivEnvoi').disabled = true;
		document.getElementById('oea-tarifVente').disabled = true;
		document.getElementById('oea-bChercherAdrLiv').disabled = true;
		document.getElementById('oea-bChercherInterLiv').disabled = true;
		document.getElementById('oea-bChercherAdrEnvoi').disabled = true;
		document.getElementById('oea-bChercherInterEnvoi').disabled = true;

		document.getElementById('oea-denominationFact').setAttribute('readonly', true);
		document.getElementById('oea-adresse1Fact').setAttribute('readonly', true);
		document.getElementById('oea-adresse2Fact').setAttribute('readonly', true);
		document.getElementById('oea-adresse3Fact').setAttribute('readonly', true);
		document.getElementById('oea-codePostalFact').setAttribute('readonly', true);
		document.getElementById('oea-villeFact').setAttribute('readonly', true);
		document.getElementById('oea-codePaysFact').disabled = true;
		document.getElementById('oea-civInterFact').disabled = true;
		document.getElementById('oea-nomInterFact').setAttribute('readonly', true);
		document.getElementById('oea-prenomInterFact').setAttribute('readonly', true);
		document.getElementById('oea-telInter1Fact').setAttribute('readonly', true);
		document.getElementById('oea-telInter2Fact').setAttribute('readonly', true);
		document.getElementById('oea-faxInterFact').setAttribute('readonly', true);
		document.getElementById('oea-emailInterFact').setAttribute('readonly', true);

		document.getElementById('oea-denominationLiv').setAttribute('readonly', true);
		document.getElementById('oea-adresse1Liv').setAttribute('readonly', true);
		document.getElementById('oea-adresse2Liv').setAttribute('readonly', true);
		document.getElementById('oea-adresse3Liv').setAttribute('readonly', true);
		document.getElementById('oea-codePostalLiv').setAttribute('readonly', true);
		document.getElementById('oea-villeLiv').setAttribute('readonly', true);
		document.getElementById('oea-codePaysLiv').disabled = true;
		document.getElementById('oea-civInterLiv').disabled = true;
		document.getElementById('oea-nomInterLiv').setAttribute('readonly', true);
		document.getElementById('oea-prenomInterLiv').setAttribute('readonly', true);
		document.getElementById('oea-telInter1Liv').setAttribute('readonly', true);
		document.getElementById('oea-telInter2Liv').setAttribute('readonly', true);
		document.getElementById('oea-faxInterLiv').setAttribute('readonly', true);
		document.getElementById('oea-emailInterLiv').setAttribute('readonly', true);

		document.getElementById('oea-denominationEnvoi').setAttribute('readonly', true);
		document.getElementById('oea-adresse1Envoi').setAttribute('readonly', true);
		document.getElementById('oea-adresse2Envoi').setAttribute('readonly', true);
		document.getElementById('oea-adresse3Envoi').setAttribute('readonly', true);
		document.getElementById('oea-codePostalEnvoi').setAttribute('readonly', true);
		document.getElementById('oea-villeEnvoi').setAttribute('readonly', true);
		document.getElementById('oea-codePaysEnvoi').disabled = true;
		document.getElementById('oea-civInterEnvoi').disabled = true;
		document.getElementById('oea-nomInterEnvoi').setAttribute('readonly', true);
		document.getElementById('oea-prenomInterEnvoi').setAttribute('readonly', true);
		document.getElementById('oea-telInter1Envoi').setAttribute('readonly', true);
		document.getElementById('oea-telInter2Envoi').setAttribute('readonly', true);
		document.getElementById('oea-faxInterEnvoi').setAttribute('readonly', true);
		document.getElementById('oea-emailInterEnvoi').setAttribute('readonly', true);

		document.getElementById('oea-commentairesFin').disabled = true;
		document.getElementById('oea-commentairesInt').disabled = true;
		document.getElementById('oea-bOuvrirCommentairesCaches').disabled = true;
		document.getElementById('oea-bChoisirMentions').disabled = true;
		document.getElementById('oea-bRemise').disabled = true;
		document.getElementById('oea-remise').disabled = true;
		document.getElementById('oea-fraisPort').disabled = true;
		document.getElementById('oea-codeTVAFraisPort').disabled = true;
		document.getElementById('oea-bRemiseFP').disabled = true;
		document.getElementById('oea-remiseFP').disabled = true;
		document.getElementById('oea-escompte').disabled = true;
		document.getElementById('oea-bEnregistrer').disabled = true;
		document.getElementById('oea-bApercu').disabled = true;
		document.getElementById('oea-bValiderAvoir').disabled = true;
		document.getElementById('oea-bVisualiser').disabled = true;
		document.getElementById('oea-bSupprimerAvoir').disabled = true;

		document.getElementById('oea-codeStats').disabled = true;
		document.getElementById('oea-reference').disabled = true;
		document.getElementById('oea-designation').disabled = true;
		document.getElementById('oea-numLot').disabled = true;
		document.getElementById('oea-nbPieces').disabled = true;
		document.getElementById('oea-quantite').disabled = true;
		document.getElementById('oea-unite').disabled = true;
		document.getElementById('oea-datePeremption').disabled = true;
		document.getElementById('oea-PU').disabled = true;
		document.getElementById('oea-ristourne').disabled = true;
		document.getElementById('oea-codeTVA').disabled = true;
		document.getElementById('oea-bSupprimer').disabled = true;
		document.getElementById('oea-bMoveUp').disabled = true;
		document.getElementById('oea-bMoveDown').disabled = true;
		document.getElementById('oea-bMoveFirst').disabled = true;
		document.getElementById('oea-bMoveLast').disabled = true;
		document.getElementById('oea-bMultiSuppression').disabled = true;
		document.getElementById('oea-bValider').disabled = true;
		document.getElementById('oea-bAnnuler').disabled = true;
		document.getElementById('oea-bArticle').disabled = true;
		document.getElementById('oea-bCommentaire').disabled = true;
		document.getElementById('oea-bConsultSerieLigne').disabled = true;
		oea_aLignes.deleteTree();

		document.getElementById('oea-pdfAvoir').setAttribute('src', '');

	} catch (e) {
		recup_erreur(e);
	}
}


function oea_debloquerChamps() {
	try {
		document.getElementById('oea-modeEnvoiAvoir').disabled = false;
		document.getElementById('oea-responsable').disabled = false;
		document.getElementById('oea-secteur').disabled = false;
		document.getElementById('oea-assujettiTVA').disabled = false;
		document.getElementById('oea-regimeTVA').disabled = false;
		document.getElementById('oea-editionTTC').disabled = false;
		document.getElementById('oea-bCopierFactVersLivEnvoi').disabled = false;
		document.getElementById('oea-tarifVente').disabled = false;

		document.getElementById('oea-denominationFact').removeAttribute('readonly');
		document.getElementById('oea-adresse1Fact').removeAttribute('readonly');
		document.getElementById('oea-adresse2Fact').removeAttribute('readonly');
		document.getElementById('oea-adresse3Fact').removeAttribute('readonly');
		document.getElementById('oea-codePostalFact').removeAttribute('readonly');
		document.getElementById('oea-villeFact').removeAttribute('readonly');
		document.getElementById('oea-codePaysFact').disabled = false;
		document.getElementById('oea-civInterFact').disabled = false;
		document.getElementById('oea-nomInterFact').removeAttribute('readonly');
		document.getElementById('oea-prenomInterFact').removeAttribute('readonly');
		document.getElementById('oea-telInter1Fact').removeAttribute('readonly');
		document.getElementById('oea-telInter2Fact').removeAttribute('readonly');
		document.getElementById('oea-faxInterFact').removeAttribute('readonly');
		document.getElementById('oea-emailInterFact').removeAttribute('readonly');

		document.getElementById('oea-denominationLiv').removeAttribute('readonly');
		document.getElementById('oea-adresse1Liv').removeAttribute('readonly');
		document.getElementById('oea-adresse2Liv').removeAttribute('readonly');
		document.getElementById('oea-adresse3Liv').removeAttribute('readonly');
		document.getElementById('oea-codePostalLiv').removeAttribute('readonly');
		document.getElementById('oea-villeLiv').removeAttribute('readonly');
		document.getElementById('oea-codePaysLiv').disabled = false;
		document.getElementById('oea-civInterLiv').disabled = false;
		document.getElementById('oea-nomInterLiv').removeAttribute('readonly');
		document.getElementById('oea-prenomInterLiv').removeAttribute('readonly');
		document.getElementById('oea-telInter1Liv').removeAttribute('readonly');
		document.getElementById('oea-telInter2Liv').removeAttribute('readonly');
		document.getElementById('oea-faxInterLiv').removeAttribute('readonly');
		document.getElementById('oea-emailInterLiv').removeAttribute('readonly');

		document.getElementById('oea-denominationEnvoi').removeAttribute('readonly');
		document.getElementById('oea-adresse1Envoi').removeAttribute('readonly');
		document.getElementById('oea-adresse2Envoi').removeAttribute('readonly');
		document.getElementById('oea-adresse3Envoi').removeAttribute('readonly');
		document.getElementById('oea-codePostalEnvoi').removeAttribute('readonly');
		document.getElementById('oea-villeEnvoi').removeAttribute('readonly');
		document.getElementById('oea-codePaysEnvoi').disabled = false;
		document.getElementById('oea-civInterEnvoi').disabled = false;
		document.getElementById('oea-nomInterEnvoi').removeAttribute('readonly');
		document.getElementById('oea-prenomInterEnvoi').removeAttribute('readonly');
		document.getElementById('oea-telInter1Envoi').removeAttribute('readonly');
		document.getElementById('oea-telInter2Envoi').removeAttribute('readonly');
		document.getElementById('oea-faxInterEnvoi').removeAttribute('readonly');
		document.getElementById('oea-emailInterEnvoi').removeAttribute('readonly');

		document.getElementById('oea-commentairesFin').disabled = false;
		document.getElementById('oea-commentairesInt').disabled = false;
		document.getElementById('oea-bChoisirMentions').disabled = false;
		document.getElementById('oea-bRemise').disabled = !oea_modifElemFin;
		document.getElementById('oea-remise').disabled = !oea_modifElemFin;
		document.getElementById('oea-fraisPort').disabled = !oea_modifElemFin;
		document.getElementById('oea-codeTVAFraisPort').disabled = !oea_modifElemFin;
		document.getElementById('oea-bRemiseFP').disabled = !oea_modifElemFin;
		document.getElementById('oea-remiseFP').disabled = !oea_modifElemFin;
		document.getElementById('oea-escompte').disabled = !oea_modifElemFin;
		document.getElementById('oea-primeCEE').disabled = !oea_modifElemFin;
		document.getElementById('oea-bEnregistrer').disabled = false;

		document.getElementById('oea-codeStats').disabled = false;
		document.getElementById('oea-reference').disabled = false;
		document.getElementById('oea-designation').disabled = false;
		document.getElementById('oea-numLot').disabled = true;
		document.getElementById('oea-nbPieces').disabled = false;
		document.getElementById('oea-quantite').disabled = false;
		document.getElementById('oea-unite').disabled = false;
		document.getElementById('oea-datePeremption').disabled = true;
		document.getElementById('oea-PU').disabled = !oea_modifElemFin;
		document.getElementById('oea-ristourne').disabled = !oea_modifElemFin;
		document.getElementById('oea-codeTVA').disabled = !oea_modifElemFin;
		document.getElementById('oea-bValider').disabled = false;
		document.getElementById('oea-bAnnuler').disabled = false;
		document.getElementById('oea-bArticle').disabled = false;
	} catch (e) {
		recup_erreur(e);
	}
}


function oea_chargerAvoir() {
	try {

		oea_mode = "M";
		oea_reinitialiser();

		oea_aLignes.setParam("Avoir_Id", oea_avoirId);
		oea_aLignes.initTree(oea_chargerAvoir2);

	} catch (e) {
		recup_erreur(e);
	}
}


function oea_chargerAvoir2() {
  try {

		var qLoad = new QueryHttp("Facturation/Avoirs/loadAvoirClient.tmpl");
		qLoad.setParam("Avoir_Id", oea_avoirId);
		var result = qLoad.execute();

		var contenu = result.responseXML.documentElement;

		var numAvoir = contenu.getAttribute('Num_Avoir');

		oea_typeRemise = (parseFloat(contenu.getAttribute('MRemise'))!=0?'M':'P');
		document.getElementById('oea-remise').value = (oea_typeRemise=='P'?contenu.getAttribute('PRemise'):contenu.getAttribute('MRemise'));
		document.getElementById('oea-bRemise').setAttribute("class", (oea_typeRemise=='P'?"bIcoPourcentage":"bIcoEuro"));

		oea_typeRemiseFP = (parseFloat(contenu.getAttribute('MRemise_FP'))!=0?'M':'P');
		document.getElementById('oea-remiseFP').value = (oea_typeRemiseFP=='P'?contenu.getAttribute('PRemise_FP'):contenu.getAttribute('MRemise_FP'));
		document.getElementById('oea-bRemiseFP').setAttribute("class", (oea_typeRemiseFP=='P'?"bIcoPourcentage":"bIcoEuro"));

		document.getElementById('oea-escompte').value = contenu.getAttribute('Escompte');
		document.getElementById('oea-primeCEE').value = contenu.getAttribute('Prime_CEE');
		document.getElementById('oea-fraisPort').value = contenu.getAttribute('Frais_Port');
		document.getElementById('oea-commentairesFin').value = contenu.getAttribute('Commentaires_Fin');
		document.getElementById('oea-commentairesInt').value = contenu.getAttribute('Commentaires_Int');
		document.getElementById('oea-dateAvoir').value = contenu.getAttribute('Date_Avoir');
		document.getElementById('oea-numAvoir').value = numAvoir;
		document.getElementById('oea-modeEnvoiAvoir').value = contenu.getAttribute('Mode_Envoi_Avoir');
		oea_chargerPolesActivite(contenu.getAttribute('Pole_Activite'));
		var refAvoirWeb = contenu.getAttribute("Ref_Avoir_Web");
		document.getElementById('oea-refAvoirWeb').value = refAvoirWeb;
		document.getElementById('oea-rowRefAvoirWeb').collapsed = isEmpty(refAvoirWeb);

		document.getElementById('oea-denominationFact').value = contenu.getAttribute('Denomination');
		document.getElementById('oea-adresse1Fact').value = contenu.getAttribute('Adresse_1');
		document.getElementById('oea-adresse2Fact').value = contenu.getAttribute('Adresse_2');
		document.getElementById('oea-adresse3Fact').value = contenu.getAttribute('Adresse_3');
		document.getElementById('oea-codePostalFact').value = contenu.getAttribute('Code_Postal');
		document.getElementById('oea-villeFact').value = contenu.getAttribute('Ville');
		document.getElementById('oea-codePaysFact').value = contenu.getAttribute('Code_Pays');
		document.getElementById('oea-civInterFact').value = contenu.getAttribute('Civ_Inter');
		document.getElementById('oea-nomInterFact').value = contenu.getAttribute('Nom_Inter');
		document.getElementById('oea-prenomInterFact').value = contenu.getAttribute('Prenom_Inter');
		document.getElementById('oea-telInter1Fact').value = contenu.getAttribute('Tel_Inter_1');
		document.getElementById('oea-telInter2Fact').value = contenu.getAttribute('Tel_Inter_2');
		document.getElementById('oea-faxInterFact').value = contenu.getAttribute('Fax_Inter');
		document.getElementById('oea-emailInterFact').value = contenu.getAttribute('Email_Inter');

		document.getElementById('oea-denominationLiv').value = contenu.getAttribute('Denomination_Liv');
		document.getElementById('oea-adresse1Liv').value = contenu.getAttribute('Adresse_1_Liv');
		document.getElementById('oea-adresse2Liv').value = contenu.getAttribute('Adresse_2_Liv');
		document.getElementById('oea-adresse3Liv').value = contenu.getAttribute('Adresse_3_Liv');
		document.getElementById('oea-codePostalLiv').value = contenu.getAttribute('Code_Postal_Liv');
		document.getElementById('oea-villeLiv').value = contenu.getAttribute('Ville_Liv');
		document.getElementById('oea-codePaysLiv').value = contenu.getAttribute('Code_Pays_Liv');
		document.getElementById('oea-civInterLiv').value = contenu.getAttribute('Civ_Inter_Liv');
		document.getElementById('oea-nomInterLiv').value = contenu.getAttribute('Nom_Inter_Liv');
		document.getElementById('oea-prenomInterLiv').value = contenu.getAttribute('Prenom_Inter_Liv');
		document.getElementById('oea-telInter1Liv').value = contenu.getAttribute('Tel_Inter_1_Liv');
		document.getElementById('oea-telInter2Liv').value = contenu.getAttribute('Tel_Inter_2_Liv');
		document.getElementById('oea-faxInterLiv').value = contenu.getAttribute('Fax_Inter_Liv');
		document.getElementById('oea-emailInterLiv').value = contenu.getAttribute('Email_Inter_Liv');

		document.getElementById('oea-denominationEnvoi').value = contenu.getAttribute('Denomination_Envoi');
		document.getElementById('oea-adresse1Envoi').value = contenu.getAttribute('Adresse_1_Envoi');
		document.getElementById('oea-adresse2Envoi').value = contenu.getAttribute('Adresse_2_Envoi');
		document.getElementById('oea-adresse3Envoi').value = contenu.getAttribute('Adresse_3_Envoi');
		document.getElementById('oea-codePostalEnvoi').value = contenu.getAttribute('Code_Postal_Envoi');
		document.getElementById('oea-villeEnvoi').value = contenu.getAttribute('Ville_Envoi');
		document.getElementById('oea-codePaysEnvoi').value = contenu.getAttribute('Code_Pays_Envoi');
		document.getElementById('oea-civInterEnvoi').value = contenu.getAttribute('Civ_Inter_Envoi');
		document.getElementById('oea-nomInterEnvoi').value = contenu.getAttribute('Nom_Inter_Envoi');
		document.getElementById('oea-prenomInterEnvoi').value = contenu.getAttribute('Prenom_Inter_Envoi');
		document.getElementById('oea-telInter1Envoi').value = contenu.getAttribute('Tel_Inter_1_Envoi');
		document.getElementById('oea-telInter2Envoi').value = contenu.getAttribute('Tel_Inter_2_Envoi');
		document.getElementById('oea-faxInterEnvoi').value = contenu.getAttribute('Fax_Inter_Envoi');
		document.getElementById('oea-emailInterEnvoi').value = contenu.getAttribute('Email_Inter_Envoi');

		oea_chargerTarifsVente(contenu.getAttribute('Tarif_Id'));
		document.getElementById('oea-regimeTVA').value = contenu.getAttribute('Regime_TVA');
		var codeTVAPort = contenu.getAttribute('Code_TVA_Port');
		oea_assujettiTVA = (contenu.getAttribute('Assujetti_TVA')=="true");
		oea_codesTvaInactifs = contenu.getAttribute('Codes_TVA_Inactifs');

		var typeEdition = (contenu.getAttribute('Edition_TTC')=="true");

		document.getElementById('oea-editionTTC').checked = typeEdition;

		document.getElementById('oea-assujettiTVA').checked = oea_assujettiTVA;
		document.getElementById('oea-numTVA').value = contenu.getAttribute("Numero_TVA");

		oea_clientId = contenu.getAttribute('Client_Id');
		var clientConnu = !isEmpty(oea_clientId);
		document.getElementById('oea-numClient').value = contenu.getAttribute('Num_Client');

		oea_chargerResponsables(contenu.getAttribute('Util_R'));

		document.getElementById('oea-creation').setAttribute("label", "Avoir cr\u00E9\u00E9 le "+ contenu.getAttribute('Date_Creation') +" par "+ contenu.getAttribute('Login_Createur'));
		document.getElementById('oea-modification').setAttribute("label", "Derni\u00E8re modification le "+ contenu.getAttribute('Date_Maj') +" par "+ contenu.getAttribute('Login_Maj'));
		document.getElementById('oea-fiche').setAttribute("label", "Avoir N\u00B0 "+ numAvoir);
		document.getElementById('oea-creation').collapsed = false;
		document.getElementById('oea-modification').collapsed = false;

		oea_initVersion();

		oea_modified = false;
		document.getElementById('oea-tabAvoir').setAttribute('image', gReadOnly?'chrome://opensi/content/design/icones/readonly.png':null);

		document.getElementById('oea-bOuvrirCommentairesCaches').disabled = false;

		if (contenu.getAttribute('Statut')=="V") {
			oea_mode = "V";
		} else {
			oea_debloquerChamps();
			document.getElementById('oea-bChercherAdrFact').disabled = !clientConnu;
			document.getElementById('oea-bChercherInter').disabled = !clientConnu;
			document.getElementById('oea-bChercherAdrLiv').disabled = !clientConnu;
			document.getElementById('oea-bChercherInterLiv').disabled = !clientConnu;
			document.getElementById('oea-bChercherAdrEnvoi').disabled = !clientConnu;
			document.getElementById('oea-bChercherInterEnvoi').disabled = !clientConnu;
			document.getElementById('oea-numTVA').disabled = !oea_assujettiTVA;
			document.getElementById('oea-bSupprimerAvoir').disabled = false;
			oea_ajouterLigne("I");
		}
		document.getElementById('oea-bOuvrirCommentairesCaches').disabled = false;
		document.getElementById('oea-bApercu').disabled = (oea_mode == "V");
		document.getElementById('oea-bValiderAvoir').disabled = (oea_mode=="V");
		document.getElementById('oea-bVisualiser').disabled = (oea_mode != "V");
		document.getElementById('oea-bApercu').collapsed = (oea_mode == "V");
		document.getElementById('oea-bValiderAvoir').collapsed = (oea_mode=="V" || gReadOnly);
		document.getElementById('oea-bVisualiser').collapsed = (oea_mode != "V");

		oea_changerTypeEdition(typeEdition);

		oea_chargerTVAPort(codeTVAPort);

		document.getElementById('oea-numAffaire').value = ofa_numAffaire;

	} catch (e) {
    recup_erreur(e);
  }
}


function oea_chargerTVAPort(selection) {
  try {

		oea_codeTVAPort = selection!=null?selection:getCodeTvaNormal(document.getElementById('oea-codePaysLiv').value, oea_assujettiTVA, document.getElementById('oea-regimeTVA').value);

		oea_aCodesTVAFraisPort.setParam("Code_Pays", document.getElementById("oea-codePaysLiv").value);
    oea_aCodesTVAFraisPort.setParam("Regime_TVA", document.getElementById("oea-regimeTVA").value);
    oea_aCodesTVAFraisPort.setParam("Assujetti_TVA", oea_assujettiTVA);
		oea_aCodesTVAFraisPort.setParam("Selection", oea_codeTVAPort);
    oea_aCodesTVAFraisPort.initTree(oea_selectionTVAPort);

	} catch (e) {
    recup_erreur(e);
  }
}


function oea_selectionTVAPort() {
  try {

   	document.getElementById('oea-codeTVAFraisPort').value = oea_codeTVAPort;
		oea_listeTVA();

		var qZoneUE = new QueryHttp("Facturation/Commun/getZoneUEPays.tmpl");
	  qZoneUE.setParam("Code_Pays", document.getElementById('oea-codePaysLiv').value);
	  var result = qZoneUE.execute();
	  oea_zoneUE = (result.responseXML.documentElement.getAttribute("Zone_UE")=="true");

	} catch (e) {
    recup_erreur(e);
  }
}


function oea_formatLigne(typeLigne) {
  try {

		switch(typeLigne) {
			case "S":
				document.getElementById('oea-codeStats').disabled = false;
				document.getElementById('oea-reference').disabled = true;
				document.getElementById('oea-designation').disabled = true;
				document.getElementById('oea-numLot').disabled = false;
				document.getElementById('oea-nbPieces').disabled = false;
				document.getElementById('oea-quantite').disabled = false;
				document.getElementById('oea-unite').disabled = false;
				document.getElementById('oea-datePeremption').disabled = false;
				document.getElementById('oea-PU').disabled = !oea_modifElemFin;
				document.getElementById('oea-ristourne').disabled = !oea_modifElemFin;
				document.getElementById('oea-bRistourne').disabled = !oea_modifElemFin;
				document.getElementById('oea-codeTVA').disabled = !oea_modifElemFin;
				document.getElementById('oea-bValider').disabled = false;
				document.getElementById('oea-bAnnuler').disabled = false;
				break;

			case "I":
				document.getElementById('oea-codeStats').disabled = false;
				document.getElementById('oea-reference').disabled = false;
				document.getElementById('oea-designation').disabled = false;
				document.getElementById('oea-numLot').disabled = true;
				document.getElementById('oea-nbPieces').disabled = false;
				document.getElementById('oea-quantite').disabled = false;
				document.getElementById('oea-unite').disabled = false;
				document.getElementById('oea-datePeremption').disabled = true;
				document.getElementById('oea-PU').disabled = !oea_modifElemFin;
				document.getElementById('oea-ristourne').disabled = !oea_modifElemFin;
				document.getElementById('oea-bRistourne').disabled = !oea_modifElemFin;
				document.getElementById('oea-codeTVA').disabled = !oea_modifElemFin;
				document.getElementById('oea-bValider').disabled = false;
				document.getElementById('oea-bAnnuler').disabled = false;
				break;

			default:
				document.getElementById('oea-codeStats').value = "";
				document.getElementById('oea-reference').value = "";
				document.getElementById('oea-designation').value = "";
				document.getElementById('oea-numLot').value = "";
				document.getElementById('oea-nbPieces').value = "";
				document.getElementById('oea-quantite').value = "";
				document.getElementById('oea-unite').value = oea_uniteDefaut;
				document.getElementById('oea-datePeremption').value = "";
				document.getElementById('oea-PU').value = "";
				document.getElementById('oea-ristourne').value = "";
				oea_libelle = "";
				oea_ligneId = "";
				document.getElementById('oea-codeTVA').value = getCodeTvaNormal(document.getElementById('oea-codePaysLiv').value, oea_assujettiTVA, document.getElementById('oea-regimeTVA').value);
				document.getElementById('oea-codeStats').disabled = true;
				document.getElementById('oea-reference').disabled = true;
				document.getElementById('oea-designation').disabled = true;
				document.getElementById('oea-numLot').disabled = true;
				document.getElementById('oea-nbPieces').disabled = true;
				document.getElementById('oea-quantite').disabled = true;
				document.getElementById('oea-unite').disabled = true;
				document.getElementById('oea-datePeremption').disabled = true;
				document.getElementById('oea-PU').disabled = true;
				document.getElementById('oea-ristourne').disabled = true;
				document.getElementById('oea-bRistourne').disabled = true;
				document.getElementById('oea-codeTVA').disabled = true;
				document.getElementById('oea-bSupprimer').disabled = true;
				document.getElementById('oea-bMoveUp').disabled = true;
				document.getElementById('oea-bMoveDown').disabled = true;
				document.getElementById('oea-bMoveFirst').disabled = true;
				document.getElementById('oea-bMoveLast').disabled = true;
				document.getElementById('oea-bMultiSuppression').disabled = true;
				document.getElementById('oea-bCommentaire').disabled = true;
				document.getElementById('oea-bValider').disabled = true;
				document.getElementById('oea-bAnnuler').disabled = true;
				break;
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oea_listeTVA() {
  try {

  	oea_calculTotaux();

    oea_aCodesTVA.setParam("Code_Pays", document.getElementById("oea-codePaysLiv").value);
    oea_aCodesTVA.setParam("Regime_TVA", document.getElementById("oea-regimeTVA").value);
    oea_aCodesTVA.setParam("Assujetti_TVA", oea_assujettiTVA);
		oea_aCodesTVA.setParam("Selection", oea_codesTvaInactifs);
    oea_aCodesTVA.initTree(oea_selectTVA);

  } catch (e) {
    recup_erreur(e);
  }
}


function oea_selectTVA() {
  try {

    document.getElementById('oea-codeTVA').value = getCodeTvaNormal(document.getElementById('oea-codePaysLiv').value, oea_assujettiTVA, document.getElementById('oea-regimeTVA').value);

  } catch (e) {
    recup_erreur(e);
  }
}


function oea_switchRistourne() {
	try {

		if (oea_typeRistourne=='P') {
			document.getElementById('oea-bRistourne').setAttribute("class", "bIcoEuro");
			oea_typeRistourne = 'M';
		}
		else {
			document.getElementById('oea-bRistourne').setAttribute("class", "bIcoPourcentage");
			oea_typeRistourne = 'P';
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oea_switchRemise() {
	try {

		if (oea_typeRemise=='P') {
			document.getElementById('oea-bRemise').setAttribute('class', 'bIcoEuro');
			oea_typeRemise = 'M';
		}
		else {
			document.getElementById('oea-bRemise').setAttribute('class', 'bIcoPourcentage');
			oea_typeRemise = 'P';
		}
		oea_calculTotaux();
		oea_setModified(true);

	} catch (e) {
    recup_erreur(e);
  }
}


function oea_switchRemiseFP() {
	try {

		if (oea_typeRemiseFP=='P') {
			document.getElementById('oea-bRemiseFP').setAttribute('class', 'bIcoEuro');
			oea_typeRemiseFP = 'M';
		}
		else {
			document.getElementById('oea-bRemiseFP').setAttribute('class', 'bIcoPourcentage');
			oea_typeRemiseFP = 'P';
		}
		oea_calculTotaux();
		oea_setModified(true);

	} catch (e) {
    recup_erreur(e);
  }
}


function oea_ajouterLigne(typeLigne, articleId) {
  try {

  	document.getElementById('oea-bSupprimer').disabled = true;
  	document.getElementById('oea-bMoveUp').disabled = true;
		document.getElementById('oea-bMoveDown').disabled = true;
  	document.getElementById('oea-bMoveFirst').disabled = true;
		document.getElementById('oea-bMoveLast').disabled = true;
		document.getElementById('oea-bMultiSuppression').disabled = true;
		document.getElementById('oea-bCommentaire').disabled = true;

		oea_modeLigne = "C";
		oea_typeLigne = typeLigne;
		oea_ligneId = "";

		oea_formatLigne(typeLigne);
		var codePaysLiv = document.getElementById('oea-codePaysLiv').value;
		var regimeTVA = document.getElementById('oea-regimeTVA').value;

		if (typeLigne=="S") {
			oea_articleId = articleId;

			if (oea_modeTarif=='Q') {
				var url = "chrome://opensi/content/facturation/user/commun/popup-choixTarif.xul";
  			window.openDialog(url,'','chrome,modal,centerscreen', oea_retourChoixPrixQuantite, articleId);

				if (!isEmpty(oea_prixId)) {
					var qGet = new QueryHttp("Facturation/Articles/getInfosArticleQuantite.tmpl");
        	qGet.setParam("Article_Id", articleId);
        	qGet.setParam("Prix_Id", oea_prixId);
					qGet.setParam("TTC", oea_editionTTC);
					var result = qGet.execute();

					var contenu = result.responseXML.documentElement;
					if (isEmpty(document.getElementById('oea-codeStats').value)) {
						document.getElementById('oea-codeStats').value = contenu.getAttribute("Code_Stats");
					}
					document.getElementById('oea-designation').value = contenu.getAttribute("Designation");
					document.getElementById('oea-numLot').value = "";
					document.getElementById('oea-nbPieces').value = "";
					document.getElementById('oea-quantite').value = contenu.getAttribute("Quantite");
					document.getElementById('oea-unite').value = contenu.getAttribute("Unite_Id");
					document.getElementById('oea-datePeremption').value = "";
					document.getElementById('oea-PU').value = contenu.getAttribute("Prix_Unitaire");
					document.getElementById('oea-ristourne').value = "0.00";
					document.getElementById('oea-codeTVA').value = getCodeTvaCorrespondant(contenu.getAttribute("Code_TVA"), codePaysLiv, oea_assujettiTVA, regimeTVA);
					oea_prixId = "";
					oea_libelle = contenu.getAttribute("Libelle");
				}
				else {
					oea_ajouterLigne("I");
				}
			}
			else {
				var qGet = new QueryHttp("Facturation/Articles/getInfosArticleVente.tmpl");
        qGet.setParam("Article_Id", articleId);
        qGet.setParam("Tarif_Id", document.getElementById('oea-tarifVente').value);
				qGet.setParam("TTC", oea_editionTTC);
				qGet.setParam("Client_Id", oea_clientId);
				var result = qGet.execute();

				var contenu = result.responseXML.documentElement;
				if (isEmpty(document.getElementById('oea-codeStats').value)) {
					document.getElementById('oea-codeStats').value = contenu.getAttribute("Code_Stats");
				}
				document.getElementById('oea-designation').value = contenu.getAttribute("Designation");
				document.getElementById('oea-numLot').value = "";
				document.getElementById('oea-nbPieces').value = "";
				document.getElementById('oea-quantite').value = 1;
				document.getElementById('oea-unite').value = contenu.getAttribute("Unite_Id");
				document.getElementById('oea-datePeremption').value = "";
				document.getElementById('oea-PU').value = contenu.getAttribute("Prix_Unitaire");
				document.getElementById('oea-ristourne').value = contenu.getAttribute("Ristourne");
				document.getElementById('oea-codeTVA').value = getCodeTvaCorrespondant(contenu.getAttribute("Code_TVA"), codePaysLiv, oea_assujettiTVA, regimeTVA);
				oea_libelle = "";
			}
		}
		else {
			oea_articleId = "";
			document.getElementById('oea-codeStats').value = "";
			document.getElementById('oea-reference').value = "";
			document.getElementById('oea-designation').value = "";
			document.getElementById('oea-numLot').value = "";
			document.getElementById('oea-nbPieces').value = "";
			document.getElementById('oea-quantite').value = 1;
			document.getElementById('oea-unite').value = oea_uniteDefaut;
			document.getElementById('oea-datePeremption').value = "";
			document.getElementById('oea-PU').value = "";
			document.getElementById('oea-ristourne').value = "0.00";
			document.getElementById('oea-codeTVA').value = getCodeTvaNormal(codePaysLiv, oea_assujettiTVA, regimeTVA);
			document.getElementById('oea-bConsultSerieLigne').disabled = true;
			oea_libelle = "";
			document.getElementById('oea-reference').focus();
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oea_pressOnWindow(ev) {
	try {

		if (ev.altKey && oea_mode!="V") {
			switch(ev.charCode) {
      	case 97: // 'a'
				case 65: // 'A'
					oea_rechercherStock();
        	break;
				case 116: // 't'
					oea_modifierTarif();
					break;
    	}
		}
		else if (ev.ctrlKey && oea_mode!="V" && ev.keyCode==46) {
			// ctrl + suppr
			ev.preventDefault();
			oea_supprimerLigne();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oea_pressOnReference(ev) {
	try {

		if (ev.keyCode==13) {
			oea_rechercherReference();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oea_rechercherStock(reference) {
	try {

		var url = "chrome://opensi/content/facturation/user/articles/popup-rechercheArticle.xul";
		var tarifId = (oea_modeTarif!="Q"?document.getElementById('oea-tarifVente').value:null);
    window.openDialog(url,'','chrome,modal,centerscreen', oea_retourRechercherStock, "V", reference, tarifId, null, null, null, oea_clientId);

	} catch (e) {
    recup_erreur(e);
  }
}


function oea_retourRechercherStock(reference, articleId) {
	try {

		document.getElementById('oea-reference').value = reference;
		document.getElementById('oea-quantite').focus();
		oea_ajouterLigne("S", articleId);

	} catch (e) {
    recup_erreur(e);
  }
}


function oea_rechercherReference() {
	try {

		var reference = document.getElementById('oea-reference').value;

		var qSearch = new QueryHttp("Facturation/Articles/searchReference.tmpl");
		qSearch.setParam("Reference", reference);
		qSearch.setParam("Vente_Achat", "V");
		var result = qSearch.execute();

		var articleId = result.responseXML.documentElement.getAttribute("Article_Id");
		if (!isEmpty(articleId)) {
			document.getElementById('oea-reference').value = result.responseXML.documentElement.getAttribute("Reference");
			document.getElementById('oea-quantite').focus();
			oea_ajouterLigne("S", articleId);
		}
		else {
			oea_rechercherStock(reference);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oea_modifierTarif() {
	try {

		if (oea_modeLigne=="M" && oea_typeLigne=='S' && oea_modeTarif=='Q') {

			var url = "chrome://opensi/content/facturation/user/commun/popup-choixTarif.xul";
    	window.openDialog(url,'','chrome,modal,centerscreen', oea_retourChoixPrixQuantite, oea_articleId);

			if (!isEmpty(oea_prixId)) {
				var qGet = new QueryHttp("Facturation/Articles/getInfosArticleQuantite.tmpl");
        qGet.setParam("Article_Id", oea_articleId);
        qGet.setParam("Prix_Id", oea_prixId);
				qGet.setParam("TTC", oea_editionTTC);
				var result = qGet.execute();

				var contenu = result.responseXML.documentElement;
				document.getElementById('oea-quantite').value = contenu.getAttribute("Quantite");
				document.getElementById('oea-unite').value = contenu.getAttribute("Unite_Id");
				document.getElementById('oea-PU').value = contenu.getAttribute("Prix_Unitaire");
				oea_prixId = "";
				oea_libelle = contenu.getAttribute("Libelle");
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oea_retourChoixPrixQuantite(prixId) {
	try {

		oea_prixId = prixId;

	} catch (e) {
		recup_erreur(e);
	}
}


function oea_ouvrirLigne() {
  try {

		if (oea_aLignes.isSelected() && oea_mode=='M') {

			if (oea_aLignes.nbSelection()==1) {
				var i = oea_aLignes.getCurrentIndex();
				oea_currentIndex = i;
				var typeLigne = oea_aLignes.getCellText(i,'oea-colTypeLigne');
				document.getElementById("oea-bConsultSerieLigne").disabled = (typeLigne!="S");
				document.getElementById('oea-bMultiSuppression').disabled = true;

				if(oea_mode=="M"){
					if (oea_aLignes.getCellText(i,'oea-colTypeLigne')=="C") {
						oea_ajouterLigne("I");
					}
					else {
						oea_modeLigne = "M";
						document.getElementById('oea-bCommentaire').disabled = false;
						document.getElementById('oea-bSupprimer').disabled = false;

						document.getElementById('oea-codeStats').value = oea_aLignes.getCellText(i,'oea-colCodeStats');
						document.getElementById('oea-reference').value = oea_aLignes.getCellText(i,'oea-colReference');
						document.getElementById('oea-designation').value = oea_aLignes.getCellText(i,'oea-colDesignation');
						document.getElementById('oea-numLot').value = oea_aLignes.getCellText(i,'oea-colNumLot');
						document.getElementById('oea-nbPieces').value = oea_aLignes.getCellText(i,'oea-colNbPieces');
						document.getElementById('oea-quantite').value = oea_aLignes.getCellText(i,'oea-colQuantite');
						document.getElementById('oea-unite').value = oea_aLignes.getCellText(i,'oea-colUnite');
						document.getElementById('oea-datePeremption').value = oea_aLignes.getCellText(i,'oea-colDatePeremption');
						document.getElementById('oea-PU').value = oea_aLignes.getCellText(i,'oea-colPU');
						document.getElementById('oea-codeTVA').value = oea_aLignes.getCellText(i,'oea-colCodeTVA');
						document.getElementById('oea-ristourne').value = oea_aLignes.getCellValue(i,'oea-colRistourne');
						oea_typeRistourne = oea_aLignes.getSelectedCellText('oea-colTypeRistourne');
						document.getElementById('oea-bRistourne').setAttribute("class", (oea_typeRistourne=='P'?"bIcoPourcentage":"bIcoEuro"));
						oea_typeLigne = oea_aLignes.getCellText(i,'oea-colTypeLigne');
						oea_ligneId = oea_aLignes.getCellText(i,'oea-colLigneId');
						oea_articleId = oea_aLignes.getCellText(i,'oea-colArticleId');
						oea_libelle = oea_aLignes.getCellText(i,'oea-colLibelle');

						// on ignore les lignes de commentaires
						var firstIndex = 0;
						var lastIndex = oea_aLignes.nbLignes()-1;
						if (oea_aLignes.getCellText(firstIndex,'oea-colTypeLigne')=="C") { firstIndex++; }
						if (oea_aLignes.getCellText(lastIndex,'oea-colTypeLigne')=="C") { lastIndex--; }

						document.getElementById('oea-bMoveUp').disabled = (i==firstIndex);
						document.getElementById('oea-bMoveDown').disabled = (i==lastIndex);
						document.getElementById('oea-bMoveFirst').disabled = (i==firstIndex);
						document.getElementById('oea-bMoveLast').disabled = (i==lastIndex);

						oea_formatLigne(oea_typeLigne);
					}
				}
			}
			else {
				oea_ajouterLigne("I");
				document.getElementById('oea-bMultiSuppression').disabled = false;
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oea_ouvrirCommentaire() {
  try {

		if (oea_aLignes.isSelected() && oea_mode=="M") {
			var i = oea_aLignes.getCurrentIndex();
			if (oea_aLignes.getCellText(i,'oea-colTypeLigne')=="C") {
				oea_editerCommentaire();
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oea_deplacerLigne(moveType) {
	try {

		if (oea_aLignes.isSelected() && oea_mode=="M" && oea_aLignes.getSelectedCellText('oea-colTypeLigne')!="C") {

			document.getElementById('oea-bMoveUp').disabled = true;
			document.getElementById('oea-bMoveDown').disabled = true;
			document.getElementById('oea-bMoveFirst').disabled = true;
			document.getElementById('oea-bMoveLast').disabled = true;

			var qMove = new QueryHttp("Facturation/Avoirs/moveLigneAvoirClient.tmpl");
			qMove.setParam("Ligne_Id", oea_ligneId);
			qMove.setParam("Move_Type", moveType);
			var result = qMove.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oea_toSelectLigne = oea_ligneId;
				oea_ajouterLigne("I");
				oea_aLignes.deleteTree();
				oea_initTree2();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oea_validerLigne() {
  try {

		var codeStats = document.getElementById('oea-codeStats').value;
		var reference = document.getElementById('oea-reference').value;
		var designation = document.getElementById('oea-designation').value;
		var numLot = document.getElementById('oea-numLot').value;
		var nbPieces = document.getElementById('oea-nbPieces').value;
		var quantite = document.getElementById('oea-quantite').value;
		var unite = document.getElementById('oea-unite').value;
		var datePeremption = document.getElementById('oea-datePeremption').value;
		var prixUnitaire = document.getElementById('oea-PU').value;
		var ristourne = document.getElementById('oea-ristourne').value;
		var codeTVA = document.getElementById('oea-codeTVA').value;

		if (isEmpty(nbPieces)) {
			nbPieces = 0;
		}

		if (isEmpty(designation)) { showWarning("D\u00E9signation de l'article manquante !"); }
		else if (!checkQte(quantite)) { showWarning("Quantit\u00E9 incorrecte !");	}
		else if (!isPositiveOrNullInteger(nbPieces)) { showWarning("Nombre de pi\u00E8ces incorrect !");	}
		else if (isEmpty(prixUnitaire) || !isPositiveOrNull(prixUnitaire) || !checkDecimal(prixUnitaire,4)) { showWarning("Prix unitaire incorrect !");	}
		else if (isEmpty(ristourne) || (oea_typeRistourne=='P'?!isTaux(ristourne):!isPositiveOrNull(ristourne) || !checkNumber(ristourne,9,2) || parseFloat(ristourne)>parseFloat(prixUnitaire))) { showWarning("Ristourne incorrecte"); }
		else if (oea_checkNumLotLigne(numLot, datePeremption)) {

			var qSave;

			if (oea_modeLigne=="C") {
				oea_currentIndex = oea_aLignes.nbLignes();

				qSave = new QueryHttp("Facturation/Avoirs/createLigneAvoirClient.tmpl");
				qSave.setParam("Avoir_Id", oea_avoirId);
			}
			else {
				qSave = new QueryHttp("Facturation/Avoirs/updateLigneAvoirClient.tmpl");
				qSave.setParam("Ligne_Id", oea_ligneId);
			}

			qSave.setParam("Reference", reference);
			qSave.setParam("Designation", designation);
			qSave.setParam("Quantite", quantite);
			qSave.setParam("Prix", prixUnitaire);
			qSave.setParam("Ristourne", ristourne);
			qSave.setParam("Type_Ristourne", oea_typeRistourne);
			qSave.setParam("Code_TVA", codeTVA);
			qSave.setParam("Libelle", oea_libelle);
			qSave.setParam("Code_Stats", codeStats);
			qSave.setParam("Unite", unite);
			qSave.setParam("Nb_Pieces", nbPieces);
			qSave.setParam("Num_Lot", numLot);
			qSave.setParam("Date_Peremption", datePeremption);

			var result = qSave.execute();

			if (oea_modeLigne=="C") {
				oea_ligneId = result.responseXML.documentElement.getAttribute('Ligne_Id');
		  }

			oea_checkNumSerieLigne(quantite);

			oea_ajouterLigne("I");
			oea_aLignes.deleteTree();
			oea_initTree2();
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oea_annulerLigne() {
  try {

  	oea_aLignes.clearSelection();
		oea_ajouterLigne("I");

	} catch (e) {
  	recup_erreur(e);
	}
}



function oea_supprimerLigne() {
  try {

		var listLigneId = "";
		var maxIndex = 0;

		if (!isEmpty(oea_ligneId)) {
			listLigneId = oea_ligneId;
			maxIndex = oea_currentIndex;
		}
		else {
			var start = new Object();
			var end = new Object();
			var numRanges = oea_aLignes.getRangeCount();

			for (var t=0; t<numRanges; t++){
				oea_aLignes.getRangeAt(t,start,end);
			  for (var v=start.value; v<=end.value; v++){
					if (oea_aLignes.getCellText(v,'oea-colTypeLigne')!="C") {
			  		listLigneId += oea_aLignes.getCellText(v,'oea-colLigneId')+",";
						if (v>maxIndex) maxIndex = v;
					}
			  }
			}
		}

		if (!isEmpty(listLigneId)) {
			var qDelete = new QueryHttp("Facturation/Avoirs/deleteLigneAvoirClient.tmpl");
			qDelete.setParam('List_Ligne_Id', listLigneId);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oea_currentIndex = maxIndex-1;
				oea_ajouterLigne("I");
				oea_aLignes.deleteTree();
				oea_initTree2();
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}



function oea_enregistrerAvoir() {
  try {

		var save = false;

		var utilR = document.getElementById('oea-responsable').value;
		var regimeTVA = document.getElementById('oea-regimeTVA').value;
		var numTva = oea_assujettiTVA?document.getElementById('oea-numTVA').value:"";
		var commentairesFin = document.getElementById('oea-commentairesFin').value;
		var commentairesInt = document.getElementById('oea-commentairesInt').value;
		var tarifVente = document.getElementById('oea-tarifVente').value;
		var remise = document.getElementById('oea-remise').value;
		var tauxRemise = 0;
		var montantRemise = 0;
		var fraisPort = document.getElementById('oea-fraisPort').value;
		var remiseFP = document.getElementById('oea-remiseFP').value;
		var tauxRemiseFP = 0;
		var montantRemiseFP = 0;
		var escompte = document.getElementById('oea-escompte').value;
		var primeCEE = document.getElementById('oea-primeCEE').value;
		var secteurActivite = document.getElementById('oea-secteur').value;

		var denominationFact = document.getElementById('oea-denominationFact').value;
		var adresse1Fact = document.getElementById('oea-adresse1Fact').value;
		var adresse2Fact = document.getElementById('oea-adresse2Fact').value;
		var adresse3Fact = document.getElementById('oea-adresse3Fact').value;
		var codePostalFact = document.getElementById('oea-codePostalFact').value;
		var villeFact = document.getElementById('oea-villeFact').value;
		var codePaysFact = document.getElementById('oea-codePaysFact').value;
		var civInterFact = document.getElementById('oea-civInterFact').value;
		var nomInterFact = document.getElementById('oea-nomInterFact').value;
		var prenomInterFact = document.getElementById('oea-prenomInterFact').value;
		var telInter1Fact = document.getElementById('oea-telInter1Fact').value;
		var telInter2Fact = document.getElementById('oea-telInter2Fact').value;
		var faxInterFact = document.getElementById('oea-faxInterFact').value;
		var emailInterFact = document.getElementById('oea-emailInterFact').value;

		var denominationLiv = document.getElementById('oea-denominationLiv').value;
		var adresse1Liv = document.getElementById('oea-adresse1Liv').value;
		var adresse2Liv = document.getElementById('oea-adresse2Liv').value;
		var adresse3Liv = document.getElementById('oea-adresse3Liv').value;
		var codePostalLiv = document.getElementById('oea-codePostalLiv').value;
		var villeLiv = document.getElementById('oea-villeLiv').value;
		var codePaysLiv = document.getElementById('oea-codePaysLiv').value;
		var civInterLiv = document.getElementById('oea-civInterLiv').value;
		var nomInterLiv = document.getElementById('oea-nomInterLiv').value;
		var prenomInterLiv = document.getElementById('oea-prenomInterLiv').value;
		var telInter1Liv = document.getElementById('oea-telInter1Liv').value;
		var telInter2Liv = document.getElementById('oea-telInter2Liv').value;
		var faxInterLiv = document.getElementById('oea-faxInterLiv').value;
		var emailInterLiv = document.getElementById('oea-emailInterLiv').value;

		var denominationEnvoi = document.getElementById('oea-denominationEnvoi').value;
		var adresse1Envoi = document.getElementById('oea-adresse1Envoi').value;
		var adresse2Envoi = document.getElementById('oea-adresse2Envoi').value;
		var adresse3Envoi = document.getElementById('oea-adresse3Envoi').value;
		var codePostalEnvoi = document.getElementById('oea-codePostalEnvoi').value;
		var villeEnvoi = document.getElementById('oea-villeEnvoi').value;
		var codePaysEnvoi = document.getElementById('oea-codePaysEnvoi').value;
		var civInterEnvoi = document.getElementById('oea-civInterEnvoi').value;
		var nomInterEnvoi = document.getElementById('oea-nomInterEnvoi').value;
		var prenomInterEnvoi = document.getElementById('oea-prenomInterEnvoi').value;
		var telInter1Envoi = document.getElementById('oea-telInter1Envoi').value;
		var telInter2Envoi = document.getElementById('oea-telInter2Envoi').value;
		var faxInterEnvoi = document.getElementById('oea-faxInterEnvoi').value;
		var emailInterEnvoi = document.getElementById('oea-emailInterEnvoi').value;

		var modeEnvoiAvoir = document.getElementById('oea-modeEnvoiAvoir').value;

		var montantBase = (oea_editionTTC?oea_montantTTC:oea_montantHT);

		oea_codeTVAPort = document.getElementById('oea-codeTVAFraisPort').value;
		var tauxTVAPort = getTva(oea_codeTVAPort);

		if (isEmpty(remise) || (oea_typeRemise=='P'?!isTaux(remise):!isPositiveOrNull(remise) || !checkNumber(remise,9,2) || parseFloat(remise)>montantBase)) { showWarning("Remise incorrecte !"); }
		else if (isEmpty(fraisPort) || !isPositiveOrNull(fraisPort)) { showWarning("Frais de port incorrects !"); }
		else if (isEmpty(primeCEE) || !isPositiveOrNull(primeCEE) || !checkNumber(primeCEE,9,2)) { showWarning("Prime CEE incorrecte"); }
		else if (isEmpty(remiseFP) || (oea_typeRemiseFP=='P'?!isTaux(remiseFP):!isPositiveOrNull(remiseFP) || !checkNumber(remiseFP,9,2) || parseFloat(remiseFP)>parseFloat(fraisPort))) { showWarning("Remise sur frais de port incorrecte !"); }
		else if (isEmpty(denominationFact)) { showWarning("Veuillez indiquer la d\u00E9nomination du client de facturation !"); }
		else if (isEmpty(adresse1Fact)) { showWarning("Veuillez indiquer l'adresse du client de facturation !"); }
		else if (isEmpty(villeFact)) { showWarning("Veuillez indiquer la ville du client de facturation !"); }
		else if (isEmpty(denominationLiv)) { showWarning("Veuillez indiquer la d\u00E9nomination du client de livraison !"); }
		else if (isEmpty(adresse1Liv)) { showWarning("Veuillez indiquer l'adresse du client de livraison !"); }
		else if (isEmpty(villeLiv)) { showWarning("Veuillez indiquer la ville du client de livraison !"); }
		else if (isEmpty(denominationEnvoi)) { showWarning("Veuillez indiquer la d\u00E9nomination du client d'envoi !"); }
		else if (isEmpty(adresse1Envoi)) { showWarning("Veuillez indiquer l'adresse du client d'envoi !"); }
		else if (isEmpty(villeEnvoi)) { showWarning("Veuillez indiquer la ville du client d'envoi !"); }
		else if (isEmpty(escompte) || !isTaux(escompte)) { showWarning("Taux d'escompte incorrect !"); }
		else if (!isEmpty(telInter1Fact) && !isPhone(telInter1Fact)) { showWarning("T\u00E9l\u00E9phone 1 de facturation incorrect !"); }
		else if (!isEmpty(telInter2Fact) && !isPhone(telInter2Fact)) { showWarning("T\u00E9l\u00E9phone 2 de facturation incorrect !"); }
		else if (gShowFax && !isEmpty(faxInterFact) && !isPhone(faxInterFact)) { showWarning("Num\u00E9ro de fax de facturation incorrect !"); }
		else if (!isEmpty(emailInterFact) && !isEmail(emailInterFact)) { showWarning("Adresse e-mail de facturation incorrecte !"); }
		else if (!isEmpty(telInter1Liv) && !isPhone(telInter1Liv)) { showWarning("T\u00E9l\u00E9phone 1 de livraison incorrect !"); }
		else if (!isEmpty(telInter2Liv) && !isPhone(telInter2Liv)) { showWarning("T\u00E9l\u00E9phone 2 de livraison incorrect !"); }
		else if (gShowFax && !isEmpty(faxInterLiv) && !isPhone(faxInterLiv)) { showWarning("Num\u00E9ro de fax de livraison incorrect !"); }
		else if (!isEmpty(emailInterLiv) && !isEmail(emailInterLiv)) { showWarning("Adresse e-mail de livraison incorrecte !"); }
		else if (!isEmpty(telInter1Envoi) && !isPhone(telInter1Envoi)) { showWarning("T\u00E9l\u00E9phone 1 d'envoi incorrect !"); }
		else if (!isEmpty(telInter2Envoi) && !isPhone(telInter2Envoi)) { showWarning("T\u00E9l\u00E9phone 2 d'envoi incorrect !"); }
		else if (gShowFax && !isEmpty(faxInterEnvoi) && !isPhone(faxInterEnvoi)) { showWarning("Num\u00E9ro de fax d'envoi incorrect !"); }
		else if (!isEmpty(emailInterEnvoi) && !isEmail(emailInterEnvoi)) { showWarning("Adresse e-mail d'envoi incorrecte !"); }
		else {

			fraisPort = parseFloat(fraisPort);
			remise = parseFloat(remise);
			remiseFP = parseFloat(remiseFP);

			if (oea_assujettiTVA && codePaysLiv!="FR" && isEmpty(numTva) && oea_zoneUE) {
				showWarning("Attention : vous n'avez pas saisi le num\u00E9ro de tva intra-communautaire !");
			}

			if (oea_typeRemise=='P') {
				tauxRemise = remise;
			}
			else {
				tauxRemise = (montantBase>0?remise/montantBase*100:0);
				montantRemise = remise;
			}

			if (oea_typeRemiseFP=='P') {
				tauxRemiseFP = remiseFP;
			}
			else {
				tauxRemiseFP = (fraisPort>0?remiseFP/fraisPort*100:0);
				montantRemiseFP = remiseFP;
			}

			var qSave = new QueryHttp("Facturation/Avoirs/updateAvoirClient.tmpl");
			qSave.setParam("Avoir_Id", oea_avoirId);
			qSave.setParam("Client_Id", oea_clientId);
			qSave.setParam("Util_R", utilR);
			qSave.setParam("Edition_TTC", oea_editionTTC);
			qSave.setParam("Regime_TVA", regimeTVA);
			qSave.setParam("Assujetti_TVA", oea_assujettiTVA);
			qSave.setParam("Numero_TVA", numTva);
			qSave.setParam("Pole_Activite", secteurActivite);
			qSave.setParam("Tarif_Id", tarifVente);
			qSave.setParam("Commentaires_Fin", commentairesFin);
			qSave.setParam("Commentaires_Int", commentairesInt);
			qSave.setParam("PRemise", tauxRemise);
			qSave.setParam("MRemise", montantRemise);
			qSave.setParam("PRemise_FP", tauxRemiseFP);
			qSave.setParam("MRemise_FP", montantRemiseFP);
			qSave.setParam("Escompte", escompte);
      qSave.setParam("Prime_CEE", primeCEE);
			qSave.setParam("Frais_Port", fraisPort);
			qSave.setParam("Code_TVA_Port", oea_codeTVAPort);
			qSave.setParam("Taux_TVA_Port", tauxTVAPort);
			qSave.setParam("Denomination", denominationFact);
			qSave.setParam("Adresse_1", adresse1Fact);
			qSave.setParam("Adresse_2", adresse2Fact);
			qSave.setParam("Adresse_3", adresse3Fact);
			qSave.setParam("Code_Postal", codePostalFact);
			qSave.setParam("Ville", villeFact);
			qSave.setParam("Code_Pays", codePaysFact);
			qSave.setParam("Civ_Inter", civInterFact);
			qSave.setParam("Nom_Inter", nomInterFact);
			qSave.setParam("Prenom_Inter", prenomInterFact);
			qSave.setParam("Tel_Inter_1", telInter1Fact);
			qSave.setParam("Tel_Inter_2", telInter2Fact);
			qSave.setParam("Fax_Inter", faxInterFact);
			qSave.setParam("Email_Inter", emailInterFact);
			qSave.setParam("Denomination_Liv", denominationLiv);
			qSave.setParam("Adresse_1_Liv", adresse1Liv);
			qSave.setParam("Adresse_2_Liv", adresse2Liv);
			qSave.setParam("Adresse_3_Liv", adresse3Liv);
			qSave.setParam("Code_Postal_Liv", codePostalLiv);
			qSave.setParam("Ville_Liv", villeLiv);
			qSave.setParam("Code_Pays_Liv", codePaysLiv);
			qSave.setParam("Civ_Inter_Liv", civInterLiv);
			qSave.setParam("Nom_Inter_Liv", nomInterLiv);
			qSave.setParam("Prenom_Inter_Liv", prenomInterLiv);
			qSave.setParam("Tel_Inter_1_Liv", telInter1Liv);
			qSave.setParam("Tel_Inter_2_Liv", telInter2Liv);
			qSave.setParam("Fax_Inter_Liv", faxInterLiv);
			qSave.setParam("Email_Inter_Liv", emailInterLiv);
			qSave.setParam("Denomination_Envoi", denominationEnvoi);
			qSave.setParam("Adresse_1_Envoi", adresse1Envoi);
			qSave.setParam("Adresse_2_Envoi", adresse2Envoi);
			qSave.setParam("Adresse_3_Envoi", adresse3Envoi);
			qSave.setParam("Code_Postal_Envoi", codePostalEnvoi);
			qSave.setParam("Ville_Envoi", villeEnvoi);
			qSave.setParam("Code_Pays_Envoi", codePaysEnvoi);
			qSave.setParam("Civ_Inter_Envoi", civInterEnvoi);
			qSave.setParam("Nom_Inter_Envoi", nomInterEnvoi);
			qSave.setParam("Prenom_Inter_Envoi", prenomInterEnvoi);
			qSave.setParam("Tel_Inter_1_Envoi", telInter1Envoi);
			qSave.setParam("Tel_Inter_2_Envoi", telInter2Envoi);
			qSave.setParam("Fax_Inter_Envoi", faxInterEnvoi);
			qSave.setParam("Email_Inter_Envoi", emailInterEnvoi);
			qSave.setParam("Mode_Envoi_Avoir", modeEnvoiAvoir);
			qSave.execute();

			oea_setModified(false);
			save = true;
		}

		return save;

	} catch (e) {
  	recup_erreur(e);
	}
}



function oea_calculTotaux() {
  try {

		if (oea_mode!='V') {
			document.getElementById('oea-editionTTC').disabled = (oea_aLignes.nbLignes()>0);
	    document.getElementById('oea-codePaysLiv').disabled = (oea_aLignes.nbLignes()>0);
	   	document.getElementById('oea-bChercherAdrLiv').disabled = (isEmpty(oea_clientId) || oea_aLignes.nbLignes()>0);
	    document.getElementById('oea-bCopierFactVersLivEnvoi').disabled = (oea_aLignes.nbLignes()>0);
	    document.getElementById('oea-tarifVente').disabled = (oea_aLignes.nbLignes()>0);
			document.getElementById('oea-regimeTVA').disabled = (oea_aLignes.nbLignes()>0);
			document.getElementById('oea-assujettiTVA').disabled = (oea_aLignes.nbLignes()>0);
		}

		var remise = parseFloat(document.getElementById('oea-remise').value);
		var tauxEscompte = parseFloat(document.getElementById('oea-escompte').value);
		var fraisPort = parseFloat(document.getElementById('oea-fraisPort').value);
		var remiseFP = parseFloat(document.getElementById('oea-remiseFP').value);
		var primeCEE = parseFloat(document.getElementById('oea-primeCEE').value);

		if (isPositiveOrNull(remise) && isPositiveOrNull(remiseFP) && isPositiveOrNull(tauxEscompte) && isPositiveOrNull(fraisPort) && isPositiveOrNull(primeCEE)) {

			var calculDocument = new CalculDocument();
			calculDocument.setEditionTTC(oea_editionTTC);
			if (oea_typeRemise=='P') { calculDocument.setRemiseP(remise); }
			else { calculDocument.setRemiseM(remise); }
			calculDocument.setFraisPortBruts(fraisPort);
			if (oea_typeRemiseFP=='P') { calculDocument.setRemiseFPP(remiseFP); }
			else { calculDocument.setRemiseFPM(remiseFP); }
			calculDocument.setCodeAndTauxTVAFP(document.getElementById('oea-codeTVAFraisPort').value, getTva(document.getElementById('oea-codeTVAFraisPort').value));
			calculDocument.setEscompteP(tauxEscompte);
			calculDocument.setPrimeCEE(primeCEE);

			for (var i=0;i<oea_aLignes.nbLignes();i++) {
				if (oea_aLignes.getCellText(i,'oea-colTypeLigne')!="C") {
					var montantLigne = oea_aLignes.getCellText(i,'oea-colTotal');
					var codeTVA = oea_aLignes.getCellText(i,'oea-colCodeTVA');
					calculDocument.addLigneDocument(montantLigne, codeTVA);
				}
			}

			calculDocument.calculer();

			if (oea_editionTTC) {
				document.getElementById('oea-pttcMontantRemise').value = calculDocument.getRemiseM();
				document.getElementById('oea-pttcMontantFraisPort').value = calculDocument.getFraisPortBruts();
				document.getElementById('oea-pttcMontantRemiseFP').value = calculDocument.getRemiseFPM();
				document.getElementById('oea-pttcTVA').value = calculDocument.getTotalTVA();
				document.getElementById('oea-pttcMontantTTC').value = calculDocument.getMontantTTC();
				document.getElementById('oea-pttcMontantEscompte').value = calculDocument.getEscompteM();
				document.getElementById('oea-pttcNetCommercial').value = calculDocument.getNetCommercial();
				document.getElementById('oea-pttcMontantPrimeCEE').value = calculDocument.getPrimeCEE();
				document.getElementById('oea-pttcTotalTTC').value = calculDocument.getTotalTTC();
				document.getElementById('oea-pttcNetTTC').value = calculDocument.getNetAPayer();

				oea_montantTTC = calculDocument.getMontantTTCSansFormat();

				document.getElementById('oea-rowRemiseTTC').collapsed = !calculDocument.afficherRemiseM();
				document.getElementById('oea-rowRemiseFPTTC').collapsed = !calculDocument.afficherRemiseFPM();
				document.getElementById('oea-rowNetCommercialTTC').collapsed = !calculDocument.afficherNetCommercial();
				document.getElementById('oea-rowEscompteTTC').collapsed = !calculDocument.afficherEscompteM();
			}
			else {
				document.getElementById('oea-montantHT').value = calculDocument.getMontantHT();
				document.getElementById('oea-montantRemise').value = calculDocument.getRemiseM();
				document.getElementById('oea-montantFraisPort').value = calculDocument.getFraisPortBruts();
				document.getElementById('oea-montantRemiseFP').value = calculDocument.getRemiseFPM();
				document.getElementById('oea-totalHT').value = calculDocument.getTotalHT();
				document.getElementById('oea-TVA').value = calculDocument.getTotalTVA();
				document.getElementById('oea-montantEscompte').value = calculDocument.getEscompteM();
				document.getElementById('oea-netCommercial').value = calculDocument.getNetCommercial();
				document.getElementById('oea-montantPrimeCEE').value = calculDocument.getPrimeCEE();
				document.getElementById('oea-totalTTC').value = calculDocument.getTotalTTC();

				oea_montantHT = calculDocument.getMontantHTSansFormat();
				oea_montantTTC = calculDocument.getMontantTTCSansFormat();

				document.getElementById('oea-rowRemiseHT').collapsed = !calculDocument.afficherRemiseM();
				document.getElementById('oea-rowRemiseFPHT').collapsed = !calculDocument.afficherRemiseFPM();
				document.getElementById('oea-rowNetCommercialHT').collapsed = !calculDocument.afficherNetCommercial();
				document.getElementById('oea-rowEscompteHT').collapsed = !calculDocument.afficherEscompteM();
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}



function oea_afterRefreshArticles() {
	try {

		if (oea_toSelectLigne!=null) {
			for (var i=0; i<oea_aLignes.nbLignes(); i++) {
				if (oea_aLignes.getCellText(i, "oea-colLigneId")==oea_toSelectLigne && oea_aLignes.getCellText(i, "oea-colTypeLigne")!="C") {
					oea_aLignes.select(i);
					break;
				}
			}
			oea_toSelectLigne = null;
		}
		oea_aLignes.ensureRowIsVisible(oea_currentIndex);

		document.getElementById('oea-reference').focus();
		oea_calculTotaux();

	} catch (e) {
  	recup_erreur(e);
	}
}


function oea_demandeEnregistrement() {
  try {

		if (oea_modified) {
			if (window.confirm("Voulez-vous enregistrer les modifications apport\u00E9es \u00E0 l'avoir ?")) {
				oea_enregistrerAvoir();
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oea_setModified(m) {
  try {

  	oea_modified = m && !gReadOnly;

		if (oea_modified) {
			document.getElementById('oea-tabAvoir').setAttribute('image', 'chrome://opensi/content/design/icones/modified.png');
			document.getElementById('oea-bApercu').disabled = true;
			document.getElementById('oea-bVisualiser').disabled = true;
			document.getElementById('oea-bValiderAvoir').disabled = true;
		}
		else {
			document.getElementById('oea-tabAvoir').setAttribute('image', gReadOnly?'chrome://opensi/content/design/icones/readonly.png':null);
			document.getElementById('oea-bApercu').disabled = false;
			document.getElementById('oea-bVisualiser').disabled = false;
			document.getElementById('oea-bValiderAvoir').disabled = false;
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oea_initTree2() {
  try {

  	oea_aLignes.setParam("Avoir_Id", oea_avoirId);
  	oea_aLignes.initTree(oea_afterRefreshArticles);

  } catch (e) {
    recup_erreur(e);
  }
}


function oea_editerCommentaire() {
  try {

		if (oea_aLignes.isSelected()) {
			var ligneId = oea_aLignes.getSelectedCellText('oea-colLigneId');

			var url = "chrome://opensi/content/facturation/user/commun/popup-commentairesLigne.xul";
    	window.openDialog(url,'','chrome,modal,centerscreen', "AC", ligneId);

			oea_aLignes.deleteTree();
			oea_initTree2();
			oea_ajouterLigne("I");
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oea_editerCommentairesInternes() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-commentairesInternes.xul";
  	window.openDialog(url,'','chrome,modal,centerscreen', "AC", oea_avoirId, gReadOnly);

	} catch (e) {
    recup_erreur(e);
  }
}


function oea_editerCommentairesDocument() {
  try {

		var commentairesFin = document.getElementById('oea-commentairesFin').value;
		var commentairesInt = document.getElementById('oea-commentairesInt').value;
		var readOnly = (oea_mode=="V" || gReadOnly);

		var url = "chrome://opensi/content/facturation/user/commun/popup-commentairesDocument.xul";
  	window.openDialog(url,'','chrome,modal,centerscreen', oea_retourEditerCommentaires, "AC", oea_avoirId, commentairesFin, commentairesInt, readOnly);

	} catch (e) {
    recup_erreur(e);
  }
}


function oea_retourEditerCommentaires(commentairesFin, commentairesInt) {
  try {

		document.getElementById('oea-commentairesFin').value = commentairesFin;
		document.getElementById('oea-commentairesInt').value = commentairesInt;

	} catch (e) {
    recup_erreur(e);
  }
}


function oea_evaluer(field, ev) {
	try {

		var val = field.value;

		if (ev.keyCode==13 && !isEmpty(val) && isArithmetic(val)) {
			field.value = calcExpr(val);
		}

	}	catch(e) {
		recup_erreur(e);
	}
}


function oea_pressOnLineNumberField(field, ev) {
	try {

		var val = field.value;

		if (ev.keyCode==13 && !isEmpty(val)) {
			if (isArithmetic(val)) {
				field.value = calcExpr(val);
			}
			else {
				oea_validerLigne();
			}
		}

	}	catch(e) {
		recup_erreur(e);
	}
}


function oea_changerTypeEdition(chgType) {
	try {

		oea_editionTTC = chgType;

		if (oea_editionTTC) {
			document.getElementById('oea-colTotal').setAttribute("label", "Total TTC");
			document.getElementById('oea-colPU').setAttribute("label", "P.U TTC");
			document.getElementById('oea-lblFraisPort').value = "Frais de port (ttc) :";
			document.getElementById('oea-lblPU').value = "P.U TTC :";
			document.getElementById('oea-piedTTC').collapsed = false;
			document.getElementById('oea-piedHT').collapsed = true;
		}
		else {
			document.getElementById('oea-colTotal').setAttribute("label", "Total HT");
			document.getElementById('oea-colPU').setAttribute("label", "P.U HT");
			document.getElementById('oea-lblFraisPort').value = "Frais de port (ht) :";
			document.getElementById('oea-lblPU').value = "P.U HT :";
			document.getElementById('oea-piedTTC').collapsed = true;
			document.getElementById('oea-piedHT').collapsed = false;
		}

	}	catch(e) {
		recup_erreur(e);
	}
}


function oea_changerAssujettiTVA(etat) {
	try {

		oea_assujettiTVA = etat;
		document.getElementById('oea-numTVA').disabled=!oea_assujettiTVA;
		oea_chargerTVAPort();
		oea_setModified(true);

	}	catch(e) {
		recup_erreur(e);
	}
}


function oea_rechercherAdrFact() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-choixAdresse.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oea_reporterAdrFact, oea_clientId, gReadOnly);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oea_reporterAdrFact(nom, adr1, adr2, adr3, cp, ville, pays, codePays, contactFact, contactLiv, contactEnvoi, contactDevis, adresseId) {
  try {

		document.getElementById('oea-denominationFact').value = nom;
		document.getElementById('oea-adresse1Fact').value = adr1;
		document.getElementById('oea-adresse2Fact').value = adr2;
		document.getElementById('oea-adresse3Fact').value = adr3;
		document.getElementById('oea-codePostalFact').value = cp;
		document.getElementById('oea-villeFact').value = ville;
	  document.getElementById('oea-codePaysFact').value = codePays;

	  if (!isEmpty(contactFact)) {
	  	var qLoad = new QueryHttp("Facturation/Clients/loadContactClient.tmpl");
	  	qLoad.setParam("Contact_Id", contactFact);
	  	var result = qLoad.execute();
	  	var contenu = result.responseXML.documentElement;
	  	oea_reporterInterFact(contenu.getAttribute("Civilite"), contenu.getAttribute("Nom"), contenu.getAttribute("Prenom"), contenu.getAttribute("Tel_1"),contenu.getAttribute("Tel_2"), contenu.getAttribute("Fax"), contenu.getAttribute("Email"));
	  }
		oea_setModified(true);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oea_rechercherInterlocuteurFact() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-choixInter.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oea_reporterInterFact, oea_clientId, gReadOnly);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oea_reporterInterFact(civ, nom, prenom, tel1, tel2, fax, email) {
  try {

		document.getElementById('oea-civInterFact').value = civ;
		document.getElementById('oea-nomInterFact').value = nom;
		document.getElementById('oea-prenomInterFact').value = prenom;
		document.getElementById('oea-telInter1Fact').value = tel1;
		document.getElementById('oea-telInter2Fact').value = tel2;
		document.getElementById('oea-faxInterFact').value = fax;
		document.getElementById('oea-emailInterFact').value = email;

		oea_setModified(true);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oea_rechercherAdrEnvoi() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-choixAdresse.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oea_reporterAdrEnvoi, oea_clientId, gReadOnly);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oea_reporterAdrEnvoi(nom, adr1, adr2, adr3, cp, ville, pays, codePays, contactFact, contactLiv, contactEnvoi, contactDevis, adresseId) {
  try {

		document.getElementById('oea-denominationEnvoi').value = nom;
		document.getElementById('oea-adresse1Envoi').value = adr1;
		document.getElementById('oea-adresse2Envoi').value = adr2;
		document.getElementById('oea-adresse3Envoi').value = adr3;
		document.getElementById('oea-codePostalEnvoi').value = cp;
		document.getElementById('oea-villeEnvoi').value = ville;
	  document.getElementById('oea-codePaysEnvoi').value = codePays;

	  if (!isEmpty(contactEnvoi)) {
	  	var qLoad = new QueryHttp("Facturation/Clients/loadContactClient.tmpl");
	  	qLoad.setParam("Contact_Id", contactEnvoi);
	  	var result = qLoad.execute();
	  	var contenu = result.responseXML.documentElement;
	  	oea_reporterInterEnvoi(contenu.getAttribute("Civilite"), contenu.getAttribute("Nom"), contenu.getAttribute("Prenom"), contenu.getAttribute("Tel_1"),contenu.getAttribute("Tel_2"), contenu.getAttribute("Fax"), contenu.getAttribute("Email"));
	  }

		oea_setModified(true);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oea_copierFactVersLivEnvoi() {
	try {

		document.getElementById('oea-denominationLiv').value = document.getElementById('oea-denominationFact').value;
		document.getElementById('oea-adresse1Liv').value = document.getElementById('oea-adresse1Fact').value;
		document.getElementById('oea-adresse2Liv').value = document.getElementById('oea-adresse2Fact').value;
		document.getElementById('oea-adresse3Liv').value = document.getElementById('oea-adresse3Fact').value;
		document.getElementById('oea-codePostalLiv').value = document.getElementById('oea-codePostalFact').value;
		document.getElementById('oea-villeLiv').value = document.getElementById('oea-villeFact').value;
	  document.getElementById('oea-codePaysLiv').value = document.getElementById('oea-codePaysFact').value;

	  document.getElementById('oea-civInterLiv').value = document.getElementById('oea-civInterFact').value;
		document.getElementById('oea-nomInterLiv').value = document.getElementById('oea-nomInterFact').value;
		document.getElementById('oea-prenomInterLiv').value = document.getElementById('oea-prenomInterFact').value;
		document.getElementById('oea-telInter1Liv').value = document.getElementById('oea-telInter1Fact').value;
		document.getElementById('oea-telInter2Liv').value = document.getElementById('oea-telInter2Fact').value;
		document.getElementById('oea-faxInterLiv').value = document.getElementById('oea-faxInterFact').value;
		document.getElementById('oea-emailInterLiv').value = document.getElementById('oea-emailInterFact').value;

		document.getElementById('oea-denominationEnvoi').value = document.getElementById('oea-denominationFact').value;
		document.getElementById('oea-adresse1Envoi').value = document.getElementById('oea-adresse1Fact').value;
		document.getElementById('oea-adresse2Envoi').value = document.getElementById('oea-adresse2Fact').value;
		document.getElementById('oea-adresse3Envoi').value = document.getElementById('oea-adresse3Fact').value;
		document.getElementById('oea-codePostalEnvoi').value = document.getElementById('oea-codePostalFact').value;
		document.getElementById('oea-villeEnvoi').value = document.getElementById('oea-villeFact').value;
	  document.getElementById('oea-codePaysEnvoi').value = document.getElementById('oea-codePaysFact').value;

	  document.getElementById('oea-civInterEnvoi').value = document.getElementById('oea-civInterFact').value;
		document.getElementById('oea-nomInterEnvoi').value = document.getElementById('oea-nomInterFact').value;
		document.getElementById('oea-prenomInterEnvoi').value = document.getElementById('oea-prenomInterFact').value;
		document.getElementById('oea-telInter1Envoi').value = document.getElementById('oea-telInter1Fact').value;
		document.getElementById('oea-telInter2Envoi').value = document.getElementById('oea-telInter2Fact').value;
		document.getElementById('oea-faxInterEnvoi').value = document.getElementById('oea-faxInterFact').value;
		document.getElementById('oea-emailInterEnvoi').value = document.getElementById('oea-emailInterFact').value;

	  oea_chargerTVAPort();
		oea_setModified(true);

	} catch (e) {
		recup_erreur(e);
	}
}


function oea_rechercherAdrLiv() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-choixAdresse.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oea_reporterAdrLiv, oea_clientId, gReadOnly);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oea_reporterAdrLiv(nom, adr1, adr2, adr3, cp, ville, pays, codePays, contactFact, contactLiv, contactEnvoi, contactDevis, adresseId) {
  try {

		document.getElementById('oea-denominationLiv').value = nom;
		document.getElementById('oea-adresse1Liv').value = adr1;
		document.getElementById('oea-adresse2Liv').value = adr2;
		document.getElementById('oea-adresse3Liv').value = adr3;
		document.getElementById('oea-codePostalLiv').value = cp;
		document.getElementById('oea-villeLiv').value = ville;
	  document.getElementById('oea-codePaysLiv').value = codePays;
	  oea_chargerTVAPort();

		if (!isEmpty(contactLiv)) {
	  	var qLoad = new QueryHttp("Facturation/Clients/loadContactClient.tmpl");
	  	qLoad.setParam("Contact_Id", contactLiv);
	  	var result = qLoad.execute();
	  	var contenu = result.responseXML.documentElement;
	  	oea_reporterInterLiv(contenu.getAttribute("Civilite"),contenu.getAttribute("Nom"),contenu.getAttribute("Prenom"),contenu.getAttribute("Tel_1"),contenu.getAttribute("Tel_2"),contenu.getAttribute("Fax"),contenu.getAttribute("Email"));
	  }
	  oea_setModified(true);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oea_rechercherInterlocuteurLiv() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-choixInter.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oea_reporterInterLiv, oea_clientId, gReadOnly);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oea_reporterInterLiv(civ, nom, prenom, tel1, tel2, fax, email) {
  try {

		document.getElementById('oea-civInterLiv').value = civ;
		document.getElementById('oea-nomInterLiv').value = nom;
		document.getElementById('oea-prenomInterLiv').value = prenom;
		document.getElementById('oea-telInter1Liv').value = tel1;
		document.getElementById('oea-telInter2Liv').value = tel2;
		document.getElementById('oea-faxInterLiv').value = fax;
		document.getElementById('oea-emailInterLiv').value = email;

		oea_setModified(true);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oea_rechercherInterlocuteurEnvoi() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-choixInter.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oea_reporterInterEnvoi, oea_clientId, gReadOnly);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oea_reporterInterEnvoi(civ, nom, prenom, tel1, tel2, fax, email) {
  try {

		document.getElementById('oea-civInterEnvoi').value = civ;
		document.getElementById('oea-nomInterEnvoi').value = nom;
		document.getElementById('oea-prenomInterEnvoi').value = prenom;
		document.getElementById('oea-telInter1Envoi').value = tel1;
		document.getElementById('oea-telInter2Envoi').value = tel2;
		document.getElementById('oea-faxInterEnvoi').value = fax;
		document.getElementById('oea-emailInterEnvoi').value = email;

		oea_setModified(true);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oea_choisirMentions() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-mentionsDocument.xul";
  	window.openDialog(url,'','chrome,modal,centerscreen', "AC", oea_avoirId, gReadOnly);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oea_apercuAvoir() {
  try {

		if (oea_aLignes.nbLignes()==0 && document.getElementById('oea-fraisPort').value==0) {
			showWarning("L'avoir ne contient aucune ligne");
		}
		else {
			oea_apercu = true;

			var qLangueDefaut = new QueryHttp("Facturation/Commun/getLangueDefaut.tmpl");
			qLangueDefaut.setParam("Type_Doc", "AC");
			qLangueDefaut.setParam("Doc_Id", oea_avoirId);
			var result = qLangueDefaut.execute();
			oea_langueDefaut = result.responseXML.documentElement.getAttribute("Langue_Id");
			oea_aLangues.setParam("Selection", oea_langueDefaut);
			oea_aLangues.initTree(oea_initLangue);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oea_editerAvoir() {
	try {

		var ok = true;

		if (oea_actSuiviSerie && oea_mode=="M") {
			var qCheck = new QueryHttp("Facturation/Avoirs/checkNumSerieAC.tmpl");
			qCheck.setParam("Avoir_Id", oea_avoirId);
			var result = qCheck.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
				ok = false;
			}
		}

	  if (ok && oea_mode=="M") {
	  	ok = window.confirm("Confirmez-vous la g\u00E9n\u00E9ration de l'avoir ?\n(Attention l'avoir g\u00E9n\u00E9r\u00E9 ne pourra plus \u00EAtre modifi\u00E9 !)");
	  }

		if (ok) {
			var montantBase = (oea_editionTTC?oea_montantTTC:oea_montantHT);
			var remise = document.getElementById('oea-remise').value;

			if (oea_aLignes.nbLignes()==0 && document.getElementById('oea-fraisPort').value==0) {
				showWarning("L'avoir ne contient aucune ligne");
			}
			else if (isEmpty(remise) || (oea_typeRemise=='P'?!isTaux(remise):!isPositiveOrNull(remise) || !checkNumber(remise,9,2) || parseFloat(remise)>montantBase)) {
				showWarning("Remise incorrecte !");
			}
			else {
				oea_apercu = false;

				var qLangueDefaut = new QueryHttp("Facturation/Commun/getLangueDefaut.tmpl");
				qLangueDefaut.setParam("Type_Doc", "AC");
				qLangueDefaut.setParam("Doc_Id", oea_avoirId);
				var result = qLangueDefaut.execute();
				oea_langueDefaut = result.responseXML.documentElement.getAttribute("Langue_Id");
				oea_aLangues.setParam("Selection", oea_langueDefaut);
				oea_aLangues.initTree(oea_initLangue);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oea_initLangue() {
	try {

		document.getElementById('oea-langueDefaut').value = oea_langueDefaut;
		oea_visualiserAvoir();

	} catch (e) {
		recup_erreur(e);
	}
}


function oea_visualiserAvoir() {
  try {

		var langue = document.getElementById('oea-langueDefaut').value;
		var qGenPdf = new QueryHttp("Facturation/Avoirs/pdfAvoirClient.tmpl");
		qGenPdf.setParam("Avoir_Id", oea_avoirId);
		qGenPdf.setParam("Langue_Id", langue);
		qGenPdf.setParam("Apercu", oea_apercu);
		var result = qGenPdf.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			document.getElementById('oea-pdfAvoir').setAttribute('src', '');
			document.getElementById('oea-deckAvoir').selectedIndex = 1;
			document.getElementById('bRetourAvoir').collapsed = false;

			var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');

			if (oea_mode=="M" && gConfig.isGACProposerRbt()) {
				// il faudrait mettre ce code dans une vraie fonction de validation de l'avoir, enlever le valid/edit avoir simultan !

				var qCheck = new QueryHttp("Facturation/Affaires/checkRemboursementPossible.tmpl");
				qCheck.setParam("Document_Id", oea_avoirId);
				qCheck.setParam("Type_Doc", "A");
				var result2 = qCheck.execute();

				var errors2 = new Errors(result2);
				if (errors2.hasNext()) {
					errors2.show();
				}
				else {
					var rbtPossible = result2.responseXML.documentElement.getAttribute("Possible")=="true";

					if (rbtPossible && window.confirm("Voulez-vous cr\u00E9er un remboursement \u00E0 effectuer pour cet avoir ?")) {
						var denominationFact = document.getElementById('oea-denominationFact').value;

						var url = "chrome://opensi/content/facturation/user/affaires/popup-creationRemboursement.xul";
						window.openDialog(url,'','chrome,modal,centerscreen', "A", oea_avoirId, oea_clientId, denominationFact);
					}
				}
			}

			document.getElementById('oea-pdfAvoir').setAttribute("src", page);	// dplac aprs remboursement sinon pb blocage xul sur windows
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oea_envoyerMail() {
	try {

		var langue = document.getElementById('oea-langueDefaut').value;

		var url = "chrome://opensi/content/popup/popup-envoyerMail.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', "AC", oea_avoirId, langue);

	} catch (e) {
		recup_erreur(e);
	}
}


function oea_supprimerAvoir() {
  try {

		if (window.confirm("Confirmez-vous la suppression de l'avoir ?")) {
			var qDelete = new QueryHttp("Facturation/Avoirs/deleteAvoirClient.tmpl");
			qDelete.setParam("Avoir_Id", oea_avoirId);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showMessage("L'avoir a \u00E9t\u00E9 supprim\u00E9");
			}

			retourFicheAffaire();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oea_initVersion() {
	try {

		oea_aVersion.setParam("Avoir_Id", oea_avoirId);
		oea_aVersion.initTree();

	} catch (e) {
		recup_erreur(e);
	}
}


function oea_checkNumSerieLigne(quantite) {
	try {

		if (oea_actSuiviSerie && !isEmpty(oea_articleId)) {

			var qSuiviSerie = new QueryHttp("Facturation/Articles/getSuiviSerie.tmpl");
			qSuiviSerie.setParam("Article_Id", oea_articleId);
			var result = qSuiviSerie.execute();
			var isSuiviSerie = (result.responseXML.documentElement.getAttribute("Suivi_Serie")=="true");

			var wrongNbSerie = false;

			if (oea_modeLigne=="M") {
			  var qNbSerie = new QueryHttp("Facturation/Avoirs/getNbNumSerieLigneAC.tmpl");
			  qNbSerie.setParam("Ligne_Id", oea_ligneId);
			  var resNS = qNbSerie.execute();
			  var nb = parseIntBis(resNS.responseXML.documentElement.getAttribute("Nombre"));
			  if ((isSuiviSerie && nb!=quantite) || nb>quantite) {
					wrongNbSerie = true;
			  }
		  }

			if ((oea_modeLigne=="C" && isSuiviSerie) || wrongNbSerie) {
				var url = "chrome://opensi/content/facturation/user/commun/popup-numSerie.xul";
		    window.openDialog(url,'','chrome,modal,centerscreen', "S", "AC", oea_ligneId, oea_clientId);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oea_consulterNumSerie() {
	try {

		if (oea_aLignes.isSelected()) {
			var url = "chrome://opensi/content/facturation/user/commun/popup-numSerie.xul";
   		window.openDialog(url,'','chrome,modal,centerscreen', (oea_mode!="V" && !gReadOnly?"S":"C"), "AC", oea_ligneId);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oea_checkNumLotLigne(numero, datePeremption) {
	try {

		var ok = true;

		if (oea_actSuiviLot && !isEmpty(oea_articleId)) {

			var qSuiviLotDLC = new QueryHttp("Facturation/Articles/getSuiviLotDLC.tmpl");
			qSuiviLotDLC.setParam("Article_Id", oea_articleId);
			var result = qSuiviLotDLC.execute();
			var isSuiviLot = (result.responseXML.documentElement.getAttribute("Suivi_Lot")=="true");
			var isSuiviDLC = (result.responseXML.documentElement.getAttribute("Suivi_DLC")=="true");

			if ((isSuiviLot || !isEmpty(datePeremption)) && isEmpty(numero)) {
				ok = false;
				showWarning("N\u00B0 Lot manquant");
			}
			else if (isSuiviDLC && isEmpty(datePeremption)) {
				ok = false;
				showWarning("Date de p\u00E9remption manquante");
			}
			else if (!isEmpty(datePeremption) && !isDate(datePeremption)) {
				ok = false;
				showWarning("Date de p\u00E9remption incorrecte");
			}
		}

		return ok;

	} catch (e) {
		recup_erreur(e);
	}
}


function oea_onKeyPressNumLot(ev) {
	try {

		if (ev.keyCode==13 && !isEmpty(oea_articleId)) {
			var numero = document.getElementById("oea-numLot").value;

			var url = "chrome://opensi/content/facturation/user/tracabilite_articles/popup-rechercheLot.xul";
			window.openDialog(url,'','chrome,modal,centerscreen', oea_retourRechercherLot, oea_articleId, numero, null, oea_clientId);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oea_retourRechercherLot(numero, datePeremption) {
	try {

		document.getElementById("oea-numLot").value = numero;
		document.getElementById("oea-datePeremption").value = datePeremption;

	} catch (e) {
		recup_erreur(e);
	}
}


function oea_updateDLC() {
	try {

		var numero = document.getElementById("oea-numLot").value;

		if (!isEmpty(numero) && !isEmpty(oea_articleId)) {
			var qGetDLC = new QueryHttp("Facturation/Tracabilite/getDLCNumLot.tmpl");
			qGetDLC.setParam("Article_Id", oea_articleId);
			qGetDLC.setParam("Numero", numero);
			var result = qGetDLC.execute();
			var datePeremption = result.responseXML.documentElement.getAttribute("Date_Peremption");
			if (!isEmpty(datePeremption)) {
				document.getElementById("oea-datePeremption").value = datePeremption;
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oea_chargerTarifsVente(selection) {
	try {

		oea_selTarifVente = selection;
		oea_aTarifsVente.setParam("Selection", oea_selTarifVente);
		oea_aTarifsVente.initTree(oea_initTarifVente);

	} catch (e) {
		recup_erreur(e);
	}
}


function oea_initTarifVente() {
  try {

		document.getElementById('oea-tarifVente').value = oea_selTarifVente;

	} catch (e) {
  	recup_erreur(e);
	}
}
