/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

var oco_aColis = new Arbre("Facturation/Affaires/list-colisCB.tmpl", "oco-listeColis");
var oco_aHorsColis = new Arbre("Facturation/Affaires/list-horsColisCB.tmpl", "oco-horsColis");
var oco_aContenuColis = new Arbre("Facturation/Affaires/list-contenuColisCB.tmpl", "oco-contenuColis");

var oco_qEtiquettes = new QueryHttp("Facturation/Affaires/pdfEtiquettes.tmpl");
var oco_qCalculColisage = new QueryHttp("Facturation/Affaires/calculColisage.tmpl");


var oco_colisId = 0;
var oco_autEtiq = false;



function oco_init() {
  try {

		oco_colisId = 0;
		oco_disableRetirer(true);
		oco_disableAjouter(true);

		var qGet = new QueryHttp("Facturation/Affaires/getNbColisSuivi.tmpl");
		qGet.setParam("Bon_Id", oeb_bonLivId);
		var result = qGet.execute();
		document.getElementById("oco-bCalculColisage").disabled = result.responseXML.documentElement.getAttribute('NbColis')>0;

		oco_qCalculColisage.setParam("Bon_Id", oeb_bonLivId);

		oco_aColis.setParam("Bon_Liv_Id", oeb_bonLivId);
		oco_aColis.initTree(oco_calcColis);

		oco_aHorsColis.setParam("Bon_Liv_Id", oeb_bonLivId);
		oco_aHorsColis.initTree();

		oco_nouveauColis();

		document.getElementById("bRetourExpedition").collapsed = false;

		if (gReadOnly) {
			document.getElementById("oco-boxActions").collapsed = true;
			document.getElementById("oco-bCalculColisage").collapsed = true;
			document.getElementById("oco-bNouveauColis").collapsed = true;
		}

  } catch (e) {
    recup_erreur(e);
  }
}


function oco_nouveauColis() {
	try {

		oco_aContenuColis.deleteTree();
		oco_colisId = 0;
		document.getElementById('oco-lblContenu').value = "Nouveau colis :";

	} catch (e) {
    recup_erreur(e);
  }
}


function oco_reporterQteEntree() {
	try {

		if (oco_aHorsColis.isSelected()) {
			if (oco_aHorsColis.nbSelection()==1) {
				document.getElementById("oco-QteEntree").value = oco_aHorsColis.getSelectedCellText('oco-colQuantiteHC');
				document.getElementById("oco-QteEntree").disabled = false;
				var poidsUnit = oco_aHorsColis.getSelectedCellText('oco-colPoidsHC');
				document.getElementById("oco-PoidsEntree").value = poidsUnit;
				document.getElementById('oco-PoidsEntree').disabled = !isEmpty(poidsUnit);
				oco_disableAjouter(false);
			}
			else {
				document.getElementById("oco-QteEntree").value = "";
				document.getElementById("oco-QteEntree").disabled = true;
				document.getElementById("oco-PoidsEntree").value = "";
				document.getElementById('oco-PoidsEntree').disabled = true;
				document.getElementById('oco-bAjouter').disabled = false;
			}
			oco_disableRetirer(true);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oco_reporterQteSortie() {
	try {

		if (oco_aContenuColis.isSelected()) {
			document.getElementById("oco-QteSortie").value = oco_aContenuColis.getSelectedCellText('oco-colQuantite');
			oco_disableRetirer(false);
			oco_disableAjouter(true);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oco_disableAjouter(b) {
	try {
		document.getElementById('oco-bAjouter').disabled = b;
		document.getElementById('oco-QteEntree').disabled = b;
		document.getElementById('oco-PoidsEntree').disabled = b;
	} catch (e) {
    recup_erreur(e);
  }
}


function oco_disableRetirer(b) {
	try {
		document.getElementById('oco-bRetirer').disabled = b;
		document.getElementById('oco-QteSortie').disabled = b;
	} catch (e) {
    recup_erreur(e);
  }
}


function oco_calculColisage() {
	try {

		oco_qCalculColisage.execute();
		oco_aHorsColis.initTree();
		oco_aColis.initTree(oco_calcColis);
		oco_nouveauColis();

	} catch (e) {
    recup_erreur(e);
  }
}


function oco_ajouterAuColis() {
	try {

		if (oco_aHorsColis.isSelected()) {

			var qAdd = new QueryHttp("Facturation/Affaires/ajouterArticleColis.tmpl");

			if (oco_aHorsColis.nbSelection()==1) {
				var refLigne = oco_aHorsColis.getSelectedCellValue('oco-colReferenceHC');
				var qteinit = oco_aHorsColis.getSelectedCellText('oco-colQuantiteHC');
				var poids = document.getElementById("oco-PoidsEntree").value;
				var quantite = document.getElementById("oco-QteEntree").value;

				if (isEmpty(quantite)) {
					showWarning("Veuillez entrer une quantit\u00E9 \u00E0 transf\u00E9rer");
				}
				else if (!checkQte(quantite)) {
					showWarning("Quantit\u00E9 incorrecte !");
				}
				else if (parseFloat(qteinit)-parseFloat(quantite)<0) {
					showWarning("La quantit\u00E9 \u00E0 transf\u00E9rer d\u00E9passe la quantit\u00E9 restant \u00E0 livrer !");
				}
				else if (isEmpty(poids)) {
					showWarning("Veuillez entrer un poids unitaire pour cet article !");
				}
				else if (!isPositiveOrNull(poids) || !checkDecimal(poids,3)) {
					showWarning("Poids unitaire incorrect !");
				}
				else {
					oco_disableAjouter(true);

					qAdd.setParam("Colis_Id", oco_colisId);
					qAdd.setParam("Ref_Ligne", refLigne);
					qAdd.setParam("Quantite", quantite);
					qAdd.setParam("Poids", poids);
					qAdd.setParam("Bon_Id", oeb_bonLivId);
					qAdd.execute(oco_ajouterAuColis_2);
				}
			}
			else {
				var liste = "";
				var rangeCount = oco_aHorsColis.getRangeCount();

				for (var j=0; j<rangeCount; j++) {
					var start = {};
					var end = {};
					oco_aHorsColis.getRangeAt(j,start,end);

					for (var c=start.value; c<=end.value; c++) {
						if (c>=0) {
							// si clic dans liste en dehors d'une ligne, la 1re ligne se slectionne en pointillets, puis slection d'une 2me ligne avec appui sur ctrl
							// les pointillets disparaissent, seule la ligne 2 est visuellement slectionne, mais le 1er c vaut -1 !
							// attention ne dysfonctionne pas tout le temps, veiller  ce que les champs poids et quantit soient vide et disabled et une seule ligne slectionne visuellement
							// de manire gnral ne dysfonctionne qu' partir du deuxime essai

							if (!isEmpty(liste)) { liste += ",";  }

							var poids = oco_aHorsColis.getCellText(c, 'oco-colPoidsHC');
							if (isEmpty(poids)) {
								poids = 0;
							}
							liste += oco_aHorsColis.getCellValue(c, 'oco-colReferenceHC') +";"+ oco_aHorsColis.getCellText(c, 'oco-colQuantiteHC') +";"+ poids;
						}
					}
				}
				oco_disableAjouter(true);

				qAdd.setParam("List_Ligne_Id", liste);
				qAdd.setParam("Colis_Id", oco_colisId);
				qAdd.setParam("Bon_Id", oeb_bonLivId);
				qAdd.execute(oco_ajouterAuColis_2);
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oco_ajouterAuColis_2(result) {
	try {

		if (oco_colisId==0) {
			oco_colisId = result.responseXML.documentElement.getAttribute("Colis_Id");
			document.getElementById('oco-lblContenu').value = "Contenu du colis n\u00B0 "+ oco_colisId;
		}
		oco_aContenuColis.setParam("Colis_Id", oco_colisId);
		oco_aContenuColis.initTree();
		oco_aHorsColis.initTree();
		oco_aColis.initTree(oco_calcColis);

	} catch (e) {
    recup_erreur(e);
  }
}


function oco_retirerAuColis() {
  try {

		if (oco_aContenuColis.isSelected()) {

			var ref_ligne = oco_aContenuColis.getSelectedCellValue('oco-colReference');
			var qteinit = oco_aContenuColis.getSelectedCellText('oco-colQuantite');
			var poids = oco_aContenuColis.getSelectedCellText('oco-colPoids');
			if (isEmpty(poids)) poids = 0;
			var quantite = document.getElementById("oco-QteSortie").value;

			if (isEmpty(quantite)) {
				showWarning("Veuillez entrer une quantit\u00E9 \u00E0 enlever");
			}
			else if (!checkQte(quantite)) {
				showWarning("Quantit\u00E9 incorrecte !");
			}
			else if (parseFloat(qteinit)-parseFloat(quantite)<0) {
				showWarning("La quantit\u00E9 \u00E0 enlever ne peut d\u00E9passer la quantit\u00E9 pr\u00E9sente dans le colis !");
			}
			else {
				oco_disableRetirer(true);

				var qUpdate = new QueryHttp("Facturation/Affaires/enleverArticleColis.tmpl");
				qUpdate.setParam("Colis_Id", oco_colisId);
				qUpdate.setParam("Ref_Ligne", ref_ligne);
				qUpdate.setParam("QteInit", qteinit);
				qUpdate.setParam("Quantite", quantite);
				qUpdate.setParam("Poids", poids);

				qUpdate.execute(oco_retirerAuColis_2);
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oco_retirerAuColis_2(result) {
  try {

		if (result.responseXML.documentElement.getAttribute("vide")=="y") {
			oco_nouveauColis();
		}
		else {
			oco_aContenuColis.setParam("Colis_Id", oco_colisId);
			oco_aContenuColis.initTree();
		}
		oco_aHorsColis.initTree();
		oco_aColis.initTree(oco_calcColis);

	} catch (e) {
  	recup_erreur(e);
	}
}


function oco_afficherContenu() {
	try {

		if (oco_aColis.isSelected()) {
			oco_colisId = oco_aColis.getSelectedCellText('oco-colColisId');
			document.getElementById('oco-lblContenu').value = "Contenu du colis n\u00B0 "+ oco_aColis.getSelectedCellText('oco-colNumInterne') +" :";
			oco_aContenuColis.setParam("Colis_Id", oco_colisId);
			oco_aContenuColis.initTree();
		}

	} catch (e) {
    recup_erreur(e);
  }
}

function oco_demandeEnregistrement() {
	try {

	} catch (e) {
    recup_erreur(e);
  }
}

function oco_calcColis() {
	try {

		if (oco_aColis.isNotNull()) {

			var nbColis = oco_aColis.nbLignes();
			document.getElementById('oco-nbColis').value = nbColis;
			document.getElementById('oeb-nbColis').value = nbColis;

			var pt = 0;

			for (var i=0;i<oco_aColis.nbLignes();i++) {
				pt += parseFloat(oco_aColis.getCellText(i, 'oco-colPoidsColis'));
			}
			var nf = new NumberFormat("0.##", false);
			document.getElementById('oco-poidsTotal').value = nf.format(pt);
		}

		oco_autEtiq = (parseIntBis(document.getElementById('oco-nbColis').value)>0);

	} catch (e) {
    recup_erreur(e);
  }
}


function oco_editerEtiquettesSans() {
	try {

		var oco_nbEtiquettes = document.getElementById('oco-nbEtiquettes').value;

		if (isEmpty(oco_nbEtiquettes) || !isPositiveInteger(oco_nbEtiquettes)) {
			showWarning("Nombre d'\u00E9tiquettes incorrect");
		}
		else {
			document.getElementById("oco-deckColisageEtiquettes").selectedIndex = 1;
			oco_qEtiquettes.setParam("Bon_Liv_Id", oeb_bonLivId);
			oco_qEtiquettes.setParam("Nb_Etiquettes", oco_nbEtiquettes);
			var result = oco_qEtiquettes.execute();
			var page = getDirPdf() + result.responseXML.documentElement.getAttribute('fichier');
			document.getElementById('oco-pdfColisageEtiquettes').setAttribute("src", page);
			document.getElementById("bRetourColisage").collapsed = false;
		}

	} catch (e) {
    recup_erreur(e);
  }
}

function oco_editerEtiquettes() {
	try {

		if (oco_autEtiq) {
			document.getElementById("oco-deckColisageEtiquettes").selectedIndex = 1;
			oco_qEtiquettes.setParam("Bon_Liv_Id", oeb_bonLivId);
			var result = oco_qEtiquettes.execute();
			var page = getDirPdf() + result.responseXML.documentElement.getAttribute('fichier');
			document.getElementById('oco-pdfColisageEtiquettes').setAttribute("src", page);
			document.getElementById("bRetourColisage").collapsed = false;
		}
		else {
			showWarning("Vous devez avoir au moins un colis pour pouvoir g\u00E9n\u00E9rer des etiquettes");
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oco_editerColis() {
	try {

		if (oco_autEtiq) {
			document.getElementById("oco-deckColisageEtiquettes").selectedIndex = 1;

			var qEditionPDF = new QueryHttp("Facturation/Affaires/pdfListeColis.tmpl");
			qEditionPDF.setParam("Bon_Id", oeb_bonLivId);
			var result = qEditionPDF.execute();
			var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
			document.getElementById('oco-pdfColisageEtiquettes').setAttribute("src", page);
			document.getElementById("bRetourColisage").collapsed = false;
		}
		else {
			showWarning("Vous devez avoir au moins un colis pour pouvoir g\u00E9n\u00E9rer la liste des colis");
		}

	} catch (e) {
    recup_erreur(e);
  }
}

