/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var oob_aPotentiels = new Arbre('Facturation/Articles/list-potentielFabrication.tmpl', 'oob-potentiels');
var oob_aReassort = new Arbre('Facturation/Articles/list-reassortFabrication.tmpl', 'oob-reassortFabrication');



function oob_initOngletPotentielFabrication() {
	try {

		oob_aPotentiels.setParam("Article_Id", ofa_articleId);
		oob_aPotentiels.initTree(oob_calculTotaux);

		var aDepots = new Arbre("ComboListe/combo-depotsStock.tmpl", "oob-depotReassort");
  	aDepots.initTree();

		document.getElementById('oob-qteReassort').value = "";
		document.getElementById('oob-depotReassort').value = "";
		oob_aReassort.deleteTree();

	} catch (e) {
		recup_erreur(e);
	}
}


function oob_calculTotaux() {
	try {

		var totalReel = 0;
		var totalReserve = 0;
		var totalDispo = 0;
		var totalAttendu = 0;
		var totalVirtuel = 0;

		for (var i=0; i<oob_aPotentiels.nbLignes(); i++) {

			totalReel += parseFloat(oob_aPotentiels.getCellText(i, "oob-colPotentielReel"));
			totalReserve += parseFloat(oob_aPotentiels.getCellText(i, "oob-colPotentielReserve"));
			totalDispo += parseFloat(oob_aPotentiels.getCellText(i, "oob-colPotentielDispo"));
			totalAttendu += parseFloat(oob_aPotentiels.getCellText(i, "oob-colPotentielAttendu"));
			totalVirtuel += parseFloat(oob_aPotentiels.getCellText(i, "oob-colPotentielVirtuel"));
		}

		var fqte = new NumberFormat("0.###", false);

		document.getElementById('oob-potentielReelTotal').value = fqte.format(totalReel);
		document.getElementById('oob-potentielReserveTotal').value = fqte.format(totalReserve);
		document.getElementById('oob-potentielDispoTotal').value = fqte.format(totalDispo);
		document.getElementById('oob-potentielAttenduTotal').value = fqte.format(totalAttendu);
		document.getElementById('oob-potentielVirtuelTotal').value = fqte.format(totalVirtuel);

		var qGet = new QueryHttp("Facturation/Articles/getCumulsPotentielFabrication.tmpl");
		qGet.setParam("Article_Id", ofa_articleId);
		var result = qGet.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			var contenu = result.responseXML.documentElement;

			document.getElementById('oob-potentielReelCumul').value = contenu.getAttribute('Cumul_Reel');
			document.getElementById('oob-potentielReserveCumul').value = contenu.getAttribute('Cumul_Reserve');
			document.getElementById('oob-potentielDispoCumul').value = contenu.getAttribute('Cumul_Dispo');
			document.getElementById('oob-potentielAttenduCumul').value = contenu.getAttribute('Cumul_Attendu');
			document.getElementById('oob-potentielVirtuelCumul').value = contenu.getAttribute('Cumul_Virtuel');
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oob_calculerReassort() {
	try {

		var quantite = document.getElementById('oob-qteReassort').value;
		var depotId = document.getElementById('oob-depotReassort').value;

		if (!isPositive(quantite)) {
			showWarning("Quantit\u00E9 incorrecte");
		}
		else {
			oob_aReassort.setParam("Article_Id", ofa_articleId);
			oob_aReassort.setParam("Quantite", quantite);
			oob_aReassort.setParam("Depot_Id", depotId);
			oob_aReassort.initTree();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oob_pressOnQteReassort(ev) {
	try {

		if (ev.keyCode==13) {
			oob_calculerReassort();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oob_pressOnDepotReassort() {
	try {

		var quantite = document.getElementById('oob-qteReassort').value;

		if (isPositive(quantite)) {
			oob_calculerReassort();
		}

	} catch (e) {
		recup_erreur(e);
	}
}
