/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

var omc_aClients = new Arbre("Facturation/Clients/list-ficheClient.tmpl", "omc-listeClients");
var omc_qListFC = new QueryHttp("Facturation/Clients/getDataListFC.tmpl");

var omc_pageCourante;
var omc_nbPages;

var omc_restrictedPoleActivite = "";



function omc_init() {
	try {

		if (gProfil.isRestricAccCDVPA() && !isEmpty(gProfil.getPoleActivite())) {
			omc_restrictedPoleActivite = gProfil.getPoleActivite();
			document.getElementById('omc-poleActivite').disabled = true;
		}

		var aFamilles = new Arbre('ComboListe/combo-famillesClient.tmpl', 'omc-famille');
		aFamilles.initTree();

		var aPolesActivite = new Arbre("ComboListe/combo-polesActivite.tmpl", "omc-poleActivite");
		if (!isEmpty(omc_restrictedPoleActivite)) {
			aPolesActivite.setParam("Selection", omc_restrictedPoleActivite);
		}
		aPolesActivite.initTree(omc_initPoleActivite);

		var aPays = new Arbre("ComboListe/combo-pays.tmpl", "omc-pays");
		aPays.initTree();

		if (gSiteWeb) {
			document.getElementById('omc-boxSiteWeb').collapsed = false;
			var aSites = new Arbre('ComboListe/combo-sitesWeb.tmpl','omc-siteWeb');
			aSites.initTree();
		}

		if (gReadOnly) {
			document.getElementById('omc-bNouveau').collapsed = true;
		}

		document.getElementById('omc-numClient').focus();

		omc_loadChiffresCles();

	} catch (e) {
		recup_erreur(e);
	}
}


function omc_initPoleActivite() {
	try {

		document.getElementById("omc-poleActivite").value = omc_restrictedPoleActivite;

	} catch (e) {
		recup_erreur(e);
	}
}


function omc_pressOnNouveauClient() {
	try {

		document.getElementById("bMenuClients").collapsed = false;
		document.getElementById("deck").selectedIndex = 1;
		ofc_nouveauClient();

	} catch (e) {
		recup_erreur(e);
	}
}


function omc_initCriteres() {
	try {

		document.getElementById('omc-numClient').value = "";
		document.getElementById('omc-denomination').value = "";
		document.getElementById('omc-contact').value = "";
		document.getElementById('omc-codePostal').value = "";
		document.getElementById('omc-ville').value = "";
		document.getElementById('omc-pays').value = "";
		document.getElementById('omc-famille').value = "";
		document.getElementById('omc-poleActivite').value = omc_restrictedPoleActivite;
		document.getElementById('omc-codeRegroupement').value = "";
		document.getElementById('omc-codeCouleur').value = "";
		document.getElementById('omc-categorie').value = "";
		document.getElementById('omc-login').value = "";
		document.getElementById('omc-siteWeb').value = "";
		document.getElementById('omc-email').value = "";
		document.getElementById('omc-telephone').value = "";
		document.getElementById('omc-actif').checked = true;

		omc_listerClients();

	} catch (e) {
		recup_erreur(e);
	}
}


function omc_listerClients() {
	try {

		var numClient = document.getElementById('omc-numClient').value;
		var denomination = document.getElementById('omc-denomination').value;
		var contact = document.getElementById('omc-contact').value;
		var codePostal = document.getElementById('omc-codePostal').value;
		var ville = document.getElementById('omc-ville').value;
		var pays = document.getElementById('omc-pays').value;
		var famille = document.getElementById('omc-famille').value;
		var poleActivite = document.getElementById('omc-poleActivite').value;
		var codeRegroupement = document.getElementById('omc-codeRegroupement').value;
		var codeCouleur = document.getElementById('omc-codeCouleur').value;
		var categorie = document.getElementById('omc-categorie').value;
		var login = document.getElementById('omc-login').value;
		var siteWeb = document.getElementById('omc-siteWeb').value;
		var email = document.getElementById('omc-email').value;
		var telephone = document.getElementById('omc-telephone').value;
		var actif = document.getElementById('omc-actif').checked;
		var nbLignesParPage = document.getElementById('omc-nbLignesParPage').value;

		omc_pageCourante = 1;
		omc_nbPages = 1;
		document.getElementById('omc-pageDeb').value = 1;
		document.getElementById('omc-pageFin').value = 1;
		document.getElementById('omc-bPrec').disabled = true;
		document.getElementById('omc-bSuiv').disabled = true;

		document.getElementById('omc-listeClients').disabled = true;
		document.getElementById('omc-bEditionCsv').disabled = true;
		omc_aClients.deleteTree();

		omc_qListFC.setParam("Num_Client", numClient);
		omc_qListFC.setParam("Denomination", denomination);
		omc_qListFC.setParam("Contact", contact);
		omc_qListFC.setParam("Code_Postal", codePostal);
		omc_qListFC.setParam("Ville", ville);
		omc_qListFC.setParam("Pays", pays);
		omc_qListFC.setParam("Famille", famille);
		omc_qListFC.setParam("Pole_Activite", poleActivite);
		omc_qListFC.setParam("Code_Regroupement", codeRegroupement);
		omc_qListFC.setParam("Code_Couleur", codeCouleur);
		omc_qListFC.setParam("Categorie", categorie);
		omc_qListFC.setParam("Login", login);
		omc_qListFC.setParam("Site_Web", siteWeb);
		omc_qListFC.setParam("Email", email);
		omc_qListFC.setParam("Telephone", telephone);
		omc_qListFC.setParam("Actif", actif);
		omc_qListFC.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
		omc_qListFC.setParam("Current_Page", omc_pageCourante);

		var result = omc_qListFC.execute();

		var contenu = result.responseXML.documentElement;

		omc_nbPages = contenu.getAttribute("Nb_Pages");
		var listClientId = contenu.getAttribute("List_Client_Id");

		omc_aClients.setParam("List_Client_Id", listClientId);
		omc_aClients.initTree(omc_initPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function omc_initPagination() {
	try {

		document.getElementById('omc-pageDeb').value = omc_pageCourante;
		document.getElementById('omc-pageFin').value = (omc_nbPages>0?omc_nbPages:1);
		document.getElementById('omc-bPrec').disabled = (omc_pageCourante==1);
		document.getElementById('omc-bSuiv').disabled = (omc_pageCourante>=omc_nbPages); // peut se produire si omc_nbPages=0

		omc_afterMajPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function omc_pressOnPagePrec() {
	try {

		omc_pageCourante--;
		omc_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function omc_pressOnPageSuiv() {
	try {

		omc_pageCourante++;
		omc_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function omc_majPagination() {
	try {

		document.getElementById('omc-pageDeb').value = omc_pageCourante;
		document.getElementById('omc-bPrec').disabled = (omc_pageCourante==1);
		document.getElementById('omc-bSuiv').disabled = (omc_pageCourante==omc_nbPages);

		document.getElementById('omc-listeClients').disabled = true;
		document.getElementById('omc-bEditionCsv').disabled = true;

		omc_qListFC.setParam("Current_Page", omc_pageCourante);
		var result = omc_qListFC.execute();
		var listClientId = result.responseXML.documentElement.getAttribute("List_Client_Id");

		omc_aClients.setParam("List_Client_Id", listClientId);
		omc_aClients.initTree(omc_afterMajPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function omc_afterMajPagination() {
	try {

		document.getElementById('omc-listeClients').disabled = false;
		document.getElementById('omc-bEditionCsv').disabled = (omc_aClients.nbLignes()==0);

	} catch (e) {
		recup_erreur(e);
	}
}


function omc_pressOnCritere(ev) {
  try {

		if (ev.keyCode==13) {
			omc_listerClients();
    }

	} catch (e) {
  	recup_erreur(e);
  }
}


function omc_pressOnListeClients(ev) {
	try {

		if (ev.keyCode==13) {
			omc_ouvrirClient();
    }

	} catch (e) {
		recup_erreur(e);
	}
}


function omc_ouvrirClient() {
  try {

  	if (omc_aClients.isSelected()) {

			ofc_clientId = omc_aClients.getSelectedCellText('omc-colClientId');
			document.getElementById('bMenuClients').collapsed = false;

			ofc_chargerClient();

			document.getElementById('deck').selectedIndex = 1;
  	}

	} catch (e) {
  	recup_erreur(e);
  }
}


function omc_pressOnEditionCsv() {
	try {

		var numClient = document.getElementById('omc-numClient').value;
		var denomination = document.getElementById('omc-denomination').value;
		var contact = document.getElementById('omc-contact').value;
		var codePostal = document.getElementById('omc-codePostal').value;
		var ville = document.getElementById('omc-ville').value;
		var pays = document.getElementById('omc-pays').value;
		var famille = document.getElementById('omc-famille').value;
		var poleActivite = document.getElementById('omc-poleActivite').value;
		var codeRegroupement = document.getElementById('omc-codeRegroupement').value;
		var codeCouleur = document.getElementById('omc-codeCouleur').value;
		var categorie = document.getElementById('omc-categorie').value;
		var login = document.getElementById('omc-login').value;
		var siteWeb = document.getElementById('omc-siteWeb').value;
		var email = document.getElementById('omc-email').value;
		var telephone = document.getElementById('omc-telephone').value;
		var actif = document.getElementById('omc-actif').checked;

		var qEditionCsv = new QueryHttp("Facturation/Clients/csvFicheClient.tmpl");
		qEditionCsv.setParam("Num_Client", numClient);
		qEditionCsv.setParam("Denomination", denomination);
		qEditionCsv.setParam("Contact", contact);
		qEditionCsv.setParam("Code_Postal", codePostal);
		qEditionCsv.setParam("Ville", ville);
		qEditionCsv.setParam("Pays", pays);
		qEditionCsv.setParam("Famille", famille);
		qEditionCsv.setParam("Pole_Activite", poleActivite);
		qEditionCsv.setParam("Code_Regroupement", codeRegroupement);
		qEditionCsv.setParam("Code_Couleur", codeCouleur);
		qEditionCsv.setParam("Categorie", categorie);
		qEditionCsv.setParam("Login", login);
		qEditionCsv.setParam("Site_Web", siteWeb);
		qEditionCsv.setParam("Email", email);
		qEditionCsv.setParam("Telephone", telephone);
		qEditionCsv.setParam("Actif", actif);

		var result = qEditionCsv.execute();
		var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');

		var file = fileChooser("save", fichier);
		if (file!=null) {
			downloadFile(getDirBuffer()+ fichier, file);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omc_loadChiffresCles() {
	try {

		var qStats = new QueryHttp("Facturation/Clients/getStatsFicheClient.tmpl");
		var result = qStats.execute();
		var contenu = result.responseXML.documentElement;

		document.getElementById("omc-nbFCTotal").value = contenu.getAttribute("Nb_FC_Total");
		document.getElementById("omc-nbFCTotalActif").value = contenu.getAttribute("Nb_FC_Total_Actif");

	} catch (e) {
		recup_erreur(e);
	}
}
