/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

var oor_aReferenceClient = new Arbre("Facturation/Clients/list-referenceClient.tmpl", "oor-listeReferences");

var oor_referenceId;



function oor_initOngletReferences() {
	try {

		document.getElementById('oor-boxRAZ').collapsed = gReadOnly;
		document.getElementById('oor-rowReferenceSpecifique').collapsed = gReadOnly;

		oor_nouveauReferenceClient();

		oor_aReferenceClient.setParam("Client_Id", ofc_clientId);
		oor_aReferenceClient.initTree();

  } catch (e) {
    recup_erreur(e);
  }
}


function oor_nouveauReferenceClient() {
	try {

		oor_referenceId = "";

		document.getElementById("oor-reference").value = "";
		document.getElementById("oor-refClient").value = "";
		document.getElementById("oor-bSupprimerReferenceClient").disabled = true;
		document.getElementById("oor-bRechercherArticle").disabled = false;
		document.getElementById("oor-refClient").disabled = true;

		oor_aReferenceClient.clearSelection();

	} catch (e) {
		recup_erreur(e);
	}
}


function oor_enregistrerReferenceClient() {
	try {

		var reference = document.getElementById("oor-reference").value;
		var refClient = document.getElementById("oor-refClient").value;

		if (isEmpty(reference)) {
			showWarning("Veuillez sp\u00E9cifier une r\u00E9f\u00E9rence article");
		}
		else if (isEmpty(refClient)) {
			showWarning("Veuillez sp\u00E9cifier une r\u00E9f\u00E9rence client");
		}
		else {
			var qSave;

			if (isEmpty(oor_referenceId)) {
				qSave = new QueryHttp("Facturation/Clients/createReferenceClient.tmpl");
				qSave.setParam("Client_Id", ofc_clientId);
				qSave.setParam("Reference", reference);
			}
			else {
				qSave = new QueryHttp("Facturation/Clients/updateReferenceClient.tmpl");
				qSave.setParam("Reference_Id", oor_referenceId);
			}

			qSave.setParam("Ref_Client", refClient);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}

			oor_aReferenceClient.initTree();
			oor_nouveauReferenceClient();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oor_supprimerReferenceClient() {
	try {

		var qSup = new QueryHttp("Facturation/Clients/deleteReferenceClient.tmpl");
		qSup.setParam("Reference_Id", oor_referenceId);
		qSup.execute();

		oor_aReferenceClient.initTree();
		oor_nouveauReferenceClient();

	} catch (e) {
		recup_erreur(e);
	}
}


function oor_pressOnListeReferenceClient() {
	try {

		if (oor_aReferenceClient.isSelected()) {
			oor_referenceId = oor_aReferenceClient.getSelectedCellText("oor-colReferenceId");

			document.getElementById("oor-reference").value = oor_aReferenceClient.getSelectedCellText("oor-colReference");
			document.getElementById("oor-refClient").value = oor_aReferenceClient.getSelectedCellText("oor-colRefClient");

			document.getElementById("oor-bSupprimerReferenceClient").disabled = false;
			document.getElementById("oor-bRechercherArticle").disabled = true;

			document.getElementById("oor-refClient").disabled = false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oor_razReferenceClient() {
	try {

		if (window.confirm("Confirmez-vous la suppression de toutes les r\u00E9f\u00E9rences sp\u00E9cifiques li\u00E9es \u00E0 ce client ?")) {
			var qSup = new QueryHttp("Facturation/Clients/deleteReferenceClientByClientId.tmpl");
			qSup.setParam("Client_Id", ofc_clientId);
			qSup.execute();

			oor_aReferenceClient.initTree();
			oor_nouveauReferenceClient();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oor_rechercherArticle() {
	try {

		var url = "chrome://opensi/content/facturation/user/articles/popup-rechercheArticle.xul";
		window.openDialog(url,'','chrome,modal,centerscreen',oor_retourRechercherArticle, "V", null, null, null, null, null, ofc_clientId);

	} catch (e) {
		recup_erreur(e);
	}
}


function oor_retourRechercherArticle(reference, articleId) {
	try {

  	document.getElementById('oor-reference').value = reference;
		document.getElementById("oor-refClient").disabled = false;

	} catch (e) {
		recup_erreur(e);
	}
}


