/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

var oorm_aRemiseMarqueClient = new Arbre("Facturation/Clients/list-remiseMarqueClient.tmpl", "oorm-listeRemises");
var oorm_aMarques = new Arbre("ComboListe/combo-marquesArticle.tmpl", "oorm-marqueId");

var oorm_remMarId;
var oorm_curMarque = "";



function oorm_initOngletRemises() {
	try {

		document.getElementById('oorm-boxRAZ').collapsed = gReadOnly;
		document.getElementById('oorm-rowRemiseMarque').collapsed = gReadOnly;

		oorm_nouveauRemiseMarqueClient();

		oorm_aRemiseMarqueClient.setParam("Client_Id", ofc_clientId);
		oorm_aRemiseMarqueClient.initTree();

  } catch (e) {
    recup_erreur(e);
  }
}


function oorm_chargerMarques(selection) {
	try {

		oorm_curMarque = selection;
		oorm_aMarques.setParam("Selection", oorm_curMarque);
		oorm_aMarques.initTree(oorm_initMarque);

	} catch (e) {
		recup_erreur(e);
	}
}


function oorm_initMarque() {
  try {

		document.getElementById('oorm-marqueId').value = oorm_curMarque;

	} catch (e) {
		recup_erreur(e);
	}
}


function oorm_nouveauRemiseMarqueClient() {
	try {

		oorm_remMarId = "";

		oorm_chargerMarques("");
		document.getElementById("oorm-tauxRemise").value = "";
		document.getElementById("oorm-bSupprimerRemiseMarqueClient").disabled = true;
		document.getElementById("oorm-marqueId").disabled = false;

		oorm_aRemiseMarqueClient.clearSelection();

	} catch (e) {
		recup_erreur(e);
	}
}


function oorm_enregistrerRemiseMarqueClient() {
	try {

		var marqueId = document.getElementById("oorm-marqueId").value;
		var tauxRemise = document.getElementById("oorm-tauxRemise").value;

		if (isEmpty(marqueId)) {
			showWarning("Veuillez sp\u00E9cifier une marque");
		}
		else if (isEmpty(tauxRemise) || !isTaux(tauxRemise) || parseFloat(tauxRemise)==0) {
			showWarning("Taux de remise incorrect");
		}
		else {
			var qSave;

			if (isEmpty(oorm_remMarId)) {
				qSave = new QueryHttp("Facturation/Clients/createRemiseMarqueClient.tmpl");
				qSave.setParam("Client_Id", ofc_clientId);
				qSave.setParam("Marque_Id", marqueId);
			}
			else {
				qSave = new QueryHttp("Facturation/Clients/updateRemiseMarqueClient.tmpl");
				qSave.setParam("Rem_Mar_Id", oorm_remMarId);
			}

			qSave.setParam("Taux_Remise", tauxRemise);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}

			oorm_aRemiseMarqueClient.initTree();
			oorm_nouveauRemiseMarqueClient();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oorm_supprimerRemiseMarqueClient() {
	try {

		var qDelete = new QueryHttp("Facturation/Clients/deleteRemiseMarqueClient.tmpl");
		qDelete.setParam("Rem_Mar_Id", oorm_remMarId);
		qDelete.execute();

		oorm_aRemiseMarqueClient.initTree();
		oorm_nouveauRemiseMarqueClient();

	} catch (e) {
		recup_erreur(e);
	}
}


function oorm_pressOnListeRemiseMarqueClient() {
	try {

		if (oorm_aRemiseMarqueClient.isSelected()) {
			oorm_remMarId = oorm_aRemiseMarqueClient.getSelectedCellText("oorm-colRemMarId");

			oorm_chargerMarques(oorm_aRemiseMarqueClient.getSelectedCellText("oorm-colMarqueId"));
			document.getElementById("oorm-tauxRemise").value = oorm_aRemiseMarqueClient.getSelectedCellText("oorm-colTauxRemise");

			document.getElementById("oorm-bSupprimerRemiseMarqueClient").disabled = false;
			document.getElementById("oorm-marqueId").disabled = true;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oorm_razRemiseMarqueClient() {
	try {

		if (window.confirm("Confirmez-vous la suppression de toutes les remises par marques sp\u00E9cifiques li\u00E9es \u00E0 ce client ?")) {
			var qDelete = new QueryHttp("Facturation/Clients/deleteRemiseMarqueClientByClientId.tmpl");
			qDelete.setParam("Client_Id", ofc_clientId);
			qDelete.execute();

			oorm_aRemiseMarqueClient.initTree();
			oorm_nouveauRemiseMarqueClient();
		}

	} catch (e) {
		recup_erreur(e);
	}
}
