/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

/*
	Arguments du popup :
		- 0 : Fonction de retour
		- 1 : Si true, affichage du bouton nouveau pour cration client express
		- 2 : Si true, impossible de choisir un client bloqu
*/

jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");


var aClients = new Arbre("Facturation/Clients/list-ficheClient.tmpl", "listeClients");
var qListFC = new QueryHttp("Facturation/Clients/getDataListFC.tmpl");

var pageCourante;
var nbPages;

var restrictedPoleActivite = "";

var argBloque;



function init() {
  try {

		var argNouv = window.arguments[1];
		argBloque = window.arguments[2];

		if (getConfig().isECommerce()) {
			var aSitesWeb = new Arbre('ComboListe/combo-sitesWeb.tmpl', 'siteWeb');
	  	aSitesWeb.initTree();
			document.getElementById("row-login").collapsed = false;
			document.getElementById("row-siteWeb").collapsed = false;
		}

		var profil = getProfil();

		if (profil.isRestricAccCDVPA() && !isEmpty(profil.getPoleActivite())) {
			restrictedPoleActivite = profil.getPoleActivite();
			document.getElementById('poleActivite').disabled = true;
		}

		var aFamilles = new Arbre('ComboListe/combo-famillesClient.tmpl', 'famille');
		aFamilles.initTree();

		var aPolesActivite = new Arbre("ComboListe/combo-polesActivite.tmpl", "poleActivite");
		if (!isEmpty(restrictedPoleActivite)) {
			aPolesActivite.setParam("Selection", restrictedPoleActivite);
		}
		aPolesActivite.initTree(initPoleActivite);

		var aPays = new Arbre("ComboListe/combo-pays.tmpl", "pays");
		aPays.initTree();

    if (argNouv!=null && argNouv==true) {
			document.getElementById('bNouveau').collapsed = false;
    }

    document.getElementById('numClient').focus();

  } catch (e) {
    recup_erreur(e);
  }
}


function initPoleActivite() {
	try {

		document.getElementById("poleActivite").value = restrictedPoleActivite;

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnNumClient(ev) {
  try {

		if (ev.keyCode==13) {
			checkClient(document.getElementById('numClient').value);
    }

  } catch (e) {
    recup_erreur(e);
  }
}


function pressOnCritere(ev) {
  try {

    if (ev.keyCode==13) {
			listerClients();
    }

  } catch (e) {
    recup_erreur(e);
  }
}


function checkClient(numClient) {
  try {

		var qSearch = new QueryHttp("Facturation/Clients/searchNumClient.tmpl");
		qSearch.setParam('Num_Client', numClient);

		var result = qSearch.execute();
		var contenu = result.responseXML.documentElement;

		var clientId = contenu.getAttribute('Client_Id');

		if (!isEmpty(clientId)) {
			ouvrirClient(contenu.getAttribute('Num_Client'), clientId);
		}
		else {
			listerClients();
		}

  } catch (e) {
    recup_erreur(e);
  }
}


function clientBloque(clientId) {
  try {

		var qGet = new QueryHttp("Facturation/Clients/getBloque.tmpl");
		qGet.setParam('Client_Id', clientId);
		var result = qGet.execute();

  	return (result.responseXML.documentElement.getAttribute('Bloque')=="true");

  } catch (e) {
    recup_erreur(e);
  }
}


function pressOnTree(ev) {
  try {

    if (ev.keyCode==13) {
			choixClient();
  	}

  } catch (e) {
    recup_erreur(e);
  }
}


function nouveauClient() {
  try {

 		var url = "chrome://opensi/content/facturation/user/commun/popup-creerClient.xul?"+ cookie() +"&DefPoleActivite="+ window.opener.getProfil().getPoleActivite();
   	window.openDialog(url,'','chrome,modal,centerscreen', reporterClient);

  } catch (e) {
    recup_erreur(e);
  }
}


function reporterClient(numClient, clientId) {
  try {

		if (!isEmpty(numClient)) {
			ouvrirClient(numClient, clientId);
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function ouvrirClient(numClient, clientId) {
  try {

		if (argBloque!=null && argBloque==true && clientBloque(clientId)) {
			showWarning("Ce client est bloqu\u00E9 !");
		}
		else {
			window.arguments[0](numClient, clientId);
      setTimeout("window.close()",0); // pour fermeture si fonction appele d'un autre popup
		}

  } catch (e) {
    recup_erreur(e);
  }
}


function choixClient() {
	try {

		if (aClients.isSelected()) {
			var numClient = aClients.getSelectedCellText('colNumClient');
			var clientId = aClients.getSelectedCellText('colClientId');
			ouvrirClient(numClient, clientId);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function initCriteres() {
	try {

		document.getElementById('numClient').value = "";
		document.getElementById('denomination').value = "";
		document.getElementById('famille').value = "";
		document.getElementById('poleActivite').value = restrictedPoleActivite;
		document.getElementById('codeRegroupement').value = "";
		document.getElementById('codeCouleur').value = "";
		document.getElementById('actif').checked = true;
		document.getElementById('categorie').value = "";
		document.getElementById('login').value = "";
		document.getElementById('siteWeb').value = "";
		document.getElementById('contact').value = "";
		document.getElementById('codePostal').value = "";
		document.getElementById('ville').value = "";
		document.getElementById('pays').value = "";
		document.getElementById('email').value = "";
		document.getElementById('telephone').value = "";

		listerClients();

	} catch (e) {
    recup_erreur(e);
  }
}


function listerClients() {
	try {

		var numClient = document.getElementById('numClient').value;
		var denomination = document.getElementById('denomination').value;
		var contact = document.getElementById('contact').value;
		var codePostal = document.getElementById('codePostal').value;
		var ville = document.getElementById('ville').value;
		var pays = document.getElementById('pays').value;
		var famille = document.getElementById('famille').value;
		var poleActivite = document.getElementById('poleActivite').value;
		var codeRegroupement = document.getElementById('codeRegroupement').value;
		var codeCouleur = document.getElementById('codeCouleur').value;
		var categorie = document.getElementById('categorie').value;
		var login = document.getElementById('login').value;
		var siteWeb = document.getElementById('siteWeb').value;
		var email = document.getElementById('email').value;
		var telephone = document.getElementById('telephone').value;
		var actif = document.getElementById('actif').checked;
		var nbLignesParPage = document.getElementById('nbLignesParPage').value;

		pageCourante = 1;
		nbPages = 1;
		document.getElementById('pageDeb').value = 1;
		document.getElementById('pageFin').value = 1;
		document.getElementById('bPrec').disabled = true;
		document.getElementById('bSuiv').disabled = true;

		document.getElementById('listeClients').disabled = true;
		aClients.deleteTree();

		qListFC.setParam("Num_Client", numClient);
		qListFC.setParam("Denomination", denomination);
		qListFC.setParam("Contact", contact);
		qListFC.setParam("Code_Postal", codePostal);
		qListFC.setParam("Ville", ville);
		qListFC.setParam("Pays", pays);
		qListFC.setParam("Famille", famille);
		qListFC.setParam("Pole_Activite", poleActivite);
		qListFC.setParam("Code_Regroupement", codeRegroupement);
		qListFC.setParam("Code_Couleur", codeCouleur);
		qListFC.setParam("Categorie", categorie);
		qListFC.setParam("Login", login);
		qListFC.setParam("Site_Web", siteWeb);
		qListFC.setParam("Email", email);
		qListFC.setParam("Telephone", telephone);
		qListFC.setParam("Actif", actif);
		qListFC.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
		qListFC.setParam("Current_Page", pageCourante);

		var result = qListFC.execute();

		var contenu = result.responseXML.documentElement;

		nbPages = contenu.getAttribute("Nb_Pages");
		var listClientId = contenu.getAttribute("List_Client_Id");

		aClients.setParam("List_Client_Id", listClientId);
		aClients.initTree(initPagination);

	} catch (e) {
    recup_erreur(e);
  }
}


function initPagination() {
	try {

		document.getElementById('pageDeb').value = pageCourante;
		document.getElementById('pageFin').value = (nbPages>0?nbPages:1);
		document.getElementById('bPrec').disabled = (pageCourante==1);
		document.getElementById('bSuiv').disabled = (pageCourante>=nbPages); // peut se produire si nbPages=0

		afterMajPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnPagePrec() {
	try {

		pageCourante--;
		majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnPageSuiv() {
	try {

		pageCourante++;
		majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function majPagination() {
	try {

		document.getElementById('pageDeb').value = pageCourante;
		document.getElementById('bPrec').disabled = (pageCourante==1);
		document.getElementById('bSuiv').disabled = (pageCourante==nbPages);

		document.getElementById('listeClients').disabled = true;

		qListFC.setParam("Current_Page", pageCourante);
		var result = qListFC.execute();
		var listClientId = result.responseXML.documentElement.getAttribute("List_Client_Id");

		aClients.setParam("List_Client_Id", listClientId);
		aClients.initTree(afterMajPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function afterMajPagination() {
	try {

		document.getElementById('listeClients').disabled = false;

	} catch (e) {
		recup_erreur(e);
	}
}
