/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

var omcf_aEtablissements = new Arbre('ComboListe/combo-etablissements.tmpl', 'omcf-etablissement');
var omcf_aDepots = new Arbre('ComboListe/combo-depotsStock.tmpl', 'omcf-depot');
var omcf_aListeCommandes = new Arbre("Facturation/Commandes/list-commandeFournisseur.tmpl","omcf-listeCommandes");
var omcf_aApercuCommande = new Arbre("Facturation/Commandes/list-apercuCommandeFournisseur.tmpl","omcf-apercu");
var omcf_qListCF = new QueryHttp("Facturation/Commandes/getDataListCF.tmpl");

var omcf_defautEtatCommande;
var omcf_pageCourante;
var omcf_nbPages;
var omcf_provenancePrep;
var omcf_depotPrep;



function omcf_init() {
  try {

		if (!gConfig.isGCFDateLivraison()) {
			document.getElementById('omcf-colDateLivraison').collapsed = true;
			document.getElementById('omcf-colDateLivraison').setAttribute('ignoreincolumnpicker', true);
		}

  	omcf_provenancePrep = (!isEmpty(ParamValeur("Provenance")) && ParamValeur("Provenance")=="Prep");
		omcf_depotPrep = omcf_provenancePrep?ParamValeur("Depot_Prep"):"";

		omcf_defautEtatCommande = gConfig.getDefEtatRechComFour();

  	var qExistePrep = new QueryHttp("Facturation/Commandes/existCommandePreparation.tmpl");
  	var result = qExistePrep.execute();
		var hasPrep = result.responseXML.documentElement.getAttribute("Exist")=="true";

  	document.getElementById('omcf-bSupprimerPrep').collapsed = !hasPrep;
		document.getElementById('omcf-bValiderPrep').collapsed = !hasPrep;

		document.getElementById('omcf-nbLignesParPage').selectedIndex = 0;

		var aPolesActivite = new Arbre("ComboListe/combo-polesActivite.tmpl", "omcf-poleActivite");
		aPolesActivite.initTree(omcf_initPoleActivite);

  } catch (e) {
  	recup_erreur(e);
  }
}


function omcf_initPoleActivite() {
	try {

		document.getElementById('omcf-poleActivite').selectedIndex = 0;
		omcf_aEtablissements.setParam('Selection', etablissementDefaut);
		omcf_aEtablissements.initTree(omcf_initEtablissement);

	} catch (e) {
		recup_erreur(e);
	}
}


function omcf_initEtablissement() {
	try {

		omcf_aDepots.setParam('Selection', depotDefaut);
		omcf_aDepots.setParam('Depot_Quarantaine', false);
		omcf_aDepots.initTree(omcf_initCriteres);

	} catch (e) {
		recup_erreur(e);
	}
}


function omcf_initCriteres() {
	try {

		document.getElementById('omcf-numCommande').value="";
		document.getElementById('omcf-refArticle').value="";
		document.getElementById('omcf-etablissement').value = etablissementDefaut;
		document.getElementById('omcf-depot').value = omcf_provenancePrep?omcf_depotPrep:depotDefaut;
		document.getElementById('omcf-numFournisseur').value="";
		document.getElementById('omcf-nomFournisseur').value="";
		document.getElementById('omcf-numBL').value = "";
		document.getElementById('omcf-etatCommande').value = omcf_provenancePrep?"P":omcf_defautEtatCommande;
		document.getElementById('omcf-numBR').value="";
		document.getElementById('omcf-intitule').value="";
		document.getElementById('omcf-dateCommandeDebut').value="";
		document.getElementById('omcf-dateCommandeFin').value="";
		document.getElementById('omcf-dateReceptionDebut').value="";
		document.getElementById('omcf-dateReceptionFin').value="";
		document.getElementById('omcf-etatPaiement').selectedIndex = 0;
		document.getElementById('omcf-bloque').selectedIndex = 0;
		document.getElementById('omcf-poleActivite').selectedIndex = 0;
		document.getElementById('omcf-numFacture').value="";
		document.getElementById('omcf-numAcompte').value="";

		omcf_pressOnEtatCommande();
		omcf_provenancePrep = false;
		omcf_listerCommandes();

	} catch (e) {
		recup_erreur(e);
	}
}


function omcf_pressOnNouvelleCommande() {
	try {

		document.getElementById('deck').selectedIndex = 1;
		document.getElementById('bMenuCommandes').collapsed = false;
		oecf_nouvelleCommande();

	} catch (e) {
		recup_erreur(e);
	}
}


function omcf_pressOnCritere(ev) {
	try {

		if (ev.keyCode==13) {
			omcf_listerCommandes();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omcf_pressOnListeCommandes(ev) {
  try {

		if (ev.keyCode==13) {
			omcf_ouvrirCommande();
    }

	} catch (e) {
  	recup_erreur(e);
  }
}


function omcf_listerCommandes() {
	try {

		var numCommande = document.getElementById('omcf-numCommande').value;
		var refArticle = document.getElementById('omcf-refArticle').value;
		var etablissement = document.getElementById('omcf-etablissement').value;
		var depot = document.getElementById('omcf-depot').value;
		var numFournisseur = document.getElementById('omcf-numFournisseur').value;
		var denomination = document.getElementById('omcf-nomFournisseur').value;
		var numBL = document.getElementById('omcf-numBL').value;
		var etatCommande = document.getElementById('omcf-etatCommande').value;
		var etatLogistique = document.getElementById('omcf-etatLogistique').value;
		var numBR = document.getElementById('omcf-numBR').value;
		var intitule = document.getElementById('omcf-intitule').value;
		var dateCommandeDebut = document.getElementById('omcf-dateCommandeDebut').value;
		var dateCommandeFin = document.getElementById('omcf-dateCommandeFin').value;
		var dateReceptionDebut = document.getElementById('omcf-dateReceptionDebut').value;
		var dateReceptionFin = document.getElementById('omcf-dateReceptionFin').value;
		var etatPaiement = document.getElementById('omcf-etatPaiement').value;
		var bloque = document.getElementById('omcf-bloque').value;
		var poleActivite = document.getElementById('omcf-poleActivite').value;
		var numFacture = document.getElementById('omcf-numFacture').value;
		var numAcompte = document.getElementById('omcf-numAcompte').value;
		var nbLignesParPage = document.getElementById('omcf-nbLignesParPage').value;

		if (!isEmpty(dateCommandeDebut) && !isDate(dateCommandeDebut)) { showWarning("Date de d\u00E9but de p\u00E9riode incorrecte pour la commande !"); }
		else if (!isEmpty(dateCommandeFin) && !isDate(dateCommandeFin)) { showWarning("Date de fin de p\u00E9riode incorrecte pour la commande !"); }
		else if (!isEmpty(dateCommandeDebut) && !isEmpty(dateCommandeFin) && !isDateInterval(dateCommandeDebut, dateCommandeFin)) { showWarning("Plage de dates incorrecte pour la commande !"); }
		else if (!isEmpty(dateReceptionDebut) && !isDate(dateReceptionDebut)) { showWarning("Date de d\u00E9but de r\u00E9ception pr\u00E9vue incorrecte"); }
		else if (!isEmpty(dateReceptionFin) && !isDate(dateReceptionFin)) { showWarning("Date de fin de r\u00E9ception pr\u00E9vue incorrecte"); }
		else if (!isEmpty(dateReceptionDebut) && !isEmpty(dateReceptionFin) && !isDateInterval(dateReceptionDebut, dateReceptionFin)) { showWarning("Plage de dates incorrecte pour la r\u00E9ception pr\u00E9vue !"); }
		else {

			omcf_pageCourante = 1;
			omcf_nbPages = 1;
			document.getElementById('omcf-pageDeb').value = 1;
			document.getElementById('omcf-pageFin').value = 1;
			document.getElementById('omcf-bPrec').disabled = true;
			document.getElementById('omcf-bSuiv').disabled = true;

			document.getElementById('omcf-listeCommandes').disabled = true;
			document.getElementById('omcf-bEditionCsv').disabled = true;
			document.getElementById('omcf-bEditionDetailCsv').disabled = true;
			document.getElementById('omcf-bEditerCommandes').disabled = true;
			document.getElementById('omcf-numCommandeSelect').value = "";
			omcf_aApercuCommande.deleteTree();
			omcf_aListeCommandes.deleteTree();

			omcf_qListCF.setParam("Num_Commande", numCommande);
			omcf_qListCF.setParam("Ref_Article", refArticle);
			omcf_qListCF.setParam("Etablissement", etablissement);
			omcf_qListCF.setParam("Pole_Activite", poleActivite);
			omcf_qListCF.setParam("Denomination", denomination);
			omcf_qListCF.setParam("Num_Fournisseur", numFournisseur);
			omcf_qListCF.setParam("Etat_Commande", etatCommande);
			omcf_qListCF.setParam("Etat_Logistique", etatLogistique);
			omcf_qListCF.setParam("Intitule", intitule);
			omcf_qListCF.setParam("Num_BL", numBL);
			omcf_qListCF.setParam("Date_Commande_Debut", dateCommandeDebut);
			omcf_qListCF.setParam("Date_Commande_Fin", dateCommandeFin);
			omcf_qListCF.setParam("Date_Reception_Debut", dateReceptionDebut);
			omcf_qListCF.setParam("Date_Reception_Fin", dateReceptionFin);
			omcf_qListCF.setParam("Depot", depot);
			omcf_qListCF.setParam("Num_BR", numBR);
			omcf_qListCF.setParam("Etat_Paiement", etatPaiement);
			omcf_qListCF.setParam("Bloque", bloque);
			omcf_qListCF.setParam("Num_Facture", numFacture);
			omcf_qListCF.setParam("Num_Acompte", numAcompte);
			omcf_qListCF.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
			omcf_qListCF.setParam("Current_Page", omcf_pageCourante);

			var result = omcf_qListCF.execute();

			var contenu = result.responseXML.documentElement;

			document.getElementById('omcf-totalHT').value = contenu.getAttribute("Total_HT");
			document.getElementById('omcf-totalTTC').value = contenu.getAttribute("Total_TTC");
			document.getElementById('omcf-totalCARecep').value = contenu.getAttribute("Total_CA_Recep");
			document.getElementById('omcf-totalCARestant').value = contenu.getAttribute("Total_CA_Restant");
			omcf_nbPages = contenu.getAttribute("Nb_Pages");
			var listCommandeId = contenu.getAttribute("List_Commande_Id");

			omcf_aListeCommandes.setParam("List_Commande_Id", listCommandeId);
			omcf_aListeCommandes.initTree(omcf_initPagination);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omcf_initPagination() {
	try {

		document.getElementById('omcf-pageDeb').value = omcf_pageCourante;
		document.getElementById('omcf-pageFin').value = (omcf_nbPages>0?omcf_nbPages:1);
		document.getElementById('omcf-bPrec').disabled = (omcf_pageCourante==1);
		document.getElementById('omcf-bSuiv').disabled = (omcf_pageCourante>=omcf_nbPages); // peut se produire si nbPages=0

		document.getElementById('omcf-listeCommandes').disabled = false;
		document.getElementById('omcf-bEditionCsv').disabled = (omcf_aListeCommandes.nbLignes()==0);
		document.getElementById('omcf-bEditionDetailCsv').disabled = (omcf_aListeCommandes.nbLignes()==0);
		document.getElementById('omcf-bEditerCommandes').disabled = (omcf_aListeCommandes.nbLignes()==0);

	} catch (e) {
		recup_erreur(e);
	}
}


function omcf_pressOnPagePrec() {
	try {

		omcf_pageCourante--;
		omcf_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function omcf_pressOnPageSuiv() {
	try {

		omcf_pageCourante++;
		omcf_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function omcf_majPagination() {
	try {

		document.getElementById('omcf-pageDeb').value = omcf_pageCourante;
		document.getElementById('omcf-bPrec').disabled = (omcf_pageCourante==1);
		document.getElementById('omcf-bSuiv').disabled = (omcf_pageCourante==omcf_nbPages);

		document.getElementById('omcf-numCommandeSelect').value = "";
		document.getElementById('omcf-listeCommandes').disabled = true;
		document.getElementById('omcf-bEditionCsv').disabled = true;
		document.getElementById('omcf-bEditionDetailCsv').disabled = true;
		document.getElementById('omcf-bEditerCommandes').disabled = true;

		omcf_aApercuCommande.deleteTree();

		omcf_qListCF.setParam("Current_Page", omcf_pageCourante);
		var result = omcf_qListCF.execute();
		var listCommandeId = result.responseXML.documentElement.getAttribute("List_Commande_Id");

		omcf_aListeCommandes.setParam("List_Commande_Id", listCommandeId);
		omcf_aListeCommandes.initTree(omcf_afterMajPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function omcf_afterMajPagination() {
	try {

		document.getElementById('omcf-listeCommandes').disabled = false;
		document.getElementById('omcf-bEditionCsv').disabled = (omcf_aListeCommandes.nbLignes()==0);
		document.getElementById('omcf-bEditionDetailCsv').disabled = (omcf_aListeCommandes.nbLignes()==0);
		document.getElementById('omcf-bEditerCommandes').disabled = (omcf_aListeCommandes.nbLignes()==0);

	} catch (e) {
		recup_erreur(e);
	}
}


function omcf_selectOnListeCommandes() {
	try {

		if (omcf_aListeCommandes.isSelected()) {
			var commandeId = omcf_aListeCommandes.getSelectedCellText("omcf-colCommandeId");
			document.getElementById('omcf-numCommandeSelect').value = omcf_aListeCommandes.getSelectedCellText("omcf-colNumCommande");
			omcf_aApercuCommande.setParam("Commande_Id", commandeId);
			omcf_aApercuCommande.initTree();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omcf_ouvrirCommande() {
	try {

		if (omcf_aListeCommandes.isSelected()) {
			oecf_commandeId = omcf_aListeCommandes.getSelectedCellText("omcf-colCommandeId");
			oecf_chargerCommande();
			document.getElementById('bMenuCommandes').collapsed = false;
			document.getElementById('deck').selectedIndex = 1;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omcf_supprimerCommandesPrep() {
  try {

		if (window.confirm("Confirmez-vous la suppression de toutes les commandes en pr\u00E9paration ?")) {
			document.getElementById('omcf-bSupprimerPrep').disabled = true;
			document.getElementById('omcf-bValiderPrep').disabled = true;

			var qDelete = new QueryHttp("Facturation/Commandes/deleteAllCommandePreparation.tmpl");
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}

			omcf_listerCommandes();
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function omcf_validerCommandesPrep() {
  try {

		if (window.confirm("Confirmez-vous la validation de toutes les commandes en pr\u00E9paration ?")) {
			document.getElementById('omcf-bValiderPrep').disabled = true;
			document.getElementById('omcf-bSupprimerPrep').disabled = true;

			var qValid = new QueryHttp("Facturation/Commandes/validAllCommandePreparation.tmpl");
			var result = qValid.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}

			omcf_listerCommandes();
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function omcf_pressOnEditionCsv() {
	try {

		var numCommande = document.getElementById('omcf-numCommande').value;
		var refArticle = document.getElementById('omcf-refArticle').value;
		var etablissement = document.getElementById('omcf-etablissement').value;
		var depot = document.getElementById('omcf-depot').value;
		var numFournisseur = document.getElementById('omcf-numFournisseur').value;
		var denomination = document.getElementById('omcf-nomFournisseur').value;
		var numBL = document.getElementById('omcf-numBL').value;
		var etatCommande = document.getElementById('omcf-etatCommande').value;
		var etatLogistique = document.getElementById('omcf-etatLogistique').value;
		var numBR = document.getElementById('omcf-numBR').value;
		var intitule = document.getElementById('omcf-intitule').value;
		var dateCommandeDebut = document.getElementById('omcf-dateCommandeDebut').value;
		var dateCommandeFin = document.getElementById('omcf-dateCommandeFin').value;
		var dateReceptionDebut = document.getElementById('omcf-dateReceptionDebut').value;
		var dateReceptionFin = document.getElementById('omcf-dateReceptionFin').value;
		var etatPaiement = document.getElementById('omcf-etatPaiement').value;
		var bloque = document.getElementById('omcf-bloque').value;
		var poleActivite = document.getElementById('omcf-poleActivite').value;
		var numFacture = document.getElementById('omcf-numFacture').value;
		var numAcompte = document.getElementById('omcf-numAcompte').value;

		if (!isEmpty(dateCommandeDebut) && !isDate(dateCommandeDebut)) { showWarning("Date de d\u00E9but de p\u00E9riode incorrecte pour la commande !"); }
		else if (!isEmpty(dateCommandeFin) && !isDate(dateCommandeFin)) { showWarning("Date de fin de p\u00E9riode incorrecte pour la commande !"); }
		else if (!isEmpty(dateCommandeDebut) && !isEmpty(dateCommandeFin) && !isDateInterval(dateCommandeDebut, dateCommandeFin)) { showWarning("Plage de dates incorrecte pour la commande !"); }
		else if (!isEmpty(dateReceptionDebut) && !isDate(dateReceptionDebut)) { showWarning("Date de d\u00E9but de r\u00E9ception pr\u00E9vue incorrecte"); }
		else if (!isEmpty(dateReceptionFin) && !isDate(dateReceptionFin)) { showWarning("Date de fin de r\u00E9ception pr\u00E9vue incorrecte"); }
		else if (!isEmpty(dateReceptionDebut) && !isEmpty(dateReceptionFin) && !isDateInterval(dateReceptionDebut, dateReceptionFin)) { showWarning("Plage de dates incorrecte pour la r\u00E9ception pr\u00E9vue !"); }
		else {

			var qEditionCsv = new QueryHttp("Facturation/Commandes/csvCommandeFournisseur.tmpl");

			qEditionCsv.setParam("Num_Commande", numCommande);
			qEditionCsv.setParam("Ref_Article", refArticle);
			qEditionCsv.setParam("Etablissement", etablissement);
			qEditionCsv.setParam("Pole_Activite", poleActivite);
			qEditionCsv.setParam("Denomination", denomination);
			qEditionCsv.setParam("Num_Fournisseur", numFournisseur);
			qEditionCsv.setParam("Etat_Commande", etatCommande);
			qEditionCsv.setParam("Etat_Logistique", etatLogistique);
			qEditionCsv.setParam("Intitule", intitule);
			qEditionCsv.setParam("Num_BL", numBL);
			qEditionCsv.setParam("Date_Commande_Debut", dateCommandeDebut);
			qEditionCsv.setParam("Date_Commande_Fin", dateCommandeFin);
			qEditionCsv.setParam("Date_Reception_Debut", dateReceptionDebut);
			qEditionCsv.setParam("Date_Reception_Fin", dateReceptionFin);
			qEditionCsv.setParam("Depot", depot);
			qEditionCsv.setParam("Num_BR", numBR);
			qEditionCsv.setParam("Etat_Paiement", etatPaiement);
			qEditionCsv.setParam("Bloque", bloque);
			qEditionCsv.setParam("Num_Facture", numFacture);
			qEditionCsv.setParam("Num_Acompte", numAcompte);

			var result = qEditionCsv.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');

				var file = fileChooser("save", fichier);
				if (file!=null) {
					downloadFile(getDirBuffer()+ fichier, file);
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omcf_pressOnEditionDetailCsv() {
	try {

		var numCommande = document.getElementById('omcf-numCommande').value;
		var refArticle = document.getElementById('omcf-refArticle').value;
		var etablissement = document.getElementById('omcf-etablissement').value;
		var depot = document.getElementById('omcf-depot').value;
		var numFournisseur = document.getElementById('omcf-numFournisseur').value;
		var denomination = document.getElementById('omcf-nomFournisseur').value;
		var numBL = document.getElementById('omcf-numBL').value;
		var etatCommande = document.getElementById('omcf-etatCommande').value;
		var etatLogistique = document.getElementById('omcf-etatLogistique').value;
		var numBR = document.getElementById('omcf-numBR').value;
		var intitule = document.getElementById('omcf-intitule').value;
		var dateCommandeDebut = document.getElementById('omcf-dateCommandeDebut').value;
		var dateCommandeFin = document.getElementById('omcf-dateCommandeFin').value;
		var dateReceptionDebut = document.getElementById('omcf-dateReceptionDebut').value;
		var dateReceptionFin = document.getElementById('omcf-dateReceptionFin').value;
		var etatPaiement = document.getElementById('omcf-etatPaiement').value;
		var bloque = document.getElementById('omcf-bloque').value;
		var poleActivite = document.getElementById('omcf-poleActivite').value;
		var numFacture = document.getElementById('omcf-numFacture').value;
		var numAcompte = document.getElementById('omcf-numAcompte').value;

		if (!isEmpty(dateCommandeDebut) && !isDate(dateCommandeDebut)) { showWarning("Date de d\u00E9but de p\u00E9riode incorrecte pour la commande !"); }
		else if (!isEmpty(dateCommandeFin) && !isDate(dateCommandeFin)) { showWarning("Date de fin de p\u00E9riode incorrecte pour la commande !"); }
		else if (!isEmpty(dateCommandeDebut) && !isEmpty(dateCommandeFin) && !isDateInterval(dateCommandeDebut, dateCommandeFin)) { showWarning("Plage de dates incorrecte pour la commande !"); }
		else if (!isEmpty(dateReceptionDebut) && !isDate(dateReceptionDebut)) { showWarning("Date de d\u00E9but de r\u00E9ception pr\u00E9vue incorrecte"); }
		else if (!isEmpty(dateReceptionFin) && !isDate(dateReceptionFin)) { showWarning("Date de fin de r\u00E9ception pr\u00E9vue incorrecte"); }
		else if (!isEmpty(dateReceptionDebut) && !isEmpty(dateReceptionFin) && !isDateInterval(dateReceptionDebut, dateReceptionFin)) { showWarning("Plage de dates incorrecte pour la r\u00E9ception pr\u00E9vue !"); }
		else {

			var qEditionCsv = new QueryHttp("Facturation/Commandes/csvDetailCommandeFournisseur.tmpl");

			qEditionCsv.setParam("Num_Commande", numCommande);
			qEditionCsv.setParam("Ref_Article", refArticle);
			qEditionCsv.setParam("Etablissement", etablissement);
			qEditionCsv.setParam("Pole_Activite", poleActivite);
			qEditionCsv.setParam("Denomination", denomination);
			qEditionCsv.setParam("Num_Fournisseur", numFournisseur);
			qEditionCsv.setParam("Etat_Commande", etatCommande);
			qEditionCsv.setParam("Etat_Logistique", etatLogistique);
			qEditionCsv.setParam("Intitule", intitule);
			qEditionCsv.setParam("Num_BL", numBL);
			qEditionCsv.setParam("Date_Commande_Debut", dateCommandeDebut);
			qEditionCsv.setParam("Date_Commande_Fin", dateCommandeFin);
			qEditionCsv.setParam("Date_Reception_Debut", dateReceptionDebut);
			qEditionCsv.setParam("Date_Reception_Fin", dateReceptionFin);
			qEditionCsv.setParam("Depot", depot);
			qEditionCsv.setParam("Num_BR", numBR);
			qEditionCsv.setParam("Etat_Paiement", etatPaiement);
			qEditionCsv.setParam("Bloque", bloque);
			qEditionCsv.setParam("Num_Facture", numFacture);
			qEditionCsv.setParam("Num_Acompte", numAcompte);

			var result = qEditionCsv.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');

				var file = fileChooser("save", fichier);
				if (file!=null) {
					downloadFile(getDirBuffer()+ fichier, file);
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omcf_pressOnEditerCommandes() {
	try {

		var numCommande = document.getElementById('omcf-numCommande').value;
		var refArticle = document.getElementById('omcf-refArticle').value;
		var etablissement = document.getElementById('omcf-etablissement').value;
		var depot = document.getElementById('omcf-depot').value;
		var numFournisseur = document.getElementById('omcf-numFournisseur').value;
		var denomination = document.getElementById('omcf-nomFournisseur').value;
		var numBL = document.getElementById('omcf-numBL').value;
		var etatCommande = document.getElementById('omcf-etatCommande').value;
		var etatLogistique = document.getElementById('omcf-etatLogistique').value;
		var numBR = document.getElementById('omcf-numBR').value;
		var intitule = document.getElementById('omcf-intitule').value;
		var dateCommandeDebut = document.getElementById('omcf-dateCommandeDebut').value;
		var dateCommandeFin = document.getElementById('omcf-dateCommandeFin').value;
		var dateReceptionDebut = document.getElementById('omcf-dateReceptionDebut').value;
		var dateReceptionFin = document.getElementById('omcf-dateReceptionFin').value;
		var etatPaiement = document.getElementById('omcf-etatPaiement').value;
		var bloque = document.getElementById('omcf-bloque').value;
		var poleActivite = document.getElementById('omcf-poleActivite').value;
		var numFacture = document.getElementById('omcf-numFacture').value;
		var numAcompte = document.getElementById('omcf-numAcompte').value;

		if (!isEmpty(dateCommandeDebut) && !isDate(dateCommandeDebut)) { showWarning("Date de d\u00E9but de p\u00E9riode incorrecte pour la commande !"); }
		else if (!isEmpty(dateCommandeFin) && !isDate(dateCommandeFin)) { showWarning("Date de fin de p\u00E9riode incorrecte pour la commande !"); }
		else if (!isEmpty(dateCommandeDebut) && !isEmpty(dateCommandeFin) && !isDateInterval(dateCommandeDebut, dateCommandeFin)) { showWarning("Plage de dates incorrecte pour la commande !"); }
		else if (!isEmpty(dateReceptionDebut) && !isDate(dateReceptionDebut)) { showWarning("Date de d\u00E9but de r\u00E9ception pr\u00E9vue incorrecte"); }
		else if (!isEmpty(dateReceptionFin) && !isDate(dateReceptionFin)) { showWarning("Date de fin de r\u00E9ception pr\u00E9vue incorrecte"); }
		else if (!isEmpty(dateReceptionDebut) && !isEmpty(dateReceptionFin) && !isDateInterval(dateReceptionDebut, dateReceptionFin)) { showWarning("Plage de dates incorrecte pour la r\u00E9ception pr\u00E9vue !"); }
		else {

			document.getElementById('omcf-pdfCommandes').setAttribute("src", "");

			var qEditionPdf = new QueryHttp("Facturation/Commandes/pdfEditionCommandes.tmpl");

			qEditionPdf.setParam("Num_Commande", numCommande);
			qEditionPdf.setParam("Ref_Article", refArticle);
			qEditionPdf.setParam("Etablissement", etablissement);
			qEditionPdf.setParam("Pole_Activite", poleActivite);
			qEditionPdf.setParam("Denomination", denomination);
			qEditionPdf.setParam("Num_Fournisseur", numFournisseur);
			qEditionPdf.setParam("Etat_Commande", etatCommande);
			qEditionPdf.setParam("Etat_Logistique", etatLogistique);
			qEditionPdf.setParam("Intitule", intitule);
			qEditionPdf.setParam("Num_BL", numBL);
			qEditionPdf.setParam("Date_Commande_Debut", dateCommandeDebut);
			qEditionPdf.setParam("Date_Commande_Fin", dateCommandeFin);
			qEditionPdf.setParam("Date_Reception_Debut", dateReceptionDebut);
			qEditionPdf.setParam("Date_Reception_Fin", dateReceptionFin);
			qEditionPdf.setParam("Depot", depot);
			qEditionPdf.setParam("Num_BR", numBR);
			qEditionPdf.setParam("Etat_Paiement", etatPaiement);
			qEditionPdf.setParam("Bloque", bloque);
			qEditionPdf.setParam("Num_Facture", numFacture);
			qEditionPdf.setParam("Num_Acompte", numAcompte);

			var result = qEditionPdf.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
				document.getElementById('omcf-deckMenu').selectedIndex = 1;
				document.getElementById('bMenuCommandes').collapsed = false;
				document.getElementById('omcf-pdfCommandes').setAttribute("src", page);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omcf_rechercherFournisseur() {
	try {

		var url = "chrome://opensi/content/facturation/user/fournisseurs/popup-rechercheFournisseur.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', omcf_retourRechercherFournisseur);

	} catch (e) {
		recup_erreur(e);
	}
}


function omcf_retourRechercherFournisseur(numFournisseur) {
	try {

  	document.getElementById('omcf-numFournisseur').value = numFournisseur;
  	omcf_listerCommandes();

	} catch (e) {
		recup_erreur(e);
	}
}


function omcf_rechercherArticle() {
	try {

		var url = "chrome://opensi/content/facturation/user/articles/popup-rechercheArticle.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', omcf_retourRechercherArticle);

	} catch (e) {
		recup_erreur(e);
	}
}


function omcf_retourRechercherArticle(reference, articleId) {
	try {

  	document.getElementById('omcf-refArticle').value = reference;
  	omcf_listerCommandes();

	} catch (e) {
		recup_erreur(e);
	}
}


function omcf_pressOnEtatCommande() {
	try {

		var etatCommande = document.getElementById("omcf-etatCommande").value;

		if (etatCommande!="T") {
			document.getElementById("omcf-bcEtatLogistique").collapsed = true;
			document.getElementById("omcf-etatLogistique").value = "";
		}
		else {
			document.getElementById("omcf-bcEtatLogistique").collapsed = false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}

