jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");


var aLignes = new Arbre("Facturation/Commandes/list-lignesNonSoldees.tmpl", "listLigneASolder");



function init() {
	try {

  	var commandeId = window.arguments[1];

  	aLignes.setParam("Commande_Id", commandeId);
		aLignes.initTree();

	} catch (e) {
		recup_erreur(e);
	}
}


function toutCocher(b) {
	try {

		for (var i=0; i<aLignes.nbLignes(); i++) {
			aLignes.setCellValue(i, "colSelLigne", b);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function valider() {
  try {

		var nbCoche = 0;
		var listLigneId = "";

		for (var i=0; i<aLignes.nbLignes(); i++) {
			if (aLignes.getCellValue(i, "colSelLigne")=="true") {
				listLigneId += aLignes.getCellText(i, "colLigneId") +",";
				nbCoche++;
			}
		}

		if (nbCoche==0) {
			showWarning("Veuillez cocher au moins une ligne");
		}
		else if (window.confirm("Confirmez-vous le solde des lignes s\u00E9lectionn\u00E9es ?\n(Attention plus aucune r\u00E9ception possible !)")) {
			document.getElementById('bValider').disabled = true;

			var qSettle = new QueryHttp("Facturation/Commandes/settleMultiLigneCF.tmpl");
			qSettle.setParam("List_Ligne_Id", listLigneId);
			var result = qSettle.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
				aLignes.initTree();
				document.getElementById('bValider').disabled = false;
			}
			else {
				window.arguments[0]();
				window.close();
			}
		}

  } catch (e) {
    recup_erreur(e);
  }
}
