/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");


var gDirection;



function init() {
  try {

  	window.parent.addEventListener("close", demandeEnregistrement, false);

		gDirection = getProfil().isDirection();

		document.getElementById('deck').selectedIndex = 0;

  	ofc_init();

		if (gDirection) {
			omc_init();
		}
		else {
			var qGet = new QueryHttp("Facturation/Commerciaux/getCommercialIdByLoggedUser.tmpl");
			var result = qGet.execute();

			var commercialId = result.responseXML.documentElement.getAttribute("Commercial_Id");

			if (!isEmpty(commercialId)) {
				ouvrirCommercial(commercialId);
			}
			else {
				retourMenuPrincipal();
				showWarning("Vous n'avez pas les droits n\u00E9cessaires pour acc\u00E9der \u00E0 la gestion des commerciaux");
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function ouvrirCommercial(commercialId) {
	try {

		ofc_commercialId = commercialId;
		ofc_chargerCommercial();
		document.getElementById('deck').selectedIndex = 1;

	} catch (e) {
    recup_erreur(e);
  }
}


function desinit() {
	try {

		window.parent.removeEventListener("close", demandeEnregistrement, false);

	} catch (e) {
    recup_erreur(e);
  }
}


function demandeEnregistrement() {
	try {

		var currentDeck = parseIntBis(document.getElementById('deck').selectedIndex);

		if (currentDeck==1) {
			ofc_demandeEnregistrement();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function retourMenuCommerciaux() {
	try {

		document.getElementById('ofc-pdfCommercial').setAttribute("src", "");
		document.getElementById('deck').selectedIndex = 0;
		document.getElementById('bMenuCommerciaux').collapsed = true;
		document.getElementById('bRetourCommercial').collapsed = true;

		document.activeElement.blur();
		omc_listerCommerciaux();

	} catch (e) {
    recup_erreur(e);
  }
}


function retourFicheCommercial() {
  try {

		document.getElementById('ofc-pdfCommercial').setAttribute("src", "");
		document.getElementById('deck').selectedIndex = 1;
		document.getElementById('ofc-deckCommercial').selectedIndex = 0;
		document.getElementById('bMenuCommerciaux').collapsed = !gDirection;
		document.getElementById('bRetourCommercial').collapsed = true;

	} catch (e) {
    recup_erreur(e);
  }
}


function retourMenuPrincipal() {
	try {

		window.location = "chrome://opensi/content/facturation/user/menu_principal.xul";

	} catch (e) {
    recup_erreur(e);
  }
}
