/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

/*
	Arguments du popup :
		- 0 : Fonction de retour
		- 1 : Identifiant client
		- 2 : Lecture seule
		- 3 : Case  cocher adresse principale
*/

jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");


var aAdresses = new Arbre("Facturation/Clients/list-adresseClient.tmpl", "tree-adresses");
var aContactsFact = new Arbre("ComboListe/combo-contactsClient.tmpl", "Contact_Fact");
var aContactsLiv = new Arbre("ComboListe/combo-contactsClient.tmpl", "Contact_Liv");
var aContactsEnvoi = new Arbre("ComboListe/combo-contactsClient.tmpl", "Contact_Envoi");
var aContactsDevis = new Arbre("ComboListe/combo-contactsClient.tmpl", "Contact_Devis");
var clientId;
var currentAdr = -1;
var readOnly;


function init() {
  try {

		clientId = window.arguments[1];
		readOnly = window.arguments[2];
		var noPrinc = window.arguments[3];

		document.getElementById('boxValider').collapsed = readOnly;
		document.getElementById('boxQuitter').collapsed = !readOnly;

		if (readOnly) {
			document.getElementById('Adresse').collapsed = true;
			document.getElementById('bQuitter').focus();
		}

		document.getElementById('Principale').collapsed = (noPrinc!=null && noPrinc);

  	aContactsFact.setParam("Client_Id", clientId);
		aContactsFact.initTree();

		aContactsLiv.setParam("Client_Id", clientId);
		aContactsLiv.initTree();

		aContactsEnvoi.setParam("Client_Id", clientId);
		aContactsEnvoi.initTree();

		aContactsDevis.setParam("Client_Id", clientId);
		aContactsDevis.initTree();

		aAdresses.setParam("Client_Id", clientId);
		aAdresses.initTree();

		var aPays = new Arbre("ComboListe/combo-pays.tmpl", "Code_Pays");
		aPays.initTree(initPays);

		nouveauAdr();

  } catch (e) {
    recup_erreur(e);
  }
}


function initPays() {
	try {

    document.getElementById('Code_Pays').value = "FR";

	} catch (e) {
    recup_erreur(e);
  }
}


function nouveauAdr() {
	try {

		aAdresses.clearSelection();

		currentAdr=-1;

		document.getElementById('Intitule').value = "";
		document.getElementById('Denomination').value = "";
		document.getElementById('Adresse_1').value = "";
		document.getElementById('Adresse_2').value = "";
		document.getElementById('Adresse_3').value = "";
		document.getElementById('Code_Postal').value = "";
		document.getElementById('Ville').value = "";
		initPays();
		document.getElementById('Defaut_Fact').checked = false;
		document.getElementById('Defaut_Liv').checked = false;
		document.getElementById('Defaut_Envoi').checked = false;
		document.getElementById('Defaut_Devis').checked = false;
		document.getElementById('Defaut_Fact').disabled = false;
		document.getElementById('Defaut_Liv').disabled = false;
		document.getElementById('Defaut_Envoi').disabled = false;
		document.getElementById('Defaut_Devis').disabled = false;
		document.getElementById('Principale').checked = false;
		document.getElementById('Principale').disabled = false;
		document.getElementById('Contact_Fact').value = "";
		document.getElementById('Contact_Liv').value = "";
		document.getElementById('Contact_Envoi').value = "";
		document.getElementById('Contact_Devis').value = "";

		document.getElementById('bNouveauAdr').collapsed = true;
		document.getElementById('bSupprimerAdr').collapsed = true;
		document.getElementById('bModifierAdr').collapsed = true;
		document.getElementById('bCreerAdr').collapsed = false;

	} catch (e) {
    recup_erreur(e);
  }
}


function supprimerAdr() {
	try {

		var denomination = document.getElementById('Denomination').value;

		if (window.confirm("Confirmez-vous la suppression de l'adresse '"+ denomination +"' ?")) {

			var qSupAdr = new QueryHttp("Facturation/Clients/deleteAdresseClient.tmpl");
			qSupAdr.setParam('Adresse_Id', currentAdr);
			var result = qSupAdr.execute();

			var errors = new Errors(result);

			if (errors.hasNext()) {
				errors.show();
			}
			else {
				document.getElementById('bSupprimerAdr').collapsed = true;
				document.getElementById('bModifierAdr').collapsed = true;
				document.getElementById('bCreerAdr').collapsed = false;
				document.getElementById('bNouveauAdr').collapsed = true;

				aAdresses.initTree();
				nouveauAdr();
			}
		}

  } catch (e) {
  	recup_erreur(e);
  }
}


function chargerAdr() {
	try {

		if (aAdresses.isSelected()) {

			currentAdr = aAdresses.getSelectedCellValue('ColDenomination');

			document.getElementById('Intitule').value = aAdresses.getSelectedCellText('ColIntitule');
			document.getElementById('Denomination').value = aAdresses.getSelectedCellText('ColDenomination');
			document.getElementById('Adresse_1').value = aAdresses.getSelectedCellText('ColAdresse_1');
			document.getElementById('Adresse_2').value = aAdresses.getSelectedCellText('ColAdresse_2');
			document.getElementById('Adresse_3').value = aAdresses.getSelectedCellText('ColAdresse_3');
			document.getElementById('Code_Postal').value = aAdresses.getSelectedCellText('ColCode_Postal');
			document.getElementById('Ville').value = aAdresses.getSelectedCellText('ColVille');
			document.getElementById('Code_Pays').value = aAdresses.getSelectedCellText('ColCode_Pays');
			document.getElementById('Defaut_Fact').checked = (aAdresses.getSelectedCellText('ColDefaut_Fact')=="true");
			document.getElementById('Defaut_Liv').checked = (aAdresses.getSelectedCellText('ColDefaut_Liv')=="true");
			document.getElementById('Defaut_Envoi').checked = (aAdresses.getSelectedCellText('ColDefaut_Envoi')=="true");
			document.getElementById('Defaut_Devis').checked = (aAdresses.getSelectedCellText('ColDefaut_Devis')=="true");
			document.getElementById('Principale').checked = (aAdresses.getSelectedCellText('ColPrincipale')=="true");
			document.getElementById('Principale').disabled = document.getElementById('Principale').checked;
			document.getElementById('Defaut_Fact').disabled = document.getElementById('Defaut_Fact').checked;
			document.getElementById('Defaut_Liv').disabled = document.getElementById('Defaut_Liv').checked;
			document.getElementById('Defaut_Envoi').disabled = document.getElementById('Defaut_Envoi').checked;
			document.getElementById('Defaut_Devis').disabled = document.getElementById('Defaut_Devis').checked;
			document.getElementById('Contact_Fact').value = aAdresses.getSelectedCellText('ColContact_Fact');
			document.getElementById('Contact_Liv').value = aAdresses.getSelectedCellText('ColContact_Liv');
			document.getElementById('Contact_Envoi').value = aAdresses.getSelectedCellText('ColContact_Envoi');
			document.getElementById('Contact_Devis').value = aAdresses.getSelectedCellText('ColContact_Devis');

			document.getElementById('bSupprimerAdr').collapsed = false;
			document.getElementById('bModifierAdr').collapsed = false;
			document.getElementById('bNouveauAdr').collapsed = false;
			document.getElementById('bCreerAdr').collapsed = true;
		}

 	} catch (e) {
    recup_erreur(e);
  }
}


function changergroupbox(check) {
	try {

		window.resizeTo(1000,check?700:400);
		document.getElementById('Group_Adresse').collapsed = !check;

	} catch (e) {
    recup_erreur(e);
  }
}


function ouvrirAdresse() {
  try {

		if (!readOnly) {
			if (currentAdr!=-1) {
				var nom = aAdresses.getSelectedCellText('ColDenomination');
   			var adr1 = aAdresses.getSelectedCellText('ColAdresse_1');
				var adr2 = aAdresses.getSelectedCellText('ColAdresse_2');
				var adr3 = aAdresses.getSelectedCellText('ColAdresse_3');
				var cp = aAdresses.getSelectedCellText('ColCode_Postal');
				var ville = aAdresses.getSelectedCellText('ColVille');
				var pays = aAdresses.getSelectedCellText('ColPays');
				var code_pays = aAdresses.getSelectedCellText('ColCode_Pays');
				var contact_fact = aAdresses.getSelectedCellText('ColContact_Fact');
				var contact_liv = aAdresses.getSelectedCellText('ColContact_Liv');
				var contact_envoi = aAdresses.getSelectedCellText('ColContact_Envoi');
				var contact_devis = aAdresses.getSelectedCellText('ColContact_Devis');

				window.arguments[0](nom, adr1, adr2, adr3, cp, ville, pays, code_pays, contact_fact, contact_liv, contact_envoi, contact_devis, currentAdr);
    		window.close();
			}
			else {
				showWarning("Veuillez s\u00E9lectionner une adresse !");
			}
		}

  } catch (e) {
    recup_erreur(e);
  }
}


function pressOnTree(ev) {
  try {

    if (ev.keyCode==13) {
    	ouvrirAdresse();
    }

  } catch (e) {
    recup_erreur(e);
  }
}


function enregistrerAdr(mode) {
  try {

		var intitule = document.getElementById('Intitule').value;
    var denomination = document.getElementById('Denomination').value;
		var adresse_1 = document.getElementById('Adresse_1').value;
		var adresse_2 = document.getElementById('Adresse_2').value;
		var adresse_3 = document.getElementById('Adresse_3').value;
		var code_postal = document.getElementById('Code_Postal').value;
		var ville = document.getElementById('Ville').value;
		var code_pays = document.getElementById('Code_Pays').value;
		var defaut_fact = document.getElementById('Defaut_Fact').checked;
		var defaut_liv = document.getElementById('Defaut_Liv').checked;
		var defaut_envoi = document.getElementById('Defaut_Envoi').checked;
		var defaut_devis = document.getElementById('Defaut_Devis').checked;
		var contact_fact = document.getElementById('Contact_Fact').value;
		var contact_liv = document.getElementById('Contact_Liv').value;
		var contact_envoi = document.getElementById('Contact_Envoi').value;
		var contact_devis = document.getElementById('Contact_Devis').value;
		var principale = document.getElementById('Principale').checked;

		if (isEmpty(denomination)) { showWarning("Veuillez sp\u00E9cifier la d\u00E9nomination"); }
		else if (isEmpty(adresse_1)) { showWarning("Veuillez sp\u00E9cifier l'adresse"); }
		else if (isEmpty(ville)) { showWarning("Veuillez sp\u00E9cifier la ville"); }
		else {

			var qSaveAdr;

			if (mode=="C") {
				qSaveAdr = new QueryHttp("Facturation/Clients/createAdresseClient.tmpl");
			}
			else {
				qSaveAdr = new QueryHttp("Facturation/Clients/updateAdresseClient.tmpl");
				qSaveAdr.setParam('Adresse_Id', currentAdr);
			}

			qSaveAdr.setParam('Client_Id', clientId);
			qSaveAdr.setParam('Intitule', intitule);
			qSaveAdr.setParam('Denomination', denomination);
			qSaveAdr.setParam('Adresse_1', adresse_1);
			qSaveAdr.setParam('Adresse_2', adresse_2);
			qSaveAdr.setParam('Adresse_3', adresse_3);
			qSaveAdr.setParam('Code_Postal', code_postal);
			qSaveAdr.setParam('Ville', ville);
			qSaveAdr.setParam('Code_Pays', code_pays);
			qSaveAdr.setParam('Defaut_Fact', defaut_fact);
			qSaveAdr.setParam('Defaut_Liv', defaut_liv);
			qSaveAdr.setParam('Defaut_Envoi', defaut_envoi);
			qSaveAdr.setParam('Defaut_Devis', defaut_devis);
			qSaveAdr.setParam('Contact_Fact', contact_fact);
			qSaveAdr.setParam('Contact_Liv', contact_liv);
			qSaveAdr.setParam('Contact_Envoi', contact_envoi);
			qSaveAdr.setParam('Contact_Devis', contact_devis);
			qSaveAdr.setParam('Principale', principale);

			var result = qSaveAdr.execute();

			document.getElementById('Defaut_Fact').disabled = defaut_fact;
			document.getElementById('Defaut_Liv').disabled = defaut_liv;
			document.getElementById('Defaut_Envoi').disabled = defaut_envoi;
			document.getElementById('Defaut_Devis').disabled = defaut_devis;
			document.getElementById('Principale').disabled = principale;

			if (mode=="C") {
				currentAdr = result.responseXML.documentElement.getAttribute('Adresse_Id');

				document.getElementById('bCreerAdr').collapsed = true;
				document.getElementById('bModifierAdr').collapsed = false;
				document.getElementById('bNouveauAdr').collapsed = false;
				document.getElementById('bSupprimerAdr').collapsed = false;
			}

			aAdresses.initTree(scrollToNum);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function scrollToNum() {
	try {

		var tree = document.getElementById("tree-adresses");

		if (tree.view!=null && tree.view.rowCount>0 && currentAdr>-1) {

			var i = 0;
			var trouve = false;

			while (!trouve && i<tree.view.rowCount) {
				if (parseIntBis(aAdresses.getCellValue(i,'ColDenomination'))==currentAdr) {
					aAdresses.ensureRowIsVisible(i);
					aAdresses.select(i);
					trouve = true;
				}

				i++;
			}
			if (!trouve) aAdresses.ensureRowIsVisible(tree.view.rowCount-1);
		}

	} catch (e) {
  	recup_erreur(e);
	}
}
