/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

/*
	Arguments du popup :
		- 0 : Type document
		- 1 : Identifiant du document
		- 2 : Lecture seule
*/

jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");


var aAssoc;
var qAttach = new QueryHttp("Facturation/Commun/attachFichierAssoc.tmpl");

var readOnly;


function init() {
	try {

    var typeDoc = window.arguments[0];
    var documentId = window.arguments[1];

		readOnly = window.arguments[2];
		document.getElementById('boxCharger').collapsed = readOnly;

		qAttach.setParam("Type", typeDoc);
		qAttach.setParam("Document_Id", documentId);

		var tmplList;

		if (typeDoc=="DC") {
			tmplList = "Facturation/Devis/list-fichierAssocDC.tmpl";
		}
		else if (typeDoc=="CC") {
			tmplList = "Facturation/Affaires/list-fichierAssocCC.tmpl";
		}
		else if (typeDoc=="FART") {
			tmplList = "Facturation/Articles/list-fichierAssocFART.tmpl";
		}
		else if (typeDoc=="FCLI") {
			tmplList = "Facturation/Clients/list-fichierAssocFCLI.tmpl";
		}
		else if (typeDoc=="FFOU") {
			tmplList = "Facturation/Fournisseurs/list-fichierAssocFFOU.tmpl";
		}
		else if (typeDoc=="AFF") {
			tmplList = "Facturation/Affaires/list-fichierAssocAFF.tmpl";
		}
		else if (typeDoc=="CF") {
			tmplList = "Facturation/Commandes/list-fichierAssocCF.tmpl";
		}
		else if (typeDoc=="FF") {
			tmplList = "Facturation/Factu_Fournisseur/list-fichierAssocFF.tmpl";
		}
		else if (typeDoc=="AF") {
			tmplList = "Facturation/Avoirs_Fournisseur/list-fichierAssocAF.tmpl";
		}

		aAssoc = new Arbre(tmplList, "assoc");
    aAssoc.setParam("Type", typeDoc);
    aAssoc.setParam("Document_Id", documentId);
    aAssoc.initTree();

	} catch (e) {
		recup_erreur(e);
	}
}


function enlever_assoc(fichierAssocId) {
  try {

		if (readOnly) {
			showWarning("Vous n'avez pas les droits n\u00E9cessaires pour enlever la liaison vers un fichier.");
		}
    else if (confirm("Etes vous s\u00FBr de vouloir enlever la liaison vers ce fichier ?")) {
	    var qDelete = new QueryHttp("Facturation/Commun/deleteFichierAssoc.tmpl");
	 	  qDelete.setParam("Fichier_Assoc_Id", fichierAssocId);
	    qDelete.execute();
	    aAssoc.initTree();
    }

	} catch (e) {
  	recup_erreur(e);
  }
}


function charger_assoc() {
	try {

		var importFile = fileChooser("open");
		if (importFile!=null) {
			if (importFile.fileSize>209715200) { // 200 Mo
				showWarning("Taille de fichier trop importante (200 Mo max.)");
			}
			else if (checkUploadFile(importFile)) {
				document.getElementById("bQuitter").disabled = true;
				document.getElementById("bCharger").disabled = true;

				uploadFile(importFile);

				qAttach.setParam("Nom", importFile.leafName);
				var result = qAttach.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
				document.getElementById("bQuitter").disabled = false;
				document.getElementById("bCharger").disabled = false;
				aAssoc.initTree();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function telecharger(fichierAssocId) {
	try {

		var qGet = new QueryHttp("Facturation/Commun/retrieveFichierAssoc.tmpl");
	 	qGet.setParam("Assoc_Id", fichierAssocId);
	  var result = qGet.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			window.open(getDirBuffer() + result.responseXML.documentElement.getAttribute('Fichier'));
		}

	} catch (e) {
		recup_erreur(e);
	}
}
