/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

/*
	Arguments du popup :
		- 0 : Type document
		- 1 : Identifiant document
		- 2 : Si true, mode lecture seule
		- 3 : Demande de confirmation d'enregistrement spcifique (argument facultatif)
*/

jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");


var typeDoc;
var docId;
var tmplSave;
var pDocId;
var aMentions;
var msgConfirm = null;



function init() {
  try {

		typeDoc = window.arguments[0];
		docId = window.arguments[1];
		msgConfirm = window.arguments[3];
		var readOnly = window.arguments[2];

		document.getElementById('boxValider').collapsed = readOnly;
		document.getElementById('boxQuitter').collapsed = !readOnly;

		if (readOnly) {
			document.getElementById('listeMentions').disabled = true;
			document.getElementById('bQuitter').focus();
		}

		var tmplLoad;
		var libellePopup;

		if (typeDoc=="CC") {
			libellePopup = "Mentions sur commande";
			tmplLoad = "Facturation/Affaires/list-mentionCommandeClient.tmpl";
			tmplSave = "Facturation/Affaires/updateMentionCommandeClient.tmpl";
			pDocId = "Commande_Id";
		}
		else if (typeDoc=="DC") {
			libellePopup = "Mentions sur devis";
			tmplLoad = "Facturation/Devis/list-mentionDevis.tmpl";
			tmplSave = "Facturation/Devis/updateMentionDevis.tmpl";
			pDocId = "Devis_Id";
		}
		else if (typeDoc=="FC") {
			libellePopup = "Mentions sur facture";
			tmplLoad = "Facturation/FacturesVente/list-mentionFactureClient.tmpl";
			tmplSave = "Facturation/FacturesVente/updateMentionFactureClient.tmpl";
			pDocId = "Facture_Id";
		}
		else if (typeDoc=="AC") {
			libellePopup = "Mentions sur avoir";
			tmplLoad = "Facturation/Avoirs/list-mentionAvoirClient.tmpl";
			tmplSave = "Facturation/Avoirs/updateMentionAvoirClient.tmpl";
			pDocId = "Avoir_Id";
		}
		else if (typeDoc=="RC") {
			libellePopup = "Mentions sur retour";
			tmplLoad = "Facturation/Affaires/list-mentionRetourClient.tmpl";
			tmplSave = "Facturation/Affaires/updateMentionRetourClient.tmpl";
			pDocId = "Retour_Id";
		}
		else if (typeDoc=="TS") {
			libellePopup = "Mentions sur transfert";
			tmplLoad = "Facturation/Transferts_Stocks/list-mentionTransfertStock.tmpl";
			tmplSave = "Facturation/Transferts_Stocks/updateMentionTransfertStock.tmpl";
			pDocId = "Transfert_Id";
		}
		else if (typeDoc=="TE") {
			libellePopup = "Mentions sur transfert";
			tmplLoad = "Facturation/Transferts_Emplacements/list-mentionTransfertEmplacement.tmpl";
			tmplSave = "Facturation/Transferts_Emplacements/updateMentionTransfertEmplacement.tmpl";
			pDocId = "Transfert_Id";
		}
		else if (typeDoc=="CF") {
			libellePopup = "Mentions sur commande";
			tmplLoad = "Facturation/Commandes/list-mentionCommandeFournisseur.tmpl";
			tmplSave = "Facturation/Commandes/updateMentionCommandeFournisseur.tmpl";
			pDocId = "Commande_Id";
		}
		else if (typeDoc=="FF") {
			libellePopup = "Mentions sur facture";
			tmplLoad = "Facturation/Factu_Fournisseur/list-mentionFactureFournisseur.tmpl";
			tmplSave = "Facturation/Factu_Fournisseur/updateMentionFactureFournisseur.tmpl";
			pDocId = "Facture_Id";
		}
		else if (typeDoc=="AF") {
			libellePopup = "Mentions sur avoir";
			tmplLoad = "Facturation/Avoirs_Fournisseur/list-mentionAvoirFournisseur.tmpl";
			tmplSave = "Facturation/Avoirs_Fournisseur/updateMentionAvoirFournisseur.tmpl";
			pDocId = "Avoir_Id";
		}
		else if (typeDoc=="RF") {
			libellePopup = "Mentions sur retour";
			tmplLoad = "Facturation/Retours_Fournisseurs/list-mentionRetourFournisseur.tmpl";
			tmplSave = "Facturation/Retours_Fournisseurs/updateMentionRetourFournisseur.tmpl";
			pDocId = "Retour_Id";
		}
		else if (typeDoc=="BR") {
			libellePopup = "Mentions sur bon de r\u00E9ception";
			tmplLoad = "Facturation/Commandes/list-mentionBonReception.tmpl";
			tmplSave = "Facturation/Commandes/updateMentionBonReception.tmpl";
			pDocId = "Bon_Rec_Id";
		}
		else if (typeDoc=="BRT") {
			libellePopup = "Mentions sur bon de r\u00E9ception";
			tmplLoad = "Facturation/Transferts_Stocks/list-mentionBonReception.tmpl";
			tmplSave = "Facturation/Transferts_Stocks/updateMentionBonReception.tmpl";
			pDocId = "Bon_Rec_Id";
		}
		else if (typeDoc=="BRR") {
			libellePopup = "Mentions sur bon de r\u00E9ception";
			tmplLoad = "Facturation/Retours_Fournisseurs/list-mentionBonReception.tmpl";
			tmplSave = "Facturation/Retours_Fournisseurs/updateMentionBonReception.tmpl";
			pDocId = "Bon_Rec_Id";
		}
		else if (typeDoc=="BLT") {
			libellePopup = "Mentions sur bon de livraison";
			tmplLoad = "Facturation/Transferts_Stocks/list-mentionBonLivraison.tmpl";
			tmplSave = "Facturation/Transferts_Stocks/updateMentionBonLivraison.tmpl";
			pDocId = "Bon_Liv_Id";
		}
		else if (typeDoc=="BLR") {
			libellePopup = "Mentions sur bon de livraison";
			tmplLoad = "Facturation/Retours_Fournisseurs/list-mentionBonLivraison.tmpl";
			tmplSave = "Facturation/Retours_Fournisseurs/updateMentionBonLivraison.tmpl";
			pDocId = "Bon_Liv_Id";
		}
		else if (typeDoc=="BL") {
			libellePopup = "Mentions sur bon de livraison";
			tmplLoad = "Facturation/Affaires/list-mentionBonLivraison.tmpl";
			tmplSave = "Facturation/Affaires/updateMentionBonLivraison.tmpl";
			pDocId = "Bon_Liv_Id";
		}
		else if (typeDoc=="CA") {
			libellePopup = "Mentions sur facture";
			tmplLoad = "Facturation/Abonnements/list-mentionContratAbonnement.tmpl";
			tmplSave = "Facturation/Abonnements/updateMentionContratAbonnement.tmpl";
			pDocId = "Contrat_Id";
		}
		else if (typeDoc=="MA") {
			libellePopup = "Mentions sur facture";
			tmplLoad = "Facturation/Abonnements/list-mentionModeleAbonnement.tmpl";
			tmplSave = "Facturation/Abonnements/updateMentionModeleAbonnement.tmpl";
			pDocId = "Modele_Id";
		}

		document.getElementById('lblPopup').value = libellePopup;

		aMentions = new Arbre(tmplLoad, 'listeMentions');
		aMentions.setParam(pDocId, docId);
		aMentions.initTree();

  } catch (e) {
    recup_erreur(e);
  }
}


function enregistrerMentions() {
  try {

		if (msgConfirm==null || window.confirm(msgConfirm)) {
			var listMentionId = "";

  		for (var i=0; i<aMentions.nbLignes(); i++) {
				if (aMentions.getCellValue(i, "colSelect")=="true") {
					listMentionId += aMentions.getCellText(i, "colMentionId") +",";
				}
  		}

  		var qSave = new QueryHttp(tmplSave);
			qSave.setParam(pDocId, docId);
			qSave.setParam("List_Mention_Id", listMentionId);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
		}

		window.close();

	} catch (e) {
    recup_erreur(e);
  }
}
