/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

/*
	Arguments du popup :
		- 0 : Mode d'ouverture du popup (S=Saisie, C=Consultation)
		- 1 : Type de document
		- 2 : Identifiant de ligne (Ligne_Id)
		- 3 : Localisation (Client_Id, Depot_Id)
*/

jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");


var aSerieComposant;
var aSerieDispo;

var composantId = "";
var docType;
var mode;
var isSuiviSerie;
var dispDispo = false;
var tmplIC;		// Infos sur le composant
var tmplAdd;
var tmplDel;



function init() {
	try {
	
		var config = getConfig();
				
		if (!config.isActSerieDLC()) {
			document.getElementById("colDatePeremptionSC").setAttribute("hidden", true);
		}

		mode = window.arguments[0];
		docType = window.arguments[1];
		var ligneId = window.arguments[2];
		var depotId = null;
		var clientId = null;

		var tmplIL;         // Infos sur la ligne de document
		var tmplSC;					// N Srie rattachs au composant
		var tmplSD = null;	// N Srie disponibles
		var tmplCL;					// Composants de la ligne

		switch (docType) {
			case "AC":
				clientId = window.arguments[3];
				tmplCL = "Facturation/Avoirs/combo-composantLigneAC.tmpl";
				tmplIL = "Facturation/Avoirs/getInfoLigneACNS.tmpl";
				tmplIC = "Facturation/Avoirs/getInfoComposantLigneACNS.tmpl";
				tmplSC = "Facturation/Avoirs/list-numSerieComposantLigneAC.tmpl";
				tmplSD = "Facturation/Avoirs/list-numSerieComposantDispoAC.tmpl";
				tmplAdd = "Facturation/Avoirs/addNumSerieComposantLigneAC.tmpl";
				tmplDel = "Facturation/Avoirs/deleteNumSerieComposantLigneAC.tmpl";
				break;
			case "BL":
				depotId = window.arguments[3];
				tmplCL = "Facturation/Affaires/combo-composantLigneBL.tmpl";
				tmplIL = "Facturation/Affaires/getInfoLigneBLNS.tmpl";
				tmplIC = "Facturation/Affaires/getInfoComposantLigneBLNS.tmpl";
				tmplSC = "Facturation/Affaires/list-numSerieComposantLigneBL.tmpl";
				tmplSD = "Facturation/Affaires/list-numSerieComposantDispoBL.tmpl";
				tmplAdd = "Facturation/Affaires/addNumSerieComposantLigneBL.tmpl";
				tmplDel = "Facturation/Affaires/deleteNumSerieComposantLigneBL.tmpl";
				break;
			case "FC":
				depotId = window.arguments[3];
				tmplCL = "Facturation/FacturesVente/combo-composantLigneFC.tmpl";
				tmplIL = "Facturation/FacturesVente/getInfoLigneFCNS.tmpl";
				tmplIC = "Facturation/FacturesVente/getInfoComposantLigneFCNS.tmpl";
				tmplSC = "Facturation/FacturesVente/list-numSerieComposantLigneFC.tmpl";
				tmplSD = "Facturation/FacturesVente/list-numSerieComposantDispoFC.tmpl";
				tmplAdd = "Facturation/FacturesVente/addNumSerieComposantLigneFC.tmpl";
				tmplDel = "Facturation/FacturesVente/deleteNumSerieComposantLigneFC.tmpl";
				break;
			case "RC":
				clientId = window.arguments[3];
			case "RCA":
				document.getElementById("boxSaisie").collapsed = true;
				tmplCL = "Facturation/Retours_Clients/combo-composantLigneRC.tmpl";
				tmplIL = "Facturation/Retours_Clients/getInfoLigneRCNS.tmpl";
				tmplIC = "Facturation/Retours_Clients/getInfoComposantLigneRCNS.tmpl";
				tmplSC = "Facturation/Retours_Clients/list-numSerieComposantLigneRC.tmpl";
				tmplSD = "Facturation/Retours_Clients/list-numSerieComposantDispoRC.tmpl";
				tmplAdd = "Facturation/Retours_Clients/addNumSerieComposantLigneRC.tmpl";
				tmplDel = "Facturation/Retours_Clients/deleteNumSerieComposantLigneRC.tmpl";
				break;
		}

		if (mode=="S") {
			document.getElementById("titre").value = "AFFECTATION DES N\u00B0 DE SERIE";
			document.getElementById("boxLigne").collapsed = false;

			if (tmplSD!=null && (depotId==null || !isEmpty(depotId))) {
				document.getElementById("boxDispo").collapsed = false;
				dispDispo = true;

				aSerieDispo = new Arbre(tmplSD, "listSerieDispo");

				if (clientId!=null) {
					aSerieDispo.setParam("Client_Id", clientId);
				}

				if (depotId!=null) {
					aSerieDispo.setParam("Depot_Id", depotId);
				}
			}
				
			if (!config.isActSerieDLC()) {
				document.getElementById("colDatePeremptionSD").setAttribute("hidden", true);
			}
		}

		aSerieComposant = new Arbre(tmplSC, "listSerieComposant");

		var qGet = new QueryHttp(tmplIL);
		qGet.setParam("Ligne_Id", ligneId);
		var result = qGet.execute();

		document.getElementById("referenceForfait").value = result.responseXML.documentElement.getAttribute('Reference');
		document.getElementById("designationForfait").value = result.responseXML.documentElement.getAttribute('Designation');
		document.getElementById("quantiteForfait").value = result.responseXML.documentElement.getAttribute('Quantite');

		var aComposants = new Arbre(tmplCL, "composant");
		aComposants.setParam("Ligne_Id", ligneId);
		aComposants.initTree();

		checkAddLine();

	}	catch (e) {
	  recup_erreur(e);
	}
}


function changeComposant() {
	try {

		composantId = document.getElementById('composant').value;

		if (!isEmpty(composantId)) {
			var qGet = new QueryHttp(tmplIC);
			qGet.setParam("Composant_Id", composantId);
			var result = qGet.execute();

			isSuiviSerie = result.responseXML.documentElement.getAttribute('Suivi_Serie')=="true";

			document.getElementById("designation").value = result.responseXML.documentElement.getAttribute('Designation');
			document.getElementById("quantite").value = result.responseXML.documentElement.getAttribute('Quantite');

			if (dispDispo) {
				aSerieDispo.setParam("Composant_Id", composantId);
				aSerieDispo.initTree();
			}

			aSerieComposant.setParam("Composant_Id", composantId);
			aSerieComposant.initTree(checkAddLine);
		}
		else {
			document.getElementById("designation").value = "";
			document.getElementById("quantite").value = "";
			if (dispDispo) {
				aSerieDispo.deleteTree();
			}
			aSerieComposant.deleteTree();
			checkAddLine();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnNumSerie(ev) {
	try {

		if (ev.keyCode==13) {
			addNumSerie();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function addNumSerie(pNumero) {
	try {

		var numero = pNumero==null?document.getElementById('numSerie').value:pNumero;

		if (isEmpty(numero)) {
			showWarning("Veuillez saisir un n\u00B0 de s\u00E9rie");
		}
		else {
			var qAdd = new QueryHttp(tmplAdd);
			qAdd.setParam("Numero", numero);
			qAdd.setParam("Composant_Id", composantId);
			var result = qAdd.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				document.getElementById('numSerie').value = "";
				if (dispDispo) {
					aSerieDispo.initTree();
				}
				aSerieComposant.initTree(checkAddLine);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function checkAddLine() {
	try {

		var quantite = document.getElementById('quantite').value;
		var nbLignes = aSerieComposant.nbLignes();
		document.getElementById("nb").value = !isEmpty(composantId)?nbLignes:"";
		var canAdd = (!isEmpty(composantId) && quantite>nbLignes);

		document.getElementById('numSerie').disabled = !canAdd;
		document.getElementById('bValider').disabled = !canAdd;
		document.getElementById('bTransferToAffect').disabled = true;
		document.getElementById('bTransferToDispo').disabled = true;
		document.getElementById('bDesaffecter').disabled = true;
		if (!canAdd) {
			document.getElementById('bQuitter').focus();
		}
		else {
			document.getElementById('numSerie').focus();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function transferToAffect() {
	try {

		var nbSelection = aSerieDispo.nbSelection();
		var quantite = document.getElementById('quantite').value;
		var nbLignes = aSerieComposant.nbLignes();

		if (nbLignes+nbSelection>quantite) {
			var restant = quantite - nbLignes;
			showWarning("Vous ne pouvez s\u00E9lectionner au maximum que "+ restant +" n\u00B0 s\u00E9rie");
		}
		else {
			var nonTrans = false;
			var start = new Object();
			var end = new Object();
			var rangeCount = aSerieDispo.getRangeCount();
			var listSerieId = new Array();

			for (var t=0; t<rangeCount; t++) {
				aSerieDispo.getRangeAt(t,start,end);
				for (var v=start.value; v<=end.value; v++) {
					if (aSerieDispo.getCellText(v, "colBloqueSD")=="true" && (docType=="BL" || docType=="FC")) {
						nonTrans = true;
					}
					else {
						listSerieId.push(aSerieDispo.getCellText(v, "colNumeroSD"));
					}
				}
			}

			for (var i=0; i<listSerieId.length; i++){
				addNumSerie(listSerieId[i]);
			}

			if (nonTrans) {
				showWarning("Les n\u00B0 de s\u00E9rie bloqu\u00E9s n'ont pas \u00E9t\u00E9 affect\u00E9s");
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function transferToDispo() {
	try {

		var start = new Object();
		var end = new Object();
		var rangeCount = aSerieComposant.getRangeCount();
		var listSerieId = new Array();

		for (var t=0; t<rangeCount; t++) {
			aSerieComposant.getRangeAt(t,start,end);
			for (var v=start.value; v<=end.value; v++) {
				listSerieId.push(aSerieComposant.getCellText(v, "colSerieIdSC"));
			}
		}

		for (var i=0; i<listSerieId.length; i++){
			deleteNumSerie(listSerieId[i]);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function deleteNumSerie(serieId) {
	try {

		var qDelete = new QueryHttp(tmplDel);
		qDelete.setParam("Composant_Id", composantId);
		qDelete.setParam("Serie_Id", serieId);
		qDelete.execute();

		if (dispDispo) {
			aSerieDispo.initTree();
		}
		aSerieComposant.initTree(checkAddLine);

	} catch (e) {
		recup_erreur(e);
	}
}


function quit() {
	try {

		if (mode=="S") {
			var nbAffect = aSerieComposant.nbLignes();
			var quantite = document.getElementById('quantite').value;

			if (nbAffect<quantite && isSuiviSerie) {
				if (!window.confirm("La saisie des n\u00B0 de s\u00E9rie est obligatoire sur cet article. Tous les n\u00B0 de s\u00E9rie n'ont pas \u00E9t\u00E9 affect\u00E9s. \nVoulez-vous continuer la saisie ?")) {
					window.close();
				}
			}
			else {
				window.close();
			}
		}
		else {
			window.close();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function degriserBoutonsTransfert() {
	try {

		if (dispDispo && aSerieDispo.isSelected()) {
			var quantite = document.getElementById('quantite').value;
			var nbAffect = aSerieComposant.nbLignes();
			document.getElementById('bTransferToAffect').disabled = (nbAffect>=quantite);
		}

		if (aSerieComposant.isSelected()) {
			document.getElementById('bTransferToDispo').disabled = false;
			document.getElementById('bDesaffecter').disabled = false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}
