/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

/*
	Arguments du popup :
		- 0 : Fonction de retour
		- 1 : Mode d'ouverture du popup (I=Incrmentation, D=Dcrmentation, T=Transfert)
		- 2 : Identifiant article Article_Id
		- 3 : Identifiant depot (Depot_Id)
		- 4 : Quantit ajustement
*/

jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");


var aSerieLigne = new Arbre("Facturation/Stocks/list-serieLigneDirect.tmpl", "listSerieLigne");
var aSerieDispo = new Arbre("Facturation/Stocks/list-serieDirectByArticleId.tmpl", "listSerieDispo");

var articleId;
var depotId;
var curListSerieId = [];
var mode;



function init() {
	try {

		document.getElementById('numSerie').focus();
	
		var config = getConfig();
				
		if (!config.isActSerieDLC()) {
			document.getElementById("colDatePeremptionSD").setAttribute("hidden", true);
			document.getElementById("colDatePeremptionSL").setAttribute("hidden", true);
		}

		mode = window.arguments[1];
		articleId = window.arguments[2];
		depotId = window.arguments[3];
		var quantite = window.arguments[4];

		var qGet = new QueryHttp("Facturation/Stocks/getNumeroSerie.tmpl");
		qGet.setParam("Article_Id", articleId);
		qGet.setParam("Depot_Id", depotId);
		var result = qGet.execute();

		var stockReel = result.responseXML.documentElement.getAttribute('Stock_Reel');
		var qteAObtenir = quantite;

		if (mode=="I") {
			document.getElementById("titre").value = "AJOUT DES N\u00B0 DE SERIE";
			document.getElementById("boxDispo").collapsed = true;
			document.getElementById('bDesaffecter').collapsed = true;
			if (config.isActSerieDLC()) {
				document.getElementById("boxDatePeremption").collapsed = false;
			}
			qteAObtenir = parseFloat(stockReel) + parseFloat(quantite);
		}
		else if (mode=="D") {
			document.getElementById("titre").value = "DESAFFECTATION DES N\u00B0 DE SERIE";
			document.getElementById("colNumeroSL").setAttribute("label", "N\u00B0 S\u00E9rie \u00E0 d\u00E9saffecter");
		}
		else if (mode=="T") {
			document.getElementById("titre").value = "TRANSFERT DES N\u00B0 DE SERIE";
			document.getElementById("colNumeroSL").setAttribute("label", "N\u00B0 S\u00E9rie \u00E0 transf\u00E9rer");
		}

		document.getElementById("reference").value = result.responseXML.documentElement.getAttribute('Reference');
		document.getElementById("designation").value = result.responseXML.documentElement.getAttribute('Designation');
		document.getElementById("quantite").value = qteAObtenir;

		aSerieDispo.setParam("Article_Id", articleId);
		aSerieDispo.setParam("Depot_Id", depotId);
		aSerieDispo.setParam("List_Serie_Id", curListSerieId.toString());
		aSerieDispo.initTree();

		aSerieLigne.setParam("Article_Id", articleId);
		aSerieLigne.setParam("Depot_Id", depotId);
		aSerieLigne.setParam("Mode", mode);

		if (mode=="I") {
			aSerieLigne.setParam("List_Serie_Id", curListSerieId.toString());
			aSerieLigne.initTree(checkAddLine);
		}

	}	catch (e) {
		recup_erreur(e);
	}
}


function pressOnNumSerie(ev) {
	try {

		if (ev.keyCode==13) {
			addNumSerie();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnDatePeremption(ev) {
	try {

		if (ev.keyCode==13) {
			addNumSerie();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function addNumSerie(pNumero) {
	try {

		var numero = pNumero==null?document.getElementById('numSerie').value:pNumero;
		var datePeremption = pNumero==null?document.getElementById('datePeremption').value:"";

		if (isEmpty(numero)) {
			showWarning("Veuillez saisir un n\u00B0 de s\u00E9rie");
		}
		else if (!isEmpty(datePeremption) && !isDate(datePeremption)) {
			showWarning("Date de p\u00E9remption incorrecte");
		}
		else {
			if (mode=="I") {
				var qAdd = new QueryHttp("Facturation/Stocks/addNumeroSerie.tmpl");
				qAdd.setParam("Article_Id", articleId);
				qAdd.setParam("Numero", numero);
				qAdd.setParam("Date_Peremption", datePeremption);
				qAdd.setParam("Depot_Id", depotId);
				var result = qAdd.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
				else {
					curListSerieId.push(result.responseXML.documentElement.getAttribute('Serie_Id'));
					document.getElementById('numSerie').value = "";
					document.getElementById('datePeremption').value = "";
					reinitialisationArbres();
				}
			}
			else {
				var trouve = false;

				for (var i=0; i<aSerieDispo.nbLignes(); i++) {
					if (aSerieDispo.getCellText(i, "colNumeroSD")==numero) {
						curListSerieId.push(aSerieDispo.getCellText(i, "colSerieIdSD"));
						trouve = true;
						break;
					}
				}

				if (!trouve) {
					showWarning("N\u00B0 S\u00E9rie non pr\u00E9sent dans le d\u00E9p\u00F4t");
				}

				document.getElementById('numSerie').value = "";
				reinitialisationArbres();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function deleteNumSerie(serieId) {
	try {

		var i = 0;
		var trouve = false;
  	while (i<curListSerieId.length && !trouve) {
			if (curListSerieId[i]==serieId) {
				trouve = true;
			}
			i++;
		}

		if (trouve) {
			curListSerieId.splice(i-1,1);
		}

		reinitialisationArbres();

	} catch (e) {
		recup_erreur(e);
	}
}


function checkAddLine() {
	try {

		var quantite = document.getElementById('quantite').value;
		var nbLignes = aSerieLigne.nbLignes();
		document.getElementById("nb").value = nbLignes;
		var canAdd = (quantite>nbLignes);

		document.getElementById('numSerie').disabled = !canAdd;
		document.getElementById('datePeremption').disabled = !canAdd;
		document.getElementById('bValider').disabled = !canAdd;
		document.getElementById('bTransferToAffect').disabled = true;
		document.getElementById('bTransferToDispo').disabled = true;
		document.getElementById('bDesaffecter').disabled = true;
		if (!canAdd) {
			document.getElementById('bQuitter').focus();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function transferToAffect() {
	try {

		var nbSelection = aSerieDispo.nbSelection();
		var quantite = document.getElementById('quantite').value;
		var nbLignes = aSerieLigne.nbLignes();

		if (nbLignes+nbSelection>quantite) {
			var restant = quantite-nbLignes;
			showWarning("Vous ne pouvez s\u00E9lectionner que "+ restant +" n\u00B0 s\u00E9rie maximum");
		}
		else {
			var nonTrans = false;
			var start = new Object();
			var end = new Object();
			var rangeCount = aSerieDispo.getRangeCount();
			var listSerieId = new Array();

			for (var t=0; t<rangeCount; t++) {
				aSerieDispo.getRangeAt(t,start,end);
				for (var v=start.value; v<=end.value; v++) {
					listSerieId.push(aSerieDispo.getCellText(v, "colSerieIdSD"));
				}
			}

			for (var i=0; i<listSerieId.length; i++) {
				curListSerieId.push(listSerieId[i]);
			}
			reinitialisationArbres();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function transferToDispo() {
	try {

		var start = new Object();
		var end = new Object();
		var rangeCount = aSerieLigne.getRangeCount();
		var listSerieId = new Array();

		for (var t=0; t<rangeCount; t++) {
			aSerieLigne.getRangeAt(t,start,end);
			for (var v=start.value; v<=end.value; v++) {
				listSerieId.push(aSerieLigne.getCellText(v, "colSerieIdSL"));
			}
		}

		for (var i=0; i<listSerieId.length; i++) {
			deleteNumSerie(listSerieId[i]);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function reinitialisationArbres() {
	try {

		aSerieDispo.setParam("List_Serie_Id", curListSerieId.toString());
		aSerieDispo.initTree();

		aSerieLigne.setParam("List_Serie_Id", curListSerieId.toString());
		aSerieLigne.initTree(checkAddLine);

	} catch (e) {
		recup_erreur(e);
	}
}


function quit() {
	try {

		if (mode=="T" || mode=="I" || mode=="D") {
			var nbAffect = aSerieLigne.nbLignes();
			var quantite = document.getElementById('quantite').value;

			if (nbAffect<quantite) {
				showWarning("La saisie des n\u00B0 de s\u00E9rie est obligatoire sur cet article. Tous les n\u00B0 de s\u00E9rie n'ont pas \u00E9t\u00E9 affect\u00E9s");
			}
			else {
				window.arguments[0](curListSerieId);
				window.close();
			}
		}
		else {
			window.arguments[0](curListSerieId);
			window.close();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function degriserBoutonsTransfert() {
	try {

		if (aSerieDispo.isSelected()) {
			var quantite = document.getElementById('quantite').value;
			var nbAffect = aSerieLigne.nbLignes();
			document.getElementById('bTransferToAffect').disabled = (nbAffect>=quantite);
		}

		if (aSerieLigne.isSelected()) {
			document.getElementById('bTransferToDispo').disabled = false;
			document.getElementById('bDesaffecter').disabled = false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}
