/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");


var aLangues = new Arbre("ComboListe/combo-langues.tmpl", "langueId");

var currentDemandeId;
var langueDefaut;



function init() {
	try {

		document.getElementById('deck').selectedIndex = 0;

		ooe_initOngletEcartsFacturation();
		oop_initOngletPrevisionsEcart();
		ood_initOngletDemandesAvoir();

	} catch (e) {
    recup_erreur(e);
  }
}


function retourControleFacturation() {
	try {

		document.getElementById('pdf').setAttribute("src", "");
		document.getElementById('deck').selectedIndex = 0;
		document.getElementById('bRetourControleFacturation').collapsed = true;

	} catch (e) {
		recup_erreur(e);
	}
}


function retourMenuPrincipal() {
	try {

		window.location = "chrome://opensi/content/facturation/user/menu_principal.xul";

	} catch (e) {
    recup_erreur(e);
  }
}


function visualiserDemandeAvoirFournisseur(demandeId) {
	try {

		currentDemandeId = demandeId;

		var qLangueDefaut = new QueryHttp("Facturation/Commun/getLangueDefaut.tmpl");
		qLangueDefaut.setParam("Type_Doc", "DA");
		qLangueDefaut.setParam("Doc_Id", currentDemandeId);
		var result = qLangueDefaut.execute();
		langueDefaut = result.responseXML.documentElement.getAttribute("Langue_Id");

		aLangues.setParam("Selection", langueDefaut);
		aLangues.initTree(visualiserDemandeAvoirFournisseur_2);

	} catch (e) {
		recup_erreur(e);
	}
}


function visualiserDemandeAvoirFournisseur_2() {
	try {

		document.getElementById('langueId').value = langueDefaut;
		editerDemandeAvoirPDF();

	} catch (e) {
		recup_erreur(e);
	}
}


function editerDemandeAvoirPDF() {
	try {

		var langueId = document.getElementById('langueId').value;

		var qEditionPdf = new QueryHttp("Facturation/Controle_Achats/pdfDemandeAvoirFournisseur.tmpl");
		qEditionPdf.setParam("Demande_Id", currentDemandeId);
		qEditionPdf.setParam("Langue_Id", langueId);

		document.getElementById('pmbox').collapsed = false;
		document.getElementById('pm').setAttribute('mode', 'undetermined');

		qEditionPdf.execute(editerDemandeAvoirPDF_2);

	} catch (e) {
    recup_erreur(e);
  }
}


function editerDemandeAvoirPDF_2(result) {
	try {

		document.getElementById('pmbox').collapsed = true;
		document.getElementById('pm').setAttribute('mode', 'none');

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
			document.getElementById('pdf').setAttribute("src", page);

			document.getElementById('deck').selectedIndex = 1;
			document.getElementById('bRetourControleFacturation').collapsed = false;
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function envoyerMail() {
	try {

		var typeDoc = "DA";
		var docId = currentDemandeId;
		var langue = document.getElementById('langueId').value;

		var url = "chrome://opensi/content/popup/popup-envoyerMail.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', typeDoc, docId, langue);

	} catch (e) {
		recup_erreur(e);
	}
}
