/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");



function init() {
	try {

		var niveauIntro = getConfig().getNiveauObligationIntro();

		if (niveauIntro=="4") {
			document.getElementById("typeDeclaration").value = "E";
			document.getElementById("typeDeclaration").disabled = true;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function creerDEB() {
	try {

		var typeDeclaration = document.getElementById("typeDeclaration").value;
		var periodeRef = document.getElementById("periodeRef").value;

		if (isEmpty(typeDeclaration)) {
			showWarning("Veuillez choisir le type de d\u00E9claration");
		}
		else if (!isPeriode(periodeRef)) {
			showWarning("P\u00E9riode incorrecte");
		}
		else {
			var qSave = new QueryHttp("Facturation/DEB/createDeclarationDEB.tmpl");
			qSave.setParam("Type_Declaration", typeDeclaration);
			qSave.setParam("Periode_Ref", periodeRef);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var declarationId = result.responseXML.documentElement.getAttribute('Declaration_Id');
				window.arguments[0](declarationId);
				window.close();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}
