/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var ome_aEcoPart = new Arbre('Facturation/EcoPart/list-declarationEcoPart.tmpl', 'ome-listeEcoPart');
var ome_aApercuEcoPart = new Arbre('Facturation/EcoPart/list-apercuDeclarationEcoPart.tmpl', 'ome-apercu');
var ome_qListEcoPart = new QueryHttp("Facturation/EcoPart/getDataListEcoPart.tmpl");

var ome_pageCourante;
var ome_nbPages;



function ome_init() {
  try {

		ome_initCriteres();

  } catch (e) {
  	recup_erreur(e);
  }
}


function ome_initCriteres() {
	try {

		document.getElementById('ome-numero').value = "";
		document.getElementById('ome-type').value = "";
		document.getElementById('ome-etat').value = "N";
		document.getElementById('ome-periodeDebut').value = "";
		document.getElementById('ome-periodeFin').value = "";

		ome_listerEcoPart();

	} catch (e) {
		recup_erreur(e);
	}
}


function ome_listerEcoPart() {
	try {

		var numero = document.getElementById('ome-numero').value;
		var typeEcoPart = document.getElementById('ome-type').value;
		var etat = document.getElementById('ome-etat').value;
		var periodeDebut = document.getElementById('ome-periodeDebut').value;
		var periodeFin = document.getElementById('ome-periodeFin').value;
		var nbLignesParPage = document.getElementById('ome-nbLignesParPage').value;

		if (!isEmpty(periodeDebut) && !isPeriode(periodeDebut)) { showWarning("P\u00E9riode de d\u00E9but incorrecte !"); }
		else if (!isEmpty(periodeFin) && !isPeriode(periodeFin)) { showWarning("P\u00E9riode de fin incorrecte !"); }
		else if (!isEmpty(periodeDebut) && !isEmpty(periodeFin) && !isPeriodeInterval(periodeDebut, periodeFin)) { showWarning("Plage de p\u00E9riodes incorrecte !"); }
		else {

			ome_pageCourante = 1;
			ome_nbPages = 1;
			document.getElementById('ome-pageDeb').value = 1;
			document.getElementById('ome-pageFin').value = 1;
			document.getElementById('ome-bPrec').disabled = true;
			document.getElementById('ome-bSuiv').disabled = true;

			document.getElementById('ome-listeEcoPart').disabled = true;
			document.getElementById('ome-numeroSelect').value = "";
			ome_aApercuEcoPart.deleteTree();
			ome_aEcoPart.deleteTree();

			ome_qListEcoPart.setParam("Numero", numero);
			ome_qListEcoPart.setParam("Type_Eco_Part", typeEcoPart);
			ome_qListEcoPart.setParam("Etat", etat);
			ome_qListEcoPart.setParam("Periode_Debut", periodeDebut);
			ome_qListEcoPart.setParam("Periode_Fin", periodeFin);
			ome_qListEcoPart.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
			ome_qListEcoPart.setParam("Current_Page", ome_pageCourante);

			var result = ome_qListEcoPart.execute();

			var contenu = result.responseXML.documentElement;

			ome_nbPages = contenu.getAttribute("Nb_Pages");
			var listDeclarationId = contenu.getAttribute("List_Declaration_Id");

			ome_aEcoPart.setParam("List_Declaration_Id", listDeclarationId);
			ome_aEcoPart.initTree(ome_initPagination);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ome_initPagination() {
	try {

		document.getElementById('ome-pageDeb').value = ome_pageCourante;
		document.getElementById('ome-pageFin').value = (ome_nbPages>0?ome_nbPages:1);
		document.getElementById('ome-bPrec').disabled = (ome_pageCourante==1);
		document.getElementById('ome-bSuiv').disabled = (ome_pageCourante>=ome_nbPages); // peut se produire si ome_nbPages=0

		ome_afterMajPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function ome_pressOnPagePrec() {
	try {

		ome_pageCourante--;
		ome_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function ome_pressOnPageSuiv() {
	try {

		ome_pageCourante++;
		ome_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function ome_majPagination() {
	try {

		document.getElementById('ome-pageDeb').value = ome_pageCourante;
		document.getElementById('ome-bPrec').disabled = (ome_pageCourante==1);
		document.getElementById('ome-bSuiv').disabled = (ome_pageCourante==ome_nbPages);

		document.getElementById('ome-numeroSelect').value = "";

		document.getElementById('ome-listeEcoPart').disabled = true;
		ome_aApercuEcoPart.deleteTree();

		ome_qListEcoPart.setParam("Current_Page", ome_pageCourante);
		var result = ome_qListEcoPart.execute();
		var listDeclarationId = result.responseXML.documentElement.getAttribute("List_Declaration_Id");

		ome_aEcoPart.setParam("List_Declaration_Id", listDeclarationId);
		ome_aEcoPart.initTree(ome_afterMajPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function ome_afterMajPagination() {
	try {

		document.getElementById('ome-listeEcoPart').disabled = false;

	} catch (e) {
		recup_erreur(e);
	}
}


function ome_selectOnListeEcoPart() {
	try {

		if (ome_aEcoPart.isSelected()) {
			var declarationId = ome_aEcoPart.getSelectedCellText('ome-colDeclarationId');
			document.getElementById('ome-numeroSelect').value = ome_aEcoPart.getSelectedCellText('ome-colNumero');
			ome_aApercuEcoPart.setParam("Declaration_Id", declarationId);
			ome_aApercuEcoPart.initTree();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ome_pressOnNouveauEcoPart() {
	try {

		var url = "chrome://opensi/content/facturation/user/ecopart/popup-nouvelleDeclarationEcoPart.xul?"+ cookie();
		window.openDialog(url,'','chrome,modal,centerscreen',ome_retourNouvelleEcoPart);

	} catch (e) {
		recup_erreur(e);
	}
}


function ome_retourNouvelleEcoPart(declarationId) {
	try {

		oee_declarationId = declarationId;
		oee_chargerEcoPart();
		document.getElementById('bMenuEcoPart').collapsed = false;
		document.getElementById('deck').selectedIndex = 1;

	} catch (e) {
		recup_erreur(e);
	}
}


function ome_pressOnCritere(ev) {
  try {

		if (ev.keyCode==13) {
			ome_listerEcoPart();
    }

	} catch (e) {
  	recup_erreur(e);
  }
}


function ome_pressOnListeEcoPart(ev) {
  try {

		if (ev.keyCode==13) {
			ome_ouvrirEcoPart();
    }

	} catch (e) {
  	recup_erreur(e);
  }
}


function ome_ouvrirEcoPart() {
  try {

  	if (ome_aEcoPart.isSelected()) {
			oee_declarationId = ome_aEcoPart.getSelectedCellText('ome-colDeclarationId');
			oee_chargerEcoPart();
			document.getElementById('bMenuEcoPart').collapsed = false;
			document.getElementById('deck').selectedIndex = 1;
  	}

	} catch (e) {
  	recup_erreur(e);
  }
}
