/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");


var aFacturesAvoirs = new Arbre('Facturation/Envoi_Factures/list-envoiFacture.tmpl', 'listeFacturesAvoirsNonEnvoyes');
var aHistorique = new Arbre('Facturation/Envoi_Factures/combo-historiqueEnvoiFacture.tmpl', 'timeEdition');



function init() {
  try {

		document.getElementById('deck').selectedIndex = 0;
		document.getElementById('bRetourFacturation').collapsed = true;

		aHistorique.initTree();
		listerFacturesAvoirs();

  } catch (e) {
  	recup_erreur(e);
  }
}


function listerFacturesAvoirs() {
	try {

		var typeDoc = document.getElementById('Type_Doc').value;
		var modeEnvoi = document.getElementById('Mode_Envoi').value;
		var statutPaiement = document.getElementById('statutPaiement').value;
		var dateDebut = document.getElementById('dateFactureDebut').value;
		var dateFin = document.getElementById('dateFactureFin').value;

		if (!isEmpty(dateDebut) && !isDate(dateDebut)) { showWarning("Date de d\u00E9but de p\u00E9riode incorrecte !"); }
		else if (!isEmpty(dateFin) && !isDate(dateFin)) { showWarning("Date de fin de p\u00E9riode incorrecte !"); }
		else if (!isEmpty(dateDebut) && !isEmpty(dateFin) && !isDateInterval(dateDebut, dateFin)) { showWarning("Plage de dates incorrecte !"); }
		else {
			aFacturesAvoirs.setParam("Type_Doc", typeDoc);
			aFacturesAvoirs.setParam("Mode_Envoi", modeEnvoi);
			aFacturesAvoirs.setParam("Statut_Paiement", statutPaiement);
			aFacturesAvoirs.setParam("Date_Debut", dateDebut);
			aFacturesAvoirs.setParam("Date_Fin", dateFin);
			aFacturesAvoirs.initTree(refreshTotaux);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function toutCocher(b) {
	try {

		for (var i=0; i<aFacturesAvoirs.nbLignes(); i++) {
			if (aFacturesAvoirs.isEditable(i, "colSelect")) {
				aFacturesAvoirs.setCellValue(i, "colSelect", b);
  		}
		}

		refreshTotaux();

	} catch (e) {
		recup_erreur(e);
	}
}


function onKeyPress(ev) {
	try {

		if (ev.keyCode==13) {
			listerFacturesAvoirs();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function envoyerFactures() {
  try {

		var nbDocsATraiter = 0;
		var listeFC = "";
		var listeAC = "";

		for (var i=0; i<aFacturesAvoirs.nbLignes(); i++) {
			if (aFacturesAvoirs.getCellValue(i, "colSelect")=="true") {
				nbDocsATraiter++;
				if (aFacturesAvoirs.getCellText(i, "colType_Doc")=="F") {
					listeFC += aFacturesAvoirs.getCellText(i, "colDoc_Id") +",";
				}
				else {
					listeAC += aFacturesAvoirs.getCellText(i, "colDoc_Id") +",";
				}
			}
  	}

		if (nbDocsATraiter==0) {
			showWarning("Veuillez cocher au moins une ligne");
		}
		else if (window.confirm("Confirmez-vous l'\u00E9dition des factures et avoirs s\u00E9lectionn\u00E9s ?")) {

			var qSend = new QueryHttp("Facturation/Envoi_Factures/sendFacturesAvoirs.tmpl");
			qSend.setParam("List_Facture_Id", listeFC);
			qSend.setParam("List_Avoir_Id", listeAC);
			var result = qSend.execute();

			var sendingTime = result.responseXML.documentElement.getAttribute('Sending_Time');
			editerFactures(sendingTime, true);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function editerFactures(sendingTime, firstEdition) {
  try {

  	var editionOk = false;

  	document.getElementById('deck').selectedIndex = 1;
		document.getElementById('bRetourFacturation').collapsed = false;

		document.getElementById('pdf').setAttribute("src", "");
		document.getElementById('pmbox').collapsed = false;
		document.getElementById('pm').setAttribute('mode', 'undetermined');

		var qEdit = new QueryHttp("Facturation/Envoi_Factures/editFacturesAvoirs.tmpl");
		qEdit.setParam('Sending_Time', sendingTime);
		qEdit.setParam('First_Edition', firstEdition);
		var result = qEdit.execute();
		if (result.responseXML.documentElement.getAttribute('Exist_Edition')=="true") {
			var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');

			document.getElementById('pdf').setAttribute("src", page);
			editionOk = true;
		}

		document.getElementById('pm').setAttribute('mode', 'none');
		document.getElementById('pmbox').collapsed = true;

		if (!editionOk) { retourFacturation(); }

  } catch (e) {
    recup_erreur(e);
  }
}


function reediter() {
  try {

		if (document.getElementById('timeEdition').selectedIndex==0) {
			showWarning("Veuillez choisir une r\u00E9\u00E9dition !");
		}
		else {
			var timeEdition = document.getElementById('timeEdition').value;
			editerFactures(timeEdition, false);
		}

  } catch (e) {
    recup_erreur(e);
  }
}


function pressOnListeNonEnvoyes(ev) {
	try {

		if (ev.keyCode==32 && aFacturesAvoirs.isSelected()) {
			aFacturesAvoirs.setSelectedCellValue("colSelect", aFacturesAvoirs.getSelectedCellValue("colSelect")=="false");
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function dblclickOnListeNonEnvoyes() {
	try {

		if (aFacturesAvoirs.isSelected()) {
			var docId = aFacturesAvoirs.getSelectedCellText("colDoc_Id");
			var typeDoc = aFacturesAvoirs.getSelectedCellText("colType_Doc");

			var url = "chrome://opensi/content/facturation/user/envoi_factures/popup-changerModeEnvoi.xul";
			window.openDialog(url,'','chrome,modal,centerscreen', init, docId, typeDoc);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function refreshTotaux() {
	try {

		var nbFactures = 0;
		var nbAvoirs = 0;

		for (var i=0; i<aFacturesAvoirs.nbLignes(); i++) {
			if (aFacturesAvoirs.getCellValue(i, "colSelect")=="true") {
				if (aFacturesAvoirs.getCellText(i, "colType_Doc")=="F") nbFactures++;
				if (aFacturesAvoirs.getCellText(i, "colType_Doc")=="A") nbAvoirs++;
			}
  	}

		document.getElementById('lblNbFacturesCochees').value = nbFactures;
		document.getElementById('lblNbAvoirsCoches').value = nbAvoirs;

	} catch (e) {
		recup_erreur(e);
	}
}


function ouvrirLegende() {
  try {

		window.openDialog("chrome://opensi/content/facturation/user/envoi_factures/popup-legende.xul",'','chrome,modal,centerscreen');

	} catch (e) {
    recup_erreur(e);
  }
}


function retourFacturation() {
  try {

		document.getElementById('pdf').setAttribute("src", "");
    document.getElementById('deck').selectedIndex = 0;
		init();

	} catch (e) {
    recup_erreur(e);
  }
}


function retourMenuPrincipal() {
  try {

    window.location = "chrome://opensi/content/facturation/user/menu_principal.xul";

	} catch (e) {
    recup_erreur(e);
  }
}
