/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

var oeof_aAFabriquer = new Arbre('Facturation/Fabrication/listeArticlesAFabriquer.tmpl', 'oeof-articlesAFabriquer');
var oeof_aComposition = new Arbre('Facturation/Fabrication/listeArticlesComposition.tmpl', 'oeof-Composition');
var oeof_aEtablissements = new Arbre('ComboListe/combo-etablissements.tmpl', 'oeof-etablissement');
var oeof_aDepots = new Arbre('ComboListe/combo-depotsStock.tmpl', 'oeof-depot');
var oeof_aVersion = new Arbre("Facturation/Fabrication/list-versionOrdreFabrication.tmpl","oeof-listeVersion");

var oeof_ordreId;
var oeof_mode;
var oeof_modifie;
var oeof_etatOF;
var oeof_suiviSerie;
var oeof_fabSerieAuto;



function oeof_init() {
	try {

		oeof_suiviSerie = gConfig.isActSuiviSerie();

		document.getElementById('oeof-gridCodeStats').collapsed = !gConfig.isSpecTRICS();
		document.getElementById('oeof-boxGererNumSerie').collapsed = !oeof_suiviSerie;
		document.getElementById('oeof-boxSaisieSerie').collapsed = !oeof_suiviSerie;

		if (!gConfig.isActSerieDLC()) {
			document.getElementById("oeof-colDatePeremption").collapsed = true;
			document.getElementById("oeof-colDatePeremption").setAttribute("ignoreincolumnpicker", true);
			document.getElementById("oeof-boxDatePeremptionGNS").collapsed = true;
		}

		oeof_aEtablissements.initTree(oeof_initEtablissement);
		oeof_setModifie(false);

  } catch (e) {
  	recup_erreur(e);
  }
}


function oeof_initEtablissement() {
	try {

		document.getElementById('oeof-etablissement').value = "";
		oeof_aDepots.initTree(oeof_initDepot);

	} catch (e) {
		recup_erreur(e);
	}
}


function oeof_initDepot() {
	try {

		document.getElementById('oeof-depot').value = "";

	} catch (e) {
		recup_erreur(e);
	}
}


function oeof_nouvelleFabrication() {
	try {

		oeof_reinitialiser();

		document.getElementById('oeof-etablissement').value = etablissementDefaut;
		document.getElementById('oeof-depot').value = depotDefaut;

		oeof_mode = "C";
		oeof_etatOF = "N";
		oeof_setModifie(false);
		oeof_setModifie(true);
		oeof_bloquerChamps(false);

	} catch (e) {
    recup_erreur(e);
  }
}


function oeof_reinitialiser() {
	try {

		document.getElementById('oeof-deckOrdreFabrication').selectedIndex = 0;
		document.getElementById('oeof-tabBoxOF').selectedIndex = 0;

		document.getElementById('oeof-ordre').value = "";
		document.getElementById('oeof-etat').value = "";
		document.getElementById('oeof-etablissement').value = "";
		document.getElementById('oeof-dateOrdreFabrication').value = "";
		document.getElementById('oeof-numCommande').value = "";
		document.getElementById('oeof-depot').value = "";
		document.getElementById('oeof-commentairesFin').value = "";
		document.getElementById('oeof-commentairesInt').value = "";
		document.getElementById('oeof-refCommande').value = "";
		document.getElementById('oeof-numClient').value = "";
		document.getElementById('oeof-denomination').value = "";
		document.getElementById('oeof-dateExpedition').value = "";

		document.getElementById('oeof-reference').value= "";
		document.getElementById('oeof-qteAFabriquer').value = "";
		document.getElementById('oeof-designation').value = "";
		document.getElementById('oeof-qteRealisee').value = "";
		document.getElementById('oeof-reliquat').value = "";
		document.getElementById('oeof-codeStats').value = "";
		document.getElementById('oeof-qteSupp').value = "";

		document.getElementById('oeof-titreComposition').value = "";

		document.getElementById('oeof-bValiderSaisieNS').disabled = true;
		document.getElementById('oeof-numSerie').disabled = true;
		document.getElementById('oeof-bGererNS').disabled = true;

		document.getElementById('oeof-numSerieGNS').value = "";
		document.getElementById('oeof-datePeremptionGNS').value = "";
		document.getElementById('oeof-validerNumSerieGNS').disabled = true;
		document.getElementById('oeof-numSerieGNS').disabled = true;
		document.getElementById('oeof-datePeremptionGNS').disabled = true;

		oeof_aAFabriquer.deleteTree();
		oeof_aComposition.deleteTree();
		oeof_aVersion.deleteTree();

		oeof_fabSerieAuto = true;
		document.getElementById("oeof-boxSerieGNS").collapsed = true;

		oeof_modifie = false;

	} catch (e) {
		recup_erreur(e);
	}
}


function oeof_bloquerChamps(bloquer) {
	try {

		document.getElementById('oeof-etablissement').disabled = bloquer;
		document.getElementById('oeof-depot').disabled = bloquer;
		document.getElementById('oeof-commentairesFin').disabled = bloquer && oeof_etatOF=='C';
		document.getElementById('oeof-commentairesInt').disabled = bloquer && oeof_etatOF=='C';

		document.getElementById('oeof-reference').disabled = bloquer;
		document.getElementById('oeof-qteAFabriquer').disabled = bloquer;

		document.getElementById('oeof-bRechReference').disabled = bloquer;

		document.getElementById('oeof-rowSupp').collapsed = (oeof_etatOF=='N' || oeof_etatOF=='C' || oeof_etatOF=='A');

	} catch (e) {
    recup_erreur(e);
  }
}


function oeof_pressOnReference(ev) {
	try {

		if (ev.keyCode==13) {
			oeof_rechercherReference();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oeof_rechercherReference() {
	try {

		var reference = document.getElementById('oeof-reference').value;

		var qSearch = new QueryHttp("Facturation/Articles/searchReference.tmpl");
		qSearch.setParam("Reference", reference);
		qSearch.setParam("Nomenclature", true);
		var result = qSearch.execute();

		var articleId = result.responseXML.documentElement.getAttribute("Article_Id");
		if (!isEmpty(articleId)) {
			document.getElementById('oeof-reference').value = result.responseXML.documentElement.getAttribute("Reference");
			document.getElementById('oeof-qteAFabriquer').focus();
		}
		else {
			oeof_rechercherStock(reference);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oeof_rechercherStock(reference) {
	try {

		var url = "chrome://opensi/content/facturation/user/articles/popup-rechercheArticle.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oeof_retourRechercherStock, null, reference, null, null, null, true);

	} catch (e) {
    recup_erreur(e);
  }
}


function oeof_retourRechercherStock(reference, articleId) {
	try {

		document.getElementById('oeof-reference').value = reference;
		document.getElementById('oeof-qteAFabriquer').focus();

	} catch (e) {
    recup_erreur(e);
  }
}


function oeof_chargerOF() {
  try {

		oeof_reinitialiser();
		oeof_aAFabriquer.setParam('Ordre_Id', oeof_ordreId);
		oeof_aComposition.setParam('Ordre_Id', oeof_ordreId);

		oeof_mode = "M";

		var qLoad = new QueryHttp('Facturation/Fabrication/loadOrdreFabrication.tmpl');
		qLoad.setParam("Ordre_Id", oeof_ordreId);
		var result = qLoad.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}

		var contenu = result.responseXML.documentElement;

		oeof_etatOF = contenu.getAttribute("Etat");

		document.getElementById('oeof-ordre').value = contenu.getAttribute("Numero");
		document.getElementById('oeof-etat').value = contenu.getAttribute("NomEtat");
		document.getElementById('oeof-etablissement').value = contenu.getAttribute("Etablissement_Id");
		document.getElementById('oeof-dateOrdreFabrication').value = contenu.getAttribute("Date");
		document.getElementById('oeof-numCommande').value = contenu.getAttribute("Num_Commande");
		document.getElementById('oeof-depot').value = contenu.getAttribute("Depot_Id");
		document.getElementById('oeof-commentairesFin').value = contenu.getAttribute("Commentaires_Fin");
		document.getElementById('oeof-commentairesInt').value = contenu.getAttribute("Commentaires_Int");
		document.getElementById('oeof-refCommande').value = contenu.getAttribute("Ref_Commande");
		document.getElementById('oeof-numClient').value = contenu.getAttribute("Num_Client");
		document.getElementById('oeof-denomination').value = contenu.getAttribute("Denomination");
		document.getElementById('oeof-dateExpedition').value = contenu.getAttribute("Date_Expedition");

		document.getElementById('oeof-reference').value= contenu.getAttribute("Reference");
		document.getElementById('oeof-qteAFabriquer').value = contenu.getAttribute("Quantite_A_Fabriquer");
		document.getElementById('oeof-designation').value = contenu.getAttribute("Designation");
		document.getElementById('oeof-qteRealisee').value = contenu.getAttribute("Quantite_Realisee");
		document.getElementById('oeof-reliquat').value = contenu.getAttribute("Reliquat");
		document.getElementById('oeof-codeStats').value = contenu.getAttribute("Code_Stats");

		document.getElementById('oeof-boxSaisieSerie').collapsed = (!oeof_suiviSerie);
		document.getElementById('oeof-boxSaisieSerie').disabled = (oeof_etatOF!="T");

		document.getElementById('oeof-boxGererNumSerie').collapsed = (!oeof_suiviSerie);
		document.getElementById('oeof-boxGererNumSerie').disabled = (oeof_etatOF!="T");

		oeof_fabSerieAuto = contenu.getAttribute("Fab_Serie_Auto")=="true";
		document.getElementById("oeof-boxSerieGNS").collapsed = oeof_fabSerieAuto && !gConfig.isActSerieDLC();

		document.getElementById('oeof-creation').setAttribute("label", "Ordre de fabrication cr\u00E9\u00E9 le "+ contenu.getAttribute('Date_C') +" par "+ contenu.getAttribute('Login_Createur'));
		document.getElementById('oeof-modification').setAttribute("label", "Derni\u00E8re modification le "+ contenu.getAttribute('Date_M') +" par "+ contenu.getAttribute('Login_Maj'));
		document.getElementById('oeof-fiche').setAttribute("label", "Ordre de fabrication N\u00B0 "+ contenu.getAttribute('Numero'));
		document.getElementById('oeof-creation').collapsed = false;
		document.getElementById('oeof-modification').collapsed = false;

		oeof_aAFabriquer.initTree();
		document.getElementById('oeof-titreComposition').value = "";
		document.getElementById('oeof-bValiderSaisieNS').disabled = true;
		document.getElementById('oeof-numSerie').disabled = true;
		oeof_aComposition.deleteTree();
		oeof_setModifie(false);

		oeof_bloquerChamps(oeof_etatOF!="N");

		oeof_aVersion.setParam("Ordre_Id", oeof_ordreId);
		oeof_aVersion.initTree();

	} catch (e) {
  	recup_erreur(e);
  }
}


function oeof_enregistrerOF(rafraichir) {
  try {

  	var ok = false;

		var etablissementId = document.getElementById('oeof-etablissement').value;
		var depotId = document.getElementById('oeof-depot').value;
		var reference = document.getElementById('oeof-reference').value;
		var qteAFabriquer = document.getElementById('oeof-qteAFabriquer').value;
		var qteSupp = document.getElementById('oeof-qteSupp').value;
		var commentairesFin = document.getElementById('oeof-commentairesFin').value;
		var commentairesInt = document.getElementById('oeof-commentairesInt').value;

		var isNomenclature = false;

		var qGetInfosArticle = new QueryHttp("Facturation/Fabrication/getInfosArticle.tmpl");
		qGetInfosArticle.setParam("Reference", reference);
		var result = qGetInfosArticle.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			document.getElementById('oeof-designation').value = result.responseXML.documentElement.getAttribute("Designation");
			isNomenclature = result.responseXML.documentElement.getAttribute("Nomenclature")=="true";
		}

		if (isEmpty(etablissementId)) { showWarning("Veuillez choisir un \u00E9tablissement"); }
		else if (isEmpty(depotId)) { showWarning("Veuillez choisir un d\u00E9p\u00F4t"); }
		else if (isEmpty(reference)) { showWarning("Veuillez saisir une r\u00E9f\u00E9rence"); }
		else if (!isNomenclature) { showWarning("Veuillez choisir une r\u00E9f\u00E9rence correcte"); }
		else if (!isPositiveInteger(qteAFabriquer)) { showWarning("Quantit\u00E9 \u00E0 fabriquer incorrecte"); }
		else if (!isEmpty(qteSupp) && !isPositiveInteger(qteSupp)) { showWarning("Quantit\u00E9 suppl\u00E9mentaire incorrecte"); }
		else {

			var qSave;

			if (oeof_mode=="C") {
				qSave = new QueryHttp("Facturation/Fabrication/createOrdreFabrication.tmpl");
			}
			else {
				qSave = new QueryHttp("Facturation/Fabrication/updateOrdreFabrication.tmpl");
				qSave.setParam("Ordre_Id", oeof_ordreId);
				qSave.setParam("Qte_Supp", qteSupp);
			}

			qSave.setParam("Etablissement_Id", etablissementId);
			qSave.setParam("Depot_Id", depotId);
			qSave.setParam("Reference", reference);
			qSave.setParam("Quantite", qteAFabriquer);
			qSave.setParam("Commentaires_Fin", commentairesFin);
			qSave.setParam("Commentaires_Int", commentairesInt);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				if (oeof_mode=="C") {
					oeof_ordreId = result.responseXML.documentElement.getAttribute("Ordre_Id");
					if (rafraichir) {
						oeof_chargerOF();
					}
				}
				else if (!isEmpty(qteSupp)) {
					oeof_chargerOF();
				}

				oeof_setModifie(false);
				ok = true;
			}
		}

		return ok;

	} catch (e) {
  	recup_erreur(e);
  }
}


function oeof_supprimerOF() {
  try {

		if (window.confirm("Confirmez-vous la suppression de cet ordre de fabrication ?")) {

			var qDelete = new QueryHttp("Facturation/Fabrication/deleteOrdreFabrication.tmpl");
			qDelete.setParam("Ordre_Id", oeof_ordreId);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showMessage("L'ordre de fabrication a \u00E9t\u00E9 supprim\u00E9");
			}

			retourMenuOrdreFabrications();
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function oeof_validerOF() {
  try {

  	if (window.confirm("Confirmez-vous la validation de l'ordre de fabrication ?")) {

			var qValid = new QueryHttp("Facturation/Fabrication/validOrdreFabrication.tmpl");
  		qValid.setParam("Ordre_Id", oeof_ordreId);
  		var result = qValid.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			oeof_chargerOF();
  	}

	} catch (e) {
  	recup_erreur(e);
  }
}


function oeof_lancerOF() {
  try {

  	if (window.confirm("Confirmez-vous le lancement de l'ordre de fabrication ?")) {

			var qLaunch = new QueryHttp("Facturation/Fabrication/launchOrdreFabrication.tmpl");
  		qLaunch.setParam("Ordre_Id", oeof_ordreId);
  		var result = qLaunch.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oeof_editionPDFOF();
			}
  	}

	} catch (e) {
  	recup_erreur(e);
  }
}


function oeof_solderOF() {
  try {

  	if (window.confirm("Confirmez-vous le solde de l'ordre de fabrication ?")) {

			var qSettle = new QueryHttp("Facturation/Fabrication/settleOrdreFabrication.tmpl");
  		qSettle.setParam("Ordre_Id", oeof_ordreId);
  		var result = qSettle.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}

			oeof_chargerOF();
  	}

	} catch (e) {
  	recup_erreur(e);
  }
}


function oeof_annulerOF() {
  try {

  	if (window.confirm("Confirmez-vous l'annulation de l'ordre de fabrication ?")) {

			var qCancel = new QueryHttp("Facturation/Fabrication/cancelOrdreFabrication.tmpl");
  		qCancel.setParam("Ordre_Id", oeof_ordreId);
  		var result = qCancel.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}

			oeof_chargerOF();
  	}

	} catch (e) {
  	recup_erreur(e);
  }
}


function oeof_demandeEnregistrement() {
  try {

		if (oeof_modifie) {
			if (window.confirm("Voulez-vous enregistrer les modifications apport\u00E9es \u00E0 l'ordre de fabrication ?")) {
				oeof_enregistrerOF(false);
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oeof_setModifie(oeof_m) {
  try {

  	oeof_modifie = oeof_m;
		if (oeof_m) {

			document.getElementById('oeof-bValider').disabled = true;
			document.getElementById('oeof-bVisualiser').disabled = true;
			document.getElementById('oeof-bSupprimer').disabled = true;
			document.getElementById('oeof-bLancer').disabled = true;
			document.getElementById('oeof-bSolder').disabled = true;
			document.getElementById('oeof-bAnnuler').disabled = true;
			document.getElementById('oeof-bEtiquettes').disabled = true;
			document.getElementById('oeof-bAssembler').disabled = true;
			document.getElementById('oeof-bDesassembler').disabled = true;
			document.getElementById('oeof-boxSaisieSerieOF').disabled = true;
		}
		else {
			var qteRealisee = document.getElementById('oeof-qteRealisee').value;

			document.getElementById('oeof-bEnregistrer').disabled = false;
			document.getElementById('oeof-bEnregistrer').collapsed = (oeof_etatOF=='C' || oeof_etatOF=='A');
			document.getElementById('oeof-bValider').disabled = false;
			document.getElementById('oeof-bValider').collapsed = (oeof_etatOF!='N');
			document.getElementById('oeof-bVisualiser').disabled = false;
			document.getElementById('oeof-bVisualiser').collapsed = (oeof_etatOF=='N' || oeof_etatOF=='V');

			document.getElementById('oeof-bSupprimer').disabled = false;
			document.getElementById('oeof-bSupprimer').collapsed = (oeof_etatOF!='N');
			document.getElementById('oeof-bLancer').disabled = false;
			document.getElementById('oeof-bLancer').collapsed = (oeof_etatOF!='V');
			document.getElementById('oeof-bSolder').disabled = false;
			document.getElementById('oeof-bSolder').collapsed = (oeof_etatOF!='T' || qteRealisee<1);
			document.getElementById('oeof-bAnnuler').disabled = false;
			document.getElementById('oeof-bAnnuler').collapsed = ((oeof_etatOF!='T' && oeof_etatOF!='V') || qteRealisee>=1);
			document.getElementById('oeof-bEtiquettes').disabled = (oeof_etatOF!='T' && oeof_etatOF!='A' && oeof_etatOF!='C');
			document.getElementById('oeof-bEtiquettes').collapsed = false;
			document.getElementById('oeof-bAssembler').disabled = (oeof_etatOF!='T');
			document.getElementById('oeof-boxSaisieSerieOF').disabled = (oeof_etatOF!='T');
			document.getElementById('oeof-bAssembler').collapsed = (oeof_etatOF!='T');
			document.getElementById('oeof-boxSaisieSerieOF').collapsed = (oeof_etatOF!='T');
			document.getElementById('oeof-bDesassembler').disabled = (oeof_etatOF!='C' && oeof_etatOF!='A');
			document.getElementById('oeof-bDesassembler').collapsed = (oeof_etatOF!='C' && oeof_etatOF!='A');
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oeof_toutCocher(b) {
	try {

		for (var i=0; i<oeof_aAFabriquer.nbLignes(); i++) {

			if (oeof_aAFabriquer.isEditable(i, "oeof-colSelect")) {
				oeof_aAFabriquer.setCellValue(i, "oeof-colSelect", b);
  		}
		}

	} catch (e) {
		recup_erreur(e);
	}
}

function oeof_assembler() {
	try {

		var nbAssemblage = 0;

		var listeAssemblage = "";

		for (var i=0; i<oeof_aAFabriquer.nbLignes(); i++) {
			if (oeof_aAFabriquer.getCellValue(i, "oeof-colSelect")=="true") {
				nbAssemblage++;
				listeAssemblage += oeof_aAFabriquer.getCellText(i, "oeof-colAssemblageId") +",";
			}
		}

		if (nbAssemblage>0) {
			var qAssemble = new QueryHttp("Facturation/Fabrication/assemblerOF.tmpl");
			qAssemble.setParam("Ordre_Id", oeof_ordreId);
			qAssemble.setParam("Liste_AssemblageId", listeAssemblage);
  		var result = qAssemble.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}

			oeof_chargerOF();
		}
		else {
			showWarning("Veuillez cocher une ligne");
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oeof_etiquettes() {
	try {

		var qEdit = new QueryHttp("Facturation/Fabrication/etiquettesOF.tmpl");
		qEdit.setParam('Ordre_Id', oeof_ordreId);
		var result = qEdit.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			document.getElementById("bRetourOF").collapsed = false;
			document.getElementById("oeof-deckOrdreFabrication").selectedIndex = 2;

			document.getElementById('oeof-pdfOrdreFabricationEtiquettes').setAttribute("src", "");

			var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
			document.getElementById('oeof-pdfOrdreFabricationEtiquettes').setAttribute("src", page);
		}

	} catch (e) {
		recup_erreur(e);
	}
}

function oeof_desassembler() {
	try {

		var nbAssemblage = 0;
		var listeAssemblage = "";

		for (var i=0; i<oeof_aAFabriquer.nbLignes(); i++) {
			if (oeof_aAFabriquer.getCellValue(i, "oeof-colSelect")=="true") {
				nbAssemblage++;
				listeAssemblage += oeof_aAFabriquer.getCellText(i, "oeof-colAssemblageId") +",";
			}
		}

		if (nbAssemblage>0) {
			var qDisassemble = new QueryHttp("Facturation/Fabrication/desassemblerOF.tmpl");
			qDisassemble.setParam("Ordre_Id", oeof_ordreId);
			qDisassemble.setParam("Liste_AssemblageId", listeAssemblage);
  		var result = qDisassemble.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}

			oeof_chargerOF();
		}
		else {
			showWarning("Veuillez cocher une ligne");
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oeof_selectionArticleAFabriquer()  {
	try {

		if (oeof_aAFabriquer.isSelected()) {
			var assemblageId = oeof_aAFabriquer.getSelectedCellText('oeof-colAssemblageId');
			document.getElementById('oeof-titreComposition').value = "Composition du N\u00B0 S\u00E9rie : "+ oeof_aAFabriquer.getSelectedCellText('oeof-colNumSerie');
			oeof_aComposition.setParam("Assemblage_Id", assemblageId);
			oeof_aComposition.initTree();
			var statut = oeof_aAFabriquer.getSelectedCellText('oeof-colValStatut');
			document.getElementById('oeof-bValiderSaisieNS').disabled = statut!="N";
			document.getElementById('oeof-numSerie').disabled = statut!="N";
			document.getElementById('oeof-bGererNS').disabled = true;

			if (!isEmpty(oeof_aAFabriquer.getSelectedCellText('oeof-colSerieId'))) {
				document.getElementById('oeof-numSerieGNS').value = oeof_aAFabriquer.getSelectedCellText('oeof-colNumSerie');
				document.getElementById('oeof-datePeremptionGNS').value = oeof_aAFabriquer.getSelectedCellText('oeof-colDatePeremption');
			}
			else {
				document.getElementById('oeof-numSerieGNS').value = "";
				document.getElementById('oeof-datePeremptionGNS').value = "";
			}
			document.getElementById('oeof-validerNumSerieGNS').disabled = statut!="N";
			document.getElementById('oeof-numSerieGNS').disabled = statut!="N" || oeof_fabSerieAuto;
			document.getElementById('oeof-datePeremptionGNS').disabled = statut!="N";
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oeof_selectOnComposition()  {
	try {

		if (oeof_aComposition.isSelected()) {
			document.getElementById('oeof-bGererNS').disabled = false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oeof_gererSerie()  {
	try {

		if (oeof_aComposition.isSelected() && oeof_aAFabriquer.isSelected()) {
			var statut = oeof_aAFabriquer.getSelectedCellText('oeof-colValStatut');
			var composantId = oeof_aComposition.getSelectedCellText('oeof-colComposantId');
			var depotId = document.getElementById('oeof-depot').value;

			var url = "chrome://opensi/content/facturation/user/commun/popup-numSerie.xul";
			window.openDialog(url,'','chrome,modal,centerscreen', (statut=="N"?"S":"C"), "OF", composantId, depotId);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oeof_onKeyPressNumSerie(ev) {
	try {

		if (ev.keyCode==13) {
			oeof_validerSaisieBySerie('');
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oeof_validerSaisieBySerie(composantId) {
	try {

		var numSerie = document.getElementById("oeof-numSerie").value;

		if (!isEmpty(numSerie)) {
			if (oeof_aAFabriquer.isSelected() && oeof_aAFabriquer.getSelectedCellText('oeof-colValStatut')=="N") {
				var assemblageId = oeof_aAFabriquer.getSelectedCellText('oeof-colAssemblageId');

				var qAdd = new QueryHttp('Facturation/Fabrication/addNumSerieAssemblageArticle.tmpl');
				qAdd.setParam("Assemblage_Id", assemblageId);
				qAdd.setParam("Num_Serie", numSerie);
				qAdd.setParam("Composant_Id", composantId);
				var result = qAdd.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
				else {
					var conflit = (result.responseXML.documentElement.getAttribute("Conflit")=="true");
					if (conflit){
						var listConflit = result.responseXML.documentElement.getAttribute("List_Conflit");
						var url = "chrome://opensi/content/facturation/user/fabrication/popup-conflitNumSerieOF.xul";
						window.openDialog(url,'','chrome,modal,centerscreen', listConflit, oeof_retourChoixConflit);
					}
					else {
						document.getElementById("oeof-numSerie").value = "";
					}
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oeof_onKeyPressNumSerieOF(event) {
	try {

		if (event.keyCode==13) {
			oeof_validerSaisieBySerieOF();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oeof_validerSaisieBySerieOF() {
	try {

		var numSerieOF = document.getElementById("oeof-numSerieOF").value;

		if (!isEmpty(numSerieOF)) {

			var qAssemble = new QueryHttp('Facturation/Fabrication/assemblerNumSerieOF.tmpl');
			qAssemble.setParam("Ordre_Id", oeof_ordreId);
			qAssemble.setParam("Num_Serie", numSerieOF);
			var result = qAssemble.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}

			document.getElementById("oeof-numSerieOF").value = "";
			oeof_chargerOF();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oeof_retourChoixConflit(composantId) {
	try {

		oeof_validerSaisieBySerie(composantId);

	} catch (e) {
		recup_erreur(e);
	}
}


function oeof_editionPDFOF() {
	try {

		document.getElementById("bRetourOF").collapsed = false;
		document.getElementById("oeof-deckOrdreFabrication").selectedIndex = 1;

		document.getElementById('oeof-pdfOrdreFabrication').setAttribute("src", "");

		var qEdit = new QueryHttp("Facturation/Fabrication/pdfOrdreFabrication.tmpl");
		qEdit.setParam('Ordre_Id', oeof_ordreId);
		var result = qEdit.execute();

		var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
		document.getElementById('oeof-pdfOrdreFabrication').setAttribute("src", page);

	} catch (e) {
		recup_erreur(e);
	}
}


function oeof_envoyerMail() {
	try {

		var url = "chrome://opensi/content/popup/popup-envoyerMail.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', "OF", oeof_ordreId);

	} catch (e) {
		recup_erreur(e);
	}
}


function oeof_validerNumSerieGNS() {
	try {

		if (oeof_aAFabriquer.isSelected()) {
			var assemblageId = oeof_aAFabriquer.getSelectedCellText('oeof-colAssemblageId');
			var numero = document.getElementById('oeof-numSerieGNS').value;
			var datePeremption = document.getElementById('oeof-datePeremptionGNS').value;

			if (isEmpty(numero)) {
				showWarning("Veuillez saisir un n\u00B0 de s\u00E9rie");
			}
			else if (!isEmpty(datePeremption) && !isDate(datePeremption)) {
				showWarning("Date de p\u00E9remption incorrecte");
			}
			else {
				var qAssign = new QueryHttp("Facturation/Fabrication/assignNumSerieAssemblageArticle.tmpl");
				qAssign.setParam("Numero", numero);
				qAssign.setParam("Date_Peremption", datePeremption);
				qAssign.setParam("Ordre_Id", oeof_ordreId);
				qAssign.setParam("Assemblage_Id", assemblageId);
				var result = qAssign.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
				else {
					document.getElementById('oeof-numSerieGNS').value = "";
					document.getElementById('oeof-datePeremptionGNS').value = "";
					document.getElementById('oeof-validerNumSerieGNS').disabled = true;
					document.getElementById('oeof-numSerieGNS').disabled = true;
					document.getElementById('oeof-datePeremptionGNS').disabled = true;
					oeof_chargerOF();
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oeof_pressOnNumSerieGNS(ev) {
	try {

		if (ev.keyCode==13) {
			oeof_validerNumSerieGNS();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oeof_pressOnDatePeremptionGNS(ev) {
	try {

		if (ev.keyCode==13) {
			oeof_validerNumSerieGNS();
		}

	} catch (e) {
		recup_erreur(e);
	}
}
