/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

var oea_aLignes = new Arbre('Facturation/Avoirs_Fournisseur/list-ligneAvoirFournisseur.tmpl', 'oea-articles');
var oea_aPolesActivite = new Arbre("ComboListe/combo-polesActivite.tmpl", "oea-secteur");
var oea_aResponsables = new Arbre("ComboListe/combo-responsables.tmpl","oea-responsable");
var oea_aVersion = new Arbre("Facturation/Avoirs_Fournisseur/list-versionAvoirFournisseur.tmpl","oea-listeVersion");
var oea_aEtablissements = new Arbre('ComboListe/combo-etablissements.tmpl', 'oea-etablissement');
var oea_aCodesTVAFraisPort = new Arbre("ComboListe/combo-tauxTVA.tmpl", "oea-codeTVAFraisPort");


var oea_avoirId;
var oea_modeLigne;
var oea_mode;
var oea_tauxTVAPort;
var oea_codeTVAPort = "";
var oea_chargerResponsable;
var oea_selPoleActivite;
var oea_modifie = false;
var oea_currentIndex = 0;
var oea_toSelectLigne = null;
var oea_typeRistourne = 'P';
var oea_typeRemise = 'P';
var oea_typeRemiseFP = 'P';
var oea_montantHT = 0;
var oea_typeLigne;
var oea_ligneId;
var oea_articleId;
var oea_curEtablissement;
var oea_actSuiviSerie;
var oea_actSuiviLot;
var oea_codesTvaInactifs = "";
var oea_uniteDefaut;
var oea_fournisseurId;
var oea_insertionLigneId = 0;



function oea_init() {
  try {

		document.getElementById('oea-rowFax').collapsed = !gConfig.isShowFax();

		oea_actSuiviLot = gConfig.isActSuiviLot();
		var actUnites = gConfig.isActUnites();
		var actNbPieces = gConfig.isActNbPieces();
		oea_actSuiviSerie = gConfig.isActSuiviSerie();
		oea_uniteDefaut = gConfig.getUniteDefaut();

		document.getElementById('oea-bConsultSerieLigne').collapsed = !oea_actSuiviSerie;
		document.getElementById('oea-bConsultSerieLigne').disabled = true;

		if (!oea_actSuiviLot) {
			document.getElementById('oea-colNumLot').collapsed = true;
			document.getElementById('oea-colDatePeremption').collapsed = true;
			document.getElementById('oea-fieldNumLot').collapsed = true;
			document.getElementById('oea-fieldDLC').collapsed = true;
		}

		if (!actUnites) {
			document.getElementById('oea-colSymboleUnite').collapsed = true;
			document.getElementById('oea-colSymboleUnite').setAttribute('ignoreincolumnpicker', true);
			document.getElementById('oea-fieldUnite').collapsed = true;
		}

		if (!actNbPieces) {
			document.getElementById('oea-colNbPieces').collapsed = true;
			document.getElementById('oea-colNbPieces').setAttribute('ignoreincolumnpicker', true);
			document.getElementById('oea-fieldNbPieces').collapsed = true;
		}

		var qAttPrinc = new QueryHttp("Facturation/Commun/getAttributsPrincipaux.tmpl");
		var result = qAttPrinc.execute();

		var contenu = result.responseXML.documentElement;

		for (var i=1; i<=6; i++) {
			if (!isEmpty(contenu.getAttribute("Groupe_Id_"+ i))) {
				document.getElementById("oea-colAttribut"+ i).setAttribute("label", contenu.getAttribute("Intitule_"+ i));
			}
			else {
				document.getElementById("oea-colAttribut"+ i).collapsed = true;
				document.getElementById("oea-colAttribut"+ i).setAttribute("ignoreincolumnpicker", true);
			}
		}

		var aUnite = new Arbre("ComboListe/combo-unitesVente.tmpl", "oea-unite");
		aUnite.initTree(oea_initUnite);

	} catch (e) {
  	recup_erreur(e);
	}
}

function oea_initUnite() {
	try {

    document.getElementById('oea-unite').selectedIndex = 0;
		var aPays = new Arbre("ComboListe/combo-pays.tmpl", "oea-codePays");
		aPays.initTree();

	} catch (e) {
    recup_erreur(e);
  }
}


function oea_rechargerTVA() {
	try {

		oea_codeTVAPort = "";

		oea_aCodesTVAFraisPort.setParam("Code_Pays", document.getElementById("oea-codePays").value);
    oea_aCodesTVAFraisPort.setParam("Selection", oea_codeTVAPort);
    oea_aCodesTVAFraisPort.initTree(oea_initCodeTVAFraisPort);

		oea_listeTVA();

	} catch (e) {
		recup_erreur(e);
	}
}


function oea_initCodeTVAFraisPort() {
  try {

    document.getElementById('oea-codeTVAFraisPort').value = (document.getElementById("oea-codePays").value=="FR"?getCodeTvaNormalFrance():getCodeTvaZero(document.getElementById("oea-codePays").value));
    oea_codeTVAPort = document.getElementById('oea-codeTVAFraisPort').value;
    oea_tauxTVAPort = getTva(oea_codeTVAPort);

  } catch (e) {
    recup_erreur(e);
  }
}


function oea_listeTVA() {
  try {

  	oea_calculTotaux();
    var aCode = new Arbre("ComboListe/combo-tauxTVA.tmpl", "oea-codeTVA");
    aCode.setParam("Code_Pays", document.getElementById("oea-codePays").value);
		aCode.setParam("Selection", oea_codesTvaInactifs);
    aCode.initTree(oea_selectTVA);

  } catch (e) {
    recup_erreur(e);
  }
}


function oea_selectTVA() {
  try {

  	var codePays = document.getElementById('oea-codePays').value;
    document.getElementById('oea-codeTVA').value = (codePays=="FR"?getCodeTvaNormalFrance():getCodeTvaZero(codePays));

  } catch (e) {
    recup_erreur(e);
  }
}


function oea_chargerResponsables(selection) {
	try {

		oea_chargerResponsable = selection;
		oea_aResponsables.setParam("Selection", oea_chargerResponsable);
		oea_aResponsables.initTree(oea_initResponsable);

	} catch (e) {
		recup_erreur(e);
	}
}

function oea_initResponsable() {
  try {

		document.getElementById('oea-responsable').value = oea_chargerResponsable;

	} catch (e) {
  	recup_erreur(e);
	}
}


function oea_chargerPolesActivite(selection) {
	try {

		oea_selPoleActivite = selection;
		oea_aPolesActivite.setParam("Selection", oea_selPoleActivite);
		oea_aPolesActivite.initTree(oea_initPoleActivite);

	} catch (e) {
		recup_erreur(e);
	}
}


function oea_initPoleActivite() {
  try {

		document.getElementById('oea-secteur').value = oea_selPoleActivite;

	} catch (e) {
  	recup_erreur(e);
	}
}


function oea_chargerEtablissement(selection) {
	try {
		oea_curEtablissement = selection;
		oea_aEtablissements.setParam("Selection", selection);
		oea_aEtablissements.initTree(oea_initEtablissement);
	} catch (e) {
		recup_erreur(e);
	}
}

function oea_initEtablissement() {
	try {
		document.getElementById('oea-etablissement').value = oea_curEtablissement;
	} catch (e) {
		recup_erreur(e);
	}
}


function oea_reinitialiser() {
	try {

		oea_fournisseurId = "";
		oea_modeLigne = "C";
		oea_currentIndex = 0;
		oea_typeRemise = "P";
		oea_typeRemiseFP = "P";
		oea_chargerResponsable = "";
		oea_selPoleActivite = "";
		oea_montantHT = 0;
		oea_codesTvaInactifs = "";
		oea_codeTVAPort = "";

		document.getElementById('oea-tabBoxAvoir').selectedIndex = 0;
		document.getElementById('oea-deckAvoir').selectedIndex = 0;
		document.getElementById('oea-boxMail').collapsed=false;
		document.getElementById('oea-tabAvoir').setAttribute('image', null);

		document.getElementById('oea-numAvoir').value = "";
		document.getElementById('oea-dateAvoir').value = "";
		document.getElementById('oea-typeRectificatif').checked = false;
		document.getElementById('oea-typeRectificatif').collapsed = true;

		oea_aVersion.deleteTree();

		document.getElementById('oea-numFournisseur').value = "";
		document.getElementById('oea-numInterne').value = "";

		oea_aResponsables.deleteTree();

		document.getElementById('oea-denomination').value = "";
		document.getElementById('oea-adresse1').value = "";
		document.getElementById('oea-adresse2').value = "";
		document.getElementById('oea-adresse3').value = "";
		document.getElementById('oea-codePostal').value = "";
		document.getElementById('oea-ville').value = "";
		document.getElementById('oea-codePays').value = "FR";
		document.getElementById('oea-civInter').selectedIndex = 0;
		document.getElementById('oea-nomInter').value = "";
		document.getElementById('oea-prenomInter').value = "";
		document.getElementById('oea-telInter1').value = "";
		document.getElementById('oea-telInter2').value = "";
		document.getElementById('oea-faxInter').value = "";
		document.getElementById('oea-emailInter').value = "";

		document.getElementById('oea-reference').value = "";
		document.getElementById('oea-designation').value = "";
		document.getElementById('oea-numLot').value = "";
		document.getElementById('oea-nbPieces').value = "";
		document.getElementById('oea-quantite').value = "";
		document.getElementById('oea-unite').value = oea_uniteDefaut;
		document.getElementById('oea-datePeremption').value = "";
		document.getElementById('oea-PU').value = "";
		document.getElementById('oea-ristourne').value = "";

		document.getElementById('oea-commentairesFin').value = "";
		document.getElementById('oea-commentairesInt').value = "";
		document.getElementById('oea-bRemise').setAttribute('class', 'bIcoPourcentage');
		document.getElementById('oea-remise').value = "0.00";
		document.getElementById('oea-fraisPort').value = "0.00";
		document.getElementById('oea-codeTVAFraisPort').selectedIndex = 0;
		document.getElementById('oea-bRemiseFP').setAttribute('class', 'bIcoPourcentage');
		document.getElementById('oea-remiseFP').value = "0.00";
		document.getElementById('oea-escompte').value = "0.00";

		document.getElementById('oea-montantHT').value = "0.00";
		document.getElementById('oea-montantRemise').value = "0.00";
		document.getElementById('oea-montantFraisPort').value = "0.00";
		document.getElementById('oea-montantRemiseFP').value = "0.00";
		document.getElementById('oea-totalHT').value = "0.00";
		document.getElementById('oea-TVA').value = "0.00";
		document.getElementById('oea-montantEscompte').value = "0.00";
		document.getElementById('oea-totalTTC').value = "0.00";

		document.getElementById('oea-rowRemiseHT').collapsed = true;
		document.getElementById('oea-rowRemiseFPHT').collapsed = true;
		document.getElementById('oea-rowEscompteHT').collapsed = true;

		document.getElementById('oea-rowNetCommercialHT').collapsed = true;
		document.getElementById('oea-netCommercial').value = "0.00";

		document.getElementById('oea-creation').setAttribute("label", "");
		document.getElementById('oea-modification').setAttribute("label", "");
		document.getElementById('oea-fiche').setAttribute("label", "");

		oea_typeLigne = "";
		oea_ligneId = "";
		oea_modifie = false;

		document.getElementById('oea-numAvoir').disabled = true;
		document.getElementById('oea-dateAvoir').disabled = true;
		document.getElementById('oea-typeRectificatif').disabled = true;
		document.getElementById('oea-etablissement').disabled = true;
		document.getElementById('oea-secteur').disabled = true;
		document.getElementById('oea-responsable').disabled = true;
		document.getElementById('oea-bAjouterLigne').disabled = true;
		document.getElementById('oea-bVoirFichier').disabled = true;
		document.getElementById('oea-bRechFournisseur').collapsed = true;
		document.getElementById('oea-bChercherAdr').disabled = true;
		document.getElementById('oea-bChercherInter').disabled = true;

		document.getElementById('oea-denomination').setAttribute('readonly', true);
		document.getElementById('oea-adresse1').setAttribute('readonly', true);
		document.getElementById('oea-adresse2').setAttribute('readonly', true);
		document.getElementById('oea-adresse3').setAttribute('readonly', true);
		document.getElementById('oea-codePostal').setAttribute('readonly', true);
		document.getElementById('oea-ville').setAttribute('readonly', true);
		document.getElementById('oea-codePays').disabled = true;
		document.getElementById('oea-civInter').disabled = true;
		document.getElementById('oea-nomInter').setAttribute('readonly', true);
		document.getElementById('oea-prenomInter').setAttribute('readonly', true);
		document.getElementById('oea-telInter1').setAttribute('readonly', true);
		document.getElementById('oea-telInter2').setAttribute('readonly', true);
		document.getElementById('oea-faxInter').setAttribute('readonly', true);
		document.getElementById('oea-emailInter').setAttribute('readonly', true);

		document.getElementById('oea-bMoveUp').disabled = true;
		document.getElementById('oea-bMoveDown').disabled = true;
		document.getElementById('oea-bMoveFirst').disabled = true;
		document.getElementById('oea-bMoveLast').disabled = true;
		document.getElementById('oea-bMultiSuppression').disabled = true;

		document.getElementById('oea-reference').disabled = true;
		document.getElementById('oea-designation').disabled = true;
		document.getElementById('oea-numLot').disabled = true;
		document.getElementById('oea-nbPieces').disabled = true;
		document.getElementById('oea-quantite').disabled = true;
		document.getElementById('oea-unite').disabled = true;
		document.getElementById('oea-datePeremption').disabled = true;
		document.getElementById('oea-PU').disabled = true;
		document.getElementById('oea-ristourne').disabled = true;
		document.getElementById('oea-codeTVA').disabled = true;

		document.getElementById('oea-bArticle').disabled = true;
		document.getElementById('oea-bCommentaire').disabled = true;
		document.getElementById('oea-bAnnuler').disabled = true;
		document.getElementById('oea-bValider').disabled = true;
		document.getElementById('oea-bSupprimer').disabled = true;
		oea_aLignes.deleteTree();

		document.getElementById('oea-commentairesFin').disabled = true;
		document.getElementById('oea-commentairesInt').disabled = true;
		document.getElementById('oea-bOuvrirCommentairesCaches').disabled = true;
		document.getElementById('oea-bChoisirMentions').disabled = true;
		document.getElementById('oea-bRemise').disabled = true;
		document.getElementById('oea-remise').disabled = true;
		document.getElementById('oea-fraisPort').disabled = true;
		document.getElementById('oea-codeTVAFraisPort').disabled = true;
		document.getElementById('oea-bRemiseFP').disabled = true;
		document.getElementById('oea-remiseFP').disabled = true;
		document.getElementById('oea-escompte').disabled = true;
		document.getElementById('oea-bEnregistrer').disabled = true;
		document.getElementById('oea-bSupAvoir').disabled = true;
		document.getElementById('oea-bVisualiser').disabled = true;
		document.getElementById('oea-bValiderAvoir').disabled = true;
		document.getElementById('oea-bVisualiser').collapsed = true;
		document.getElementById('oea-bValiderAvoir').collapsed = false;
		document.getElementById('oea-pdfAvoir').setAttribute('src', '');

	} catch (e) {
		recup_erreur(e);
	}
}


function oea_debloquerChamps() {
	try {

		document.getElementById('oea-numAvoir').disabled = false;
		document.getElementById('oea-dateAvoir').disabled = false;
		document.getElementById('oea-typeRectificatif').disabled = false;
		document.getElementById('oea-etablissement').disabled = false;
		document.getElementById('oea-secteur').disabled = false;
		document.getElementById('oea-responsable').disabled = false;

		document.getElementById('oea-denomination').removeAttribute('readonly');
		document.getElementById('oea-adresse1').removeAttribute('readonly');
		document.getElementById('oea-adresse2').removeAttribute('readonly');
		document.getElementById('oea-adresse3').removeAttribute('readonly');
		document.getElementById('oea-codePostal').removeAttribute('readonly');
		document.getElementById('oea-ville').removeAttribute('readonly');
		document.getElementById('oea-codePays').disabled = false;
		document.getElementById('oea-civInter').disabled = false;
		document.getElementById('oea-nomInter').removeAttribute('readonly');
		document.getElementById('oea-prenomInter').removeAttribute('readonly');
		document.getElementById('oea-telInter1').removeAttribute('readonly');
		document.getElementById('oea-telInter2').removeAttribute('readonly');
		document.getElementById('oea-faxInter').removeAttribute('readonly');
		document.getElementById('oea-emailInter').removeAttribute('readonly');

		oea_ajouterLigne("I");
		document.getElementById('oea-bArticle').disabled = false;

		document.getElementById('oea-commentairesFin').disabled = false;
		document.getElementById('oea-commentairesInt').disabled = false;
		document.getElementById('oea-bChoisirMentions').disabled = false;
		document.getElementById('oea-bRemise').disabled = false;
		document.getElementById('oea-remise').disabled = false;
		document.getElementById('oea-fraisPort').disabled = false;
		document.getElementById('oea-codeTVAFraisPort').disabled = false;
		document.getElementById('oea-bRemiseFP').disabled = false;
		document.getElementById('oea-remiseFP').disabled = false;
		document.getElementById('oea-escompte').disabled = false;
		document.getElementById('oea-bEnregistrer').disabled = false;
		document.getElementById('oea-bSupAvoir').disabled = (oea_mode!="M");

		if (oea_mode=='C') { document.getElementById('oea-bRechFournisseur').collapsed = false; }

	} catch (e) {
		recup_erreur(e);
	}
}


function oea_chargerAvoir() {
  try {

		oea_mode = "M";
		oea_reinitialiser();

  	var qLoad = new QueryHttp("Facturation/Avoirs_Fournisseur/getAvoir.tmpl");
  	qLoad.setParam("Avoir_Id", oea_avoirId);
		var result = qLoad.execute();
		var contenu = result.responseXML.documentElement;

		var numAvoir = contenu.getAttribute('Numero');
		var statut = contenu.getAttribute('Statut');
		if (statut=="V") { oea_mode = "V"; }

    oea_chargerResponsables(contenu.getAttribute('Util_R'));
		document.getElementById('oea-commentairesFin').value = contenu.getAttribute('Commentaires_Fin');
		document.getElementById('oea-commentairesInt').value = contenu.getAttribute('Commentaires_Int');
		document.getElementById('oea-dateAvoir').value = contenu.getAttribute('Date_Avoir');
		document.getElementById('oea-typeRectificatif').checked = contenu.getAttribute('Type_Rectificatif')=="true";
		document.getElementById('oea-typeRectificatif').collapsed = contenu.getAttribute('Rectification_Possible')=="false";
		document.getElementById('oea-numAvoir').value = numAvoir;
		document.getElementById('oea-escompte').value = contenu.getAttribute('Escompte');
    document.getElementById('oea-fraisPort').value = contenu.getAttribute('Frais_Port');
    oea_codeTVAPort = contenu.getAttribute('Code_TVA_Port');
		oea_tauxTVAPort = contenu.getAttribute('Taux_TVA_Port');

		oea_fournisseurId = contenu.getAttribute('Fournisseur_Id');
		var fournisseurConnu = (oea_fournisseurId!="");
		document.getElementById('oea-numFournisseur').value = contenu.getAttribute('Num_Fournisseur');
		document.getElementById('oea-numInterne').value = contenu.getAttribute('Num_Interne');

    document.getElementById('oea-denomination').value = contenu.getAttribute('Denomination');
    document.getElementById('oea-adresse1').value = contenu.getAttribute('Adresse_1');
    document.getElementById('oea-adresse2').value = contenu.getAttribute('Adresse_2');
		document.getElementById('oea-adresse3').value = contenu.getAttribute('Adresse_3');
    document.getElementById('oea-codePostal').value = contenu.getAttribute('Code_Postal');
    document.getElementById('oea-ville').value = contenu.getAttribute('Ville');
		document.getElementById('oea-codePays').value = contenu.getAttribute('Code_Pays');
		oea_codesTvaInactifs = contenu.getAttribute('Codes_TVA_Inactifs');

		document.getElementById('oea-civInter').value = contenu.getAttribute('Civ_Inter');
    document.getElementById('oea-nomInter').value = contenu.getAttribute('Nom_Inter');
    document.getElementById('oea-prenomInter').value = contenu.getAttribute('Prenom_Inter');
    document.getElementById('oea-telInter1').value = contenu.getAttribute('Tel_Inter_1');
    document.getElementById('oea-telInter2').value = contenu.getAttribute('Tel_Inter_2');
    document.getElementById('oea-faxInter').value = contenu.getAttribute('Fax_Inter');
    document.getElementById('oea-emailInter').value = contenu.getAttribute('Email_Inter');

		oea_typeRemise = (parseFloat(contenu.getAttribute('MRemise'))!=0?'M':'P');
		document.getElementById('oea-remise').value = (oea_typeRemise=='P'?contenu.getAttribute('PRemise'):contenu.getAttribute('MRemise'));
		document.getElementById('oea-bRemise').setAttribute("class", (oea_typeRemise=='P'?"bIcoPourcentage":"bIcoEuro"));

		oea_typeRemiseFP = (parseFloat(contenu.getAttribute('MRemise_FP'))!=0?'M':'P');
		document.getElementById('oea-remiseFP').value = (oea_typeRemiseFP=='P'?contenu.getAttribute('PRemise_FP'):contenu.getAttribute('MRemise_FP'));
		document.getElementById('oea-bRemiseFP').setAttribute("class", (oea_typeRemiseFP=='P'?"bIcoPourcentage":"bIcoEuro"));

		oea_chargerPolesActivite(contenu.getAttribute('Pole_Activite'));
		oea_chargerEtablissement(contenu.getAttribute('Etab_Id'));

		document.getElementById('oea-creation').label = "Avoir cr\u00E9\u00E9 le "+ contenu.getAttribute('Date_Creation') + " par "+ contenu.getAttribute('Login_Createur');
		document.getElementById('oea-modification').label = "Derni\u00E8re modification le "+ contenu.getAttribute('Date_Maj') +" par "+ contenu.getAttribute('Login_Maj');
		document.getElementById('oea-fiche').label = "Avoir N\u00B0 "+ contenu.getAttribute('Numero');

		document.getElementById('oea-tabVersionDocument').collapsed = false;
		oea_initVersion();

		oea_setModifie(false);

		if (oea_mode!="V") {
			oea_debloquerChamps();
			document.getElementById('oea-bChercherInter').disabled = !fournisseurConnu;
		}

		document.getElementById('oea-bOuvrirCommentairesCaches').disabled = false;
    document.getElementById('oea-bVisualiser').disabled = (oea_mode!="V");
		document.getElementById('oea-bValiderAvoir').disabled = (oea_mode=="V");
		document.getElementById('oea-bVisualiser').collapsed = (oea_mode!="V");
		document.getElementById('oea-bValiderAvoir').collapsed = (oea_mode=="V");
		document.getElementById('oea-bVoirFichier').disabled = (oea_mode!="V");

		oea_aLignes.setParam("Avoir_Id", oea_avoirId);
		oea_aLignes.initTree(oea_chargerAvoir2);

	} catch (e) {
    recup_erreur(e);
  }
}


function oea_chargerAvoir2() {
  try {

		oea_aCodesTVAFraisPort.setParam("Code_Pays", document.getElementById("oea-codePays").value);
		oea_aCodesTVAFraisPort.setParam("Selection", oea_codeTVAPort);
		oea_aCodesTVAFraisPort.initTree(oea_selectionTvaPort);

	} catch (e) {
    recup_erreur(e);
  }
}


function oea_selectionTvaPort() {
  try {

		document.getElementById('oea-codeTVAFraisPort').value = oea_codeTVAPort;
		oea_tauxTVAPort = getTva(oea_codeTVAPort);
		oea_listeTVA();

  } catch (e) {
    recup_erreur(e);
  }
}


function oea_switchRistourne() {
	try {

		if (oea_typeRistourne=='P') {
			document.getElementById('oea-bRistourne').setAttribute("class", "bIcoEuro");
			oea_typeRistourne = 'M';
		}
		else {
			document.getElementById('oea-bRistourne').setAttribute("class", "bIcoPourcentage");
			oea_typeRistourne = 'P';
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oea_switchRemise() {
	try {

		if (oea_typeRemise=='P') {
			document.getElementById('oea-bRemise').setAttribute("class", "bIcoEuro");
			oea_typeRemise = 'M';
		}
		else {
			document.getElementById('oea-bRemise').setAttribute("class", "bIcoPourcentage");
			oea_typeRemise = 'P';
		}
		oea_calculTotaux();
		oea_setModifie(true);

	} catch (e) {
    recup_erreur(e);
  }
}


function oea_switchRemiseFP() {
	try {

		if (oea_typeRemiseFP=='P') {
			document.getElementById('oea-bRemiseFP').setAttribute("class", "bIcoEuro");
			oea_typeRemiseFP = 'M';
		}
		else {
			document.getElementById('oea-bRemiseFP').setAttribute("class", "bIcoPourcentage");
			oea_typeRemiseFP = 'P';
		}
		oea_calculTotaux();
		oea_setModifie(true);

	} catch (e) {
    recup_erreur(e);
  }
}


function oea_rechercherFournisseur() {
  try {

		var url = "chrome://opensi/content/facturation/user/fournisseurs/popup-rechercheFournisseur.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oea_retourRechercherFournisseur);

	} catch (e) {
  	recup_erreur(e);
  }
}

function oea_retourRechercherFournisseur(numFournisseur, fournisseurId) {
	try {

		oea_fournisseurId = fournisseurId;
		oea_setModifie(true);
		oea_chargerCoord();

	} catch (e) {
		recup_erreur(e);
	}
}


function oea_rechercherAdr() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-choixAdrCom.xul?"+ cookie() +"&Fournisseur_Id="+ oea_fournisseurId;
    window.openDialog(url,'','chrome,modal,centerscreen', oea_reporterAdr);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oea_reporterAdr(nom, adr1, adr2, adr3, cp, ville, pays, code_pays, contactId, depotId) {
  try {

		document.getElementById("oea-denomination").value = nom;
		document.getElementById("oea-adresse1").value = adr1;
		document.getElementById("oea-adresse2").value = adr2;
		document.getElementById("oea-adresse3").value = adr3;
		document.getElementById("oea-codePostal").value = cp;
		document.getElementById("oea-ville").value = ville;
	  document.getElementById("oea-codePays").value = code_pays;
	  oea_rechargerTVA();

	  if (!isEmpty(contactId)) {
	  	var qLoad = new QueryHttp("Facturation/Fournisseurs/loadContactFournisseur.tmpl");
	  	qLoad.setParam("Contact_Id", contactId);
	  	var result = qLoad.execute();
	  	var contenu = result.responseXML.documentElement;
	  	oea_reporterInter(contenu.getAttribute("Civilite"),contenu.getAttribute("Nom"),contenu.getAttribute("Prenom"),contenu.getAttribute("Tel_1"),contenu.getAttribute("Tel_2"),contenu.getAttribute("Fax"),contenu.getAttribute("Email"));
	  }
	  oea_setModifie(true);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oea_rechercherInterlocuteur() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-choixInterFournisseur.xul?"+ cookie() +"&Fournisseur_Id="+ oea_fournisseurId;
    window.openDialog(url,'','chrome,modal,centerscreen', oea_reporterInter);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oea_reporterInter(civ, nom, prenom, tel1, tel2, fax, email) {
  try {

		document.getElementById("oea-civInter").value = civ;
		document.getElementById("oea-nomInter").value = nom;
		document.getElementById("oea-prenomInter").value = prenom;
		document.getElementById("oea-telInter1").value = tel1;
		document.getElementById("oea-telInter2").value = tel2;
		document.getElementById("oea-faxInter").value = fax;
		document.getElementById("oea-emailInter").value = email;

		oea_setModifie(true);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oea_chargerCoord() {
  try {

		var qGet = new QueryHttp("Facturation/Fournisseurs/getDefautDocumentAchat.tmpl");
		qGet.setParam("Fournisseur_Id", oea_fournisseurId);
	  var result = qGet.execute();

	  var contenu = result.responseXML.documentElement;

		document.getElementById('oea-numFournisseur').value = contenu.getAttribute("Num_Fournisseur");

		document.getElementById("oea-denomination").value = contenu.getAttribute("Denomination");
		document.getElementById("oea-adresse1").value = contenu.getAttribute("Adresse_1");
		document.getElementById("oea-adresse2").value = contenu.getAttribute("Adresse_2");
		document.getElementById("oea-adresse3").value = contenu.getAttribute("Adresse_3");
		document.getElementById("oea-codePostal").value = contenu.getAttribute("Code_Postal");
		document.getElementById("oea-ville").value = contenu.getAttribute("Ville");
		document.getElementById("oea-codePays").value = contenu.getAttribute("Code_Pays");

		document.getElementById("oea-civInter").value = contenu.getAttribute("Civ_Inter");
		document.getElementById("oea-nomInter").value = contenu.getAttribute("Nom_Inter");
		document.getElementById("oea-prenomInter").value = contenu.getAttribute("Prenom_Inter");
		document.getElementById("oea-telInter1").value = contenu.getAttribute("Tel_Inter_1");
		document.getElementById("oea-telInter2").value = contenu.getAttribute("Tel_Inter_2");
		document.getElementById("oea-faxInter").value = contenu.getAttribute("Fax_Inter");
		document.getElementById("oea-emailInter").value = contenu.getAttribute("Email_Inter");

		document.getElementById('oea-remise').value = contenu.getAttribute("Taux_Remise");
		document.getElementById('oea-bRemise').setAttribute("class", "bIcoPourcentage");
		oea_typeRemise = 'P';

		oea_rechargerTVA();

		oea_chargerResponsables(contenu.getAttribute('Util_R'));
		oea_chargerPolesActivite(contenu.getAttribute("Pole_Activite"));

		oea_ajouterLigne("I");

		document.getElementById('oea-bChercherAdr').disabled = false;
		document.getElementById('oea-bChercherInter').disabled = false;

	} catch (e) {
  	recup_erreur(e);
  }
}


function oea_ajouterLigne(typeLigne, articleId) {
  try {

		document.getElementById('oea-bSupprimer').disabled = true;
		document.getElementById('oea-bMoveUp').disabled = true;
		document.getElementById('oea-bMoveDown').disabled = true;
		document.getElementById('oea-bMoveFirst').disabled = true;
		document.getElementById('oea-bMoveLast').disabled = true;
		document.getElementById('oea-bMultiSuppression').disabled = true;
		document.getElementById('oea-bCommentaire').disabled = true;

		oea_modeLigne = "C";
		oea_typeLigne = typeLigne;
		oea_ligneId = "";

		oea_formatLigne(typeLigne);
		var codePays = document.getElementById('oea-codePays').value;

		if (typeLigne=="S") {
			oea_articleId = articleId;

			var qInfos = new QueryHttp("Facturation/Articles/getInfosArticleAchat.tmpl");
			qInfos.setParam("Article_Id", articleId);
			qInfos.setParam("Fournisseur_Id", oea_fournisseurId);
			var result = qInfos.execute();

			var contenu = result.responseXML.documentElement;
			document.getElementById("oea-designation").value = contenu.getAttribute("Designation");
			document.getElementById("oea-numLot").value = "";
			document.getElementById("oea-nbPieces").value = "";
			document.getElementById('oea-quantite').value = 1;
			document.getElementById('oea-unite').value = contenu.getAttribute("Unite_Id");
			document.getElementById("oea-datePeremption").value = "";
			document.getElementById("oea-PU").value = contenu.getAttribute("Prix_Unitaire");
			document.getElementById('oea-ristourne').value = "0.00";
			document.getElementById("oea-codeTVA").value = (codePays=="FR"?contenu.getAttribute("Code_TVA"):getCodeTvaZero(codePays));
		}
		else {
			oea_articleId = "";
			document.getElementById("oea-bConsultSerieLigne").disabled = true;
			document.getElementById('oea-reference').value = "";
			document.getElementById('oea-designation').value = "";
			document.getElementById("oea-numLot").value = "";
			document.getElementById("oea-nbPieces").value = "";
			document.getElementById('oea-quantite').value = 1;
			document.getElementById('oea-unite').value = oea_uniteDefaut;
			document.getElementById("oea-datePeremption").value = "";
			document.getElementById('oea-PU').value = "";
			document.getElementById('oea-ristourne').value = "0.00";
			document.getElementById('oea-codeTVA').value = (codePays=="FR"?getCodeTvaNormalFrance():getCodeTvaZero(codePays));
			oea_insertionLigneId = 0;
			document.getElementById('oea-bAjouterLigne').disabled = true;
			document.getElementById('oea-actInsert').collapsed = true;
			oea_aLignes.setCellSrc(oea_currentIndex, 'oea-colReference', "");
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oea_ajouterLigneAvant() {
  try {

		if (oea_aLignes.isSelected() && oea_mode=="M") {
			var idx = oea_aLignes.getCurrentIndex();
			var ligneId = oea_aLignes.getCellText(idx,'oea-colLigneId');
			oea_annulerLigne();
			oea_aLignes.setCellSrc(idx, 'oea-colReference', "chrome://opensi/content/design/insertbefore.png");
			oea_insertionLigneId = ligneId;
			oea_currentIndex = idx;
			document.getElementById('oea-actInsert').collapsed = false;
			document.getElementById('oea-reference').focus();
		}

	} catch (e) {
  	recup_erreur(e);
	}
}

function oea_pressOnLigneAvoir(event) {
	try {

		if (event.keyCode==45 && event.ctrlKey) {
			// ctrl + inser
			// insrer une ligne avant

			oea_ajouterLigneAvant();
		}
	} catch (e) {
		recup_erreur(e);
	}
}


function oea_formatLigne(typeLigne) {
  try {
		switch (typeLigne) {
			case "S":
        if (oea_mode != 'V') {
				  document.getElementById('oea-reference').disabled = true;
				  document.getElementById('oea-designation').disabled = true;
				  document.getElementById('oea-numLot').disabled = false;
					document.getElementById('oea-nbPieces').disabled = false;
				  document.getElementById('oea-quantite').disabled = false;
				  document.getElementById('oea-unite').disabled = false;
					document.getElementById('oea-datePeremption').disabled = false;
				  document.getElementById('oea-PU').disabled = false;
				  document.getElementById('oea-ristourne').disabled = false;
				  document.getElementById('oea-bRistourne').disabled = false;
				  document.getElementById('oea-codeTVA').disabled = false;
				  document.getElementById('oea-bValider').disabled = false;
				  document.getElementById('oea-bAnnuler').disabled = false;
        }
				break;

			case "I":
        if (oea_mode != 'V') {
  				document.getElementById('oea-reference').disabled = false;
	  			document.getElementById('oea-designation').disabled = false;
	  			document.getElementById('oea-numLot').disabled = true;
					document.getElementById('oea-nbPieces').disabled = false;
		  		document.getElementById('oea-quantite').disabled = false;
		  		document.getElementById('oea-unite').disabled = false;
					document.getElementById('oea-datePeremption').disabled = true;
			  	document.getElementById('oea-PU').disabled = false;
			  	document.getElementById('oea-ristourne').disabled = false;
				  document.getElementById('oea-bRistourne').disabled = false;
				  document.getElementById('oea-codeTVA').disabled = false;
				  document.getElementById('oea-bValider').disabled = false;
				  document.getElementById('oea-bAnnuler').disabled = false;
        }
				break;

			default:
				var codePays = document.getElementById('oea-codePays').value;

				document.getElementById('oea-reference').value = "";
				document.getElementById('oea-designation').value = "";
				document.getElementById('oea-numLot').value = "";
				document.getElementById('oea-nbPieces').value = "";
				document.getElementById('oea-quantite').value = "";
				document.getElementById('oea-unite').value = oea_uniteDefaut;
				document.getElementById('oea-datePeremption').value = "";
				document.getElementById('oea-PU').value = "";
				document.getElementById('oea-ristourne').value = "0.00";
				document.getElementById('oea-codeTVA').value = (codePays=="FR"?getCodeTvaNormalFrance():getCodeTvaZero(codePays));
				oea_ligneId = "";
				document.getElementById('oea-reference').disabled = true;
				document.getElementById('oea-designation').disabled = true;
				document.getElementById('oea-numLot').disabled = true;
				document.getElementById('oea-nbPieces').disabled = true;
				document.getElementById('oea-quantite').disabled = true;
				document.getElementById('oea-unite').disabled = true;
				document.getElementById('oea-datePeremption').disabled = true;
				document.getElementById('oea-PU').disabled = true;
				document.getElementById('oea-ristourne').disabled = true;
				document.getElementById('oea-bRistourne').disabled = true;
				document.getElementById('oea-codeTVA').disabled = true;
				document.getElementById('oea-bSupprimer').disabled = true;
				document.getElementById('oea-bMoveUp').disabled = true;
				document.getElementById('oea-bMoveDown').disabled = true;
				document.getElementById('oea-bMoveFirst').disabled = true;
				document.getElementById('oea-bMoveLast').disabled = true;
				document.getElementById('oea-bMultiSuppression').disabled = true;
				document.getElementById('oea-bCommentaire').disabled = true;
				document.getElementById('oea-bValider').disabled = true;
				document.getElementById('oea-bAnnuler').disabled = true;
				break;
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oea_pressOnWindow(ev) {
	try {

		if (ev.altKey && oea_mode!="V") {
			switch(ev.charCode) {
      	case 97: // 'a'
				case 65: // 'A'
					oea_rechercherStock();
        	break;
    	}
		}
		else if (ev.ctrlKey && oea_mode!="V") {
			if (ev.keyCode==46) {
				// ctrl + suppr
				ev.preventDefault();
				oea_supprimerLigne();
			}
			else if (ev.charCode==114 || ev.charCode==82) {
				// ctrl + r (ou R)
				ev.preventDefault();	
				oea_appliquerRistourne();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oea_pressOnReference(ev) {
	try {

		if (ev.keyCode==13) {
			oea_rechercherReference();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oea_rechercherStock(reference) {
	try {

		var url = "chrome://opensi/content/facturation/user/articles/popup-rechercheArticle.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oea_retourRechercherStock, "A", reference, null, null, oea_fournisseurId, null, null, true);

	} catch (e) {
    recup_erreur(e);
  }
}


function oea_retourRechercherStock(reference, articleId, listArticleId) {
	try {

		if (articleId!=null) {
			document.getElementById('oea-reference').value = reference;
			document.getElementById('oea-quantite').focus();
			oea_ajouterLigne("S", articleId);
		}
		else {
			oea_ajouterMulti(listArticleId);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oea_rechercherReference() {
	try {

		var reference = document.getElementById('oea-reference').value;

		var qSearch = new QueryHttp("Facturation/Articles/searchReference.tmpl");
		qSearch.setParam('Reference', reference);
		qSearch.setParam('Vente_Achat', "A");
		if (!isEmpty(oea_fournisseurId)) {
			qSearch.setParam('Fournisseur_Id', oea_fournisseurId);
		}
		var result = qSearch.execute();

		var articleId = result.responseXML.documentElement.getAttribute("Article_Id");
		if (!isEmpty(articleId)) {
			document.getElementById('oea-reference').value = result.responseXML.documentElement.getAttribute("Reference");
			document.getElementById('oea-quantite').focus();
			oea_ajouterLigne("S", articleId);
		}
		else {
			oea_rechercherStock(reference);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oea_ajouterMulti(listArticleId) {
	try {

		var ok = true;

		if (oea_mode=="C") {
			ok = oea_enregistrerAvoir();
		}

		if (ok) {
			var qAdd = new QueryHttp("Facturation/Avoirs_Fournisseur/addLigneAvoirFournisseur.tmpl");
			qAdd.setParam("List_Article_Id", listArticleId);
			qAdd.setParam("Avoir_Id", oea_avoirId);
			qAdd.execute();

			oea_ajouterLigne("I");
			oea_aLignes.initTree(oea_afterRefreshArticles);
		}

	} catch (e) {
		recup_erreur(e);
  }
}


function oea_ouvrirLigne() {
  try {

		if (oea_aLignes.isSelected() && oea_mode=="M") {

			if (oea_aLignes.nbSelection()==1) {
				var i = oea_aLignes.getCurrentIndex();
				oea_aLignes.setCellSrc(i, 'oea-colReference', "");
				oea_currentIndex = i;

				oea_typeLigne = oea_aLignes.getCellText(i,'oea-colTypeLigne');
				document.getElementById("oea-bConsultSerieLigne").disabled = (oea_typeLigne!="S");
				document.getElementById('oea-bMultiSuppression').disabled = true;

				if (oea_aLignes.getCellText(i,'oea-colTypeLigne')=="C") {
					oea_ajouterLigne("I");
				}
				else {
					oea_modeLigne = "M";

					document.getElementById("oea-reference").value = oea_aLignes.getCellText(i,'oea-colReference');
					document.getElementById("oea-designation").value = oea_aLignes.getCellText(i,'oea-colDesignation');
					document.getElementById("oea-numLot").value = oea_aLignes.getCellText(i,'oea-colNumLot');
					document.getElementById("oea-nbPieces").value = oea_aLignes.getCellText(i,'oea-colNbPieces');
					document.getElementById("oea-quantite").value = oea_aLignes.getCellText(i,'oea-colQuantite');
					document.getElementById("oea-unite").value = oea_aLignes.getCellText(i,'oea-colUnite');
					document.getElementById("oea-datePeremption").value = oea_aLignes.getCellText(i,'oea-colDatePeremption');
					document.getElementById("oea-PU").value = oea_aLignes.getCellText(i,'oea-colPU');
					document.getElementById("oea-ristourne").value = oea_aLignes.getCellValue(i,'oea-colRistourne');
					oea_typeRistourne = oea_aLignes.getSelectedCellText('oea-colTypeRistourne');
					document.getElementById('oea-bRistourne').setAttribute("class", (oea_typeRistourne=='P'?"bIcoPourcentage":"bIcoEuro"));
					document.getElementById("oea-codeTVA").value = oea_aLignes.getCellText(i,'oea-colCodeTVA');
					oea_ligneId = oea_aLignes.getCellText(i,'oea-colLigneId');
					oea_articleId = oea_aLignes.getCellText(i,'oea-colArticleId');

					if (oea_mode=="M") {
						document.getElementById('oea-bAjouterLigne').disabled = false;
						oea_insertionLigneId = 0;
						document.getElementById('oea-actInsert').collapsed = true;

						document.getElementById('oea-bCommentaire').disabled = false;
						document.getElementById('oea-bSupprimer').disabled = false;

  		    	// on ignore les lignes de commentaires
  					var firstIndex = 0;
  					var lastIndex = oea_aLignes.nbLignes()-1;
  					if (oea_aLignes.getCellText(firstIndex,'oea-colTypeLigne')=="C") { firstIndex++; }
  					if (oea_aLignes.getCellText(lastIndex,'oea-colTypeLigne')=="C") { lastIndex--; }

  					document.getElementById('oea-bMoveUp').disabled = (i==firstIndex);
  					document.getElementById('oea-bMoveDown').disabled = (i==lastIndex);
						document.getElementById('oea-bMoveFirst').disabled = (i==firstIndex);
  					document.getElementById('oea-bMoveLast').disabled = (i==lastIndex);
        	}
					oea_formatLigne(oea_typeLigne);
				}
			}
			else {
				oea_ajouterLigne("I");
				document.getElementById('oea-bMultiSuppression').disabled = false;
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oea_ouvrirCommentaire() {
  try {

		if (oea_aLignes.isSelected() && oea_mode=="M") {
			var i = oea_aLignes.getCurrentIndex();

			if (oea_aLignes.getCellText(i,'oea-colTypeLigne')=="C") {
				oea_editerCommentaire();
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oea_deplacerLigne(moveType) {
	try {

		if (oea_aLignes.isSelected() && oea_mode=="M" && oea_aLignes.getSelectedCellText('oea-colTypeLigne')!="C") {

			document.getElementById('oea-bMoveUp').disabled = true;
			document.getElementById('oea-bMoveDown').disabled = true;
			document.getElementById('oea-bMoveFirst').disabled = true;
			document.getElementById('oea-bMoveLast').disabled = true;

			var qMove = new QueryHttp("Facturation/Avoirs_Fournisseur/moveLigneAvoirFournisseur.tmpl");
			qMove.setParam("Ligne_Id", oea_ligneId);
			qMove.setParam("Move_Type", moveType);
			var result = qMove.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oea_toSelectLigne = oea_ligneId;
				oea_ajouterLigne("I");
				oea_aLignes.initTree(oea_afterRefreshArticles);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oea_validerLigne() {
  try {

		var reference = document.getElementById("oea-reference").value;
		var designation = document.getElementById("oea-designation").value;
		var numLot = document.getElementById("oea-numLot").value;
		var nbPieces = document.getElementById("oea-nbPieces").value;
		var quantite = document.getElementById("oea-quantite").value;
		var unite = document.getElementById("oea-unite").value;
		var datePeremption = document.getElementById("oea-datePeremption").value;
		var prixUnitaire = document.getElementById("oea-PU").value;
		var ristourne = document.getElementById("oea-ristourne").value;
		var codeTVA = document.getElementById("oea-codeTVA").value;

		if (isEmpty(nbPieces)) {
			nbPieces = 0;
		}

		var ok = true;

		if (oea_mode=="C") {
			ok = oea_enregistrerAvoir();
		}

		if (ok) {

			if (isEmpty(designation)) { showWarning("D\u00E9signation de l'article manquante !"); }
			else if (!checkQte(quantite)) { showWarning("Quantit\u00E9 incorrecte !");	}
			else if (!isPositiveOrNullInteger(nbPieces)) { showWarning("Nombre de pi\u00E8ces incorrect !");	}
			else if (isEmpty(prixUnitaire) || !checkDecimal(prixUnitaire,4) || !isPositiveOrNull(prixUnitaire)) { showWarning("Prix unitaire incorrect !");	}
			else if (isEmpty(ristourne) || (oea_typeRistourne=='P'?!isTaux(ristourne):!isPositiveOrNull(ristourne) || !checkNumber(ristourne,9,2) || parseFloat(ristourne)>parseFloat(prixUnitaire))) { showWarning("Ristourne incorrecte"); }
			else if (oea_checkNumLotLigne(numLot, datePeremption)) {

				var qSave;

				if (oea_modeLigne=="C") {
					if (oea_insertionLigneId==0) {
						oea_currentIndex = oea_aLignes.nbLignes();
					}
					qSave = new QueryHttp("Facturation/Avoirs_Fournisseur/ajouterArticle.tmpl");
					qSave.setParam("Avoir_Id", oea_avoirId);
				}
				else {
					qSave = new QueryHttp("Facturation/Avoirs_Fournisseur/modifierArticle.tmpl");
					qSave.setParam("Ligne_Id", oea_ligneId);
				}

				qSave.setParam("Reference", reference);
				qSave.setParam("Designation", designation);
				qSave.setParam("Quantite", quantite);
				qSave.setParam("Prix", prixUnitaire);
				qSave.setParam("Ristourne", ristourne);
				qSave.setParam("Type_Ristourne", oea_typeRistourne);
				qSave.setParam("Code_TVA", codeTVA);
				qSave.setParam("Num_Lot", numLot);
				qSave.setParam("Date_Peremption", datePeremption);
				qSave.setParam("Nb_Pieces", nbPieces);
				qSave.setParam("Unite", unite);
				qSave.setParam("Insertion_Ligne_Id", oea_insertionLigneId);

				var result = qSave.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
				else {

					if (oea_modeLigne=="C") {
						oea_ligneId = result.responseXML.documentElement.getAttribute('Ligne_Id');
					}

					oea_checkNumSerieLigne(quantite);

					oea_ajouterLigne("I");
					oea_aLignes.initTree(oea_afterRefreshArticles);
				}
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oea_annulerLigne() {
  try {

  	oea_aLignes.clearSelection();
  	oea_ajouterLigne("I");

	} catch (e) {
  	recup_erreur(e);
	}
}


function oea_supprimerLigne() {
  try {

		var listLigneId = "";
		var maxIndex = 0;

		if (!isEmpty(oea_ligneId)) {
			listLigneId = oea_ligneId;
			maxIndex = oea_currentIndex;
		}
		else {
			var start = new Object();
			var end = new Object();
			var numRanges = oea_aLignes.getRangeCount();

			for (var t=0; t<numRanges; t++){
				oea_aLignes.getRangeAt(t,start,end);
			  for (var v=start.value; v<=end.value; v++){
					if (oea_aLignes.getCellText(v,'oea-colTypeLigne')!="C") {
			  		listLigneId += oea_aLignes.getCellText(v,'oea-colLigneId')+",";
						if (v>maxIndex) maxIndex = v;
					}
			  }
			}
		}

		if (!isEmpty(listLigneId)) {
			var qDelete = new QueryHttp("Facturation/Avoirs_Fournisseur/supprimerArticle.tmpl");
			qDelete.setParam('List_Ligne_Id', listLigneId);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oea_currentIndex = maxIndex-1;
				oea_ajouterLigne("I");
				oea_aLignes.initTree(oea_afterRefreshArticles);
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oea_appliquerRistourne() {
	try {
		
		var listLigneId = "";
		var maxIndex = 0;

		if (oea_aLignes.isSelected()) {
			var start = new Object();
			var end = new Object();
			var numRanges = oea_aLignes.getRangeCount();

			for (var t=0; t<numRanges; t++){
				oea_aLignes.getRangeAt(t,start,end);
			  for (var v=start.value; v<=end.value; v++){
					if (oea_aLignes.getCellText(v,'oea-colTypeLigne')!="C") {
			  		listLigneId += oea_aLignes.getCellText(v,'oea-colLigneId')+",";
						if (v>maxIndex) maxIndex = v;
					}
			  }
			}
		}

		if (!isEmpty(listLigneId)) {
			var url = "chrome://opensi/content/facturation/user/commun/popup-applicationRistourne.xul";
			window.openDialog(url,'','chrome,modal,centerscreen', "AF", listLigneId);

			oea_currentIndex = maxIndex;
			oea_ajouterLigne("I");
			oea_aLignes.initTree(oea_afterRefreshArticles);
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oea_enregistrerAvoir() {
  try {

  	var ok = false;

    var fraisPort = document.getElementById('oea-fraisPort').value;
		var escompte = document.getElementById('oea-escompte').value;
    var denomination = document.getElementById('oea-denomination').value;
    var adresse1 = document.getElementById('oea-adresse1').value;
    var adresse2 = document.getElementById('oea-adresse2').value;
		var adresse3 = document.getElementById('oea-adresse3').value;
    var cp = document.getElementById('oea-codePostal').value;
    var ville = document.getElementById('oea-ville').value;
		var codePays = document.getElementById('oea-codePays').value;
		var civInter = document.getElementById('oea-civInter').value;
		var nomInter = document.getElementById('oea-nomInter').value;
		var prenomInter = document.getElementById('oea-prenomInter').value;
		var telInter1 = document.getElementById('oea-telInter1').value;
		var telInter2 = document.getElementById('oea-telInter2').value;
		var faxInter = document.getElementById('oea-faxInter').value;
		var emailInter = document.getElementById('oea-emailInter').value;
		var numero = document.getElementById('oea-numAvoir').value;
		var dateAvoir = document.getElementById('oea-dateAvoir').value;
		var typeRectificatif = document.getElementById('oea-typeRectificatif').checked;
		var etablissement = document.getElementById('oea-etablissement').value;
		var secteurActivite = document.getElementById('oea-secteur').value;
		var responsable = document.getElementById('oea-responsable').value;
		var commentairesFin = document.getElementById('oea-commentairesFin').value;
		var commentairesInt = document.getElementById('oea-commentairesInt').value;

		var remise = document.getElementById('oea-remise').value;
	  var remiseFP = document.getElementById('oea-remiseFP').value;
		var tauxRemise = 0;
		var montantRemise = 0;
		var tauxRemiseFP = 0;
		var montantRemiseFP = 0;

		var montantBase = oea_montantHT;

		oea_codeTVAPort = document.getElementById('oea-codeTVAFraisPort').value;
		oea_tauxTVAPort = getTva(oea_codeTVAPort);

		if (isEmpty(denomination)) { showWarning("Veuillez saisir la d\u00E9nomination du fournisseur !"); }
		else if (isEmpty(adresse1)) { showWarning("Veuillez saisir l'adresse du fournisseur !"); }
		else if (isEmpty(ville)) { showWarning("Veuillez saisir la ville du fournisseur !"); }
		else if (isEmpty(remise) || (oea_typeRemise=='P'?!isTaux(remise):!isPositiveOrNull(remise) || !checkNumber(remise,9,2) || parseFloat(remise)>montantBase)) { showWarning("Remise incorrecte !"); }
		else if (isEmpty(fraisPort) || !isPositiveOrNull(fraisPort)) { showWarning("Frais de port incorrects !"); }
		else if (isEmpty(remiseFP) || (oea_typeRemiseFP=='P'?!isTaux(remiseFP):!isPositiveOrNull(remiseFP) || !checkNumber(remiseFP,9,2) || parseFloat(remiseFP)>parseFloat(fraisPort))) { showWarning("Remise sur frais de port incorrecte !"); }
    else if (isEmpty(escompte) || !isTaux(escompte)) { showWarning("Taux d'escompte incorrect !"); }
    else if (isEmpty(numero)) { showWarning("Num\u00E9ro de l'avoir incorrect !"); }
		else if (isEmpty(dateAvoir) || !isDate(dateAvoir)) { showWarning("Date de l'avoir incorrecte !"); }
		else if (!isEmpty(telInter1) && !isPhone(telInter1)) { showWarning("T\u00E9l\u00E9phone 1 de facturation incorrect !"); }
		else if (!isEmpty(telInter2) && !isPhone(telInter2)) { showWarning("T\u00E9l\u00E9phone 2 de facturation incorrect !"); }
		else if (!isEmpty(faxInter) && !isPhone(faxInter)) { showWarning("Num\u00E9ro de fax de facturation incorrect !"); }
		else if (!isEmpty(emailInter) && !isEmail(emailInter)) { showWarning("Adresse e-mail de facturation incorrecte !"); }
 		else {

			fraisPort = parseFloat(fraisPort);
			remise = parseFloat(remise);
			remiseFP = parseFloat(remiseFP);

			var qEnregistrer;

			if (oea_mode=="C") {
			  qEnregistrer = new QueryHttp("Facturation/Avoirs_Fournisseur/creerAvoir.tmpl");
			}
			else {
			  qEnregistrer = new QueryHttp("Facturation/Avoirs_Fournisseur/modifierAvoir.tmpl");
				qEnregistrer.setParam("Avoir_Id", oea_avoirId);
			}

			if (oea_typeRemise=='P') {
				tauxRemise = remise;
			}
			else {
				tauxRemise = (montantBase>0?remise/montantBase*100:0);
				montantRemise = remise;
			}

			if (oea_typeRemiseFP=='P') {
				tauxRemiseFP = remiseFP;
			}
			else {
				tauxRemiseFP = (fraisPort>0?remiseFP/fraisPort*100:0);
				montantRemiseFP = remiseFP;
			}

			qEnregistrer.setParam("Fournisseur_Id", oea_fournisseurId);
			qEnregistrer.setParam("PRemise", tauxRemise);
			qEnregistrer.setParam("MRemise", montantRemise);
			qEnregistrer.setParam("PRemise_FP", tauxRemiseFP);
			qEnregistrer.setParam("MRemise_FP", montantRemiseFP);
			qEnregistrer.setParam("Date_Avoir", dateAvoir);
			qEnregistrer.setParam("Etab_Id", etablissement);
			qEnregistrer.setParam("Numero", numero);
			qEnregistrer.setParam("Denomination", denomination);
			qEnregistrer.setParam("Adresse_1", adresse1);
			qEnregistrer.setParam("Adresse_2", adresse2);
			qEnregistrer.setParam("Adresse_3", adresse3);
			qEnregistrer.setParam("Code_Postal", cp);
			qEnregistrer.setParam("Ville", ville);
			qEnregistrer.setParam("Code_Pays", codePays);
			qEnregistrer.setParam("Util_R", responsable);
			qEnregistrer.setParam("Civ_Inter", civInter);
			qEnregistrer.setParam("Nom_Inter", nomInter);
			qEnregistrer.setParam("Prenom_Inter", prenomInter);
			qEnregistrer.setParam("Tel_Inter_1", telInter1);
			qEnregistrer.setParam("Tel_Inter_2", telInter2);
			qEnregistrer.setParam("Fax_Inter", faxInter);
			qEnregistrer.setParam("Email_Inter", emailInter);
			qEnregistrer.setParam("Code_TVA_Port", oea_codeTVAPort);
			qEnregistrer.setParam("Taux_TVA_Port", oea_tauxTVAPort);
			qEnregistrer.setParam("Pole_Activite", secteurActivite);
			qEnregistrer.setParam("Frais_Port", fraisPort);
			qEnregistrer.setParam("Escompte", escompte);
			qEnregistrer.setParam("Type_Rectificatif", typeRectificatif);
			qEnregistrer.setParam("Commentaires_Fin", commentairesFin);
			qEnregistrer.setParam("Commentaires_Int", commentairesInt);
			var result = qEnregistrer.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var contenu = result.responseXML.documentElement;

				if (oea_mode=="C") {
					oea_avoirId = contenu.getAttribute("Avoir_Id");
					oea_aLignes.setParam("Avoir_Id", oea_avoirId);
					oea_chargerAvoir();
				}

			  oea_setModifie(false);
			  ok = true;
		  }
		}

    return ok;

	} catch (e) {
  	recup_erreur(e);
	}
}


function oea_calculTotaux() {
  try {

		var fournisseurConnu = (oea_fournisseurId!="");

  	if (oea_mode!='V') {
			document.getElementById('oea-bRechFournisseur').collapsed = (oea_aLignes.nbLignes()>0);
	    document.getElementById('oea-codePays').disabled = (oea_aLignes.nbLignes()>0);
	    document.getElementById('oea-bChercherAdr').disabled = (!fournisseurConnu || oea_aLignes.nbLignes()>0);
		}

		var tauxEscompte = parseFloat(document.getElementById('oea-escompte').value);
		var fraisPort = parseFloat(document.getElementById('oea-fraisPort').value);
		var remise = parseFloat(document.getElementById('oea-remise').value);
		var remiseFP = parseFloat(document.getElementById('oea-remiseFP').value);

		if ((oea_typeRemise=='P'?isTaux(remise):isPositiveOrNull(remise)) && (oea_typeRemiseFP=='P'?isTaux(remiseFP):isPositiveOrNull(remiseFP)) && isTaux(tauxEscompte) && isPositiveOrNull(fraisPort)) {

			var calculDocument = new CalculDocument();
			if (oea_typeRemise=='P') { calculDocument.setRemiseP(remise); }
			else { calculDocument.setRemiseM(remise); }
			calculDocument.setFraisPortBruts(fraisPort);
			if (oea_typeRemiseFP=='P') { calculDocument.setRemiseFPP(remiseFP); }
			else { calculDocument.setRemiseFPM(remiseFP); }
			calculDocument.setCodeAndTauxTVAFP(document.getElementById('oea-codeTVAFraisPort').value, getTva(document.getElementById('oea-codeTVAFraisPort').value));
			calculDocument.setEscompteP(tauxEscompte);

			var nbLignes = oea_aLignes.nbLignes();
			for (var i=0; i<nbLignes; i++) {
				if (oea_aLignes.getCellText(i,'oea-colTypeLigne')!="C") {
					var montantLigne = oea_aLignes.getCellText(i,'oea-colTotal');
					var codeTVA = oea_aLignes.getCellText(i,'oea-colCodeTVA');
					calculDocument.addLigneDocument(montantLigne, codeTVA);
				}
			}

			calculDocument.calculer();

			document.getElementById('oea-montantHT').value = calculDocument.getMontantHT();
			document.getElementById('oea-montantRemise').value = calculDocument.getRemiseM();
			document.getElementById('oea-montantFraisPort').value = calculDocument.getFraisPortBruts();
			document.getElementById('oea-montantRemiseFP').value = calculDocument.getRemiseFPM();
			document.getElementById('oea-totalHT').value = calculDocument.getTotalHT();
			document.getElementById('oea-TVA').value = calculDocument.getTotalTVA();
			document.getElementById('oea-montantEscompte').value = calculDocument.getEscompteM();
			document.getElementById('oea-netCommercial').value = calculDocument.getNetCommercial();
			document.getElementById('oea-totalTTC').value = calculDocument.getTotalTTC();

			oea_montantHT = calculDocument.getMontantHTSansFormat();

			document.getElementById('oea-rowRemiseHT').collapsed = !calculDocument.afficherRemiseM();
			document.getElementById('oea-rowRemiseFPHT').collapsed = !calculDocument.afficherRemiseFPM();
			document.getElementById('oea-rowNetCommercialHT').collapsed = !calculDocument.afficherNetCommercial();
			document.getElementById('oea-rowEscompteHT').collapsed = !calculDocument.afficherEscompteM();
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oea_demandeEnregistrement() {
  try {

		if (oea_modifie) {
			if (window.confirm("Voulez-vous enregistrer les modifications apport\u00E9es \u00E0 l'avoir ?")) {
				oea_enregistrerAvoir();
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oea_afterRefreshArticles() {
	try {

		if (oea_toSelectLigne!=null) {
			for (var i=0; i<oea_aLignes.nbLignes(); i++) {
				if (oea_aLignes.getCellText(i, "oea-colLigneId")==oea_toSelectLigne && oea_aLignes.getCellText(i, "oea-colTypeLigne")!="C") {
					oea_aLignes.select(i);
					break;
				}
			}
			oea_toSelectLigne = null;
		}
		oea_aLignes.ensureRowIsVisible(oea_currentIndex);

		oea_calculTotaux();

	} catch (e) {
  	recup_erreur(e);
	}
}


function oea_evaluer(field, ev) {
	try {

		var val = field.value;

		if (ev.keyCode==13 && !isEmpty(val) && isArithmetic(val)) {
			field.value = calcExpr(val);
		}

	}	catch(e) {
		recup_erreur(e);
	}
}


function oea_pressOnLineNumberField(field, ev) {
	try {

		var val = field.value;

		if (ev.keyCode==13 && !isEmpty(val)) {
			if (isArithmetic(val)) {
				field.value = calcExpr(val);
			}
			else {
				oea_validerLigne();
			}
		}

	}	catch(e) {
		recup_erreur(e);
	}
}


function oea_setModifie(m) {
  try {

  	oea_modifie = m;
  	document.getElementById('oea-bVisualiser').disabled = m;
		document.getElementById('oea-bValiderAvoir').disabled = m;
		if (m) {
			document.getElementById('oea-tabAvoir').setAttribute('image', 'chrome://opensi/content/design/icones/modified.png');
		}
		else {
			document.getElementById('oea-tabAvoir').setAttribute('image', null);
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oea_nouvelAvoir() {
	try {
		oea_mode = "C";
		oea_reinitialiser();
		oea_chargerResponsables(getProfil().getLoggedUser());
		oea_chargerEtablissement(etablissementDefaut);
		oea_chargerPolesActivite("");
		oea_rechargerTVA();
		oea_debloquerChamps();
		oea_typeRistourne = 'P';
		document.getElementById('oea-bRistourne').setAttribute("class", "bIcoPourcentage");
	} catch (e) {
		recup_erreur(e);
	}
}


function oea_visualiserAvoir() {
  try {

  	if (isEmpty(document.getElementById('oea-numAvoir').value)) {
			showWarning("Num\u00E9ro d'avoir incorrect !");
		}
		else {
			var ok = true;
			if (oea_mode=="M") {
				ok = oea_enregistrerAvoir();
			}

			if (ok) {
				if (oea_aLignes.nbLignes()==0 && document.getElementById('oea-fraisPort').value==0) {
					showWarning("L'avoir ne contient aucune ligne !");
				}
				else {

					if (oea_actSuiviSerie) {
						var qCheck = new QueryHttp("Facturation/Avoirs_Fournisseur/checkNumSerieAF.tmpl");
						qCheck.setParam("Avoir_Id", oea_avoirId);
						var result = qCheck.execute();

						var errors = new Errors(result);
						if (errors.hasNext()) {
							errors.show();
							ok = false;
						}
					}

					if (ok && (oea_mode=="V" || window.confirm("Confirmez-vous la g\u00E9n\u00E9ration de l'avoir ?\n(Attention l'avoir g\u00E9n\u00E9r\u00E9 ne pourra plus \u00EAtre modifi\u00E9 !)"))) {

						var qGenPdf = new QueryHttp("Facturation/Factu_Fournisseur/avoir_pdf.tmpl");
						qGenPdf.setParam("Avoir_Id", oea_avoirId);
			      var result = qGenPdf.execute();

						var errors = new Errors(result);
						if (errors.hasNext()) {
							errors.show();
						}
						else {
							document.getElementById('oea-deckAvoir').selectedIndex = 1;
							document.getElementById('bRetourAvoir').collapsed = false;

							var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
			      	document.getElementById('oea-pdfAvoir').setAttribute("src", page);
						}
					}
				}
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oea_supprimerAvoir() {
  try {

		if (window.confirm("Confirmez-vous la suppression de l'avoir ?")) {

			var qSupprimer = new QueryHttp("Facturation/Avoirs_Fournisseur/supprimerAvoir.tmpl");
			qSupprimer.setParam("Avoir_Id", oea_avoirId);
			var result = qSupprimer.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showMessage("L'avoir a \u00E9t\u00E9 supprim\u00E9 !");
			}

			retourMenuFactures();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oea_editerCommentaire() {
  try {

		if (oea_aLignes.isSelected()) {
			var ligneId = oea_aLignes.getSelectedCellText('oea-colLigneId');

			var url = "chrome://opensi/content/facturation/user/commun/popup-commentairesLigne.xul";
    	window.openDialog(url,'','chrome,modal,centerscreen', "AF", ligneId);

    	oea_aLignes.initTree(oea_afterRefreshArticles);
    	oea_ajouterLigne("I");
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oea_editerCommentairesInternes() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-commentairesInternes.xul";
  	window.openDialog(url,'','chrome,modal,centerscreen', "AF", oea_avoirId, false);

	} catch (e) {
    recup_erreur(e);
  }
}


function oea_editerCommentairesDocument() {
  try {

		var commentairesFin = document.getElementById('oea-commentairesFin').value;
		var commentairesInt = document.getElementById('oea-commentairesInt').value;
		var readOnly = (oea_mode=="V");

		var url = "chrome://opensi/content/facturation/user/commun/popup-commentairesDocument.xul";
  	window.openDialog(url,'','chrome,modal,centerscreen', oea_retourEditerCommentaires, "AF", oea_avoirId, commentairesFin, commentairesInt, readOnly);

	} catch (e) {
    recup_erreur(e);
  }
}


function oea_retourEditerCommentaires(commentairesFin, commentairesInt) {
  try {

		document.getElementById('oea-commentairesFin').value = commentairesFin;
		document.getElementById('oea-commentairesInt').value = commentairesInt;

	} catch (e) {
    recup_erreur(e);
  }
}


function oea_choisirMentions() {
  try {

  	var ok = true;

  	if (oea_mode=="C") {
			ok = oea_enregistrerAvoir();
		}

		if (ok) {
			var url = "chrome://opensi/content/facturation/user/commun/popup-mentionsDocument.xul";
    	window.openDialog(url,'','chrome,modal,centerscreen', "AF", oea_avoirId, false);
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function oea_initVersion() {
	try {

		oea_aVersion.setParam("Avoir_Id", oea_avoirId);
		oea_aVersion.initTree();

	} catch (e) {
		recup_erreur(e);
	}
}


function oea_envoyerMail() {
	try {

		var url = "chrome://opensi/content/popup/popup-envoyerMail.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', "AF", oea_avoirId);

	}	catch (e) {
    recup_erreur(e);
  }
}


function oea_checkNumSerieLigne(quantite) {
	try {

		if (oea_actSuiviSerie && !isEmpty(oea_articleId)) {

			var qSuiviSerie = new QueryHttp("Facturation/Articles/getSuiviSerie.tmpl");
			qSuiviSerie.setParam("Article_Id", oea_articleId);
			var result = qSuiviSerie.execute();
			var isSuiviSerie = (result.responseXML.documentElement.getAttribute("Suivi_Serie")=="true") && gConfig.isTracabiliteNSFF();

			var wrongNbSerie = false;

			if (oea_modeLigne=="M") {
			  var qNbSerie = new QueryHttp("Facturation/Avoirs_Fournisseur/getNbNumSerieLigneAF.tmpl");
			  qNbSerie.setParam("Ligne_Id", oea_ligneId);
			  var resNS = qNbSerie.execute();
			  var nb = parseIntBis(resNS.responseXML.documentElement.getAttribute("Nombre"));
			  if ((isSuiviSerie && nb!=quantite) || nb>quantite) {
					wrongNbSerie = true;
			  }
		  }

			if ((oea_modeLigne=="C" && isSuiviSerie) || wrongNbSerie) {
				var url = "chrome://opensi/content/facturation/user/commun/popup-numSerie.xul";
		    window.openDialog(url,'','chrome,modal,centerscreen', "S", "AF", oea_ligneId);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oea_consulterNumSerie() {
	try {

		if (oea_aLignes.isSelected()) {
			var url = "chrome://opensi/content/facturation/user/commun/popup-numSerie.xul";
   		window.openDialog(url,'','chrome,modal,centerscreen', (oea_mode!="V"?"S":"C"), "AF", oea_ligneId);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oea_checkNumLotLigne(numero, datePeremption) {
	try {

		var ok = true;

		if (oea_actSuiviLot && !isEmpty(oea_articleId)) {

			var qSuiviLotDLC = new QueryHttp("Facturation/Articles/getSuiviLotDLC.tmpl");
			qSuiviLotDLC.setParam("Article_Id", oea_articleId);
			var result = qSuiviLotDLC.execute();
			var isSuiviLot = (result.responseXML.documentElement.getAttribute("Suivi_Lot")=="true") && gConfig.isTracabiliteNLFF();
			var isSuiviDLC = (result.responseXML.documentElement.getAttribute("Suivi_DLC")=="true") && gConfig.isTracabiliteNLFF();

			if ((isSuiviLot || !isEmpty(datePeremption)) && isEmpty(numero)) {
				ok = false;
				showWarning("N\u00B0 Lot manquant");
			}
			else if (isSuiviDLC && isEmpty(datePeremption)) {
				ok = false;
				showWarning("Date de p\u00E9remption manquante");
			}
			else if (!isEmpty(datePeremption) && !isDate(datePeremption)) {
				ok = false;
				showWarning("Date de p\u00E9remption incorrecte");
			}
		}

		return ok;

	} catch (e) {
		recup_erreur(e);
	}
}


function oea_onKeyPressNumLot(ev) {
	try {

		if (ev.keyCode==13 && !isEmpty(oea_articleId)) {
			var numero = document.getElementById("oea-numLot").value;

			var url = "chrome://opensi/content/facturation/user/tracabilite_articles/popup-rechercheLot.xul";
			window.openDialog(url,'','chrome,modal,centerscreen', oea_retourRechercherLot, oea_articleId, numero, null, null);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oea_retourRechercherLot(numero, datePeremption) {
	try {

		document.getElementById("oea-numLot").value = numero;
		document.getElementById("oea-datePeremption").value = datePeremption;

	} catch (e) {
		recup_erreur(e);
	}
}


function oea_updateDLC() {
	try {

		var numero = document.getElementById("oea-numLot").value;

		if (!isEmpty(numero) && !isEmpty(oea_articleId)) {
			var qGetDLC = new QueryHttp("Facturation/Tracabilite/getDLCNumLot.tmpl");
			qGetDLC.setParam("Article_Id", oea_articleId);
			qGetDLC.setParam("Numero", numero);
			var result = qGetDLC.execute();
			var datePeremption = result.responseXML.documentElement.getAttribute("Date_Peremption");
			if (!isEmpty(datePeremption)) {
				document.getElementById("oea-datePeremption").value = datePeremption;
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oea_afficherFichiers() {
	try {

 	  var url = "chrome://opensi/content/facturation/user/commun/popup-fichiersAssocies.xul";
   	window.openDialog(url,'','chrome,modal,centerscreen', "AF", oea_avoirId, false);

	} catch (e) {
    recup_erreur(e);
  }
}
