/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

/*
	Arguments du popup :
		- 0 : Fonction de retour
		- 1 : Identifiant fournisseur
		- 2 : Identifiant facture
*/

jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");

var aListBR = new Arbre("Facturation/Factu_Fournisseur/list-bonReceptionAFacturer.tmpl", "listeBR");
var aListCF = new Arbre("Facturation/Factu_Fournisseur/list-commandeFournisseurAFacturer.tmpl", "listeCommandes");
var aArticles = new Arbre("Facturation/Factu_Fournisseur/list-articleAFacturer.tmpl", "articles");

var fournisseurId;
var factureId;



function init() {
  try {

		fournisseurId = window.arguments[1];
		factureId = window.arguments[2];

		aListBR.setParam("Fournisseur_Id", fournisseurId);
		aListCF.setParam("Fournisseur_Id", fournisseurId);

		document.getElementById('grpModeRecherche').value = "B";
		document.getElementById('Numero_BR').focus();
		initCriteres();

  } catch (e) {
    recup_erreur(e);
  }
}


function initCriteres() {
	try {

		document.getElementById('Numero_BR').value = "";
		document.getElementById('Num_Commande').value = "";
		document.getElementById('Num_BL').value = "";
		document.getElementById('Ref_Article').value = "";

		listerDocuments();

	} catch (e) {
		recup_erreur(e);
	}
}


function listerDocuments() {
	try {

		document.getElementById('bOk').disabled = true;
		document.getElementById('listeBR').disabled = true;
		document.getElementById('listeCommandes').disabled = true;
		document.getElementById('articles').disabled = true;
		document.getElementById('bToutCocher').disabled = true;
		document.getElementById('bToutDecocher').disabled = true;
		aArticles.deleteTree();
		aListBR.clearSelection();
		aListBR.deleteTree();
		aListCF.clearSelection();
		aListCF.deleteTree();

		var modeRecherche = document.getElementById('grpModeRecherche').value;
		document.getElementById('boxBR').collapsed = (modeRecherche!="B");
		document.getElementById('boxCommandes').collapsed = (modeRecherche!="C");

		if (modeRecherche=="B") {
			aListBR.setParam("Numero_BR", document.getElementById('Numero_BR').value);
			aListBR.setParam("Num_Commande", document.getElementById('Num_Commande').value);
			aListBR.setParam("Num_BL", document.getElementById('Num_BL').value);
			aListBR.setParam("Ref_Article", document.getElementById('Ref_Article').value);
			aListBR.initTree(retourListerDocuments);
		}
		else {
			aListCF.setParam("Numero_BR", document.getElementById('Numero_BR').value);
			aListCF.setParam("Num_Commande", document.getElementById('Num_Commande').value);
			aListCF.setParam("Num_BL", document.getElementById('Num_BL').value);
			aListCF.setParam("Ref_Article", document.getElementById('Ref_Article').value);
			aListCF.initTree(retourListerDocuments);
		}

  } catch (e) {
    recup_erreur(e);
  }
}


function retourListerDocuments() {
	try {

		document.getElementById('bOk').disabled = false;
		document.getElementById('listeBR').disabled = false;
		document.getElementById('listeCommandes').disabled = false;
		document.getElementById('articles').disabled = false;
		document.getElementById('bToutCocher').disabled = false;
		document.getElementById('bToutDecocher').disabled = false;

		var modeRecherche = document.getElementById('grpModeRecherche').value;

		if (modeRecherche=="B") {
			if (aListBR.nbLignes()==1) {
				aListBR.select(0);
			}
		}
		else {
			if (aListCF.nbLignes()==1) {
				aListCF.select(0);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnCritere(ev) {
  try {

		if (ev.keyCode==13) {
			listerDocuments();
    }

  } catch (e) {
    recup_erreur(e);
  }
}


function choixCommande() {
	try {

		if (aListCF.isSelected()) {
			var listId = "";
			var start = new Object();
			var end = new Object();
			var numRanges = aListCF.getRangeCount();

			for (var t=0; t<numRanges; t++){
				aListCF.getRangeAt(t,start,end);
			  for (var v=start.value; v<=end.value; v++){
			  	listId += aListCF.getCellText(v,'colCommandeIdMC')+",";
			  }
			}

			chargerArticles(listId, "C");
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function choixBR() {
	try {

		if (aListBR.isSelected()) {
			var listId = "";
			var start = new Object();
			var end = new Object();
			var numRanges = aListBR.getRangeCount();

			for (var t=0; t<numRanges; t++){
			  aListBR.getRangeAt(t,start,end);
			  for (var v=start.value; v<=end.value; v++){
			  	listId += aListBR.getCellText(v,'colBonRecIdMB')+",";
			  }
			}

			chargerArticles(listId, "B");
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function chargerArticles(listId, typeList) {
	try {

		if (!isEmpty(listId)) {
			aArticles.clearParams();
			aArticles.setParam("List_Id", listId);
			aArticles.setParam("Type_List", typeList);
			aArticles.initTree();
		}
		else {
			// Franck : Cas d'une dslection complte en mode multi slection de ligne de la liste BR ou CF (touche ctrl enfonce), le isSelected arrive  passer
			aArticles.deleteTree();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function toutCocher(b) {
	try {

		for (var i=0; i<aArticles.nbLignes(); i++) {
			aArticles.setCellValue(i, "colSelect", b);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function choixArticle() {
	try {

		var listLigneId = "";

		for (var i=0; i<aArticles.nbLignes(); i++) {
			if (aArticles.getCellValue(i, "colSelect")=="true") {
				listLigneId += aArticles.getCellText(i, "colLigne_Id") +",";
			}
  	}

		if (isEmpty(listLigneId)) {
			showWarning("Veuillez cocher au moins une ligne");
		}
		else {
			var qAjArtBon = new QueryHttp("Facturation/Factu_Fournisseur/addLigneFactureFournisseurByLigneBR.tmpl");
			qAjArtBon.setParam('Facture_Id', factureId);
			qAjArtBon.setParam('List_Ligne_Id', listLigneId);
			qAjArtBon.execute();

			window.arguments[0]();
			window.close();
		}

	} catch (e) {
    recup_erreur(e);
	}
}
