/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

/*
	Arguments du popup :
		- 0 : Fonction de retour
		- 1 : Facture_Id
		- 2 : Modifiable (true/false)
*/

jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/formatter.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arrondi.js");


var factureId;
var modifiable;
var chargerModeReg;
var montantNet;
var totalEcheances;
var totalRestant;
var currentEcheance;
var modifie = false;
var chargement = true;

var nf = new NumberFormat("0.00");
var nf2 = new NumberFormat("0.00", true);

var aListeEcheances = new Arbre('Facturation/FacturesVente/list-echeanceFactureClient.tmpl', 'listeEcheances');
var aModesReglements = new Arbre('ComboListe/combo-modesReglement.tmpl', 'Mode_Reg');



function init() {
	try {

		window.parent.addEventListener("close", majParentOnClose, false);

		factureId = window.arguments[1];
		modifiable = window.arguments[2];

		if (!modifiable) {
			document.getElementById('boxModification').collapsed = true;
		}

		var qGet = new QueryHttp("Facturation/FacturesVente/getMontantNet.tmpl");
		qGet.setParam("Facture_Id", factureId);
		var result = qGet.execute();

		montantNet = parseFloat(result.responseXML.documentElement.getAttribute("Montant_Net"));
		document.getElementById('montantNet').value = nf2.format(montantNet);

		aListeEcheances.setParam("Facture_Id", factureId);
		aListeEcheances.initTree(initLigne);

	} catch (e) {
		recup_erreur(e);
	}
}


function chargerModesReglements(selection) {
	try {

		chargerModeReg = selection;
		aModesReglements.setParam("Selection", chargerModeReg);
		aModesReglements.initTree(initModeReglement);

	} catch (e) {
		recup_erreur(e);
	}
}


function initModeReglement() {
	try {

    document.getElementById('Mode_Reg').value = chargerModeReg;

	} catch (e) {
    recup_erreur(e);
  }
}


function selectOnListeEcheances() {
	try {

		if (modifiable && aListeEcheances.isSelected()) {
			var i = aListeEcheances.getCurrentIndex();
			document.getElementById('bSupprimer').disabled = (i==0);
			currentEcheance = aListeEcheances.getCellText(i, 'colEcheanceId');
			document.getElementById('Date_Echeance').value = aListeEcheances.getCellText(i, 'colDateEcheance');
			document.getElementById('Montant').value = aListeEcheances.getCellText(i, 'colMontant');
			chargerModesReglements(aListeEcheances.getCellText(i, 'colModeRegId'));
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function calculerTotalEcheances() {
	try {

		var r2 = new Arrondi(2);
		totalEcheances = 0;
		var nbLignes = aListeEcheances.nbLignes();
		for (var i=0; i<nbLignes; i++) {
			totalEcheances = r2.round(totalEcheances + parseFloat(aListeEcheances.getCellText(i, 'colMontant')));
		}

		totalRestant = r2.round(montantNet - totalEcheances);
		document.getElementById('totalEcheances').value = nf2.format(totalEcheances);
		document.getElementById('totalRestant').value = nf2.format(totalRestant);

	} catch (e) {
		recup_erreur(e);
	}
}


function initLigne() {
	try {

		calculerTotalEcheances();

		if (chargement && aListeEcheances.nbLignes()==1) {
			chargement = false;
			aListeEcheances.select(0);
			selectOnListeEcheances();
		}
		else {
			if (aListeEcheances.isSelected()) {
				aListeEcheances.clearSelection();
			}
			currentEcheance = "";
			document.getElementById('bSupprimer').disabled = true;
			if (aListeEcheances.nbLignes()>0) {
				var i = aListeEcheances.nbLignes()-1;
				document.getElementById('Date_Echeance').value = aListeEcheances.getCellText(i, 'colDateEcheance');
				document.getElementById('Montant').value = (totalRestant>0?nf.format(totalRestant):"");
				chargerModesReglements(aListeEcheances.getCellText(i, 'colModeRegId'));
			}
			else { // peut se produire si la facture est paye entirement avec un acompte
				document.getElementById('Date_Echeance').value = "";
				document.getElementById('Montant').value = montantNet;
				chargerModesReglements("");
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function validerLigne() {
	try {

		var dateEcheance = document.getElementById('Date_Echeance').value;
		var modeReglement = document.getElementById('Mode_Reg').value;
		var montant = document.getElementById('Montant').value;

		if (isEmpty(dateEcheance) || !isDate(dateEcheance)) { showWarning("Date d'\u00E9ch\u00E9ance incorrecte !"); }
		else if (isEmpty(montant) || !isPositiveOrNull(montant) || (montantNet!=0 && parseFloat(montant)==0)) { showWarning("Montant incorrect !"); }
		else {

			var qSave;
			if (isEmpty(currentEcheance)) {
				qSave = new QueryHttp("Facturation/FacturesVente/createEcheanceFactureClient.tmpl");
				qSave.setParam("Facture_Id", factureId);
			}
			else {
				qSave = new QueryHttp("Facturation/FacturesVente/updateEcheanceFactureClient.tmpl");
				qSave.setParam("Echeance_Id", currentEcheance);
			}

			qSave.setParam("Date_Echeance", dateEcheance);
			qSave.setParam("Mode_Reg_Id", modeReglement);
			qSave.setParam("Montant", montant);
			qSave.execute();

			aListeEcheances.initTree(initLigne);
			modifie = true;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function supprimerLigne() {
	try {

		if (window.confirm("Confirmez-vous la suppression de l'\u00E9ch\u00E9ance ?")) {
			var qDelete = new QueryHttp("Facturation/FacturesVente/deleteEcheanceFactureClient.tmpl");
			qDelete.setParam("Echeance_Id", currentEcheance);
			qDelete.execute();

			aListeEcheances.initTree(initLigne);
			modifie = true;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function evaluer(field, ev) {
	try {
	
		var val = field.value;

		if (ev.keyCode==13 && !isEmpty(val) && isArithmetic(val)) {
			field.value = calcExpr(val);		
		}

	}	catch(e) {
		recup_erreur(e);
	}
}


function reinitialiser() {
	try {

		if (window.confirm("Voulez-vous r\u00E9initialiser les \u00E9ch\u00E9ances ?")) {
			var qReset = new QueryHttp("Facturation/FacturesVente/resetEcheancesFacture.tmpl");
			qReset.setParam("Facture_Id", factureId);
			qReset.execute();
			aListeEcheances.initTree(initLigne);
			modifie = true;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function checkEcheances() {
	try {

		var ok = false;

		if (!modifiable) {
			ok = true;
		}
		else {
	  	var qCheck = new QueryHttp("Facturation/FacturesVente/checkEcheancesFacture.tmpl");
	  	qCheck.setParam("Facture_Id", factureId);
			var result = qCheck.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				ok = true;
			}
		}

		return ok;

	} catch (e) {
		recup_erreur(e);
	}
}


function majParent() {
	try {

		if (checkEcheances()) {
			if (modifie) {
				window.arguments[0]();
				modifie = false;
			}
			window.close();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function majParentOnClose() {
	try {

		checkEcheances();
		if (modifie) { window.arguments[0](); }

	} catch (e) {
		recup_erreur(e);
	}
}


