/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/formatter.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/banques.js");


var gProfil;



function init() {
  try {

  	window.parent.addEventListener("close", demandeEnregistrement, false);

		gProfil = getProfil();

		document.getElementById('deck').selectedIndex = 0;
  	omf_init();
  	off_init();

	} catch (e) {
    recup_erreur(e);
  }
}


function desinit() {
	try {

		window.parent.removeEventListener("close", demandeEnregistrement, false);

	} catch (e) {
    recup_erreur(e);
  }
}



function demandeEnregistrement() {
	try {

		var currentDeck = parseIntBis(document.getElementById('deck').selectedIndex);

		if (currentDeck==1) {
			off_demandeEnregistrement();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function retourMenuFournisseurs() {
	try {

		document.getElementById('off-pdfFournisseur').setAttribute("src", "");
		document.getElementById('deck').selectedIndex = 0;
		document.getElementById('bMenuFournisseurs').collapsed = true;

		document.activeElement.blur();
		omf_listerFournisseurs();

	} catch (e) {
    recup_erreur(e);
  }
}


function retourFicheFournisseur() {
  try {

		document.getElementById('off-pdfFournisseur').setAttribute("src", "");
		document.getElementById('deck').selectedIndex = 1;
		document.getElementById('off-deckFournisseur').selectedIndex = 0;
		document.getElementById('bMenuFournisseurs').collapsed = false;

	} catch (e) {
    recup_erreur(e);
  }
}


function retourMenuPrincipal() {
	try {

		window.location = "chrome://opensi/content/facturation/user/menu_principal.xul";

	} catch (e) {
    recup_erreur(e);
  }
}
