/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

var omf_aFournisseurs = new Arbre("Facturation/Fournisseurs/list-ficheFournisseur.tmpl", "omf-listeFournisseurs");
var omf_qListFF = new QueryHttp("Facturation/Fournisseurs/getDataListFF.tmpl");

var omf_pageCourante;
var omf_nbPages;



function omf_init() {
	try {

		var aFamilles = new Arbre('ComboListe/combo-famillesFournisseur.tmpl', 'omf-famille');
		aFamilles.initTree();

		var aPays = new Arbre("ComboListe/combo-pays.tmpl", "omf-pays");
		aPays.initTree();

		document.getElementById('omf-numFournisseur').focus();

		omf_loadChiffresCles();

	} catch (e) {
		recup_erreur(e);
	}
}


function omf_pressOnNouveauFournisseur() {
	try {

		document.getElementById("bMenuFournisseurs").collapsed = false;
		document.getElementById("deck").selectedIndex = 1;
		off_nouveauFournisseur();

	} catch (e) {
		recup_erreur(e);
	}
}


function omf_initCriteres() {
	try {

		document.getElementById('omf-numFournisseur').value = "";
		document.getElementById('omf-denomination').value = "";
		document.getElementById('omf-contact').value = "";
		document.getElementById('omf-ville').value = "";
		document.getElementById('omf-pays').value = "";
		document.getElementById('omf-famille').value = "";
		document.getElementById('omf-codeCouleur').value = "";
		document.getElementById('omf-actif').checked = true;

		omf_listerFournisseurs();

	} catch (e) {
		recup_erreur(e);
	}
}


function omf_listerFournisseurs() {
	try {

		var numFournisseur = document.getElementById('omf-numFournisseur').value;
		var denomination = document.getElementById('omf-denomination').value;
		var contact = document.getElementById('omf-contact').value;
		var ville = document.getElementById('omf-ville').value;
		var pays = document.getElementById('omf-pays').value;
		var famille = document.getElementById('omf-famille').value;
		var codeCouleur = document.getElementById('omf-codeCouleur').value;
		var actif = document.getElementById('omf-actif').checked;
		var nbLignesParPage = document.getElementById('omf-nbLignesParPage').value;

		omf_pageCourante = 1;
		omf_nbPages = 1;
		document.getElementById('omf-pageDeb').value = 1;
		document.getElementById('omf-pageFin').value = 1;
		document.getElementById('omf-bPrec').disabled = true;
		document.getElementById('omf-bSuiv').disabled = true;

		document.getElementById('omf-listeFournisseurs').disabled = true;
		document.getElementById('omf-bEditionCsv').disabled = true;
		omf_aFournisseurs.deleteTree();

		omf_qListFF.setParam("Num_Fournisseur", numFournisseur);
		omf_qListFF.setParam("Denomination", denomination);
		omf_qListFF.setParam("Contact", contact);
		omf_qListFF.setParam("Ville", ville);
		omf_qListFF.setParam("Pays", pays);
		omf_qListFF.setParam("Famille", famille);
		omf_qListFF.setParam("Code_Couleur", codeCouleur);
		omf_qListFF.setParam("Actif", actif);
		omf_qListFF.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
		omf_qListFF.setParam("Current_Page", omf_pageCourante);

		var result = omf_qListFF.execute();

		var contenu = result.responseXML.documentElement;

		omf_nbPages = contenu.getAttribute("Nb_Pages");
		var listFournisseurId = contenu.getAttribute("List_Fournisseur_Id");

		omf_aFournisseurs.setParam("List_Fournisseur_Id", listFournisseurId);
		omf_aFournisseurs.initTree(omf_initPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function omf_initPagination() {
	try {

		document.getElementById('omf-pageDeb').value = omf_pageCourante;
		document.getElementById('omf-pageFin').value = (omf_nbPages>0?omf_nbPages:1);
		document.getElementById('omf-bPrec').disabled = (omf_pageCourante==1);
		document.getElementById('omf-bSuiv').disabled = (omf_pageCourante>=omf_nbPages); // peut se produire si omf_nbPages=0

		omf_afterMajPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function omf_pressOnPagePrec() {
	try {

		omf_pageCourante--;
		omf_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function omf_pressOnPageSuiv() {
	try {

		omf_pageCourante++;
		omf_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function omf_majPagination() {
	try {

		document.getElementById('omf-pageDeb').value = omf_pageCourante;
		document.getElementById('omf-bPrec').disabled = (omf_pageCourante==1);
		document.getElementById('omf-bSuiv').disabled = (omf_pageCourante==omf_nbPages);

		document.getElementById('omf-listeFournisseurs').disabled = true;
		document.getElementById('omf-bEditionCsv').disabled = true;

		omf_qListFF.setParam("Current_Page", omf_pageCourante);
		var result = omf_qListFF.execute();
		var listFournisseurId = result.responseXML.documentElement.getAttribute("List_Fournisseur_Id");

		omf_aFournisseurs.setParam("List_Fournisseur_Id", listFournisseurId);
		omf_aFournisseurs.initTree(omf_afterMajPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function omf_afterMajPagination() {
	try {

		document.getElementById('omf-listeFournisseurs').disabled = false;
		document.getElementById('omf-bEditionCsv').disabled = (omf_aFournisseurs.nbLignes()==0);

	} catch (e) {
		recup_erreur(e);
	}
}


function omf_pressOnCritere(ev) {
  try {

		if (ev.keyCode==13) {
			omf_listerFournisseurs();
    }

	} catch (e) {
  	recup_erreur(e);
  }
}


function omf_pressOnListeFournisseurs(ev) {
	try {

		if (ev.keyCode==13) {
			omf_ouvrirFournisseur();
    }

	} catch (e) {
		recup_erreur(e);
	}
}


function omf_ouvrirFournisseur() {
  try {

  	if (omf_aFournisseurs.isSelected()) {

			off_fournisseurId = omf_aFournisseurs.getSelectedCellText('omf-colFournisseurId');
			document.getElementById('bMenuFournisseurs').collapsed = false;

			off_chargerFournisseur();

			document.getElementById('deck').selectedIndex = 1;
  	}

	} catch (e) {
  	recup_erreur(e);
  }
}


function omf_pressOnEditionCsv() {
	try {

		var numFournisseur = document.getElementById('omf-numFournisseur').value;
		var denomination = document.getElementById('omf-denomination').value;
		var contact = document.getElementById('omf-contact').value;
		var ville = document.getElementById('omf-ville').value;
		var pays = document.getElementById('omf-pays').value;
		var famille = document.getElementById('omf-famille').value;
		var codeCouleur = document.getElementById('omf-codeCouleur').value;
		var actif = document.getElementById('omf-actif').checked;

		var qEditionCsv = new QueryHttp("Facturation/Fournisseurs/csvFicheFournisseur.tmpl");
		qEditionCsv.setParam("Num_Fournisseur", numFournisseur);
		qEditionCsv.setParam("Denomination", denomination);
		qEditionCsv.setParam("Contact", contact);
		qEditionCsv.setParam("Ville", ville);
		qEditionCsv.setParam("Pays", pays);
		qEditionCsv.setParam("Famille", famille);
		qEditionCsv.setParam("Code_Couleur", codeCouleur);
		qEditionCsv.setParam("Actif", actif);

		var result = qEditionCsv.execute();
		var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');

		var file = fileChooser("save", fichier);
		if (file!=null) {
			downloadFile(getDirBuffer()+ fichier, file);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omf_loadChiffresCles() {
	try {

		var qStats = new QueryHttp("Facturation/Fournisseurs/getStatsFicheFournisseur.tmpl");
		var result = qStats.execute();
		var contenu = result.responseXML.documentElement;

		document.getElementById("omf-nbFFTotal").value = contenu.getAttribute("Nb_FF_Total");
		document.getElementById("omf-nbFFTotalActif").value = contenu.getAttribute("Nb_FF_Total_Actif");

	} catch (e) {
		recup_erreur(e);
	}
}
