/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var omt_typeTarif;
var omt_tarifId;
var omt_element;
var omt_varMontant;
var omt_varPourcentage;
var omt_varPAFournisseur;
var omt_varPACUMP;
var omt_nouvelleValeur;
var omt_typeArrondi;
var omt_valArrondi;
var omt_modeArrondi;
var omt_appArrondi;
var omt_calcForfait;
var omt_calcForfaitPA;

var omt_chkPAFRem;
var omt_chkSpec;
var omt_chkRepercussion;

var omt_refArticle;
var omt_refModele;
var omt_famille1;
var omt_famille2;
var omt_famille3;
var omt_marque;
var omt_fournisseur;

var omt_aFamille1 = new Arbre('ComboListe/combo-famillesArticle.tmpl', 'omt-famille1');
var omt_aFamille2 = new Arbre('ComboListe/combo-famillesArticle.tmpl', 'omt-famille2');
var omt_aFamille3 = new Arbre('ComboListe/combo-famillesArticle.tmpl', 'omt-famille3');
var omt_aMarques = new Arbre("ComboListe/combo-marquesArticle.tmpl", "omt-listeMarques");
var omt_aFournisseurs = new Arbre("Facturation/MajTarifs/combo-fournisseursMT.tmpl", "omt-listeFournisseurs");
var omt_aPrixArticle = new Arbre("Facturation/MajTarifs/list-majPrixArticle.tmpl", "omt-listePrixArticle");
var omt_aPrixClient = new Arbre("Facturation/MajTarifs/list-majPrixClient.tmpl", "omt-listePrixClient");
var omt_qListPA = new QueryHttp("Facturation/MajTarifs/getDataListPA.tmpl");
var omt_qListPC = new QueryHttp("Facturation/MajTarifs/getDataListPC.tmpl");

var omt_pageCourante;
var omt_nbPages;



function omt_initMajTarifs() {
	try {

		document.getElementById("omt-bReporter").disabled = true;

		var aTarifsVente = new Arbre("ComboListe/combo-tarifsVente.tmpl", "omt-tarifId");
		aTarifsVente.initTree(omt_defaultBoxOperation);

		omt_aFamille1.initTree(omt_initFamille1);

	}	catch(e){
		recup_erreur(e);
	}
}


function omt_initFamille1() {
  try {

		document.getElementById('omt-famille1').selectedIndex = 0;
		omt_aMarques.initTree(omt_initMarques);

	} catch (e) {
		recup_erreur(e);
	}
}


function omt_initMarques() {
	try {

		document.getElementById("omt-listeMarques").selectedIndex = 0;
		omt_aFournisseurs.initTree(omt_initFournisseurs);

	} catch (e) {
		recup_erreur(e);
	}
}

function omt_initFournisseurs() {
	try {

		document.getElementById("omt-listeFournisseurs").selectedIndex = 0;

	} catch (e) {
		recup_erreur(e);
	}
}


function omt_chargerFamilles2() {
	try {

		if (!isEmpty(document.getElementById('omt-famille1').value)) {
			omt_aFamille2.setParam('Parent_Id', document.getElementById('omt-famille1').value);
			omt_aFamille2.initTree(omt_initFamille2);
		}
		else {
			omt_aFamille2.deleteTree();
			omt_initFamille2();
		}

		omt_initFamille3();

	} catch (e) {
		recup_erreur(e);
	}
}


function omt_initFamille2() {
  try {

		document.getElementById('omt-famille2').selectedIndex = 0;

	} catch (e) {
		recup_erreur(e);
	}
}


function omt_chargerFamilles3() {
	try {

		if (!isEmpty(document.getElementById('omt-famille2').value)) {
			omt_aFamille3.setParam('Parent_Id', document.getElementById('omt-famille2').value);
			omt_aFamille3.initTree(omt_initFamille3);
		}
		else {
			omt_aFamille3.deleteTree();
			omt_initFamille3();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omt_initFamille3() {
  try {

		document.getElementById('omt-famille3').selectedIndex = 0;

	} catch (e) {
		recup_erreur(e);
	}
}


function omt_defaultBoxOperation() {
	try {

		document.getElementById("omt-typeTarif").value = "G";
		document.getElementById("omt-rgpElement").value = gConfig.getGDTElementAModifier();
		document.getElementById("omt-rgpElementTS").value = "0";
		document.getElementById("omt-tarifId").value = gConfig.getGDTTarifImpacte();
		document.getElementById("omt-varPourcentage").value = "";
		document.getElementById("omt-varMontant").value = "";
		document.getElementById("omt-varPAFournisseur").value = 0;
		document.getElementById("omt-typeVariation").value = 0;
		document.getElementById("omt-chkPAFRem").checked = false;
		document.getElementById("omt-nouvelleValeur").value = "";
		document.getElementById("omt-chkRepercussion").checked = true;
		document.getElementById("omt-chkSpec").checked = false;
		document.getElementById("omt-typeArrondi").value = "";
		document.getElementById("omt-valArrondi").value = "";
		document.getElementById("omt-modeArrondi").value = "S";
		document.getElementById("omt-appArrondi").value = 0;
		document.getElementById("omt-chkCalcForfait").checked = false;
		document.getElementById("omt-chkCalcForfaitPA").checked = false;

		omt_initBoxOperation();

	} catch (e) {
		recup_erreur(e);
	}
}


function omt_initBoxOperation() {
	try {

		var typeTarif = document.getElementById("omt-typeTarif").value;
		var elem = (typeTarif=="G"?document.getElementById("omt-rgpElement").value:document.getElementById("omt-rgpElementTS").value);

		document.getElementById('omt-listePrixArticle').collapsed = typeTarif!="G";
		document.getElementById('omt-listePrixClient').collapsed = typeTarif=="G";

		document.getElementById("omt-boxReport").collapsed = (typeTarif=="S");

		document.getElementById("omt-aidePV").collapsed = (elem=="2" || elem=="3" || elem=="5");
		document.getElementById("omt-aideCoeff").collapsed = (typeTarif=="S" || elem!="2");
		document.getElementById("omt-aidePourcPV").collapsed = (typeTarif=="G" || elem!="2");
		document.getElementById("omt-aideTauxMarque").collapsed = (elem!="3");
		document.getElementById("omt-aideTauxMarge").collapsed = (elem!="5");

		document.getElementById("omt-rowRepercussion").collapsed = (elem!="4" || typeTarif=="S");
		document.getElementById("omt-rowSpec").collapsed = (typeTarif=="S" || (elem=="4" && !document.getElementById("omt-chkRepercussion").checked));
		document.getElementById("omt-fournisseur").collapsed = (elem!="4" || typeTarif=="S");

		document.getElementById("omt-rowVariation").collapsed = (elem=="2" || elem=="3" || elem=="5");
		document.getElementById("omt-rowNouvelleValeur").collapsed = (elem!="2" && elem!="3" && elem!="5");

		document.getElementById("omt-rowElement").collapsed = (typeTarif=="S");
		document.getElementById("omt-rowElementTS").collapsed = (typeTarif=="G");
		document.getElementById("omt-rowTarif").collapsed = (typeTarif=="G" && elem=="4");

		document.getElementById("omt-lblTarifImp").collapsed = (typeTarif=="S");
		document.getElementById("omt-lblTarifRef").collapsed = (typeTarif=="G");

		document.getElementById("omt-boxVarPAFournisseur").collapsed = (elem!="4");
		document.getElementById("omt-boxVarPACUMP").collapsed = (elem!="4");
		if (elem!=4 && document.getElementById("omt-typeVariation").value>=2) {
			document.getElementById("omt-typeVariation").value = 0;
			omt_pressOnTypeVariation();
		}

		if (elem==4 && !document.getElementById("omt-chkRepercussion").checked) {
			document.getElementById("omt-typeArrondi").value = "";
			omt_changeTypeArrondi();
		}

		document.getElementById("omt-rowArrondi").collapsed = (elem=="4" && !document.getElementById("omt-rowRepercussion").collapsed && !document.getElementById("omt-chkRepercussion").checked);
		document.getElementById("omt-lblTerminant").collapsed = (document.getElementById("omt-typeArrondi").value!="P");
		document.getElementById("omt-rowAppArrondi").collapsed = document.getElementById("omt-rowArrondi").collapsed || isEmpty(document.getElementById("omt-typeArrondi").value);

		document.getElementById("omt-rowCalcForfait").collapsed = (typeTarif=="S" || (elem=="4" && !document.getElementById("omt-chkRepercussion").checked));
		document.getElementById("omt-rowCalcForfaitPA").collapsed = (typeTarif=="S" || elem!="4");

		omt_desactiverValidation();

	}	catch(e) {
		recup_erreur(e);
	}
}


function omt_pressOnFamille1() {
	try {

		omt_chargerFamilles2();
		omt_desactiverValidation();

	} catch (e) {
		recup_erreur(e);
	}
}


function omt_pressOnFamille2() {
	try {

		omt_chargerFamilles3();
		omt_desactiverValidation();

	} catch (e) {
		recup_erreur(e);
	}
}


function omt_pressOnTypeVariation() {
	try {

		var typeVariation = document.getElementById("omt-typeVariation").value;
		document.getElementById("omt-varPourcentage").disabled = (typeVariation!="0");
		document.getElementById("omt-varMontant").disabled = (typeVariation!="1");
		document.getElementById("omt-varPourcentage").value = "";
		document.getElementById("omt-varMontant").value = "";
		document.getElementById("omt-varPAFournisseur").disabled = (typeVariation!="2");
		document.getElementById("omt-chkPAFRem").disabled = (typeVariation!="2");
		if (typeVariation!="2") {
			document.getElementById("omt-varPAFournisseur").value = 0;
			document.getElementById("omt-chkPAFRem").checked = false;
		}
		omt_desactiverValidation();

	}	catch(e){
		recup_erreur(e);
	}
}


function omt_changeTypeArrondi() {
	try {

		var typeArrondi = document.getElementById("omt-typeArrondi").value;
		document.getElementById("omt-boxArrondi").collapsed = isEmpty(typeArrondi);
		document.getElementById("omt-valArrondi").value = "";
		document.getElementById("omt-lblTerminant").collapsed = (document.getElementById("omt-typeArrondi").value!="P");
		document.getElementById("omt-rowAppArrondi").collapsed = isEmpty(typeArrondi);

	}	catch(e){
		recup_erreur(e);
	}
}


function omt_desactiverValidation() {
	try {

		document.getElementById("omt-bEditionPdf").disabled = true;
		document.getElementById("omt-bEditionCsv").disabled = true;
		document.getElementById("omt-bValider").disabled = true;

		document.getElementById('omt-pageDeb').value = "";
		document.getElementById('omt-pageFin').value = "";
		document.getElementById('omt-bPrec').disabled = true;
		document.getElementById('omt-bSuiv').disabled = true;
		document.getElementById('omt-nbLignesParPage').disabled = true;

		omt_aPrixArticle.deleteTree();
		omt_aPrixClient.deleteTree();

	} catch (e) {
		recup_erreur(e);
	}
}


function omt_listerTarifs() {
	try {

		omt_tarifId = document.getElementById("omt-tarifId").value;
		omt_refArticle = document.getElementById("omt-txtRefArticle").value;
		omt_refModele = document.getElementById("omt-txtRefModele").value;
		omt_famille1 = document.getElementById("omt-famille1").value;
		omt_famille2 = document.getElementById("omt-famille2").value;
		omt_famille3 = document.getElementById("omt-famille3").value;
		omt_marque = document.getElementById("omt-listeMarques").value;
		omt_fournisseur = document.getElementById("omt-listeFournisseurs").value;

		omt_typeTarif = document.getElementById("omt-typeTarif").value;
		omt_element = (omt_typeTarif=="G"?document.getElementById("omt-rgpElement").value:document.getElementById("omt-rgpElementTS").value);
		omt_varPourcentage = document.getElementById("omt-varPourcentage").value;
		omt_varMontant = document.getElementById("omt-varMontant").value;
		omt_varPAFournisseur = document.getElementById("omt-varPAFournisseur").value;
		omt_varPACUMP = document.getElementById("omt-typeVariation").value==3;
		omt_chkPAFRem = document.getElementById("omt-chkPAFRem").checked;
		omt_nouvelleValeur = document.getElementById("omt-nouvelleValeur").value;
		omt_chkRepercussion = document.getElementById("omt-chkRepercussion").checked;
		omt_chkSpec = document.getElementById("omt-chkSpec").checked;
		omt_typeArrondi = document.getElementById("omt-typeArrondi").value;
		omt_valArrondi = document.getElementById("omt-valArrondi").value;
		omt_modeArrondi = document.getElementById("omt-modeArrondi").value;
		omt_appArrondi = document.getElementById("omt-appArrondi").value;
		omt_calcForfait = document.getElementById("omt-chkCalcForfait").checked;
		omt_calcForfaitPA = document.getElementById("omt-chkCalcForfaitPA").checked;

		var nbLignesParPage = document.getElementById('omt-nbLignesParPage').value;
		var isVarPour = !document.getElementById("omt-rowVariation").collapsed && document.getElementById("omt-typeVariation").value == "0";
		var isVarMont = !document.getElementById("omt-rowVariation").collapsed && document.getElementById("omt-typeVariation").value == "1";
		var isTauxMarque = !document.getElementById("omt-rowNouvelleValeur").collapsed && omt_element == "3";
		var isTauxMarge = !document.getElementById("omt-rowNouvelleValeur").collapsed && omt_element == "5";
		var isCoeff = omt_typeTarif=="G" && !document.getElementById("omt-rowNouvelleValeur").collapsed && omt_element == "2";
		var isPourcPV = omt_typeTarif=="S" && !document.getElementById("omt-rowNouvelleValeur").collapsed && omt_element == "2";
		var isArrondi = !document.getElementById("omt-rowArrondi").collapsed;

		if (omt_element=="4") {
			omt_tarifId = "";	// important
		}

		if (isVarPour && (isEmpty(omt_varPourcentage) || !checkNumber(omt_varPourcentage,5,2) || parseFloat(omt_varPourcentage)<-100 || parseFloat(omt_varPourcentage)==0)) {
			showWarning("Variation en pourcentage incorrecte");
		}
		else if (isVarMont && (isEmpty(omt_varMontant) || !checkNumber(omt_varMontant,14,4) || parseFloat(omt_varMontant)==0)) {
			showWarning("Variation en montant incorrecte");
		}
		else if (isCoeff && (isEmpty(omt_nouvelleValeur) || !isPositiveOrNull(omt_nouvelleValeur) || !checkNumber(omt_nouvelleValeur,12,6))) {
			showWarning("Nouvelle valeur de coefficient incorrecte");
		}
		else if (isPourcPV && (isEmpty(omt_nouvelleValeur) || !isPositiveOrNull(omt_nouvelleValeur) || !checkNumber(omt_nouvelleValeur,12,4))) {
			showWarning("Nouvelle valeur de pourcentage incorrecte");
		}
		else if (isTauxMarque && (isEmpty(omt_nouvelleValeur) || !checkNumber(omt_nouvelleValeur,12,6) || parseFloat(omt_nouvelleValeur)>=100)) {
			showWarning("Nouvelle valeur de taux de marque incorrecte");
		}
		else if (isTauxMarge && (isEmpty(omt_nouvelleValeur) || !checkNumber(omt_nouvelleValeur,12,4))) {
			showWarning("Nouvelle valeur de taux de marge incorrecte");
		}
		else if (isArrondi && document.getElementById("omt-typeArrondi").value=="M" && (!isPositive(omt_valArrondi) || !checkNumber(omt_valArrondi,6,4))) {
			showWarning("Valeur d'arrondi multiple incorrecte");
		}
		else if (isArrondi && document.getElementById("omt-typeArrondi").value=="P" && (!isPositive(omt_valArrondi) || !checkNumber(omt_valArrondi,8,4))) {
			showWarning("Valeur d'arrondi psychologique incorrecte");
		}
		else {

			omt_pageCourante = 1;
			omt_nbPages = 1;
			document.getElementById('omt-pageDeb').value = 1;
			document.getElementById('omt-pageFin').value = 1;
			document.getElementById('omt-bPrec').disabled = true;
			document.getElementById('omt-bSuiv').disabled = true;
			document.getElementById('omt-nbLignesParPage').disabled = true;

			document.getElementById('omt-listePrixArticle').disabled = true;
			document.getElementById('omt-listePrixClient').disabled = true;
			document.getElementById('omt-bEditionCsv').disabled = true;
			document.getElementById('omt-bEditionPdf').disabled = true;
			document.getElementById('omt-bValider').disabled = true;
			document.getElementById("omt-bCalculer").disabled = true;
			document.getElementById("omt-bReporter").disabled = true;
			omt_aPrixArticle.deleteTree();
			omt_aPrixClient.deleteTree();

			if (omt_typeTarif=="G") {
				omt_qListPA.setParam("Tarif", omt_tarifId);
				omt_qListPA.setParam("Reference", omt_refArticle);
				omt_qListPA.setParam("Ref_Modele", omt_refModele);
				omt_qListPA.setParam("Famille_1", omt_famille1);
				omt_qListPA.setParam("Famille_2", omt_famille2);
				omt_qListPA.setParam("Famille_3", omt_famille3);
				omt_qListPA.setParam("Marque", omt_marque);
				omt_qListPA.setParam("Fournisseur", omt_fournisseur);

				omt_qListPA.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
				omt_qListPA.setParam("Current_Page", omt_pageCourante);

				var result = omt_qListPA.execute();

				var contenu = result.responseXML.documentElement;

				omt_nbPages = contenu.getAttribute("Nb_Pages");
				var listPrixId = contenu.getAttribute("List_Prix_Id");

				omt_aPrixArticle.setParam("List_Prix_Id", listPrixId);
				omt_aPrixArticle.setParam("Element", omt_element);
				omt_aPrixArticle.setParam("Var_Pourcentage", omt_varPourcentage);
				omt_aPrixArticle.setParam("Var_Montant", omt_varMontant);
				omt_aPrixArticle.setParam("Var_PAFournisseur", omt_varPAFournisseur);
				omt_aPrixArticle.setParam("Var_PACUMP", omt_varPACUMP);
				omt_aPrixArticle.setParam("PAF_Rem", omt_chkPAFRem);
				omt_aPrixArticle.setParam("Nouvelle_Valeur", omt_nouvelleValeur);
				omt_aPrixArticle.setParam("Report_PA", omt_chkRepercussion);
				omt_aPrixArticle.setParam("Report_TS", omt_chkSpec);
				omt_aPrixArticle.setParam("Type_Arrondi", omt_typeArrondi);
				omt_aPrixArticle.setParam("Val_Arrondi", omt_valArrondi);
				omt_aPrixArticle.setParam("Mode_Arrondi", omt_modeArrondi);
				omt_aPrixArticle.setParam("App_Arrondi", omt_appArrondi);
				omt_aPrixArticle.setParam("Calc_Forfait", omt_calcForfait);
				omt_aPrixArticle.setParam("Calc_Forfait_PA", omt_calcForfaitPA);
				omt_aPrixArticle.initTree(omt_initPagination);
			}
			else {
				omt_qListPC.setParam("Tarif", omt_tarifId);
				omt_qListPC.setParam("Reference", omt_refArticle);
				omt_qListPC.setParam("Ref_Modele", omt_refModele);
				omt_qListPC.setParam("Famille_1", omt_famille1);
				omt_qListPC.setParam("Famille_2", omt_famille2);
				omt_qListPC.setParam("Famille_3", omt_famille3);
				omt_qListPC.setParam("Marque", omt_marque);
				omt_qListPC.setParam("Fournisseur", omt_fournisseur);

				omt_qListPC.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
				omt_qListPC.setParam("Current_Page", omt_pageCourante);

				var result = omt_qListPC.execute();

				var contenu = result.responseXML.documentElement;

				omt_nbPages = contenu.getAttribute("Nb_Pages");
				var listPrixId = contenu.getAttribute("List_Prix_Id");

				omt_aPrixClient.setParam("List_Prix_Id", listPrixId);
				omt_aPrixClient.setParam("Element", omt_element);
				omt_aPrixClient.setParam("Var_Pourcentage", omt_varPourcentage);
				omt_aPrixClient.setParam("Var_Montant", omt_varMontant);
				omt_aPrixClient.setParam("Nouvelle_Valeur", omt_nouvelleValeur);
				omt_aPrixClient.setParam("Type_Arrondi", omt_typeArrondi);
				omt_aPrixClient.setParam("Val_Arrondi", omt_valArrondi);
				omt_aPrixClient.setParam("Mode_Arrondi", omt_modeArrondi);
				omt_aPrixClient.setParam("App_Arrondi", omt_appArrondi);
				omt_aPrixClient.initTree(omt_initPagination);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omt_initPagination() {
	try {

		document.getElementById('omt-pageDeb').value = omt_pageCourante;
		document.getElementById('omt-pageFin').value = (omt_nbPages>0?omt_nbPages:1);
		document.getElementById('omt-bPrec').disabled = (omt_pageCourante==1);
		document.getElementById('omt-bSuiv').disabled = (omt_pageCourante>=omt_nbPages); // peut se produire si omt_nbPages=0
		document.getElementById('omt-nbLignesParPage').disabled = false;

		omt_afterMajPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function omt_pressOnPagePrec() {
	try {

		omt_pageCourante--;
		omt_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function omt_pressOnPageSuiv() {
	try {

		omt_pageCourante++;
		omt_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function omt_majPagination() {
	try {

		document.getElementById('omt-pageDeb').value = omt_pageCourante;
		document.getElementById('omt-bPrec').disabled = (omt_pageCourante==1);
		document.getElementById('omt-bSuiv').disabled = (omt_pageCourante==omt_nbPages);
		document.getElementById('omt-nbLignesParPage').disabled = false;

		document.getElementById('omt-listePrixArticle').disabled = true;
		document.getElementById('omt-listePrixClient').disabled = true;
		document.getElementById('omt-bEditionCsv').disabled = true;
		document.getElementById('omt-bEditionPdf').disabled = true;
		document.getElementById('omt-bValider').disabled = true;
		document.getElementById("omt-bCalculer").disabled = true;
		document.getElementById("omt-bReporter").disabled = true;

		if (omt_typeTarif=="G") {
			omt_qListPA.setParam("Current_Page", omt_pageCourante);
			var result = omt_qListPA.execute();
			var listPrixId = result.responseXML.documentElement.getAttribute("List_Prix_Id");

			omt_aPrixArticle.setParam("List_Prix_Id", listPrixId);
			omt_aPrixArticle.initTree(omt_afterMajPagination);
		}
		else {
			omt_qListPC.setParam("Current_Page", omt_pageCourante);
			var result = omt_qListPC.execute();
			var listPrixId = result.responseXML.documentElement.getAttribute("List_Prix_Id");

			omt_aPrixClient.setParam("List_Prix_Id", listPrixId);
			omt_aPrixClient.initTree(omt_afterMajPagination);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omt_afterMajPagination() {
	try {

		document.getElementById('omt-listePrixArticle').disabled = false;
		document.getElementById('omt-listePrixClient').disabled = false;

		if (omt_typeTarif=="G") {
			document.getElementById('omt-bEditionCsv').disabled = (omt_aPrixArticle.nbLignes()==0);
			document.getElementById('omt-bEditionPdf').disabled = (omt_aPrixArticle.nbLignes()==0);
			document.getElementById('omt-bValider').disabled = (omt_aPrixArticle.nbLignes()==0);
		}
		else {
			document.getElementById('omt-bEditionCsv').disabled = (omt_aPrixClient.nbLignes()==0);
			document.getElementById('omt-bEditionPdf').disabled = (omt_aPrixClient.nbLignes()==0);
			document.getElementById('omt-bValider').disabled = (omt_aPrixClient.nbLignes()==0);
		}

		document.getElementById("omt-bCalculer").disabled = false;

	} catch (e) {
		recup_erreur(e);
	}
}


function omt_selectOnListePrixArticle() {
	try {

		if (omt_aPrixArticle.isSelected()) {
			document.getElementById("omt-bReporter").disabled = false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omt_reporter() {
  try {

		if (omt_aPrixArticle.isSelected()) {
			var reportElement = document.getElementById("omt-reportElement").value;
			document.getElementById("omt-rgpElement").value = reportElement;

			var colReport;
			switch(reportElement) {
				case "2":	colReport = "omt-colNvCoeff";				break;
				case "3":	colReport = "omt-colNvTauxMarque";	break;
				case "5":	colReport = "omt-colNvTauxMarge";		break;
			}

			document.getElementById("omt-nouvelleValeur").value = omt_aPrixArticle.getSelectedCellText(colReport);
			omt_initBoxOperation();
			omt_listerTarifs();
		}
		else {
			showWarning("Veuillez s\u00E9lectionner une ligne dans la liste de pr\u00E9visualisation");
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function omt_pressOnEditionPdf() {
	try {

		var qEdit = new QueryHttp("Facturation/MajTarifs/"+ (omt_typeTarif=="G"?"pdfMajPrixArticle.tmpl":"pdfMajPrixClient.tmpl"));

		qEdit.setParam("Tarif", omt_tarifId);
		qEdit.setParam("Reference", omt_refArticle);
		qEdit.setParam("Ref_Modele", omt_refModele);
		qEdit.setParam("Famille_1", omt_famille1);
		qEdit.setParam("Famille_2", omt_famille2);
		qEdit.setParam("Famille_3", omt_famille3);
		qEdit.setParam("Marque", omt_marque);
		qEdit.setParam("Fournisseur", omt_fournisseur);
		qEdit.setParam("Element", omt_element);
		qEdit.setParam("Var_Pourcentage", omt_varPourcentage);
		qEdit.setParam("Var_Montant", omt_varMontant);
		qEdit.setParam("Nouvelle_Valeur", omt_nouvelleValeur);
		qEdit.setParam("Type_Arrondi", omt_typeArrondi);
		qEdit.setParam("Val_Arrondi", omt_valArrondi);
		qEdit.setParam("Mode_Arrondi", omt_modeArrondi);
		qEdit.setParam("App_Arrondi", omt_appArrondi);

		if (omt_typeTarif=="G") {
			qEdit.setParam("Var_PAFournisseur", omt_varPAFournisseur);
			qEdit.setParam("Var_PACUMP", omt_varPACUMP);
			qEdit.setParam("PAF_Rem", omt_chkPAFRem);
			qEdit.setParam("Report_PA", omt_chkRepercussion);
			qEdit.setParam("Report_TS", omt_chkSpec);
			qEdit.setParam("Calc_Forfait", omt_calcForfait);
			qEdit.setParam("Calc_Forfait_PA", omt_calcForfaitPA);
		}

		var result = qEdit.execute();

		var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
		document.getElementById('pdf').setAttribute("src", page);

		document.getElementById("bRetourMajTarifs").collapsed = false;
		document.getElementById("deck").selectedIndex = 1;

	}	catch (e) {
		recup_erreur(e);
	}
}


function omt_pressOnEditionCsv() {
	try {

		var qEdit = new QueryHttp("Facturation/MajTarifs/"+ (omt_typeTarif=="G"?"csvMajPrixArticle.tmpl":"csvMajPrixClient.tmpl"));

		qEdit.setParam("Tarif", omt_tarifId);
		qEdit.setParam("Reference", omt_refArticle);
		qEdit.setParam("Ref_Modele", omt_refModele);
		qEdit.setParam("Famille_1", omt_famille1);
		qEdit.setParam("Famille_2", omt_famille2);
		qEdit.setParam("Famille_3", omt_famille3);
		qEdit.setParam("Marque", omt_marque);
		qEdit.setParam("Fournisseur", omt_fournisseur);
		qEdit.setParam("Element", omt_element);
		qEdit.setParam("Var_Pourcentage", omt_varPourcentage);
		qEdit.setParam("Var_Montant", omt_varMontant);
		qEdit.setParam("Nouvelle_Valeur", omt_nouvelleValeur);
		qEdit.setParam("Type_Arrondi", omt_typeArrondi);
		qEdit.setParam("Val_Arrondi", omt_valArrondi);
		qEdit.setParam("Mode_Arrondi", omt_modeArrondi);
		qEdit.setParam("App_Arrondi", omt_appArrondi);

		if (omt_typeTarif=="G") {
			qEdit.setParam("Var_PAFournisseur", omt_varPAFournisseur);
			qEdit.setParam("Var_PACUMP", omt_varPACUMP);
			qEdit.setParam("PAF_Rem", omt_chkPAFRem);
			qEdit.setParam("Report_PA", omt_chkRepercussion);
			qEdit.setParam("Report_TS", omt_chkSpec);
			qEdit.setParam("Calc_Forfait", omt_calcForfait);
			qEdit.setParam("Calc_Forfait_PA", omt_calcForfaitPA);
		}

		var result = qEdit.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');

			var file = fileChooser("save", fichier);
			if (file!=null) {
				downloadFile(getDirBuffer()+ fichier, file);
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function omt_valider() {
	try {

		if (window.confirm("Attention ! La validation entrainera une mise \u00E0 jour d\u00E9finitive des prix.")) {

			document.getElementById('pmbox').collapsed = false;
			document.getElementById('pm').setAttribute('mode', 'undetermined');

			omt_desactiverValidation();
			document.getElementById('omt-bCalculer').disabled = true;

			var qValid = new QueryHttp("Facturation/MajTarifs/"+ (omt_typeTarif=="G"?"validMajPrixArticle.tmpl":"validMajPrixClient.tmpl"));

			qValid.setParam("Tarif", omt_tarifId);
			qValid.setParam("Reference", omt_refArticle);
			qValid.setParam("Ref_Modele", omt_refModele);
			qValid.setParam("Famille_1", omt_famille1);
			qValid.setParam("Famille_2", omt_famille2);
			qValid.setParam("Famille_3", omt_famille3);
			qValid.setParam("Marque", omt_marque);
			qValid.setParam("Fournisseur", omt_fournisseur);
			qValid.setParam("Element", omt_element);
			qValid.setParam("Var_Pourcentage", omt_varPourcentage);
			qValid.setParam("Var_Montant", omt_varMontant);
			qValid.setParam("Nouvelle_Valeur", omt_nouvelleValeur);
			qValid.setParam("Type_Arrondi", omt_typeArrondi);
			qValid.setParam("Val_Arrondi", omt_valArrondi);
			qValid.setParam("Mode_Arrondi", omt_modeArrondi);
			qValid.setParam("App_Arrondi", omt_appArrondi);

			if (omt_typeTarif=="G") {
				qValid.setParam("Var_PAFournisseur", omt_varPAFournisseur);
				qValid.setParam("Var_PACUMP", omt_varPACUMP);
				qValid.setParam("PAF_Rem", omt_chkPAFRem);
				qValid.setParam("Report_PA", omt_chkRepercussion);
				qValid.setParam("Report_TS", omt_chkSpec);
				qValid.setParam("Calc_Forfait", omt_calcForfait);
				qValid.setParam("Calc_Forfait_PA", omt_calcForfaitPA);
			}

			qValid.execute(omt_validerEnd);
		}

	}	catch(e){
		recup_erreur(e);
	}
}


function omt_validerEnd() {
	try {

		document.getElementById('pm').setAttribute('mode', 'none');
		document.getElementById('pmbox').collapsed = true;

		showMessage("Mise \u00E0 jour termin\u00E9e");

		omt_defaultBoxOperation();
		document.getElementById('omt-bCalculer').disabled = false;

	}	catch(e){
		recup_erreur(e);
	}
}
