/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");


var aFamilles2 = new Arbre('ComboListe/combo-famillesArticle.tmpl', 'famille2');
var aFamilles3 = new Arbre('ComboListe/combo-famillesArticle.tmpl', 'famille3');
var aDepots = new Arbre('ComboListe/combo-depotsStock.tmpl', 'depotStock');
var aZones = new Arbre("ComboListe/combo-zonesStockage.tmpl", "zoneStockage");



function init() {
  try {

		document.getElementById('rowZoneStockage').collapsed = !getConfig().isActEmplacements();

		disableCriteres(true);
		aDepots.initTree();

		var aMarques = new Arbre('ComboListe/combo-marquesArticle.tmpl', 'marque');
		aMarques.setParam("Search_Mode", true);
		aMarques.initTree();

		var aFamilles1 = new Arbre('ComboListe/combo-famillesArticle.tmpl', 'famille1');
		aFamilles1.setParam("Search_Mode", true);
		aFamilles1.initTree();

  } catch (e) {
    recup_erreur(e);
  }
}


function chargerZonesStockage() {
	try {

		var depotId = document.getElementById('depotStock').value;

		if (isEmpty(depotId)) {
			aZones.deleteTree();
			initZone();
		}
		else {
			aZones.setParam("Depot_Id", depotId);
			aZones.initTree(initZone);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function initZone() {
  try {

		document.getElementById('zoneStockage').value = "";

	} catch (e) {
		recup_erreur(e);
	}
}


function chargerFamilles2() {
	try {

		var famille1 = document.getElementById('famille1').value;

		document.getElementById('famille2').value = "";
		document.getElementById('famille2').disabled = isEmpty(famille1);

		aFamilles3.deleteTree();
		document.getElementById('famille3').value = "";
		document.getElementById('famille3').disabled = true;

		aFamilles2.setParam("Search_Mode", true);
		aFamilles2.setParam('Parent_Id', famille1);
		aFamilles2.initTree();

	} catch (e) {
		recup_erreur(e);
	}
}


function chargerFamilles3() {
	try {

		var famille2 = document.getElementById('famille2').value;

		document.getElementById('famille3').value = "";
		document.getElementById('famille3').disabled = isEmpty(famille2);

		aFamilles3.setParam("Search_Mode", true);
		aFamilles3.setParam('Parent_Id', famille2);
		aFamilles3.initTree();

	} catch (e) {
		recup_erreur(e);
	}
}


function disableCriteres(b) {
  try {

		document.getElementById('zoneStockage').disabled = b;
		document.getElementById('codeEmplacement').disabled = b;
		document.getElementById('marque').disabled = b;
		document.getElementById('famille1').disabled = b;

		if (b) {
			document.getElementById('famille2').disabled = true;
			document.getElementById('famille3').disabled = true;
			document.getElementById('zoneStockage').value = "";
			document.getElementById('codeEmplacement').value = "";
			document.getElementById('marque').value = "";
			document.getElementById('famille1').value = "";
			document.getElementById('famille2').value = "";
			document.getElementById('famille3').value = "";
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function valider() {
  try {

		var typeInventaire = document.getElementById('typeInventaire').value;
		var zoneStockage = (typeInventaire=='P'?document.getElementById('zoneStockage').value:"");
		var codeEmplacement = (typeInventaire=='P'?document.getElementById('codeEmplacement').value:"");
		var marque = (typeInventaire=='P'?document.getElementById('marque').value:"");
		var famille1 = (typeInventaire=='P'?document.getElementById('famille1').value:"");
		var famille2 = (typeInventaire=='P'?document.getElementById('famille2').value:"");
		var famille3 = (typeInventaire=='P'?document.getElementById('famille3').value:"");
		var depotStock = document.getElementById('depotStock').value;

		if (isEmpty(depotStock)) {
			showWarning("Veuillez choisir un d\u00E9p\u00F4t de stock");
		}
		else if (typeInventaire=="P" && isEmpty(zoneStockage) && isEmpty(codeEmplacement) && isEmpty(marque) && isEmpty(famille1) && isEmpty(famille2) && isEmpty(famille3)) {
			showWarning("Veuillez s\u00E9lectionner au moins un crit\u00E8re");
		}
		else {
			window.arguments[0](typeInventaire, zoneStockage, codeEmplacement, marque, famille1, famille2, famille3, depotStock);
			window.close();
		}

  } catch (e) {
    recup_erreur(e);
  }
}
