/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var oms_aMouvements = new Arbre('Facturation/Mouvements_Stocks/list-mvtStock.tmpl', 'oms-listeMouvements');
var oms_qListMS = new QueryHttp("Facturation/Mouvements_Stocks/getDataListMS.tmpl");
var oms_aZones = new Arbre("ComboListe/combo-zonesStockage.tmpl", "oms-zoneStockage");

var oms_pageCourante;
var oms_nbPages;



function oms_init() {
  try {

		var oms_aDepots = new Arbre("ComboListe/combo-depotsStock.tmpl", "oms-depot");
  	oms_aDepots.initTree(oms_chargerZones);

		var actEmplacements = getConfig().isActEmplacements();

		if (!actEmplacements) {
			document.getElementById('oms-bRechEmplacement').collapsed = true;
			document.getElementById('oms-lblFiltreZone').collapsed = true;
			document.getElementById('oms-zoneStockage').collapsed = true;
			document.getElementById('oms-itemTE').collapsed = true;
		}

  } catch (e) {
  	recup_erreur(e);
  }
}


function oms_chargerZones() {
	try {

		oms_aZones.setParam("Depot_Id", document.getElementById('oms-depot').value);
		oms_aZones.initTree(oms_initZoneStockage);

	} catch (e) {
		recup_erreur(e);
  }
}


function oms_initZoneStockage() {
	try {

		document.getElementById('oms-zoneStockage').value = "";

	} catch (e) {
		recup_erreur(e);
  }
}


function oms_rechercherStock() {
	try {

		var url = "chrome://opensi/content/facturation/user/articles/popup-rechercheArticle.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oms_retourRechercherStock, null, null, null, true);

	} catch (e) {
    recup_erreur(e);
  }
}


function oms_retourRechercherStock(reference, articleId) {
	try {

		document.getElementById('oms-refArticle').value = reference;

	} catch (e) {
    recup_erreur(e);
  }
}


function oms_rechercherEmplacement() {
	try {

		var url = "chrome://opensi/content/facturation/user/emplacements/popup-rechercheEmplacement.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', oms_retourRechercherEmplacement);

	} catch (e) {
		recup_erreur(e);
	}
}


function oms_retourRechercherEmplacement(codeEmplacement, emplacementId) {
	try {

  	document.getElementById('oms-codeEmplacement').value = codeEmplacement;
  	oms_listerMouvements();

	} catch (e) {
		recup_erreur(e);
	}
}


function oms_initCriteres() {
	try {

		document.getElementById('oms-depot').value = "";
		document.getElementById('oms-codeEmplacement').value = "";
		document.getElementById('oms-zoneStockage').value = "";
		document.getElementById('oms-typeMvt').value = "";
		document.getElementById('oms-numPiece').value = "";
		document.getElementById('oms-libelle').value = "";
		document.getElementById('oms-sens').value = "";
		document.getElementById('oms-refArticle').value = "";
		document.getElementById('oms-dateDebut').value = "";
		document.getElementById('oms-dateFin').value = "";

		oms_listerMouvements();

	} catch (e) {
		recup_erreur(e);
	}
}


function oms_listerMouvements() {
	try {

		var depotId = document.getElementById('oms-depot').value;
		var codeEmplacement = document.getElementById('oms-codeEmplacement').value;
		var zoneStockage = document.getElementById('oms-zoneStockage').value;
		var typeMvt = document.getElementById('oms-typeMvt').value;
		var numPiece = document.getElementById('oms-numPiece').value;
		var libelle = document.getElementById('oms-libelle').value;
		var refArticle = document.getElementById('oms-refArticle').value;
		var sens = document.getElementById('oms-sens').value;
		var dateDebut = document.getElementById('oms-dateDebut').value;
		var dateFin = document.getElementById('oms-dateFin').value;
		var nbLignesParPage = document.getElementById('oms-nbLignesParPage').value;

		if (!isEmpty(dateDebut) && !isDate(dateDebut)) { showWarning("Date de d\u00E9but incorrecte !"); }
		else if (!isEmpty(dateFin) && !isDate(dateFin)) { showWarning("Date de fin incorrecte !"); }
		else if (!isEmpty(dateDebut) && !isEmpty(dateFin) && !isDateInterval(dateDebut, dateFin)) { showWarning("Plage de dates incorrecte !"); }
		else {

			oms_pageCourante = 1;
			oms_nbPages = 1;
			document.getElementById('oms-pageDeb').value = 1;
			document.getElementById('oms-pageFin').value = 1;
			document.getElementById('oms-bPrec').disabled = true;
			document.getElementById('oms-bSuiv').disabled = true;

			document.getElementById('oms-listeMouvements').disabled = true;
			document.getElementById('oms-bEditionCsv').disabled = true;
			oms_aMouvements.deleteTree();

			oms_qListMS.setParam("Depot_Id", depotId);
			oms_qListMS.setParam("Code_Emplacement", codeEmplacement);
			oms_qListMS.setParam("Zone_Stockage", zoneStockage);
			oms_qListMS.setParam("Type_Mvt", typeMvt);
			oms_qListMS.setParam("Num_Piece", numPiece);
			oms_qListMS.setParam("Libelle", libelle);
			oms_qListMS.setParam("Ref_Article", refArticle);
			oms_qListMS.setParam("Sens", sens);
			oms_qListMS.setParam("Date_Mvt_Debut", dateDebut);
			oms_qListMS.setParam("Date_Mvt_Fin", dateFin);
			oms_qListMS.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
			oms_qListMS.setParam("Current_Page", oms_pageCourante);

			var result = oms_qListMS.execute();

			var contenu = result.responseXML.documentElement;

			oms_nbPages = contenu.getAttribute("Nb_Pages");
			var listMvtId = contenu.getAttribute("List_Mvt_Id");

			oms_aMouvements.setParam("List_Mvt_Id", listMvtId);
			oms_aMouvements.initTree(oms_initPagination);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oms_initPagination() {
	try {

		document.getElementById('oms-pageDeb').value = oms_pageCourante;
		document.getElementById('oms-pageFin').value = (oms_nbPages>0?oms_nbPages:1);
		document.getElementById('oms-bPrec').disabled = (oms_pageCourante==1);
		document.getElementById('oms-bSuiv').disabled = (oms_pageCourante>=oms_nbPages); // peut se produire si oms_nbPages=0

		oms_afterMajPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function oms_pressOnPagePrec() {
	try {

		oms_pageCourante--;
		oms_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function oms_pressOnPageSuiv() {
	try {

		oms_pageCourante++;
		oms_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function oms_majPagination() {
	try {

		document.getElementById('oms-pageDeb').value = oms_pageCourante;
		document.getElementById('oms-bPrec').disabled = (oms_pageCourante==1);
		document.getElementById('oms-bSuiv').disabled = (oms_pageCourante==oms_nbPages);

		document.getElementById('oms-listeMouvements').disabled = true;
		document.getElementById('oms-bEditionCsv').disabled = true;

		oms_qListMS.setParam("Current_Page", oms_pageCourante);
		var result = oms_qListMS.execute();
		var listMvtId = result.responseXML.documentElement.getAttribute("List_Mvt_Id");

		oms_aMouvements.setParam("List_Mvt_Id", listMvtId);
		oms_aMouvements.initTree(oms_afterMajPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function oms_afterMajPagination() {
	try {

		document.getElementById('oms-listeMouvements').disabled = false;
		document.getElementById('oms-bEditionCsv').disabled = (oms_aMouvements.nbLignes()==0);

	} catch (e) {
		recup_erreur(e);
	}
}


function oms_pressOnCritere(ev) {
  try {

		if (ev.keyCode==13) {
			oms_listerMouvements();
    }

	} catch (e) {
  	recup_erreur(e);
  }
}


function oms_pressOnEditionCsv() {
	try {

		var depotId = document.getElementById('oms-depot').value;
		var codeEmplacement = document.getElementById('oms-codeEmplacement').value;
		var zoneStockage = document.getElementById('oms-zoneStockage').value;
		var typeMvt = document.getElementById('oms-typeMvt').value;
		var numPiece = document.getElementById('oms-numPiece').value;
		var libelle = document.getElementById('oms-libelle').value;
		var refArticle = document.getElementById('oms-refArticle').value;
		var sens = document.getElementById('oms-sens').value;
		var dateDebut = document.getElementById('oms-dateDebut').value;
		var dateFin = document.getElementById('oms-dateFin').value;

		if (!isEmpty(dateDebut) && !isDate(dateDebut)) { showWarning("Date de d\u00E9but incorrecte !"); }
		else if (!isEmpty(dateFin) && !isDate(dateFin)) { showWarning("Date de fin incorrecte !"); }
		else if (!isEmpty(dateDebut) && !isEmpty(dateFin) && !isDateInterval(dateDebut, dateFin)) { showWarning("Plage de dates incorrecte !"); }
		else {

			var qEditionCsv = new QueryHttp("Facturation/Mouvements_Stocks/csvMvtStock.tmpl");

			qEditionCsv.setParam("Depot_Id", depotId);
			qEditionCsv.setParam("Code_Emplacement", codeEmplacement);
			qEditionCsv.setParam("Zone_Stockage", zoneStockage);
			qEditionCsv.setParam("Type_Mvt", typeMvt);
			qEditionCsv.setParam("Num_Piece", numPiece);
			qEditionCsv.setParam("Libelle", libelle);
			qEditionCsv.setParam("Ref_Article", refArticle);
			qEditionCsv.setParam("Sens", sens);
			qEditionCsv.setParam("Date_Mvt_Debut", dateDebut);
			qEditionCsv.setParam("Date_Mvt_Fin", dateFin);

			var result = qEditionCsv.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');

				var file = fileChooser("save", fichier);
				if (file!=null) {
					downloadFile(getDirBuffer()+ fichier, file);
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}
