/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");


var aDepots = new Arbre('ComboListe/combo-depotsStock.tmpl', 'depot');
var depotDefaut;
var fournisseurId = "";
var rcfNumBLOblig;



function init() {
  try {

		rcfNumBLOblig = getConfig().isRCFNumBLOblig();

		var etablissementDefaut = getProfil().getEtabId();

		var qDepotDefaut = new QueryHttp("Facturation/Commun/getDepotDefautEts.tmpl");
		qDepotDefaut.setParam("Etablissement_Id", etablissementDefaut);
		var result = qDepotDefaut.execute();
		depotDefaut = result.responseXML.documentElement.getAttribute('Depot_Defaut');

		aDepots.setParam("Depot_Expedition", true);
		aDepots.setParam("Depot_Logistique", false);
		aDepots.setParam("Depot_Vente", false);
		aDepots.setParam("Depot_Quarantaine", false);
		aDepots.initTree(initDepot);

  } catch (e) {
    recup_erreur(e);
  }
}


function initDepot() {
	try {

		document.getElementById('depot').value = depotDefaut;
		rechercherFournisseur();

	} catch (e) {
		recup_erreur(e);
	}
}


function rechercherFournisseur() {
	try {

		var url = "chrome://opensi/content/facturation/user/fournisseurs/popup-rechercheFournisseur.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', retourRechercherFournisseur);

  } catch (e) {
    recup_erreur(e);
  }
}


function retourRechercherFournisseur(numFournisseur, selFournisseurId) {
	try {

		fournisseurId = selFournisseurId;
		document.getElementById('numFournisseur').value = numFournisseur;
		document.getElementById('numeroBL').focus();

	} catch (e) {
		recup_erreur(e);
	}
}


function valider() {
	try {

		var depotId = document.getElementById('depot').value;
		var numeroBL = document.getElementById('numeroBL').value;

		if (isEmpty(fournisseurId)) { showWarning("Veuillez choisir un fournisseur."); }
		else if (rcfNumBLOblig && isEmpty(numeroBL)) { showWarning("N\u00B0 Bon de livraison obligatoire"); }
		else {
			var qCreate = new QueryHttp("Facturation/Reception/createReceptionLot.tmpl");
			qCreate.setParam("Fournisseur_Id", fournisseurId);
			qCreate.setParam("Depot_Id", depotId);
			qCreate.setParam("Numero_BL", numeroBL);
			var result = qCreate.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var receptionId = result.responseXML.documentElement.getAttribute('Reception_Id');
				window.arguments[0](receptionId);
				window.close();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}
