/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/formatter.js");


var receptionId;
var typeEdition;
var currentFournisseurId;

var aReceptions = new Arbre("Facturation/Reception/list-receptionLot.tmpl", "listeReceptionLot");
var aLignes = new Arbre("Facturation/Reception/list-ligneReception.tmpl", "listeLigneReception");
var aSeries = new Arbre("Facturation/Reception/liste-numerosSerie.tmpl", "liste_numero_serie");
var aLots = new Arbre("Facturation/Reception/liste-numerosLot.tmpl", "listeNumLot");

var aAttRecep = new Arbre("Facturation/Reception/list-articleAttenteReception.tmpl", "tree-attRecep");
var aFournisseursAtt = new Arbre("Facturation/Reception/combo-fournisseurAttenteReception.tmpl", "Fournisseur_Att");

var aRecus = new Arbre("Facturation/Reception/list-articleRecu.tmpl", "listeArticleRecu");
var qListAR = new QueryHttp("Facturation/Reception/getDataListAR.tmpl");

var pageCouranteAR;
var nbPagesAR;

var artAttCharge = false;
var bonChiffreDefaut;
var ordreTriDefaut;
var actSuiviSerie = false;
var actSuiviLot = false;
var actQRCode = false;
var depotDefaut;
var switchCount = 1;
var switchPosition = 0;
var gcfEtiqArticle;
var rcfNumBLOblig;
var fqte = new NumberFormat("0.###", false);



function init() {
  try {

		document.getElementById("modifierSeries").disabled = true;

		var config = getConfig();

		bonChiffreDefaut = config.isBRChiffre();
		ordreTriDefaut = config.getOrdreTriBR();
		actSuiviSerie = config.isActSuiviSerie();
		actSuiviLot = config.isActSuiviLot();
		actQRCode = config.isRCLQRCode();
		gcfEtiqArticle = config.isGCFEtiqArticle();
		rcfNumBLOblig = config.isRCFNumBLOblig();

		document.getElementById('boxEtiquettes').collapsed = !gcfEtiqArticle;

		if (config.isSpecHLSRR()) {
			document.getElementById('colStockReserve').collapsed = false;
			document.getElementById('colStockReserve').setAttribute("ignoreincolumnpicker", false);
		}

		if (!config.isGCFDateLivraison()) {
			document.getElementById('colDateLivraisonAR').collapsed = true;
			document.getElementById('colDateLivraisonAR').setAttribute('ignoreincolumnpicker', true);
		}

		if (!config.isActSerieDLC()) {
			document.getElementById("colDatePeremptionNS").setAttribute("hidden", true);
		}

		var qAttPrinc = new QueryHttp("Facturation/Commun/getAttributsPrincipaux.tmpl");
		var result = qAttPrinc.execute();

		var contenu = result.responseXML.documentElement;

		for (var i=1; i<=6; i++) {
			if (!isEmpty(contenu.getAttribute("Groupe_Id_"+ i))) {
				document.getElementById("ColAttribut"+ i).setAttribute("label", contenu.getAttribute("Intitule_"+ i));
			}
			else {
				document.getElementById("ColAttribut"+ i).collapsed = true;
				document.getElementById("ColAttribut"+ i).setAttribute("ignoreincolumnpicker", true);
			}
		}

		document.getElementById("vboxNumSerie").collapsed=!actSuiviSerie;
		document.getElementById("vboxNumLot").collapsed=!actSuiviLot;
		document.getElementById("groupboxDetailReceptionArticle").collapsed=!(actSuiviSerie || actSuiviLot);
		document.getElementById("NouveauNumLot").disabled = true;
		document.getElementById("ValiderNumLot").disabled = true;
		document.getElementById("SupprimerNumLot").disabled = true;

		if (actQRCode) {
			document.getElementById("bSwitchMode").collapsed=false;
			switchCount = 1 + ((actQRCode)?1:0);
			nextModeSaisie();
		}

		var etablissementDefaut = getProfil().getEtabId();

		var qDepotDefaut = new QueryHttp("Facturation/Commun/getDepotDefautEts.tmpl");
		qDepotDefaut.setParam("Etablissement_Id", etablissementDefaut);
		result = qDepotDefaut.execute();
		depotDefaut = result.responseXML.documentElement.getAttribute('Depot_Defaut');

		var aDepotsArtAtt = new Arbre('ComboListe/combo-depotsStock.tmpl', 'depotArtAtt');
		aDepotsArtAtt.setParam("Depot_Quarantaine", false);
		aDepotsArtAtt.initTree(initDepotArtAtt);

  } catch (e) {
    recup_erreur(e);
  }
}


function initDepotArtAtt() {
	try {

		document.getElementById('depotArtAtt').value = depotDefaut;

		var aDepotsArtRecep = new Arbre('ComboListe/combo-depotsStock.tmpl', 'depotArtRecep');
		aDepotsArtRecep.setParam("Depot_Quarantaine", false);
		aDepotsArtRecep.initTree(initDepotArtRecep);

	} catch (e) {
		recup_erreur(e);
	}
}


function initDepotArtRecep() {
	try {

		document.getElementById('depotArtRecep').value = depotDefaut;
  	document.getElementById('deck').selectedIndex = 0;
		document.getElementById('Fournisseur_Recep').value = "";

		aReceptions.initTree(initIHM);

	} catch (e) {
		recup_erreur(e);
	}
}


function initIHM() {
	try {

		receptionId = "";
		currentFournisseurId = "";
		document.getElementById('denomination').value = "";
		document.getElementById('depotReception').value = "";
		document.getElementById('numeroBL').value = "";
		document.getElementById('refArticle').value = "";
		document.getElementById('qrCode').value = "";
		document.getElementById('Quantite').value = 1;
		document.getElementById('recep_unitaire').checked = false;
		document.getElementById('bSupprimerPrep').disabled = true;
		document.getElementById('numeroBL').disabled = true;
		document.getElementById('bEnregistrerNumBL').disabled = true;
		document.getElementById('refArticle').disabled = true;
		document.getElementById('bSwitchMode').disabled = true;
		document.getElementById('bCodeBarre').disabled = true;
		document.getElementById('bArticle').disabled = true;
		document.getElementById('Quantite').disabled = true;
		document.getElementById('recep_unitaire').disabled = true;
		aLignes.deleteTree();
		aSeries.deleteTree();
		aLots.deleteTree();

		document.getElementById('bSupprimerLigne').disabled = true;
		document.getElementById('bValiderPrep').disabled = true;
		document.getElementById('nbLignes').value = "0";
		document.getElementById('qteTotale').value = "0";

	} catch (e) {
		recup_erreur(e);
	}
}


function nouvelleReception() {
	try {

		var url = "chrome://opensi/content/facturation/user/reception/popup-nouvelleReception.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', retourNouvelleReception);

	} catch (e) {
		recup_erreur(e);
	}
}


function nextModeSaisie() {
	try {

		switchPosition = ((switchPosition +1) % switchCount);
		selectModeSaisie();

	} catch (e) {
		recup_erreur(e);
	}
}


function selectModeSaisie() {
	try {

		document.getElementById("labelArticle").collapsed = switchPosition!=0;
		document.getElementById("boxArticle").collapsed = switchPosition!=0;
		if (switchPosition==0) {
			document.getElementById("refArticle").focus();
		}

		document.getElementById("labelQRC").collapsed = switchPosition!=1;
		document.getElementById("qrCode").collapsed = switchPosition!=1;
		if (switchPosition==1) {
			document.getElementById("qrCode").focus();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function retourNouvelleReception(selReceptionId) {
	try {

		receptionId = selReceptionId;
		aReceptions.initTree(selectPrepReception);

	} catch (e) {
		recup_erreur(e);
	}
}


function selectPrepReception() {
	try {

		var i=0;
		var nbLignes = aReceptions.nbLignes();
		var trouve = false;
		while (!trouve && i<nbLignes) {
			if (receptionId==aReceptions.getCellText(i,'colReceptionId')) {
				trouve = true;
				aReceptions.select(i);
			}
			i++;
		}

		pressOnListeReceptionLot();

	} catch (e) {
		recup_erreur(e);
	}
}



function enregistrerNumBL() {
	try {

		var numeroBL = document.getElementById('numeroBL').value;

		if (rcfNumBLOblig && isEmpty(numeroBL)) {
			showWarning("N\u00B0 Bon de livraison obligatoire");
		}
		else {
			var qUpdate = new QueryHttp("Facturation/Reception/updateNumeroBL.tmpl");
			qUpdate.setParam("Numero_BL", numeroBL);
			qUpdate.setParam("Reception_Id", receptionId);
			var result = qUpdate.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				aReceptions.initTree(selectPrepReception);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnListeReceptionLot() {
	try {

		if (aReceptions.isSelected()) {

			receptionId = aReceptions.getSelectedCellText('colReceptionId');
			currentFournisseurId = aReceptions.getSelectedCellText('colFournisseurId');

			document.getElementById('denomination').value = aReceptions.getSelectedCellText('colDenomination');
			document.getElementById('depotReception').value = aReceptions.getSelectedCellText('colDepotStock');
			document.getElementById('numeroBL').value = aReceptions.getSelectedCellText('colNumeroBL');

			document.getElementById('bSupprimerPrep').disabled = false;
			document.getElementById('numeroBL').disabled = false;
			document.getElementById('bEnregistrerNumBL').disabled = false;
			document.getElementById('refArticle').disabled = false;
			document.getElementById('bSwitchMode').disabled = false;
			document.getElementById('qrCode').disabled = false;
			document.getElementById('bCodeBarre').disabled = false;
			document.getElementById('bArticle').disabled = false;
			document.getElementById('Quantite').disabled = false;
			document.getElementById('recep_unitaire').disabled = false;

			aLignes.setParam("Reception_Id", receptionId);
			aLignes.initTree(initTreeArticle);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnArtAtt() {
	try {

		if (!artAttCharge) {
			artAttCharge = true;
			aFournisseursAtt.initTree(initFournisseur_Att);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function initFournisseur_Att() {
	try {

		document.getElementById('Fournisseur_Att').selectedIndex = 0;
		chargerAttenteReception();

	} catch (e) {
		recup_erreur(e);
	}
}


function rechercherArticle() {
	try {

		var url = "chrome://opensi/content/facturation/user/articles/popup-rechercheArticle.xul";
		var reference = document.getElementById('refArticle').value;
   	window.openDialog(url,'','chrome,modal,centerscreen', retourRechercherArticle, "A", reference, null, null, currentFournisseurId);

	} catch (e) {
		recup_erreur(e);
  }
}


function retourRechercherArticle(reference, articleId) {
	try {

		document.getElementById('refArticle').value = reference;
		rechercherReference();

	} catch (e) {
    recup_erreur(e);
  }
}


function pressOnCritereAR(ev) {
	try {

		if (ev.keyCode==13) {
			chargerAttenteReception();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function rechercherArticleAR() {
	try {

		var fournisseurId = document.getElementById('Fournisseur_Att').value;
		if (fournisseurId==0) {
			fournisseurId = "";
		}

		var url = "chrome://opensi/content/facturation/user/articles/popup-rechercheArticle.xul";
		var reference = document.getElementById('refArticleAR').value;
   	window.openDialog(url,'','chrome,modal,centerscreen', retourRechercherArticleAR, "A", reference, null, null, fournisseurId);

	} catch (e) {
		recup_erreur(e);
  }
}


function retourRechercherArticleAR(reference, articleId) {
	try {

		document.getElementById('refArticleAR').value = reference;
		chargerAttenteReception();

	} catch (e) {
    recup_erreur(e);
  }
}


function associerCodeBarre() {
	try {

		var codeBarre = document.getElementById('refArticle').value;

		if (isEmpty(codeBarre)) {
			showWarning("Veuillez saisir un code barre");
		}
		else if (codeBarre.length>18) {
			showWarning("Le code barre saisi est trop long");
		}
		else if (!isCodeBarre(codeBarre)) {
			showWarning("Code barre incorrect");
		}
		else {
			var url = "chrome://opensi/content/facturation/user/reception/popup-associerCodeBarre.xul";
    	window.openDialog(url,'','chrome,modal,centerscreen', codeBarre);
			rechercherReference();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function keypress(e,id) {
	try {

		if (e.keyCode==13) {
			if (id=="refArticle") {
				rechercherReference();
			}
			else if (id=="qrCode") {
				validerQRC();
			}
			else if (id=="Quantite"){
				if (switchPosition==0) {
					validerLigne();
				}
				else {
					validerLigneQRC();
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function rechercherReference() {
	try {

		var reference = document.getElementById('refArticle').value;

		var qSearch = new QueryHttp("Facturation/Articles/searchReference.tmpl");
		qSearch.setParam('Reference', reference);
		qSearch.setParam('Vente_Achat', "A");
		var result = qSearch.execute();

		var articleId = result.responseXML.documentElement.getAttribute("Article_Id");

		if (!isEmpty(articleId)) {
			var findReference = result.responseXML.documentElement.getAttribute("Reference");
			document.getElementById('refArticle').value = findReference;
			document.getElementById('Quantite').value = getQuantiteCodeBarre(findReference, reference);

			if (document.getElementById('recep_unitaire').checked) {
				validerLigne();
			}
			else {
				document.getElementById('Quantite').select();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function getQuantiteCodeBarre(reference, codeBarre) {
	try {

		var qQteCB = new QueryHttp("Facturation/Articles/getQuantiteCodeBarre.tmpl");
		qQteCB.setParam('Reference', reference);
		qQteCB.setParam('Code_Barre', codeBarre);

		var result = qQteCB.execute();

		var quantite = result.responseXML.documentElement.getAttribute("Quantite");

		return fqte.format(quantite);

	} catch (e) {
    recup_erreur(e);
  }
}


function validerQRC() {
	try {

		var QRC = document.getElementById('qrCode').value;

		if (!isEmpty(QRC)) {
			if (document.getElementById('recep_unitaire').checked) {
				document.getElementById('Quantite').value=1;
				validerLigneQRC();
			}
			else {
				document.getElementById('Quantite').select();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function changerTypeQuantite(unitaire) {
  try {
		document.getElementById('Quantite').disabled=unitaire;
		document.getElementById('Quantite').value="1";
		if (switchPosition==0) {
			document.getElementById("refArticle").focus();
		}
		else {
			document.getElementById("qrCode").focus();
		}
  } catch (e) {
    recup_erreur(e);
  }
}


function validerLigne() {
	try {

		var reference = document.getElementById('refArticle').value;
		var quantite = document.getElementById('Quantite').value;

		if (!isPositive(quantite) || !checkNumber(quantite,10,3)) {
			showWarning("Quantit\u00E9 incorrecte");
		}
		else {
			var qAdd = new QueryHttp("Facturation/Reception/addLigneReception.tmpl");
			qAdd.setParam('Reception_Id', receptionId);
			qAdd.setParam('Reference', reference);
			qAdd.setParam('Quantite', quantite);
			var result = qAdd.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var quantiteRestante = result.responseXML.documentElement.getAttribute("Quantite_Restante");
				var ligneId = result.responseXML.documentElement.getAttribute("Ligne_Id");
				var suiviSerie = result.responseXML.documentElement.getAttribute("Suivi_Serie")=="true";

				if (quantiteRestante>0) {
					showWarning("Vous ne pouvez pas r\u00E9ceptionner plus que la quantit\u00E9 attendue. L'exc\u00E9dent n'a donc pas \u00E9t\u00E9 pris en compte.");
				}

				if (actSuiviSerie && suiviSerie) {
		    	var url = "chrome://opensi/content/facturation/user/commun/popup-numSerie.xul";
		    	window.openDialog(url,'','chrome,modal,centerscreen', "S", "RL", ligneId);
				}

				aLignes.initTree(initTreeArticle);
				aSeries.deleteTree();
				aLots.deleteTree();
				document.getElementById('refArticle').value = "";
				document.getElementById('Quantite').value = "1";
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function validerLigneQRC() {
	try {

		var QRC = document.getElementById('qrCode').value;
		var quantite = document.getElementById('Quantite').value;

		if (!checkQte(quantite)) {
			showWarning("Quantit\u00E9 incorrecte !");
		}
		else {
			var qAdd = new QueryHttp("Facturation/Reception/addLigneReceptionByQRC.tmpl");
			qAdd.setParam('Reception_Id', receptionId);
			qAdd.setParam('QRC', QRC);
			qAdd.setParam('Quantite', quantite);
			var result = qAdd.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var quantiteRestante = result.responseXML.documentElement.getAttribute("Quantite_Restante");
				var ligneId = result.responseXML.documentElement.getAttribute("Ligne_Id");
				var suiviSerie = result.responseXML.documentElement.getAttribute("Suivi_Serie")=="true";

				if (quantiteRestante>0) {
					showWarning("Vous ne pouvez pas r\u00E9ceptionner plus que la quantit\u00E9 attendue. L'exc\u00E9dent n'a donc pas \u00E9t\u00E9 pris en compte.");
				}

				if (actSuiviSerie && suiviSerie) {
	    		var url = "chrome://opensi/content/facturation/user/commun/popup-numSerie.xul";
	    		window.openDialog(url,'','chrome,modal,centerscreen', "S", "RL", ligneId);
				}

				aLignes.initTree(initTreeArticle);
				aSeries.deleteTree();
				aLots.deleteTree();
				document.getElementById('qrCode').value = "";
				document.getElementById('refArticle').value = "";
				document.getElementById('Quantite').value = "1";
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function modifierSeries() {
	try {

		if (actSuiviSerie) {
			if (aLignes.isSelected()) {
				var ligneId = aLignes.getSelectedCellText('lcColLigneId');
    		var url = "chrome://opensi/content/facturation/user/commun/popup-numSerie.xul";
    		window.openDialog(url,'','chrome,modal,centerscreen', "S", "RL", ligneId);
			}
			aLignes.initTree(initTreeArticle);
			aSeries.deleteTree();
			aLots.deleteTree();
			document.getElementById('refArticle').value = "";
			document.getElementById('Quantite').value = "1";
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function validerNumLot() {
	try {

		if (aLignes.isSelected()) {
			var ligneId = aLignes.getSelectedCellText('lcColLigneId');
			if (!isPositiveOrNull(document.getElementById('quantiteLot').value)) {
				showWarning("Veuillez v\u00E9rifier le format de la quantit\u00E9 saisie");
			}
			else if (document.getElementById('numeroLot').value=="") {
				showWarning("Veuillez v\u00E9rifier le num\u00E9ro de lot");
			}
			else {
				if (document.getElementById('lotId').value!="") {
					var qUpdate = new QueryHttp("Facturation/Reception/updateNumLot.tmpl");
					qUpdate.setParam("Reception_Id", receptionId);
					qUpdate.setParam("Ligne_Id", ligneId);
					qUpdate.setParam("Reference", aLignes.getSelectedCellText('colReference'));
					qUpdate.setParam("Lot_Id", document.getElementById('lotId').value);
					qUpdate.setParam("Quantite", document.getElementById('quantiteLot').value);
					qUpdate.setParam("Date_Peremption", document.getElementById('datePeremption').value);
					var result = qUpdate.execute();

					var errors = new Errors(result);
					if (errors.hasNext()) {
						errors.show();
					}
				}
				else {
					var qCreate = new QueryHttp("Facturation/Reception/createNumLot.tmpl");
					qCreate.setParam("Reception_Id", receptionId);
					qCreate.setParam("Ligne_Id", ligneId);
					qCreate.setParam("Reference", aLignes.getSelectedCellText('colReference'));
					qCreate.setParam("Num_Lot", document.getElementById('numeroLot').value);
					qCreate.setParam("Quantite", document.getElementById('quantiteLot').value);
					qCreate.setParam("Date_Peremption", document.getElementById('datePeremption').value);
					var result = qCreate.execute();

					var errors = new Errors(result);
					if (errors.hasNext()) {
						errors.show();
					}
				}

				aLots.initTree();
				nouveauNumLot();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function supprimerNumLot() {
	try {

		if (aLignes.isSelected()) {
			var ligneId = aLignes.getCellText(aLignes.getCurrentIndex(), 'lcColLigneId');
			if (document.getElementById('lotId').value!="") {
				var qDelete = new QueryHttp("Facturation/Reception/deleteNumLot.tmpl");
				qDelete.setParam("Reception_Id", receptionId);
				qDelete.setParam("Ligne_Id", ligneId);
				qDelete.setParam("Reference", aLignes.getSelectedCellText('colReference'));
				qDelete.setParam("Lot_Id", document.getElementById('lotId').value);
				var result = qDelete.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
			}
		}

		aLots.initTree();
		nouveauNumLot();

	} catch (e) {
    recup_erreur(e);
  }
}


function nouveauNumLot() {
	try {

		document.getElementById('lotId').value = "";
		document.getElementById('numeroLot').value = "";
		document.getElementById('quantiteLot').value = "";
		document.getElementById('datePeremption').value = "";
		document.getElementById("NouveauNumLot").disabled = false;
		document.getElementById("ValiderNumLot").disabled = false;
		document.getElementById("SupprimerNumLot").disabled = true;
		document.getElementById("quantiteLot").disabled = false;
		document.getElementById("datePeremption").disabled = false;
		document.getElementById("numeroLot").disabled = false;
		document.getElementById('numeroLot').select();

	} catch (e) {
    recup_erreur(e);
  }
}


function selectOnListeNumLot() {
	try {

		if (aLots.isSelected()) {
			var i = aLots.getCurrentIndex();
			document.getElementById('lotId').value = aLots.getCellText(i, "lcColLotId");
			document.getElementById('numeroLot').value = aLots.getCellText(i, "lcColNumLot");
			document.getElementById('quantiteLot').value = aLots.getCellText(i, "lcColQuantite");
			document.getElementById('datePeremption').value = aLots.getCellText(i, "lcColDatePeremption");
			document.getElementById("NouveauNumLot").disabled = false;
			document.getElementById("ValiderNumLot").disabled = false;
			document.getElementById("SupprimerNumLot").disabled = false;
			document.getElementById("quantiteLot").disabled = false;
			document.getElementById("datePeremption").disabled = false;
			document.getElementById("numeroLot").disabled = true;
			document.getElementById('quantiteLot').select();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function onKeyPressQuantiteLot(event) {
	try {

		if (event.keyCode==13) {
			validerNumLot();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function onKeyPressDatePeremption(event) {
	try {

		if (event.keyCode==13) {
			validerNumLot();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnListeLigneReception() {
	try {

		if (aLignes.isSelected()) {
			document.getElementById('bSupprimerLigne').disabled = false;
			if (actSuiviSerie) {
				aSeries.setParam('Ligne_Id',aLignes.getSelectedCellText('lcColLigneId'));
				aSeries.initTree();
				document.getElementById("modifierSeries").disabled = false;
			}
			if (actSuiviLot) {
				aLots.setParam('Ligne_Id',aLignes.getSelectedCellText('lcColLigneId'));
				aLots.initTree();
				document.getElementById('lotId').value = "";
				document.getElementById('numeroLot').value = "";
				document.getElementById('quantiteLot').value = "";
				document.getElementById('datePeremption').value = "";
				document.getElementById("NouveauNumLot").disabled = false;
				document.getElementById("ValiderNumLot").disabled = false;
				document.getElementById("SupprimerNumLot").disabled = true;
				document.getElementById("quantiteLot").disabled = false;
				document.getElementById("datePeremption").disabled = false;
				document.getElementById("numeroLot").disabled = false;
			}
			else {
				aLots.deleteTree();
				document.getElementById('lotId').value = "";
				document.getElementById('numeroLot').value = "";
				document.getElementById('quantiteLot').value = "";
				document.getElementById('datePeremption').value = "";
				document.getElementById("NouveauNumLot").disabled = true;
				document.getElementById("ValiderNumLot").disabled = true;
				document.getElementById("SupprimerNumLot").disabled = true;
				document.getElementById("quantiteLot").disabled = true;
				document.getElementById("datePeremption").disabled = true;
				document.getElementById("numeroLot").disabled = true;
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function supprimerLigne() {
	try {

		if (aLignes.isSelected()) {
			var qDelete = new QueryHttp("Facturation/Reception/deleteLigneReception.tmpl");
			qDelete.setParam('Ligne_Id', aLignes.getSelectedCellText('lcColLigneId'));
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				aLignes.initTree(initTreeArticle);
			}
		}
		else {
			showWarning("Veuillez s\u00E9lectionner une ligne !");
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function initTreeArticle() {
	try {

		var nbLignes = aLignes.nbLignes();
		document.getElementById("modifierSeries").disabled = true;
		document.getElementById('bSupprimerLigne').disabled = true;
		document.getElementById('bValiderPrep').disabled = (nbLignes==0);
		document.getElementById('nbLignes').value = nbLignes;

		var qteTotale = 0;
		var lastModified = 0;
		for (var i=0; i<nbLignes; i++) {
			qteTotale += parseFloat(aLignes.getCellText(i, 'Quantite'));
			if (aLignes.getCellText(i, 'colModified')=="true") {
				lastModified = i;
			}
		}
		document.getElementById('qteTotale').value = qteTotale;
		aLignes.ensureRowIsVisible(lastModified);

		if (switchPosition==0) {
			document.getElementById("refArticle").focus();
		}
		else {
			document.getElementById("qrCode").focus();
		}

		aSeries.deleteTree();
		aLots.deleteTree();

	} catch (e) {
		recup_erreur(e);
	}
}


function supprimerReception() {
	try {

		if (aReceptions.isSelected()) {
			var fournisseur = aReceptions.getSelectedCellText('colFournisseurId');
			var depot = aReceptions.getSelectedCellText('colDepotStock');

			if (confirm("Etes vous s\u00FBr de vouloir supprimer la r\u00E9ception pour le fournisseur "+ fournisseur +" et le d\u00E9p\u00F4t "+ depot +" ?")) {

				var qSup = new QueryHttp("Facturation/Reception/deleteReceptionLot.tmpl");
				qSup.setParam('Reception_Id', receptionId);
				var result = qSup.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}

				aReceptions.initTree(initIHM);
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function chargerAttenteReception() {
	try {

		document.getElementById('bEditerReliquats').disabled = true;
		document.getElementById('bEditerArtAtt').disabled = true;

		if (document.getElementById('Fournisseur_Att').selectedIndex!=0) {
			var fournisseurId = document.getElementById('Fournisseur_Att').value;
			var depotId = document.getElementById('depotArtAtt').value;
			var reference = document.getElementById('refArticleAR').value;
			aAttRecep.setParam("Fournisseur_Id", fournisseurId);
			aAttRecep.setParam("Depot_Id", depotId);
			aAttRecep.setParam("Reference", reference);
			aAttRecep.initTree(initListeArtAttRecep);
		}
		else {
			aAttRecep.deleteTree();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function initListeArtAttRecep() {
	try {

		if (aAttRecep.nbLignes()>0) {
			document.getElementById('bEditerReliquats').disabled = false;
			document.getElementById('bEditerArtAtt').disabled = false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function editerArtAtt() {
	try {

		if (document.getElementById('Fournisseur_Att').selectedIndex!=0) {
			var fournisseurId = document.getElementById('Fournisseur_Att').value;
			var depotId = document.getElementById('depotArtAtt').value;
			var reference = document.getElementById('refArticleAR').value;

			var queryEdit = new QueryHttp("Facturation/Reception/csvArticleAttenteReception.tmpl");
			queryEdit.setParam("Fournisseur_Id", fournisseurId);
			queryEdit.setParam("Depot_Id", depotId);
			queryEdit.setParam("Reference", reference);
			queryEdit.execute(editerArtAtt_2);
		}
		else {
			showWarning("Veuillez choisir un fournisseur !");
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function editerArtAtt_2(result) {
	try {

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');

			var file = fileChooser("save", fichier);
			if (file!=null) {
				downloadFile(getDirBuffer()+ fichier, file);
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function validerPrepBR() {
	try {

		if (!aLignes.nbLignes()) {
			showWarning("Impossible de valider la r\u00E9ception. Vous n'avez rien r\u00E9ceptionn\u00E9.");
		}
		else if (window.confirm("Confirmez-vous la validation de la r\u00E9ception ?")) {
			var qValid = new QueryHttp("Facturation/Reception/validReceptionLot.tmpl");
			qValid.setParam("Reception_Id", receptionId);
			var result = qValid.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				editerBR();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function reediterDerniereValidation() {
	try {

		editerBR();

	} catch (e) {
    recup_erreur(e);
  }
}


function editerBR() {
	try {

		typeEdition = "BR";
		document.getElementById('chkBonReceptionChiffre').setAttribute("checked", bonChiffreDefaut);
		document.getElementById('ordreTri').value = ordreTriDefaut;
		document.getElementById('optionsReliquat').collapsed = true;
		document.getElementById('optionsBR').collapsed = false;
		document.getElementById('boxEtiquettes').collapsed = !gcfEtiqArticle;
		document.getElementById('pdfEtiquettes').setAttribute("src", "");

		var qGenPdf = new QueryHttp("Facturation/Reception/pdfReception.tmpl");
		qGenPdf.setParam("Chiffre", document.getElementById('chkBonReceptionChiffre').checked);
		qGenPdf.setParam("Ordre_Tri", document.getElementById('ordreTri').value);
		var result = qGenPdf.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
			document.getElementById('br').setAttribute("src", page);
			document.getElementById('deck').selectedIndex = 1;
			document.getElementById('bRetourReception').collapsed = false;

			if (gcfEtiqArticle) {
				var qGenEtiq = new QueryHttp("Facturation/Reception/pdfEtiquettesReception.tmpl");
				qGenEtiq.setParam('Reception_Id', receptionId);
				result = qGenEtiq.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
				else if (result.responseXML.documentElement.getAttribute('Has_Etiquettes')=="true") {
					page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
					document.getElementById('pdfEtiquettes').setAttribute("src", page);
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function editerBonReliquats() {
	try {

		if (document.getElementById('Fournisseur_Att').selectedIndex!=0) {
			typeEdition = "Reliquats";
			var fournisseurId = document.getElementById('Fournisseur_Att').value;
			var depotId = document.getElementById('depotArtAtt').value;
			var reference = document.getElementById('refArticleAR').value;

			var qGenPdf = new QueryHttp("Facturation/Reception/pdfBonReliquats.tmpl");
			qGenPdf.setParam("Chiffre", false);
			qGenPdf.setParam("Ordre_Tri", "D");
			qGenPdf.setParam("Fournisseur_Id", fournisseurId);
			qGenPdf.setParam("Depot_Id", depotId);
			qGenPdf.setParam("Reference", reference);
			var result = qGenPdf.execute();
			var errors = new Errors(result);

			if (errors.hasNext()) {
				errors.show();
			} else {
				document.getElementById('boxEtiquettes').collapsed = true;
				var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');

				document.getElementById('br').setAttribute("src", page);
				document.getElementById('chkBonReliquatChiffre').setAttribute("checked", false);
				document.getElementById('optionsReliquat').collapsed = false;
				document.getElementById('optionsBR').collapsed = true;
				document.getElementById('rgpTri').value = "D";
				document.getElementById('deck').selectedIndex = 1;
				document.getElementById('bRetourReception').collapsed = false;
			}
		}
		else {
			showWarning("Veuillez choisir un fournisseur !");
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function pressOnBonChiffre() {
	try {

		document.getElementById('br').setAttribute("src", "");
		document.getElementById('pdfEtiquettes').setAttribute("src", "");

		if (typeEdition=="BR") {
			var qGenPdf = new QueryHttp("Facturation/Reception/pdfReception.tmpl");
			qGenPdf.setParam("Chiffre", document.getElementById('chkBonReceptionChiffre').checked);
			qGenPdf.setParam("Ordre_Tri", document.getElementById('ordreTri').value);
			var result = qGenPdf.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
				document.getElementById('br').setAttribute("src", page);
			}

			if (gcfEtiqArticle) {
				var qGenEtiq = new QueryHttp("Facturation/Reception/pdfEtiquettesReception.tmpl");
				qGenEtiq.setParam('Reception_Id', receptionId);
				result = qGenEtiq.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
				else if (result.responseXML.documentElement.getAttribute('Has_Etiquettes')=="true") {
					page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
					document.getElementById('pdfEtiquettes').setAttribute("src", page);
				}
			}
		}
		else {
			var tri = document.getElementById('rgpTri').value;
			var fournisseurId = document.getElementById('Fournisseur_Att').value;
			var depotId = document.getElementById('depotArtAtt').value;
			var chiffre = (document.getElementById('chkBonReliquatChiffre').checked);
			var reference = document.getElementById('refArticleAR').value;

			var qGenPdf = new QueryHttp("Facturation/Reception/pdfBonReliquats.tmpl");
			qGenPdf.setParam("Chiffre", chiffre);
			qGenPdf.setParam("Ordre_Tri", tri);
			qGenPdf.setParam("Fournisseur_Id", fournisseurId);
			qGenPdf.setParam("Depot_Id", depotId);
			qGenPdf.setParam("Reference", reference);
			var result = qGenPdf.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
				document.getElementById('br').setAttribute("src",page);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function retourReception() {
  try {

  	aReceptions.initTree(initIHM);

		document.getElementById('br').setAttribute("src", "");
		document.getElementById('pdfEtiquettes').setAttribute("src", "");
		document.getElementById('bRetourReception').collapsed = true;
		document.getElementById('deck').selectedIndex = 0;

  } catch (e) {
    recup_erreur(e);
  }
}


function retourMenuPrincipal() {
  try {

    window.location = "chrome://opensi/content/facturation/user/menu_principal.xul";

  } catch (e) {
    recup_erreur(e);
  }
}


// ONGLET ARTICLES RECEPTIONNES


function listerArticlesRecus() {
	try {

		var numFournisseur = document.getElementById('Fournisseur_Recep').value;
		var depotId = document.getElementById('depotArtRecep').value;
		var dateDebut = document.getElementById('Date_Debut').value;
		var dateFin = document.getElementById('Date_Fin').value;
		var numeroBL = document.getElementById('Numero_BL').value;
		var nbLignesParPage = document.getElementById('nbLignesParPageAR').value;

		if (isEmpty(dateDebut)) {	showWarning("Veuillez saisir une date de d\u00E9but !");	}
		else if (!isDate(dateDebut)) {	showWarning("Date de d\u00E9but incorrecte !");	}
		else if (!isEmpty(dateFin) && !isDate(dateFin)) { showWarning("Date de fin incorrecte !");  }
		else if (!isEmpty(dateFin) && !isDateInterval(dateDebut, dateFin)) {  showWarning("La date de fin doit \u00EAtre sup\u00E9rieure \u00E0 la date de d\u00E9but !");  }
		else {

			pageCouranteAR = 1;
			nbPagesAR = 1;
			document.getElementById('pageDebAR').value = 1;
			document.getElementById('pageFinAR').value = 1;
			document.getElementById('bPrecAR').disabled = true;
			document.getElementById('bSuivAR').disabled = true;

			document.getElementById('listeArticleRecu').disabled = true;
			document.getElementById('bEditionCsvAR').disabled = true;
			aRecus.deleteTree();

			qListAR.setParam("Num_Fournisseur", numFournisseur);
			qListAR.setParam("Numero_BL", numeroBL);
			qListAR.setParam("Depot_Id", depotId);
			qListAR.setParam("Date_Debut", dateDebut);
			qListAR.setParam("Date_Fin", dateFin);
			qListAR.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
			qListAR.setParam("Current_Page", pageCouranteAR);

			var result = qListAR.execute();

			var contenu = result.responseXML.documentElement;

			nbPagesAR = contenu.getAttribute("Nb_Pages");
			var listArticleRecuId = contenu.getAttribute("List_Article_Recu_Id");
			var listArticleId = contenu.getAttribute("List_Article_Id");
			var listBonRecId = contenu.getAttribute("List_Bon_Rec_Id");

			aRecus.setParam("List_Article_Recu_Id", listArticleRecuId);
			aRecus.setParam("List_Article_Id", listArticleId);
			aRecus.setParam("List_Bon_Rec_Id", listBonRecId);
			aRecus.initTree(initPaginationAR);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function initPaginationAR() {
	try {

		document.getElementById('pageDebAR').value = pageCouranteAR;
		document.getElementById('pageFinAR').value = (nbPagesAR>0?nbPagesAR:1);
		document.getElementById('bPrecAR').disabled = (pageCouranteAR==1);
		document.getElementById('bSuivAR').disabled = (pageCouranteAR>=nbPagesAR); // peut se produire si nbPagesAR=0

		afterMajPaginationAR();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnPagePrecAR() {
	try {

		pageCouranteAR--;
		majPaginationAR();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnPageSuivAR() {
	try {

		pageCouranteAR++;
		majPaginationAR();

	} catch (e) {
		recup_erreur(e);
	}
}


function majPaginationAR() {
	try {

		document.getElementById('pageDebAR').value = pageCouranteAR;
		document.getElementById('bPrecAR').disabled = (pageCouranteAR==1);
		document.getElementById('bSuivAR').disabled = (pageCouranteAR==nbPagesAR);

		document.getElementById('listeArticleRecu').disabled = true;
		document.getElementById('bEditionCsvAR').disabled = true;

		qListAR.setParam("Current_Page", pageCouranteAR);
		var result = qListAR.execute();
		var listArticleRecuId = result.responseXML.documentElement.getAttribute("List_Article_Recu_Id");
		var listArticleId = result.responseXML.documentElement.getAttribute("List_Article_Id");
		var listBonRecId = result.responseXML.documentElement.getAttribute("List_Bon_Rec_Id");

		aRecus.setParam("List_Article_Recu_Id", listArticleRecuId);
		aRecus.setParam("List_Article_Id", listArticleId);
		aRecus.setParam("List_Bon_Rec_Id", listBonRecId);
		aRecus.initTree(afterMajPaginationAR);

	} catch (e) {
		recup_erreur(e);
	}
}


function afterMajPaginationAR() {
	try {

		document.getElementById('listeArticleRecu').disabled = false;
		document.getElementById('bEditionCsvAR').disabled = (aRecus.nbLignes()==0);

	} catch (e) {
		recup_erreur(e);
	}
}


function rechercherFournisseurRecep() {
	try {

		var url = "chrome://opensi/content/facturation/user/fournisseurs/popup-rechercheFournisseur.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', retourRechercherFournisseurRecep);

	} catch (e) {
		recup_erreur(e);
	}
}


function retourRechercherFournisseurRecep(numFournisseur, fournisseurId) {
	try {

		document.getElementById('Fournisseur_Recep').value = numFournisseur;
		listerArticlesRecus();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnDateDebut(ev) {
  try {

    if (ev.keyCode==13) {
			listerArticlesRecus();
    }

  } catch (e) {
    recup_erreur(e);
  }
}


function pressOnDateFin(ev) {
  try {

    if (ev.keyCode==13) {
			listerArticlesRecus();
    }

  } catch (e) {
    recup_erreur(e);
  }
}


function pressOnFournisseurRecep(ev) {
  try {

    if (ev.keyCode==13) {
			listerArticlesRecus();
    }

  } catch (e) {
    recup_erreur(e);
  }
}


function pressOnNumeroBL(ev) {
  try {

    if (ev.keyCode==13) {
			listerArticlesRecus();
    }

  } catch (e) {
    recup_erreur(e);
  }
}


function editerArtRecus() {
	try {

		var numFournisseur = document.getElementById('Fournisseur_Recep').value;
		var depotId = document.getElementById('depotArtRecep').value;
		var dateDebut = document.getElementById('Date_Debut').value;
		var dateFin = document.getElementById('Date_Fin').value;
		var numeroBL = document.getElementById('Numero_BL').value;

		if (isEmpty(dateDebut)) {
			showWarning("Veuillez saisir une date de d\u00E9but !");
		}
		else if (!isDate(dateDebut)) {
			showWarning("Date de d\u00E9but incorrecte !");
		}
		else if (!isEmpty(dateFin) && !isDate(dateFin)) {
			showWarning("Date de fin incorrecte !");
		}
		else if (!isEmpty(dateFin) && !isDateInterval(dateDebut, dateFin)) {
			showWarning("La date de fin doit \u00EAtre sup\u00E9rieure \u00E0 la date de d\u00E9but !");
		}
		else {
			var queryEdit = new QueryHttp("Facturation/Reception/csvArticleRecu.tmpl");
			queryEdit.setParam('Date_Debut', dateDebut);
			queryEdit.setParam('Date_Fin', dateFin);
			queryEdit.setParam('Num_Fournisseur', numFournisseur);
			queryEdit.setParam('Depot_Id', depotId);
			queryEdit.setParam('Numero_BL', numeroBL);
			queryEdit.execute(editerArtRecus_2);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function editerArtRecus_2(result) {
	try {

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');

			var file = fileChooser("save", fichier);
			if (file!=null) {
				downloadFile(getDirBuffer()+ fichier, file);
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}
