/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var oebr_aEtablissements = new Arbre('ComboListe/combo-etablissements.tmpl', 'oebr-etablissement');
var oebr_aDepotsStock = new Arbre('ComboListe/combo-depotsStock.tmpl', 'oebr-depotStock');
var oebr_aModesExpedition = new Arbre("ComboListe/combo-modesExpedition.tmpl","oebr-modeExpedition");
var oebr_aLignes = new Arbre('Facturation/Retours_Fournisseurs/list-ligneRetourFournisseur.tmpl', 'oebr-tLignesRetour');
var oebr_aVersion = new Arbre("Facturation/Retours_Fournisseurs/list-versionRetourFournisseur.tmpl","oebr-listeVersion");

var oebr_retourId;
var oebr_ligneId = null;
var oebr_mode;
var oebr_etatRetour;
var oebr_typeRetour;
var oebr_soldeLiv;
var oebr_soldeRec;
var oebr_modified = false;
var oebr_curEtablissement;
var oebr_curDepotStock;
var oebr_curModeExpedition;
var oebr_uniteDefaut;
var oebr_fournisseurId;
var oebr_currentIndex;
var oebr_toSelectLigne = null;
var oebr_insertionLigneId;



function oebr_init() {
  try {

		oebr_uniteDefaut = gConfig.getUniteDefaut();

		document.getElementById('oebr-rowFax').collapsed = !gConfig.isShowFax();

		var aPays = new Arbre("ComboListe/combo-pays.tmpl", "oebr-codePays");
		aPays.initTree();

		var aUnites = new Arbre("ComboListe/combo-unitesVente.tmpl", "oebr-unite");
		aUnites.initTree();

	} catch (e) {
  	recup_erreur(e);
	}
}


function oebr_chargerDepotStock(selection) {
	try {

		oebr_curDepotStock = selection;
		oebr_aDepotsStock.setParam("Selection", selection);
		oebr_aDepotsStock.initTree(oebr_initDepotStock);

	} catch (e) {
		recup_erreur(e);
	}
}


function oebr_initDepotStock() {
	try {

		document.getElementById('oebr-depotStock').value = oebr_curDepotStock;

	} catch (e) {
		recup_erreur(e);
	}
}


function oebr_chargerEtablissement(selection) {
	try {

		oebr_curEtablissement = selection;
		oebr_aEtablissements.setParam("Selection", selection);
		oebr_aEtablissements.initTree(oebr_initEtablissement);

	} catch (e) {
		recup_erreur(e);
	}
}


function oebr_initEtablissement() {
	try {

		document.getElementById('oebr-etablissement').value = oebr_curEtablissement;

	} catch (e) {
		recup_erreur(e);
	}
}


function oebr_chargerModeExpedition(selection) {
	try {

		oebr_curModeExpedition = selection;
		oebr_aModesExpedition.setParam("Selection", selection);
		oebr_aModesExpedition.initTree(oebr_initModeExpedition);

	} catch (e) {
		recup_erreur(e);
	}
}


function oebr_initModeExpedition() {
	try {

		document.getElementById('oebr-modeExpedition').value = oebr_curModeExpedition;

	} catch (e) {
		recup_erreur(e);
	}
}


function oebr_initIHM() {
	try {

		document.getElementById('oebr-bEnregistrerRF').collapsed = oebr_mode=="V";
		document.getElementById('oebr-bSupprimerRF').collapsed = oebr_mode!="M";
		document.getElementById('oebr-bAnnulerRF').collapsed = oebr_mode!="V" || oebr_etatRetour!="T";
		document.getElementById('oebr-bVisualiserRF').collapsed = oebr_mode!="V";
		document.getElementById('oebr-bValiderRF').collapsed = oebr_mode!="M";
		document.getElementById('oebr-bExpeditions').collapsed = oebr_mode!="V";
		document.getElementById('oebr-bReceptions').collapsed = oebr_mode!="V" || oebr_typeRetour=="R";
		document.getElementById('oebr-bSolderLiv').collapsed = oebr_mode!="V" || oebr_soldeLiv || oebr_etatRetour=="A";
		document.getElementById('oebr-bSolderRec').collapsed = oebr_mode!="V" || (!oebr_soldeLiv || oebr_soldeRec) || oebr_typeRetour=="R";
		document.getElementById('oebr-bChoisirMentions').disabled = oebr_mode!="M";
		document.getElementById('oebr-bOuvrirCommentairesCaches').disabled = oebr_mode=="C";
		document.getElementById('oebr-bImporterLignes').disabled = oebr_mode!="M";
		document.getElementById('oebr-bMultiSuppression').disabled = true;

		document.getElementById('oebr-ligneRetour').collapsed = oebr_mode=="V";
		document.getElementById('oebr-boxTotaux').collapsed = oebr_mode!="V";
		oebr_annulerLigne();

		document.getElementById('oebr-etablissement').disabled = oebr_mode=="V";
		document.getElementById('oebr-depotStock').disabled = oebr_mode=="V";
		document.getElementById('oebr-modeExpedition').disabled = oebr_mode=="V";
		document.getElementById('oebr-numRMA').disabled = oebr_mode=="V";
		document.getElementById('oebr-intitule').disabled = oebr_mode=="V";
		document.getElementById('oebr-typeRetour').disabled = oebr_mode=="V";
		document.getElementById('oebr-commentairesFin').disabled = oebr_mode=="V";
		document.getElementById('oebr-commentairesInt').disabled = oebr_mode=="V";
		document.getElementById('oebr-bRechFournisseur').collapsed = oebr_mode=="V";

		if (oebr_mode=="V") {
			document.getElementById('oebr-denomination').setAttribute('readonly', true);
			document.getElementById('oebr-adresse1').setAttribute('readonly', true);
			document.getElementById('oebr-adresse2').setAttribute('readonly', true);
			document.getElementById('oebr-adresse3').setAttribute('readonly', true);
			document.getElementById('oebr-codePostal').setAttribute('readonly', true);
			document.getElementById('oebr-ville').setAttribute('readonly', true);
			document.getElementById('oebr-codePays').disabled = true;
			document.getElementById('oebr-civInter').disabled = true;
			document.getElementById('oebr-nomInter').setAttribute('readonly', true);
			document.getElementById('oebr-prenomInter').setAttribute('readonly', true);
			document.getElementById('oebr-telInter1').setAttribute('readonly', true);
			document.getElementById('oebr-telInter2').setAttribute('readonly', true);
			document.getElementById('oebr-faxInter').setAttribute('readonly', true);
			document.getElementById('oebr-emailInter').setAttribute('readonly', true);
		}
		else {
			document.getElementById('oebr-denomination').removeAttribute('readonly');
			document.getElementById('oebr-adresse1').removeAttribute('readonly');
			document.getElementById('oebr-adresse2').removeAttribute('readonly');
			document.getElementById('oebr-adresse3').removeAttribute('readonly');
			document.getElementById('oebr-codePostal').removeAttribute('readonly');
			document.getElementById('oebr-ville').removeAttribute('readonly');
			document.getElementById('oebr-codePays').disabled = false;
			document.getElementById('oebr-civInter').disabled = false;
			document.getElementById('oebr-nomInter').removeAttribute('readonly');
			document.getElementById('oebr-prenomInter').removeAttribute('readonly');
			document.getElementById('oebr-telInter1').removeAttribute('readonly');
			document.getElementById('oebr-telInter2').removeAttribute('readonly');
			document.getElementById('oebr-faxInter').removeAttribute('readonly');
			document.getElementById('oebr-emailInter').removeAttribute('readonly');
		}

		document.getElementById('oebr-tLignesRetour').disabled = false;
		document.getElementById('oebr-tabEntete').selectedIndex = 0;

		document.getElementById('oebr-colPrixUnitaire').collapsed = oebr_mode!="V";
		if (oebr_mode=="V") {
			document.getElementById('oebr-colPrixUnitaire').removeAttribute("ignoreincolumnpicker");
		}
		else {
			document.getElementById('oebr-colPrixUnitaire').setAttribute("ignoreincolumnpicker", true);
		}

		document.getElementById("oebr-chiffre").checked = gConfig.isRFChiffre();

		oebr_setModified(false);

	} catch (e) {
		recup_erreur(e);
	}
}


function oebr_nouveauRetour() {
  try {

		document.getElementById('oebr-deckRetour').selectedIndex = 0;
		document.getElementById('oebr-tLignesRetour').disabled = true;

		oebr_retourId = "";
		oebr_mode = "C";
		oebr_etatRetour = "N";
		oebr_typeRetour = "";
		oebr_soldeLiv = false;
		oebr_soldeRec = false;
		oebr_fournisseurId = "";
  	oebr_chargerDepotStock(depotDefaut);
		oebr_chargerEtablissement(etablissementDefaut);
		oebr_chargerModeExpedition("");
		oebr_aLignes.deleteTree();
		oebr_aVersion.deleteTree();
		document.getElementById('oebr-tabVersionDocument').collapsed = true;

		document.getElementById('oebr-numRetour').value = "";
		document.getElementById('oebr-dateRetour').value = "";
		document.getElementById('oebr-etat').value = "Nouveau";
		document.getElementById('oebr-numFournisseur').value = "";
		document.getElementById('oebr-numRMA').value = "";
		document.getElementById('oebr-intitule').value = "";
		document.getElementById('oebr-typeRetour').selectedIndex = -1;
		document.getElementById('oebr-commentairesFin').value = "";
		document.getElementById('oebr-commentairesInt').value = "";
		document.getElementById('oebr-totalHT').value = "";
		document.getElementById('oebr-denomination').value = "";
		document.getElementById('oebr-adresse1').value = "";
		document.getElementById('oebr-adresse2').value = "";
		document.getElementById('oebr-adresse3').value = "";
		document.getElementById('oebr-codePostal').value = "";
		document.getElementById('oebr-ville').value = "";
		document.getElementById('oebr-codePays').value = "FR";
		document.getElementById('oebr-civInter').selectedIndex = 0;
		document.getElementById('oebr-nomInter').value = "";
		document.getElementById('oebr-prenomInter').value = "";
		document.getElementById('oebr-telInter1').value = "";
		document.getElementById('oebr-telInter2').value = "";
		document.getElementById('oebr-faxInter').value = "";
		document.getElementById('oebr-emailInter').value = "";

		document.getElementById('oebr-creation').setAttribute("label", "");
		document.getElementById('oebr-modification').setAttribute("label", "");
		document.getElementById('oebr-document').setAttribute("label", "");

		oebr_initIHM();

	} catch (e) {
  	recup_erreur(e);
  }
}


function oebr_chargerRetour() {
  try {

		document.getElementById('oebr-deckRetour').selectedIndex = 0;
		document.getElementById('oebr-tLignesRetour').disabled = true;
		document.getElementById('oebr-tabVersionDocument').collapsed = false;

		var qLoad = new QueryHttp('Facturation/Retours_Fournisseurs/loadRetourFournisseur.tmpl');
		qLoad.setParam("Retour_Id", oebr_retourId);
		var result = qLoad.execute();
		var contenu = result.responseXML.documentElement;

		oebr_etatRetour = contenu.getAttribute("Etat");
		oebr_typeRetour = contenu.getAttribute("Type_Retour");
		oebr_soldeLiv = contenu.getAttribute("Solde_Liv")=="true";
		oebr_soldeRec = contenu.getAttribute("Solde_Rec")=="true";
		oebr_mode = (oebr_etatRetour=="N"?"M":"V");

		oebr_chargerDepotStock(contenu.getAttribute('Depot_Id'));
		oebr_chargerEtablissement(contenu.getAttribute('Etab_Id'));
		oebr_chargerModeExpedition(contenu.getAttribute('Mode_Expedition'));

		oebr_fournisseurId = contenu.getAttribute("Fournisseur_Id");

		document.getElementById('oebr-numRetour').value = contenu.getAttribute("Num_Retour");
		document.getElementById('oebr-dateRetour').value = contenu.getAttribute("Date_Retour");
		document.getElementById('oebr-etat').value = contenu.getAttribute("Libelle_Etat");
		document.getElementById('oebr-numFournisseur').value = contenu.getAttribute("Num_Fournisseur");
		document.getElementById('oebr-numRMA').value = contenu.getAttribute("Num_RMA");
		document.getElementById('oebr-intitule').value = contenu.getAttribute("Intitule");
		document.getElementById('oebr-typeRetour').value = contenu.getAttribute("Type_Retour");
		document.getElementById('oebr-commentairesFin').value = contenu.getAttribute("Commentaires_Fin");
		document.getElementById('oebr-commentairesInt').value = contenu.getAttribute("Commentaires_Int");
		document.getElementById('oebr-totalHT').value = contenu.getAttribute("Total_HT");
		document.getElementById('oebr-denomination').value = contenu.getAttribute("Denomination");
		document.getElementById('oebr-adresse1').value = contenu.getAttribute("Adresse_1");
		document.getElementById('oebr-adresse2').value = contenu.getAttribute("Adresse_2");
		document.getElementById('oebr-adresse3').value = contenu.getAttribute("Adresse_3");
		document.getElementById('oebr-codePostal').value = contenu.getAttribute("Code_Postal");
		document.getElementById('oebr-ville').value = contenu.getAttribute("Ville");
		document.getElementById('oebr-codePays').value = contenu.getAttribute("Code_Pays");
		document.getElementById('oebr-civInter').value = contenu.getAttribute("Civ_Inter");
		document.getElementById('oebr-nomInter').value = contenu.getAttribute("Nom_Inter");
		document.getElementById('oebr-prenomInter').value = contenu.getAttribute("Prenom_Inter");
		document.getElementById('oebr-telInter1').value = contenu.getAttribute("Tel_Inter_1");
		document.getElementById('oebr-telInter2').value = contenu.getAttribute("Tel_Inter_2");
		document.getElementById('oebr-faxInter').value = contenu.getAttribute("Fax_Inter");
		document.getElementById('oebr-emailInter').value = contenu.getAttribute("Email_Inter");

		document.getElementById('oebr-creation').setAttribute("label","Retour cr\u00E9\u00E9 le "+ contenu.getAttribute('Date_Creation') +" par "+ contenu.getAttribute('Login_Creation'));
		document.getElementById('oebr-modification').setAttribute("label","Derni\u00E8re modification le "+ contenu.getAttribute('Date_Maj') +" par "+ contenu.getAttribute('Login_Maj'));
		document.getElementById('oebr-document').setAttribute("label","Retour N\u00B0 "+ contenu.getAttribute('Num_Retour'));

		oebr_aLignes.setParam('Retour_Id', oebr_retourId);
		oebr_aLignes.initTree();

		oebr_aVersion.setParam("Retour_Id", oebr_retourId);
		oebr_aVersion.initTree();

		oebr_initIHM();

	} catch (e) {
  	recup_erreur(e);
  }
}


function oebr_enregistrerRetour(rafraichir) {
  try {

  	var ok = false;

		var qSave;

		if (oebr_mode=="C") {
			qSave = new QueryHttp("Facturation/Retours_Fournisseurs/createRetourFournisseur.tmpl");
		}
		else {
			qSave = new QueryHttp("Facturation/Retours_Fournisseurs/updateRetourFournisseur.tmpl");
			qSave.setParam("Retour_Id", oebr_retourId);
		}

		var numRMA = document.getElementById('oebr-numRMA').value;
		var intitule = document.getElementById('oebr-intitule').value;
		var typeRetour = document.getElementById('oebr-typeRetour').value;
		var etablissement = document.getElementById('oebr-etablissement').value;
		var depotStock = document.getElementById('oebr-depotStock').value;
		var modeExpedition = document.getElementById('oebr-modeExpedition').value;
		var commentairesFin = document.getElementById('oebr-commentairesFin').value;
		var commentairesInt = document.getElementById('oebr-commentairesInt').value;
		var denomination = document.getElementById('oebr-denomination').value;
		var adresse1 = document.getElementById('oebr-adresse1').value;
		var adresse2 = document.getElementById('oebr-adresse2').value;
		var adresse3 = document.getElementById('oebr-adresse3').value;
		var codePostal = document.getElementById('oebr-codePostal').value;
		var ville = document.getElementById('oebr-ville').value;
		var codePays = document.getElementById('oebr-codePays').value;
		var civInter = document.getElementById('oebr-civInter').value;
		var nomInter = document.getElementById('oebr-nomInter').value;
		var prenomInter = document.getElementById('oebr-prenomInter').value;
		var telInter1 = document.getElementById('oebr-telInter1').value;
		var telInter2 = document.getElementById('oebr-telInter2').value;
		var faxInter = document.getElementById('oebr-faxInter').value;
		var emailInter = document.getElementById('oebr-emailInter').value;

		if (isEmpty(denomination)) { showWarning("Veuillez indiquer la d\u00E9nomination du fournisseur"); }
		else if (isEmpty(adresse1)) { showWarning("Veuillez indiquer l'adresse du fournisseur"); }
		else if (isEmpty(ville)) { showWarning("Veuillez indiquer la ville du fournisseur"); }
		else if (!isEmpty(telInter1) && !isPhone(telInter1)) { showWarning("T\u00E9l\u00E9phone 1 du contact incorrect"); }
		else if (!isEmpty(telInter2) && !isPhone(telInter2)) { showWarning("T\u00E9l\u00E9phone 2 du contact incorrect"); }
		else if (!isEmpty(faxInter) && !isPhone(faxInter)) { showWarning("Num\u00E9ro de fax du contact incorrect"); }
		else if (!isEmpty(emailInter) && !isEmail(emailInter)) { showWarning("Adresse e-mail du contact incorrecte"); }
		else if (isEmpty(typeRetour) || document.getElementById('oebr-typeRetour').selectedIndex==-1) { showWarning("Veuillez choisir un type de retour"); }
		else {

			qSave.setParam("Fournisseur_Id", oebr_fournisseurId);
			qSave.setParam("Num_RMA", numRMA);
			qSave.setParam("Intitule", intitule);
			qSave.setParam("Type_Retour", typeRetour);
			qSave.setParam("Etab_Id", etablissement);
			qSave.setParam("Depot_Id", depotStock);
			qSave.setParam("Mode_Expedition", modeExpedition);
			qSave.setParam("Commentaires_Fin", commentairesFin);
			qSave.setParam("Commentaires_Int", commentairesInt);
			qSave.setParam("Denomination", denomination);
			qSave.setParam("Adresse_1", adresse1);
			qSave.setParam("Adresse_2", adresse2);
			qSave.setParam("Adresse_3", adresse3);
			qSave.setParam("Code_Postal", codePostal);
			qSave.setParam("Ville", ville);
			qSave.setParam("Code_Pays", codePays);
			qSave.setParam("Civ_Inter", civInter);
			qSave.setParam("Nom_Inter", nomInter);
			qSave.setParam("Prenom_Inter", prenomInter);
			qSave.setParam("Tel_Inter_1", telInter1);
			qSave.setParam("Tel_Inter_2", telInter2);
			qSave.setParam("Fax_Inter", faxInter);
			qSave.setParam("Email_Inter", emailInter);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				if (oebr_mode=="C") {
					oebr_retourId = result.responseXML.documentElement.getAttribute("Retour_Id");
					if (rafraichir) {
						oebr_chargerRetour();
					}
				}

				oebr_setModified(false);
				ok = true;
			}
		}

		return ok;

	} catch (e) {
  	recup_erreur(e);
  }
}


function oebr_supprimerRetour() {
  try {

		if (window.confirm("Confirmez-vous la suppression du retour ?")) {

			var qSup = new QueryHttp("Facturation/Retours_Fournisseurs/deleteRetourFournisseur.tmpl");
			qSup.setParam("Retour_Id", oebr_retourId);
			var result = qSup.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showMessage("Le retour a \u00E9t\u00E9 supprim\u00E9.");
				retourMenuRetours();
			}
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function oebr_annulerLigne() {
	try {

		oebr_aLignes.clearSelection();
		oebr_ligneId = null;

		oebr_initLigneIHM();

		document.getElementById('oebr-reference').focus();

	} catch (e) {
		recup_erreur(e);
	}
}


function oebr_pressOnWindow(ev) {
	try {

		if (ev.altKey && oebr_mode!="V") {
			switch(ev.charCode) {
      	case 97: // 'a'
				case 65: // 'A'
        	oebr_rechercherArticle();
        	break;
    	}
		}
		else if (ev.ctrlKey && oebr_mode!="V" && ev.keyCode==46) {
			// ctrl + suppr
			ev.preventDefault();
			oebr_supprimerLigne();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oebr_initLigneIHM() {
	try {

		document.getElementById('oebr-bMoveUp').disabled = true;
		document.getElementById('oebr-bMoveDown').disabled = true;
		document.getElementById('oebr-bMoveFirst').disabled = true;
		document.getElementById('oebr-bMoveLast').disabled = true;

		oebr_insertionLigneId = 0;
		document.getElementById('oebr-bInsererLigne').disabled = true;
		document.getElementById('oebr-actInsert').collapsed = true;
		oebr_aLignes.setCellSrc(oebr_currentIndex, 'oebr-colReference', "");

		document.getElementById('oebr-bLiaisonBR').disabled = true;
		document.getElementById('oebr-bLiaisonBR').collapsed = false;
		document.getElementById('oebr-bDeliaisonBR').disabled = true;
		document.getElementById('oebr-bDeliaisonBR').collapsed = true;

		document.getElementById('oebr-reference').value = "";
		document.getElementById('oebr-designation').value = "";
		document.getElementById('oebr-nbPieces').value = "";
		document.getElementById('oebr-quantite').value = "1";
		document.getElementById('oebr-unite').value = oebr_uniteDefaut;
		document.getElementById('oebr-bArticle').disabled = false;
		document.getElementById('oebr-bCommentaire').disabled = true;
		document.getElementById('oebr-bSupprimer').disabled = true;
		document.getElementById('oebr-reference').removeAttribute("readonly");
		document.getElementById('oebr-designation').removeAttribute("readonly");

	} catch (e) {
		recup_erreur(e);
	}
}


function oebr_ouvrirCommentaire() {
  try {

		if (oebr_aLignes.isSelected() && oebr_mode=="M") {
			if (oebr_aLignes.getSelectedCellText('oebr-colTypeLigne')=="C") {
				oebr_editerCommentaire();
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oebr_editerCommentaire() {
  try {

		if (oebr_ligneId!=null) {
			var url = "chrome://opensi/content/facturation/user/commun/popup-commentairesLigne.xul";
    	window.openDialog(url,'','chrome,modal,centerscreen', "RF", oebr_ligneId);

			oebr_annulerLigne();
			oebr_aLignes.initTree(oebr_afterRefreshLignes);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oebr_deplacerLigne(moveType) {
	try {

		if (oebr_ligneId!=null && oebr_mode=="M" && oebr_aLignes.getSelectedCellText('oebr-colTypeLigne')!="C") {

			document.getElementById('oebr-bMoveUp').disabled = true;
			document.getElementById('oebr-bMoveDown').disabled = true;
			document.getElementById('oebr-bMoveFirst').disabled = true;
			document.getElementById('oebr-bMoveLast').disabled = true;

			var qMove = new QueryHttp("Facturation/Retours_Fournisseurs/moveLigneRetourFournisseur.tmpl");
			qMove.setParam("Ligne_Id", oebr_ligneId);
			qMove.setParam("Move_Type", moveType);
			var result = qMove.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oebr_toSelectLigne = oebr_ligneId;
				oebr_annulerLigne();
				oebr_aLignes.initTree(oebr_afterRefreshLignes);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oebr_afterRefreshLignes() {
	try {

		if (oebr_toSelectLigne!=null) {
			for (var i=0; i<oebr_aLignes.nbLignes(); i++) {
				if (oebr_aLignes.getCellText(i, "oebr-colLigneId")==oebr_toSelectLigne && oebr_aLignes.getCellText(i, "oebr-colTypeLigne")!="C") {
					oebr_aLignes.select(i);
					break;
				}
			}
			oebr_toSelectLigne = null;
		}
		oebr_aLignes.ensureRowIsVisible(oebr_currentIndex);

	} catch (e) {
  	recup_erreur(e);
	}
}


function oebr_pressOnQuantite(ev) {
	try {

		if (ev.keyCode==13) {
			oebr_validerLigne();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oebr_validerLigne() {
	try {

		var reference = document.getElementById('oebr-reference').value;
		var designation = document.getElementById('oebr-designation').value;
		var nbPieces = document.getElementById('oebr-nbPieces').value;
		var quantite = document.getElementById('oebr-quantite').value;
		var unite = document.getElementById('oebr-unite').value;

		if (isEmpty(nbPieces)) {
			nbPieces = 0;
		}

		if (isEmpty(designation)) { showWarning("D\u00E9signation de l'article manquante"); }
		else if (!checkQte(quantite)) { showWarning("Quantit\u00E9 incorrecte"); }
		else if (!isPositiveOrNullInteger(nbPieces)) { showWarning("Nombre de pi\u00E8ces incorrect");	}
		else {

			var saved = true;
			if (oebr_mode=="C") {
				saved = oebr_enregistrerRetour(true);
			}

			if (saved) {
				var qValider;

				if (oebr_ligneId!=null) {
					qValider = new QueryHttp("Facturation/Retours_Fournisseurs/updateLigneRetourFournisseur.tmpl");
					qValider.setParam("Ligne_Id", oebr_ligneId);
				}
				else {
					qValider = new QueryHttp("Facturation/Retours_Fournisseurs/createLigneRetourFournisseur.tmpl");
					qValider.setParam("Retour_Id", oebr_retourId);
				}

				qValider.setParam("Reference", reference);
				qValider.setParam("Designation", designation);
				qValider.setParam("Nb_Pieces", nbPieces);
				qValider.setParam("Quantite", quantite);
				qValider.setParam("Unite_Id", unite);
				qValider.setParam("Insertion_Ligne_Id", oebr_insertionLigneId);

				var result = qValider.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
				else {
					oebr_annulerLigne();
					oebr_aLignes.initTree(oebr_afterRefreshLignes);
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oebr_supprimerLigne() {
	try {

		var listLigneId = "";
		var maxIndex = 0;

		if (oebr_aLignes.nbSelection()==1) {
			listLigneId = oebr_ligneId;
			maxIndex = oebr_currentIndex;
		}
		else {
			var start = new Object();
			var end = new Object();
			var numRanges = oebr_aLignes.getRangeCount();

			for (var t=0; t<numRanges; t++){
				oebr_aLignes.getRangeAt(t,start,end);
			  for (var v=start.value; v<=end.value; v++){
					if (oebr_aLignes.getCellText(v,'oebr-colTypeLigne')!="C") {
			  		listLigneId += oebr_aLignes.getCellText(v,'oebr-colLigneId')+",";
						if (v>maxIndex) maxIndex = v;
					}
			  }
			}
		}

		if (!isEmpty(listLigneId)) {
			var qDelete = new QueryHttp("Facturation/Retours_Fournisseurs/deleteLigneRetourFournisseur.tmpl");
			qDelete.setParam('List_Ligne_Id', listLigneId);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oebr_currentIndex = maxIndex-1;
				oebr_annulerLigne();
				oebr_aLignes.initTree(oebr_afterRefreshLignes);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oebr_insererLigne() {
  try {

		if (oebr_aLignes.isSelected() && oebr_mode=="M") {
			var idx = oebr_aLignes.getCurrentIndex();
			oebr_currentIndex = idx;
			var ligneId = oebr_aLignes.getCellText(idx,'oebr-colLigneId');
			oebr_annulerLigne();

			oebr_aLignes.setCellSrc(idx, 'oebr-colReference', "chrome://opensi/content/design/insertbefore.png");

			oebr_insertionLigneId = ligneId;

			document.getElementById('oebr-actInsert').collapsed = false;
			document.getElementById('oebr-reference').focus();
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oebr_pressOnLigneRetour(ev) {
	try {

		if (ev.keyCode==45 && ev.ctrlKey) {
			// ctrl + inser
			// insrer une ligne avant

			oebr_insererLigne();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oebr_selectOnLignesRetour() {
	try {

		if (oebr_mode!="V" && oebr_aLignes.isSelected()) {

			if (oebr_aLignes.nbSelection()==1) {
				oebr_currentIndex = oebr_aLignes.getCurrentIndex();
				oebr_ligneId = oebr_aLignes.getSelectedCellText('oebr-colLigneId');
				document.getElementById('oebr-bMultiSuppression').disabled = true;

				if (oebr_aLignes.getSelectedCellText('oebr-colTypeLigne')=="C") {
					oebr_initLigneIHM();
				}
				else {
					document.getElementById('oebr-reference').value = oebr_aLignes.getSelectedCellText('oebr-colReference');
					document.getElementById('oebr-designation').value = oebr_aLignes.getSelectedCellText('oebr-colDesignation');
					document.getElementById('oebr-nbPieces').value = oebr_aLignes.getSelectedCellText('oebr-colNbPieces');
					document.getElementById('oebr-quantite').value = oebr_aLignes.getSelectedCellText('oebr-colQuantite');
					document.getElementById('oebr-unite').value = oebr_aLignes.getSelectedCellText('oebr-colUniteId');
					document.getElementById('oebr-bSupprimer').disabled = false;
					document.getElementById('oebr-bCommentaire').disabled = false;

					if (oebr_aLignes.getSelectedCellText('oebr-colTypeLigne')=="S") {
						document.getElementById('oebr-reference').setAttribute("readonly", true);
						document.getElementById('oebr-designation').setAttribute("readonly", true);
					}

					oebr_aLignes.setCellSrc(oebr_currentIndex, 'oebr-colReference', "");

					document.getElementById('oebr-bInsererLigne').disabled = false;
					oebr_insertionLigneId = 0;
					document.getElementById('oebr-actInsert').collapsed = true;

					var linked = !isEmpty(oebr_aLignes.getSelectedCellText('oebr-colNumeroBR'));

					document.getElementById('oebr-bLiaisonBR').disabled = linked;
					document.getElementById('oebr-bLiaisonBR').collapsed = linked;
					document.getElementById('oebr-bDeliaisonBR').disabled = !linked;
					document.getElementById('oebr-bDeliaisonBR').collapsed = !linked;

					var firstIndex = 0;
					var lastIndex = oebr_aLignes.nbLignes()-1;

					if (oebr_aLignes.getCellText(firstIndex,'oebr-colTypeLigne')=="C") { firstIndex++; }
					if (oebr_aLignes.getCellText(lastIndex,'oebr-colTypeLigne')=="C") { lastIndex--; }

					document.getElementById('oebr-bMoveUp').disabled = (oebr_currentIndex==firstIndex);
					document.getElementById('oebr-bMoveDown').disabled = (oebr_currentIndex==lastIndex);
					document.getElementById('oebr-bMoveFirst').disabled = (oebr_currentIndex==firstIndex);
					document.getElementById('oebr-bMoveLast').disabled = (oebr_currentIndex==lastIndex);
				}
			}
			else {
				oebr_initLigneIHM();
				document.getElementById('oebr-bMultiSuppression').disabled = false;
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oebr_demandeEnregistrement() {
  try {

		if (oebr_modified) {
			if (window.confirm("Voulez-vous enregistrer les modifications apport\u00E9es au retour ?")) {
				oebr_enregistrerRetour(false);
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oebr_setModified(m) {
  try {

  	oebr_modified = m;
		if (m) {
			document.getElementById('oebr-tabRetour').setAttribute('image', 'chrome://opensi/content/design/icones/modified.png');
			document.getElementById('oebr-bValiderRF').disabled = true;
		}
		else {
			document.getElementById('oebr-tabRetour').setAttribute('image', null);
			document.getElementById('oebr-bValiderRF').disabled = false;
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oebr_editerRetour() {
	try {

		document.getElementById('oebr-pdfRetour').setAttribute("src", "");
		document.getElementById("bRetourBonRetour").collapsed = false;
		document.getElementById("oebr-deckRetour").selectedIndex = 1;
		var chiffre = document.getElementById("oebr-chiffre").checked;

		var qGenPdf = new QueryHttp("Facturation/Retours_Fournisseurs/pdfRetourFournisseur.tmpl");
		qGenPdf.setParam("Retour_Id", oebr_retourId);
		qGenPdf.setParam("Chiffre", chiffre);
		var result = qGenPdf.execute();
		var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
		document.getElementById('oebr-pdfRetour').setAttribute("src", page);

	} catch (e) {
		recup_erreur(e);
	}
}


function oebr_validerRetour() {
  try {

		if (oebr_aLignes.nbLignes()==0) {
			showWarning("Le retour ne contient aucune ligne.");
		}
  	else if (window.confirm("Confirmez-vous la validation du retour ?")) {

			var qValider = new QueryHttp("Facturation/Retours_Fournisseurs/validRetourFournisseur.tmpl");
			qValider.setParam("Retour_Id", oebr_retourId);
			var result = qValider.execute();
			var errors = new Errors(result);

			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oebr_chargerRetour();
			}
  	}

	} catch (e) {
    recup_erreur(e);
  }
}


function oebr_annulerRetour() {
	try {

		if (window.confirm("Confirmez-vous l'annulation du retour ?")) {
			var qAnnuler = new QueryHttp("Facturation/Retours_Fournisseurs/cancelRetourFournisseur.tmpl");
			qAnnuler.setParam("Retour_Id", oebr_retourId);
			var result = qAnnuler.execute();
			var errors = new Errors(result);

			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showMessage("Le retour a \u00E9t\u00E9 annul\u00E9.");
				oebr_chargerRetour();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oebr_solderLivraison() {
	try {

		if (window.confirm("Confirmez-vous le solde de la livraison du retour fournisseur ?")) {
			var qSolder = new QueryHttp("Facturation/Retours_Fournisseurs/settleLivraison.tmpl");
			qSolder.setParam('Retour_Id', oebr_retourId);
			var result = qSolder.execute();
			var errors = new Errors(result);

			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showMessage("Le retour fournisseur a \u00E9t\u00E9 sold\u00E9 en livraison.");
				oebr_chargerRetour();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oebr_solderReception() {
	try {

		if (window.confirm("Confirmez-vous le solde de la r\u00E9ception du retour fournisseur ?")) {
			var qSolder = new QueryHttp("Facturation/Retours_Fournisseurs/settleReception.tmpl");
			qSolder.setParam('Retour_Id', oebr_retourId);
			var result = qSolder.execute();
			var errors = new Errors(result);

			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showMessage("Le retour fournisseur a \u00E9t\u00E9 sold\u00E9 en r\u00E9ception.");
				oebr_chargerRetour();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oebr_initLigneArticle(reference, articleId) {
	try {

		oebr_ligneId = null;
		document.getElementById('oebr-reference').value = reference;
		document.getElementById('oebr-quantite').value = 1;
		document.getElementById('oebr-quantite').focus();

		var qDesignation = new QueryHttp("Facturation/Articles/getDesignation.tmpl");
		qDesignation.setParam("Article_Id", articleId);
		var result = qDesignation.execute();
		document.getElementById('oebr-designation').value = result.responseXML.documentElement.getAttribute("Designation");

		document.getElementById('oebr-reference').setAttribute("readonly", true);
		document.getElementById('oebr-designation').setAttribute("readonly", true);

	} catch (e) {
    recup_erreur(e);
  }
}


function oebr_rechercherArticle(reference) {
	try {

		var url = "chrome://opensi/content/facturation/user/articles/popup-rechercheArticle.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oebr_initLigneArticle, "A", reference, null, true, oebr_fournisseurId);

	} catch (e) {
    recup_erreur(e);
  }
}


function oebr_pressOnReference(ev) {
	try {

		if (ev.keyCode==13) {
			oebr_rechercherReference();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oebr_rechercherReference() {
	try {

		var reference = document.getElementById('oebr-reference').value;

		var qSearch = new QueryHttp("Facturation/Articles/searchReference.tmpl");
		qSearch.setParam("Reference", reference);
		qSearch.setParam("Vente_Achat", "A");
		qSearch.setParam("No_Forfait", true);
		if (!isEmpty(oebr_fournisseurId)) { qSearch.setParam('Fournisseur_Id', oebr_fournisseurId); }
		var result = qSearch.execute();

		var articleId = result.responseXML.documentElement.getAttribute("Article_Id");

		if (!isEmpty(articleId)) {
			var findReference = result.responseXML.documentElement.getAttribute("Reference");
			oebr_initLigneArticle(findReference, articleId);
		}
		else {
			oebr_rechercherArticle(reference);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oebr_rechercherFournisseur() {
	try {

		var url = "chrome://opensi/content/facturation/user/fournisseurs/popup-rechercheFournisseur.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oebr_retourRechercherFournisseur);

  } catch (e) {
    recup_erreur(e);
  }
}


function oebr_retourRechercherFournisseur(numFournisseur, fournisseurId) {
	try {

		oebr_fournisseurId = fournisseurId;
		oebr_setModified(true);
		oebr_chargerCoord();

	} catch (e) {
		recup_erreur(e);
	}
}


function oebr_chargerCoord() {
  try {

		var qGet = new QueryHttp("Facturation/Fournisseurs/getDefautDocumentAchat.tmpl");
		qGet.setParam("Fournisseur_Id", oebr_fournisseurId);
	  var result = qGet.execute();

	  var contenu = result.responseXML.documentElement;

		document.getElementById('oebr-numFournisseur').value = contenu.getAttribute("Num_Fournisseur");

		document.getElementById("oebr-denomination").value = contenu.getAttribute("Denomination");
		document.getElementById("oebr-adresse1").value = contenu.getAttribute("Adresse_1");
		document.getElementById("oebr-adresse2").value = contenu.getAttribute("Adresse_2");
		document.getElementById("oebr-adresse3").value = contenu.getAttribute("Adresse_3");
		document.getElementById("oebr-codePostal").value = contenu.getAttribute("Code_Postal");
		document.getElementById("oebr-ville").value = contenu.getAttribute("Ville");
		document.getElementById("oebr-codePays").value = contenu.getAttribute("Code_Pays");

		document.getElementById("oebr-civInter").value = contenu.getAttribute("Civ_Inter");
		document.getElementById("oebr-nomInter").value = contenu.getAttribute("Nom_Inter");
		document.getElementById("oebr-prenomInter").value = contenu.getAttribute("Prenom_Inter");
		document.getElementById("oebr-telInter1").value = contenu.getAttribute("Tel_Inter_1");
		document.getElementById("oebr-telInter2").value = contenu.getAttribute("Tel_Inter_2");
		document.getElementById("oebr-faxInter").value = contenu.getAttribute("Fax_Inter");
		document.getElementById("oebr-emailInter").value = contenu.getAttribute("Email_Inter");

		document.getElementById('oebr-bChercherAdresse').disabled = false;
		document.getElementById('oebr-bChercherInter').disabled = false;

	} catch (e) {
  	recup_erreur(e);
  }
}


function oebr_rechercherAdr() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-choixAdrCom.xul?"+ cookie() +"&Fournisseur_Id="+ oebr_fournisseurId;
    window.openDialog(url,'','chrome,modal,centerscreen', oebr_reporterAdr);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oebr_reporterAdr(nom, adr1, adr2, adr3, cp, ville, pays, code_pays, contactId, depotId) {
  try {

		document.getElementById('oebr-denomination').value = nom;
		document.getElementById('oebr-adresse1').value = adr1;
		document.getElementById('oebr-adresse2').value = adr2;
		document.getElementById('oebr-adresse3').value = adr3;
		document.getElementById('oebr-codePostal').value = cp;
		document.getElementById('oebr-ville').value = ville;
	  document.getElementById('oebr-codePays').value = code_pays;

		if (!isEmpty(contactId)) {
			var qLoad = new QueryHttp("Facturation/Fournisseurs/loadContactFournisseur.tmpl");
	  	qLoad.setParam("Contact_Id", contactId);
	  	var result = qLoad.execute();
	  	var contenu = result.responseXML.documentElement;
	  	oebr_reporterInter(contenu.getAttribute("Civilite"),contenu.getAttribute("Nom"),contenu.getAttribute("Prenom"),contenu.getAttribute("Tel_1"),contenu.getAttribute("Tel_2"),contenu.getAttribute("Fax"),contenu.getAttribute("Email"));
	  }
		else {
			oebr_setModified(true);
	  }

	} catch (e) {
  	recup_erreur(e);
  }
}


function oebr_rechercherInterlocuteur() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-choixInterFournisseur.xul?"+ cookie() +"&Fournisseur_Id="+ oebr_fournisseurId;
    window.openDialog(url,'','chrome,modal,centerscreen',oebr_reporterInter);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oebr_reporterInter(civ, nom, prenom, tel1, tel2, fax, email) {
  try {

		document.getElementById('oebr-civInter').value = civ;
		document.getElementById('oebr-nomInter').value = nom;
		document.getElementById('oebr-prenomInter').value = prenom;
		document.getElementById('oebr-telInter1').value = tel1;
		document.getElementById('oebr-telInter2').value = tel2;
		document.getElementById('oebr-faxInter').value = fax;
		document.getElementById('oebr-emailInter').value = email;

		oebr_setModified(true);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oebr_choisirMentions() {
  try {

  	var ok = true;

  	if (oebr_mode=="C") {
			ok = oebr_enregistrerRetour(true);
		}

		if (ok) {
			var url = "chrome://opensi/content/facturation/user/commun/popup-mentionsDocument.xul";
	    window.openDialog(url,'','chrome,modal,centerscreen', "RF", oebr_retourId, false);
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function oebr_editerCommentairesInternes() {
  try {

  	var url = "chrome://opensi/content/facturation/user/commun/popup-commentairesInternes.xul";
  	window.openDialog(url,'','chrome,modal,centerscreen', "RF", oebr_retourId, false);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oebr_editerCommentairesDocument() {
  try {

		var commentairesFin = document.getElementById('oebr-commentairesFin').value;
		var commentairesInt = document.getElementById('oebr-commentairesInt').value;
		var readOnly = (oebr_mode=="V");

		var url = "chrome://opensi/content/facturation/user/commun/popup-commentairesDocument.xul";
  	window.openDialog(url,'','chrome,modal,centerscreen', oebr_retourEditerCommentaires, "RF", oebr_retourId, commentairesFin, commentairesInt, readOnly);

	} catch (e) {
    recup_erreur(e);
  }
}


function oebr_retourEditerCommentaires(commentairesFin, commentairesInt) {
  try {

		document.getElementById('oebr-commentairesFin').value = commentairesFin;
		document.getElementById('oebr-commentairesInt').value = commentairesInt;

	} catch (e) {
    recup_erreur(e);
  }
}


function oebr_envoyer() {
	try {

		var chiffre = document.getElementById("oebr-chiffre").checked;

		var url = "chrome://opensi/content/popup/popup-envoyerMail.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', "RF", oebr_retourId, "", chiffre);

	} catch (e) {
		recup_erreur(e);
	}
}


function oebr_accExpeditions() {
	try {

		document.getElementById('deck').selectedIndex = 2;
		document.getElementById('bMenuRetours').collapsed = false;
		document.getElementById('bRetourBonRetour').collapsed = false;
		oerf_retourId = oebr_retourId;
		oerf_start();

	} catch (e) {
		recup_erreur(e);
	}
}


function oebr_accReceptions() {
	try {

		document.getElementById('deck').selectedIndex = 3;
		document.getElementById('bMenuRetours').collapsed = false;
		document.getElementById('bRetourBonRetour').collapsed = false;
		orrf_retourId = oebr_retourId;
		orrf_start();

	} catch (e) {
		recup_erreur(e);
	}
}


function oebr_lierLigneBR() {
	try {

		var url = "chrome://opensi/content/facturation/user/retours_fournisseurs/popup-rechLigneBR.xul?"+ cookie();
		window.openDialog(url,'','chrome,modal,centerscreen', oebr_ligneId, oebr_retourLierLigneBR);

	} catch (e) {
		recup_erreur(e);
	}
}


function oebr_retourLierLigneBR() {
	try {

		oebr_annulerLigne();
		oebr_aLignes.initTree(oebr_afterRefreshLignes);

	} catch (e) {
		recup_erreur(e);
	}
}


function oebr_delierLigneBR() {
	try {

		var qDelier = new QueryHttp("Facturation/Retours_Fournisseurs/unlinkLigneRetourFournisseurBR.tmpl");
		qDelier.setParam("Ligne_Id", oebr_ligneId);
		qDelier.execute();

		oebr_annulerLigne();
		oebr_aLignes.initTree(oebr_afterRefreshLignes);

	} catch (e) {
		recup_erreur(e);
	}
}


function oebr_importLignes() {
  try {

	  var url = "chrome://opensi/content/facturation/user/retours_fournisseurs/popup-importerLignes.xul";
	  window.openDialog(url,'','chrome,modal,centerscreen', oebr_retourImportLignes, oebr_retourId);

  } catch (e) {
    recup_erreur(e);
  }
}


function oebr_retourImportLignes() {
	try {

		oebr_aLignes.initTree(oebr_afterRefreshLignes);

	} catch (e) {
	  recup_erreur(e);
	}
}
