/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

const gClipboardHelper = Components.classes["@mozilla.org/widget/clipboardhelper;1"].getService(Components.interfaces.nsIClipboardHelper);

var oerf_aArticlesBL = new Arbre('Facturation/Retours_Fournisseurs/list-ligneBonLivraison.tmpl', 'oerf-tArticlesBL');
var oerf_aArticlesRF = new Arbre('Facturation/Retours_Fournisseurs/list-articlesNonExpediesRF.tmpl', 'oerf-tArticlesRF');
var oerf_aExpeditions = new Arbre('Facturation/Retours_Fournisseurs/list-bonLivraison.tmpl', 'oerf-tExpeditions');
var oerf_aModesExpedition = new Arbre("ComboListe/combo-modesExpedition.tmpl", "oerf-modeExpedition");
var oerf_aVersions = new Arbre("Facturation/Retours_Fournisseurs/list-versionBonLivraison.tmpl","oerf-tVersions");
var oerf_aLiensColis = new Arbre("Facturation/Affaires/list-colisBL.tmpl","oerf-liensColis");
var oerf_aLangues = new Arbre("ComboListe/combo-langues.tmpl", "oerf-langueDefaut");


var oerf_modified = false;

var oerf_editBP;
var oerf_actSuiviSerie;
var oerf_actSuiviLot;
var oerf_etapePrepaBL;
var oerf_defautEtapePrepaBLRF;

var oerf_bonId;
var oerf_retourId;
var oerf_depotId;
var oerf_bloquerBLSansStock;

var oerf_mode;
var oerf_etatBon;
var oerf_statutExpedition;
var oerf_etatRF;
var oerf_soldeLiv;
var oerf_langueDefaut;
var oerf_selectModeExpedition;
var oerf_envoiTrans;



function oerf_init() {
	try {

		var config = getConfig();

		oerf_editBP = config.isGACEditBP();
		oerf_actSuiviLot = config.isActSuiviLot();
		oerf_actSuiviSerie = config.isActSuiviSerie();
		oerf_defautEtapePrepaBLRF = config.isEtapePrepaBLRF();
		oerf_envoiTrans = config.isGRFEnvoiTransFTP();
		oerf_bloquerBLSansStock = config.isBloquerBLSansStock();

		document.getElementById("oerf-colVolumeColis").setAttribute("label", "Volume ("+ config.getSymboleUniteVolume() +")");

		document.getElementById('oerf-bConsultSerieLigne').collapsed = !oerf_actSuiviSerie;
		document.getElementById('oerf-boxSaisieSerie').collapsed = !oerf_actSuiviSerie;

		if (!oerf_actSuiviLot) {
			document.getElementById('oerf-colNumLotBL').collapsed = true;
			document.getElementById('oerf-colNumLotBL').setAttribute('ignoreincolumnpicker', true);
			document.getElementById('oerf-colDatePeremptionBL').collapsed = true;
			document.getElementById('oerf-colDatePeremptionBL').setAttribute('ignoreincolumnpicker', true);
			document.getElementById('oerf-rowNumLot').collapsed = true;
			document.getElementById('oerf-rowDLC').collapsed = true;
		}

		if (!config.isActNbPieces()) {
			document.getElementById('oerf-colNbPiecesRF').collapsed = true;
			document.getElementById('oerf-colNbPiecesRF').setAttribute('ignoreincolumnpicker', true);
			document.getElementById('oerf-colNbPiecesBL').collapsed = true;
			document.getElementById('oerf-colNbPiecesBL').setAttribute('ignoreincolumnpicker', true);
			document.getElementById('oerf-rowNbPieces').collapsed = true;
		}

  } catch (e) {
  	recup_erreur(e);
  }
}


function oerf_initModeExpedition() {
	try {

		document.getElementById('oerf-modeExpedition').value = oerf_selectModeExpedition;

	} catch (e) {
		recup_erreur(e);
	}
}


function oerf_chargerModesExpedition(selection) {
	try {

		oerf_selectModeExpedition = selection;
		oerf_aModesExpedition.setParam("Selection", selection);
		oerf_aModesExpedition.initTree(oerf_initModeExpedition);

	} catch (e) {
		recup_erreur(e);
	}
}


function oerf_start() {
	try {

		var qHasBLNonValide = new QueryHttp('Facturation/Retours_Fournisseurs/getFirstBLNonValide.tmpl');
		qHasBLNonValide.setParam("Retour_Id", oerf_retourId);
		var result = qHasBLNonValide.execute();

		if (result.responseXML.documentElement.getAttribute("HasBLNonValide")=="true") {
			oerf_bonId = result.responseXML.documentElement.getAttribute("Bon_Id");
			oerf_chargerBon();
		}
		else {
			oerf_nouveauBon();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oerf_reinitialiser() {
	try {

		oerf_mode = "C";
		oerf_etatBon = "N";
		oerf_statutExpedition = "N";
		oerf_modified = false;

		document.getElementById('oerf-deckBonLivraison').selectedIndex = 0;
		document.getElementById('oerf-tbExpedition').selectedIndex = 0;
		document.getElementById('oerf-tabBon').setAttribute('image', null);
		document.getElementById('oerf-numeroBL').value = "";
		document.getElementById('oerf-numeroBP').value = "";
		document.getElementById('oerf-tabVersions').collapsed = true;
		document.getElementById('oerf-tabColis').collapsed = true;

		oerf_aVersions.deleteTree();
		oerf_aLiensColis.deleteTree();
		oerf_aExpeditions.setParam("Retour_Id", oerf_retourId);
		oerf_aExpeditions.initTree();

		document.getElementById('oerf-numSerie').value = "";
		document.getElementById('oerf-dateBL').value = "";
		document.getElementById('oerf-dateBP').value = "";
		document.getElementById('oerf-etat').value = "";
		document.getElementById('oerf-commentairesFin').value = "";
		document.getElementById('oerf-commentairesInt').value = "";
		document.getElementById('oerf-numLot').value = "";
		document.getElementById('oerf-datePeremption').value = "";
		document.getElementById('oerf-nbPieces').value = "";
		document.getElementById('oerf-quantite').value = "";
		document.getElementById('oerf-creation').value = "";
		document.getElementById('oerf-modification').value = "";
		document.getElementById('oerf-document').value = "";
		document.getElementById('oerf-consignesLiv').value = "";
		document.getElementById('oerf-envoiTrans').checked = false;
		document.getElementById('oerf-infoPrepaExpe').value = "";
		document.getElementById('oerf-infoEnvoiTrans').value = "";
		document.getElementById('oerf-infoPrepaExpe').collapsed = true;
		document.getElementById('oerf-infoEnvoiTrans').collapsed = true;

		document.getElementById('oerf-bChoisirMentions').disabled = true;
		document.getElementById('oerf-bAjouter').disabled = true;
		document.getElementById('oerf-bToutAjouter').disabled = true;
		document.getElementById('oerf-bToutAjouterDispo').disabled = true;
		document.getElementById('oerf-bEnlever').disabled = true;
		document.getElementById('oerf-bToutEnlever').disabled = true;
		document.getElementById('oerf-bEnregistrer').disabled = true;
		document.getElementById('oerf-bGenerateBP').disabled = true;
		document.getElementById('oerf-bAnnuler').disabled = true;
		document.getElementById('oerf-bGenerateBL').collapsed = true;
		document.getElementById('oerf-bConfirmer').collapsed = true;
		document.getElementById('oerf-bSupprimer').disabled = true;
		document.getElementById('oerf-bEditionBL').disabled = true;
		document.getElementById('oerf-bEditionBP').disabled = true;
		document.getElementById('oerf-envoiTrans').disabled = true;
		document.getElementById('oerf-bAnnulerColis').disabled = true;
		document.getElementById('oerf-bCsvColisage').disabled = true;
		document.getElementById('oerf-bPdfColisage').disabled = true;

		document.getElementById('oerf-modeExpedition').disabled = true;
		document.getElementById('oerf-consignesLiv').disabled = true;
		document.getElementById('oerf-commentairesFin').disabled = true;
		document.getElementById('oerf-commentairesInt').disabled = true;
		document.getElementById('oerf-numLot').disabled = true;
		document.getElementById('oerf-datePeremption').disabled = true;
		document.getElementById('oerf-nbPieces').disabled = true;
		document.getElementById('oerf-quantite').disabled = true;
		document.getElementById('oerf-bConsultSerieLigne').disabled = true;
		document.getElementById('oerf-bOuvrirCommentairesCaches').disabled = true;

		document.getElementById('oerf-bEditionBL').collapsed = true;
		document.getElementById('oerf-bEditionBP').collapsed = true;
		document.getElementById('oerf-boxSaisieSerie').collapsed = (!oerf_actSuiviSerie || oerf_etatBon!="N");
		document.getElementById('oerf-chkEditBP').checked = !oerf_etapePrepaBL && oerf_editBP;
		document.getElementById('oerf-envoiTrans').collapsed = true;

		if (oerf_etatBon=="N") {
			document.getElementById('oerf-numSerie').focus();
		}

		oerf_aArticlesBL.deleteTree();
		oerf_aArticlesRF.deleteTree();

		// chargement des infos du retour

		var qDefTrans = new QueryHttp('Facturation/Retours_Fournisseurs/loadRetourFournisseur.tmpl');
		qDefTrans.setParam('Retour_Id', oerf_retourId);
		var result = qDefTrans.execute();
		oerf_depotId = result.responseXML.documentElement.getAttribute('Depot_Id');
		oerf_etatRF = result.responseXML.documentElement.getAttribute('Etat');
		oerf_soldeLiv = (result.responseXML.documentElement.getAttribute('Solde_Liv')=="true");
		document.getElementById('oerf-numRetour').value = result.responseXML.documentElement.getAttribute('Num_Retour');
		document.getElementById('oerf-commentairesInt').value = result.responseXML.documentElement.getAttribute('Commentaires_Int');
		document.getElementById('oerf-commentairesFin').value = result.responseXML.documentElement.getAttribute('Commentaires_Fin');

		document.getElementById('oerf-bNouveau').disabled = (oerf_etatRF=="C" || oerf_etatRF=="A" || oerf_soldeLiv);

		oerf_chargerModesExpedition(result.responseXML.documentElement.getAttribute('Mode_Expedition'));

		var qDepot = new QueryHttp("Facturation/Commun/getDepotStock.tmpl");
		qDepot.setParam("Depot_Id", oerf_depotId);
		result = qDepot.execute();

		oerf_etapePrepaBL = oerf_defautEtapePrepaBLRF;
		var etapePrepaDepotBL = result.responseXML.documentElement.getAttribute("Etape_Prepa_BL_RF");
		if (!isEmpty(etapePrepaDepotBL)) {
			oerf_etapePrepaBL = (etapePrepaDepotBL=="true");
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oerf_debloquerChamps() {
	try {

		document.getElementById('oerf-bChoisirMentions').disabled = false;
		document.getElementById('oerf-bAjouter').disabled = false;
		document.getElementById('oerf-bToutAjouter').disabled = oerf_bloquerBLSansStock;
		document.getElementById('oerf-bToutAjouterDispo').disabled = false;
		document.getElementById('oerf-bEnlever').disabled = false;

		document.getElementById('oerf-modeExpedition').disabled = false;
		document.getElementById('oerf-consignesLiv').disabled = false;
		document.getElementById('oerf-commentairesFin').disabled = false;
		document.getElementById('oerf-commentairesInt').disabled = false;
		document.getElementById('oerf-numLot').disabled = false;
		document.getElementById('oerf-datePeremption').disabled = false;
		document.getElementById('oerf-nbPieces').disabled = false;
		document.getElementById('oerf-quantite').disabled = false;
		document.getElementById('oerf-bEnregistrer').disabled = false;
		document.getElementById('oerf-bSupprimer').disabled = false;

		document.getElementById('oerf-bAjouter').disabled = true;
		document.getElementById('oerf-bEnlever').disabled = true;

	} catch (e) {
    recup_erreur(e);
  }
}


function oerf_nouveauBon() {
  try {

		oerf_bonId = "";
		oerf_reinitialiser();

		if (oerf_etatRF!="C" && oerf_etatRF!="A" && !oerf_soldeLiv) {
			oerf_aArticlesRF.clearParams();
			oerf_aArticlesRF.setParam('Retour_Id', oerf_retourId);
			oerf_aArticlesRF.initTree();

			document.getElementById('oerf-bEditionBL').collapsed = false;
			document.getElementById('oerf-bEditionBP').collapsed = false;
			document.getElementById('oerf-bSupprimer').collapsed = true;
			document.getElementById('oerf-bAnnuler').collapsed = true;
			document.getElementById('oerf-bGenerateBL').collapsed = true;
			document.getElementById('oerf-bConfirmer').collapsed = true;
			oerf_debloquerChamps();

			document.getElementById('oerf-bGenerateBP').disabled = true;
			document.getElementById('oerf-bEditionBL').disabled = true;
			document.getElementById('oerf-bEditionBP').disabled = true;
			document.getElementById('oerf-boxArticlesRF').collapsed = false;
			document.getElementById('oerf-boxActions').collapsed = false;

			oerf_setModified(false);
		}
		else {
			document.getElementById('oerf-boxActions').collapsed = true;
			document.getElementById('oerf-boxArticlesRF').collapsed = true;
			document.getElementById('oerf-boxSaisieSerie').collapsed = true;
			document.getElementById('oerf-bGenerateBP').collapsed = true;
			document.getElementById('oerf-bSupprimer').collapsed = true;
			document.getElementById('oerf-bAnnuler').collapsed = true;
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function oerf_pressOnExpeditions(ev) {
  try {

		if (ev.keyCode==13) {
			oerf_bonId = oerf_aExpeditions.getSelectedCellText('oerf-colBonId');
			oerf_chargerBon();
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function oerf_dblclickOnExpeditions() {
  try {

		if (oerf_aExpeditions.isSelected()) {
			oerf_bonId = oerf_aExpeditions.getSelectedCellText('oerf-colBonId');
			oerf_chargerBon();
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function oerf_chargerBon() {
  try {

		oerf_reinitialiser();
		oerf_aArticlesBL.setParam('Bon_Id', oerf_bonId);
		oerf_aArticlesRF.setParam('Bon_Id', oerf_bonId);

		document.getElementById('oerf-bEditionBL').collapsed = false;
		document.getElementById('oerf-bEditionBP').collapsed = false;

		oerf_mode = "M";

		var qGetBL = new QueryHttp('Facturation/Retours_Fournisseurs/loadBonLivraison.tmpl');
		qGetBL.setParam("Bon_Id", oerf_bonId);
		var result = qGetBL.execute();
		var contenu = result.responseXML.documentElement;

		oerf_etatBon = contenu.getAttribute("Etat");
		oerf_statutExpedition = contenu.getAttribute("Statut_Expedition");
		oerf_chargerModesExpedition(contenu.getAttribute('Mode_Expedition'));

		document.getElementById('oerf-bGenerateBL').collapsed = true;
		document.getElementById('oerf-bConfirmer').collapsed = true;
		document.getElementById('oerf-etat').value = contenu.getAttribute('LibEtat');

		if (oerf_etatBon=="V") {
			document.getElementById('oerf-bSupprimer').collapsed = true;
			document.getElementById('oerf-bAnnuler').collapsed = (oerf_etatRF=="C");
			document.getElementById('oerf-boxArticlesRF').collapsed = true;
			document.getElementById('oerf-boxActions').collapsed = true;
			document.getElementById('oerf-bAnnuler').disabled = (oerf_etatRF=="C");
			if (oerf_statutExpedition=="P") {
				document.getElementById('oerf-bGenerateBL').collapsed = false;
				document.getElementById('oerf-envoiTrans').collapsed = !oerf_envoiTrans;
				document.getElementById('oerf-envoiTrans').checked = oerf_envoiTrans;
				document.getElementById('oerf-envoiTrans').disabled = false;
			}
			else if (oerf_statutExpedition=="C") {
				document.getElementById('oerf-bConfirmer').collapsed = false;
			}
		}
		else if (oerf_etatBon=="A") {
			document.getElementById('oerf-bSupprimer').collapsed = true;
			document.getElementById('oerf-bAnnuler').collapsed = true;
			document.getElementById('oerf-boxArticlesRF').collapsed = true;
			document.getElementById('oerf-boxActions').collapsed = true;
		}
		else {
			document.getElementById('oerf-bAnnuler').collapsed = true;
			document.getElementById('oerf-bSupprimer').collapsed = false;
			document.getElementById('oerf-boxArticlesRF').collapsed = false;
			document.getElementById('oerf-boxActions').collapsed = false;
			document.getElementById('oerf-bNouveau').disabled = true;
			document.getElementById('oerf-envoiTrans').collapsed = !(oerf_envoiTrans && !oerf_etapePrepaBL);
			document.getElementById('oerf-envoiTrans').checked = (oerf_envoiTrans && !oerf_etapePrepaBL);
			document.getElementById('oerf-envoiTrans').disabled = oerf_etapePrepaBL;
		}

		if (oerf_etatBon!="N") {
			document.getElementById('oerf-bCsvColisage').disabled = false;
			document.getElementById('oerf-bPdfColisage').disabled = false;
			document.getElementById('oerf-tabVersions').collapsed = false;
			document.getElementById('oerf-tabColis').collapsed = false;
			oerf_initVersion();
			if (!isEmpty(contenu.getAttribute("Date_Prepa_Expe"))) {
				document.getElementById('oerf-infoPrepaExpe').value = "Pr\u00E9paration d'exp\u00E9dition valid\u00E9e le "+ contenu.getAttribute("Date_Prepa_Expe");
				document.getElementById('oerf-infoPrepaExpe').collapsed = false;
			}
			if (contenu.getAttribute("Envoi_Trans")=="true") {
				document.getElementById('oerf-infoEnvoiTrans').value = "Export transporteur effectu\u00E9";
				document.getElementById('oerf-infoEnvoiTrans').collapsed = false;
			}
		}
		else {
			document.getElementById('oerf-numSerie').focus();
		}

		document.getElementById('oerf-boxSaisieSerie').collapsed = (!oerf_actSuiviSerie || oerf_etatBon!="N");
		document.getElementById('oerf-consignesLiv').value = contenu.getAttribute('Consignes_Liv');

		document.getElementById('oerf-dateBL').value = contenu.getAttribute("Date_BL");
		document.getElementById('oerf-dateBP').value = contenu.getAttribute("Date_BP");
		document.getElementById('oerf-commentairesFin').value = contenu.getAttribute("Commentaires_Fin");
		document.getElementById('oerf-commentairesInt').value = contenu.getAttribute("Commentaires_Int");
		document.getElementById('oerf-numeroBL').value = contenu.getAttribute("Numero");
		document.getElementById('oerf-numeroBP').value = contenu.getAttribute("Numero_BP");

		document.getElementById('oerf-creation').setAttribute("label", "Exp\u00E9dition cr\u00E9\u00E9e le "+ contenu.getAttribute('Date_Creation') +" par "+ contenu.getAttribute('Login_Createur'));
		document.getElementById('oerf-modification').setAttribute("label", "Derni\u00E8re modification le "+ contenu.getAttribute('Date_Maj') +" par "+ contenu.getAttribute('Login_Maj'));
		document.getElementById('oerf-document').setAttribute("label", "Bon de livraison N\u00B0 "+ contenu.getAttribute('Numero'));
		document.getElementById('oerf-creation').collapsed = false;
		document.getElementById('oerf-modification').collapsed = false;

		document.getElementById('oerf-bOuvrirCommentairesCaches').disabled = false;

		oerf_aLiensColis.setParam("Bon_Id", oerf_bonId);
		oerf_aLiensColis.initTree();

		oerf_aArticlesBL.initTree();

		oerf_setModified(false);

		if (oerf_etatBon!='V' && oerf_etatBon!='A') {
			oerf_aArticlesRF.setParam('Retour_Id', oerf_retourId);
			oerf_aArticlesRF.initTree();
			oerf_debloquerChamps();
			document.getElementById('oerf-bToutEnlever').disabled = false;
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function oerf_editerCommentairesInternes()  {
  try {

  	var url = "chrome://opensi/content/facturation/user/commun/popup-commentairesInternes.xul";
  	window.openDialog(url,'','chrome,modal,centerscreen', "BLR", oerf_bonId, false);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oerf_editerCommentairesDocument() {
  try {

		var commentairesFin = document.getElementById('oerf-commentairesFin').value;
		var commentairesInt = document.getElementById('oerf-commentairesInt').value;
		var readOnly = (oerf_etatBon!="N");

		var url = "chrome://opensi/content/facturation/user/commun/popup-commentairesDocument.xul";
  	window.openDialog(url,'','chrome,modal,centerscreen', oerf_retourEditerCommentaires, "BLR", oerf_bonId, commentairesFin, commentairesInt, readOnly);

	} catch (e) {
    recup_erreur(e);
  }
}


function oerf_retourEditerCommentaires(commentairesFin, commentairesInt) {
  try {

		document.getElementById('oerf-commentairesFin').value = commentairesFin;
		document.getElementById('oerf-commentairesInt').value = commentairesInt;

	} catch (e) {
    recup_erreur(e);
  }
}


function oerf_enregistrerBon(rafraichir) {
  try {

  	var ok = false;

		var modeExpedition = document.getElementById('oerf-modeExpedition').value;
		var consignesLiv = document.getElementById('oerf-consignesLiv').value;
		var commentairesFin = document.getElementById('oerf-commentairesFin').value;
		var commentairesInt = document.getElementById('oerf-commentairesInt').value;

		if (!isEmpty(consignesLiv) && consignesLiv.length>100) {
			showWarning("Consignes de livraison incorrectes (longueur max = 100 caract\u00E8res)");
		}
		else {
			var qSave;

			if (oerf_mode=="C") {
				qSave = new QueryHttp("Facturation/Retours_Fournisseurs/createBonLivraison.tmpl");
				qSave.setParam("Retour_Id", oerf_retourId);
			}
			else {
				qSave = new QueryHttp("Facturation/Retours_Fournisseurs/updateBonLivraison.tmpl");
				qSave.setParam("Bon_Id", oerf_bonId);
			}

			qSave.setParam("Depot_Id", oerf_depotId);
			qSave.setParam("Mode_Expedition", modeExpedition);
			qSave.setParam("Consignes_Liv", consignesLiv);
			qSave.setParam("Commentaires_Fin", commentairesFin);
			qSave.setParam("Commentaires_Int", commentairesInt);

			var result = qSave.execute();

			if (oerf_mode=="C") {
				oerf_bonId = result.responseXML.documentElement.getAttribute("Bon_Id");

				if (rafraichir) {
					oerf_chargerBon();
				}
			}
			oerf_aExpeditions.initTree();

			oerf_setModified(false);
			ok = true;
		}

		return ok;

	} catch (e) {
  	recup_erreur(e);
  }
}


function oerf_supprimerBon() {
  try {

		if (window.confirm("Confirmez-vous la suppression de cette exp\u00E9dition ?")) {

			var qDelete = new QueryHttp("Facturation/Retours_Fournisseurs/deleteBonLivraison.tmpl");
			qDelete.setParam("Bon_Id", oerf_bonId);
			qDelete.execute();

			showMessage("L'exp\u00E9dition a \u00E9t\u00E9 supprim\u00E9e avec succ\u00E8s");
			oerf_nouveauBon();
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function oerf_generateBL() {
  try {

		if (oerf_aArticlesBL.nbLignes()<=0) {
			showWarning("L'exp\u00E9dition ne contient aucune ligne !");
		}
		else if (window.confirm("Confirmez-vous la g\u00E9n\u00E9ration du bon de livraison ?\n(Attention le bon de livraison valid\u00E9 ne pourra plus \u00EAtre modifi\u00E9 !)")) {

			var ok = true;

			if (oerf_actSuiviSerie) {
				var qChkNS = new QueryHttp("Facturation/Retours_Fournisseurs/checkNumSerieBL.tmpl");
				qChkNS.setParam("Bon_Id", oerf_bonId);
				var result = qChkNS.execute();
				var errors = new Errors(result);
				if (errors.hasNext()) {
					ok = false;
					errors.show();
				}
			}

			if (oerf_statutExpedition!="P") {

				if (oerf_actSuiviLot && ok) {
					var qChkLot = new QueryHttp("Facturation/Retours_Fournisseurs/checkNumLotBL.tmpl");
					qChkLot.setParam("Bon_Id", oerf_bonId);
					var resultLot = qChkLot.execute();
					var errorsLot = new Errors(resultLot);
					if (errorsLot.hasNext()) {
						ok = false;
						errorsLot.show();
					}
				}

				if (ok) {
					var qValider = new QueryHttp("Facturation/Retours_Fournisseurs/validBonLivraison.tmpl");
					qValider.setParam('Bon_Id', oerf_bonId);
					var result = qValider.execute();

					var errors = new Errors(result);

					if (errors.hasNext()) {
						ok = false;
						errors.show();
					}
				}
			}

			if (ok) {
				var qGenBL = new QueryHttp("Facturation/Retours_Fournisseurs/generateBonLivraison.tmpl");
				qGenBL.setParam("Bon_Id", oerf_bonId);
				qGenBL.setParam("Envoi_Trans", document.getElementById('oerf-envoiTrans').checked);
				qGenBL.execute();

				oerf_chargerBon();
				oerf_chargerPdfBL();
			}
  	}

	} catch (e) {
  	recup_erreur(e);
  }
}


function oerf_confirmerExpedition() {
  try {

  	if (window.confirm("Confirmez-vous l'exp\u00E9dition ?")) {

			var qConfExpe = new QueryHttp("Facturation/Retours_Fournisseurs/confirmExpedition.tmpl");
			qConfExpe.setParam("Bon_Id", oerf_bonId);
			var result = qConfExpe.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oerf_chargerBon();
			}
  	}

	} catch (e) {
  	recup_erreur(e);
  }
}


function oerf_toutTransferer() {
  try {

  	var ok = true;
		if (oerf_mode=="C") {
			ok = oerf_enregistrerBon(true);
		}
		if (ok) {
			var qAdd = new QueryHttp('Facturation/Retours_Fournisseurs/addAllBL.tmpl');
			qAdd.setParam("Bon_Id", oerf_bonId);
			qAdd.setParam("Retour_Id", oerf_retourId);
			qAdd.execute();

			oerf_aArticlesRF.initTree();
			oerf_aArticlesBL.initTree();

			document.getElementById('oerf-numLot').value = "";
			document.getElementById('oerf-datePeremption').value = "";
			document.getElementById('oerf-nbPieces').value = "";
			document.getElementById('oerf-quantite').value = "";

			document.getElementById('oerf-bAjouter').disabled = true;
			document.getElementById('oerf-bEnlever').disabled = true;
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oerf_toutTransfererDispo() {
  try {

  	var ok = true;
		if (oerf_mode=="C") {
			ok = oerf_enregistrerBon(true);
		}
		if (ok) {
			var qAdd = new QueryHttp('Facturation/Retours_Fournisseurs/addAllDispoBL.tmpl');
			qAdd.setParam("Bon_Id", oerf_bonId);
			qAdd.setParam("Retour_Id", oerf_retourId);
			qAdd.execute();

			oerf_aArticlesRF.initTree();
			oerf_aArticlesBL.initTree();

			document.getElementById('oerf-numLot').value = "";
			document.getElementById('oerf-datePeremption').value = "";
			document.getElementById('oerf-nbPieces').value = "";
			document.getElementById('oerf-quantite').value = "";

			document.getElementById('oerf-bAjouter').disabled = true;
			document.getElementById('oerf-bEnlever').disabled = true;
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oerf_toutEnlever() {
  try {

		var qRemove = new QueryHttp('Facturation/Retours_Fournisseurs/removeAllBL.tmpl');
		qRemove.setParam("Bon_Id", oerf_bonId);
		qRemove.execute();

		oerf_aArticlesRF.initTree();
		oerf_aArticlesBL.initTree();

		document.getElementById('oerf-numLot').value = "";
		document.getElementById('oerf-datePeremption').value = "";
		document.getElementById('oerf-nbPieces').value = "";
		document.getElementById('oerf-quantite').value = "";

		document.getElementById('oerf-bAjouter').disabled = true;
		document.getElementById('oerf-bEnlever').disabled = true;

		document.getElementById("oerf-bConsultSerieLigne").disabled = true;

	} catch (e) {
  	recup_erreur(e);
	}
}


function oerf_ajouter() {
  try {

		if (oerf_aArticlesRF.isSelected()) {

			var articleId = oerf_aArticlesRF.getSelectedCellText('oerf-colArticleIdRF');
			var ligneRF = oerf_aArticlesRF.getSelectedCellText('oerf-colLigneIdRF');
			var isSuiviLot = oerf_aArticlesRF.getSelectedCellText('oerf-colSuiviLotRF')=="true";
			var isSuiviDLC = oerf_aArticlesRF.getSelectedCellText('oerf-colSuiviDLCRF')=="true";
			var isSuiviSerie = oerf_aArticlesRF.getSelectedCellText('oerf-colSuiviSerieRF')=="true";
			var qteRestante = oerf_aArticlesRF.getSelectedCellText('oerf-colQuantiteRF');
			var quantiteMax = oerf_aArticlesRF.getSelectedCellText('oerf-colQteMaxRF');
			var nbPiecesRestant = oerf_aArticlesRF.getSelectedCellText('oerf-colNbPiecesRF');
			if (isEmpty(nbPiecesRestant)) { nbPiecesRestant = 0; }

			var quantite = document.getElementById('oerf-quantite').value;
			var numLot = document.getElementById('oerf-numLot').value;
			var datePeremption = document.getElementById('oerf-datePeremption').value;
			var nbPieces = document.getElementById('oerf-nbPieces').value;
			if (isEmpty(nbPieces)) { nbPieces = 0; }

			if (isEmpty(quantite)) { showWarning("Veuillez entrer une quantit\u00E9 \u00E0 transf\u00E9rer"); }
			else if (!checkQte(quantite)) { showWarning("Quantit\u00E9 incorrecte"); }
			else if (!isPositiveOrNullInteger(nbPieces)) { showWarning("Nombre de pi\u00E8ces incorrect");	}
			else if (parseFloat(qteRestante)-parseFloat(quantite)<0) { showWarning("La quantit\u00E9 \u00E0 transf\u00E9rer d\u00E9passe la quantit\u00E9 restant \u00E0 livrer"); }
			else if (parseFloat(nbPiecesRestant)-parseFloat(nbPieces)<0) { showWarning("Le nb de pi\u00E8ces \u00E0 transf\u00E9rer d\u00E9passe le nb de pi\u00E8ces restant \u00E0 livrer");	}
			//else if (oerf_bloquerBLSansStock && quantite>quantiteMax) { showWarning("Quantit\u00E9 en stock insuffisante (max: "+ quantiteMax +")"); }
			else if (oerf_checkNumLotLigne(numLot, datePeremption, articleId, isSuiviLot, isSuiviDLC)) {

				var ok = true;

				if (oerf_mode=="C") {
					ok = oerf_enregistrerBon(true);
				}

				if (ok) {
					var qAdd = new QueryHttp('Facturation/Retours_Fournisseurs/addLigneBL.tmpl');
					qAdd.setParam("Bon_Id", oerf_bonId);
					qAdd.setParam("Ligne_RF", ligneRF);
					qAdd.setParam("Quantite", quantite);
					qAdd.setParam("Num_Lot", numLot);
					qAdd.setParam("Nb_Pieces", nbPieces);
					qAdd.setParam("Date_Peremption", datePeremption);
					var result = qAdd.execute();

					var ligneBL = result.responseXML.documentElement.getAttribute('Ligne_Id');
					var quantiteBL = parseIntBis(result.responseXML.documentElement.getAttribute('Quantite'));

					oerf_aArticlesRF.initTree();
					oerf_aArticlesBL.initTree();

					document.getElementById('oerf-numLot').value = "";
					document.getElementById('oerf-datePeremption').value = "";
					document.getElementById('oerf-nbPieces').value = "";
					document.getElementById('oerf-quantite').value = "";

					document.getElementById('oerf-bAjouter').disabled = true;

					if (!oerf_etapePrepaBL) {
						oerf_checkNumSerieLigne(ligneBL, isSuiviSerie, quantiteBL);
					}
				}
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oerf_enlever() {
  try {

		if (oerf_aArticlesBL.isSelected()) {

			var ligneId = oerf_aArticlesBL.getSelectedCellText('oerf-colLigneIdBL');
			var qteInit = oerf_aArticlesBL.getSelectedCellText('oerf-colQuantiteBL');
			var quantite = document.getElementById('oerf-quantite').value;
			var nbPiecesInit = oerf_aArticlesBL.getSelectedCellText('oerf-colNbPiecesBL');
			if (isEmpty(nbPiecesInit)) {
				nbPiecesInit = 0;
			}
			var nbPieces = document.getElementById('oerf-nbPieces').value;
			if (isEmpty(nbPieces)) {
				nbPieces = 0;
			}

			if (isEmpty(quantite)) {
				showWarning("Veuillez entrer une quantit\u00E9 \u00E0 enlever");
			}
			else if (!checkQte(quantite)) {
				showWarning("Quantit\u00E9 incorrecte !");
			}
			else if (parseFloat(qteInit)-parseFloat(quantite)<0) {
				showWarning("La quantit\u00E9 \u00E0 enlever ne peut d\u00E9passer la quantit\u00E9 pr\u00E9sente dans l'exp\u00E9dition !");
			}
			else if (!isPositiveOrNullInteger(nbPieces)) {
				showWarning("Nombre de pi\u00E8ces incorrect !");
			}
			else if (parseFloat(nbPiecesInit)-parseFloat(nbPieces)<0) {
				showWarning("Le nb de pi\u00E8ces \u00E0 enlever ne peut d\u00E9passer le nb de pi\u00E8ces pr\u00E9sent dans l'exp\u00E9dition !");
			}
			else {
				var qRemove = new QueryHttp('Facturation/Retours_Fournisseurs/removeLigneBL.tmpl');
				qRemove.setParam("Ligne_Id", ligneId);
				qRemove.setParam("Quantite", quantite);
				qRemove.setParam("Nb_Pieces", nbPieces);
				qRemove.execute();

				oerf_aArticlesRF.initTree();
				oerf_aArticlesBL.initTree();

				document.getElementById('oerf-numLot').value = "";
				document.getElementById('oerf-datePeremption').value = "";
				document.getElementById('oerf-nbPieces').value = "";
				document.getElementById('oerf-quantite').value = "";

				document.getElementById('oerf-bEnlever').disabled = true;

				document.getElementById("oerf-bConsultSerieLigne").disabled = true;
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oerf_demandeEnregistrement() {
  try {

		if (oerf_modified) {
			if (window.confirm("Voulez-vous enregistrer les modifications apport\u00E9es \u00E0 l'exp\u00E9dition ?")) {
				oerf_enregistrerBon(false);
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oerf_setModified(modified) {
  try {

		oerf_modified = modified;

		if (modified) {
			document.getElementById('oerf-tabBon').setAttribute('image', 'chrome://opensi/content/design/icones/modified.png');
			document.getElementById('oerf-bGenerateBP').disabled = true;
			document.getElementById('oerf-bEditionBL').disabled = true;
			document.getElementById('oerf-bEditionBP').disabled = true;
		}
		else {
			document.getElementById('oerf-tabBon').setAttribute('image', null);
			document.getElementById('oerf-bGenerateBP').disabled = (oerf_etatBon=='V');
			document.getElementById('oerf-bGenerateBP').collapsed = oerf_mode=='C' || (!oerf_etapePrepaBL || oerf_etatBon!='N');
			document.getElementById('oerf-bGenerateBL').collapsed = oerf_mode=='C' || (oerf_statutExpedition!='P' && (oerf_etapePrepaBL || oerf_etatBon!='N'));
			document.getElementById('oerf-bEditionBL').disabled = false;
			document.getElementById('oerf-bEditionBL').collapsed = (oerf_etatBon=='N' || oerf_statutExpedition=='P' || isEmpty(document.getElementById('oerf-dateBL').value));
			document.getElementById('oerf-bEditionBP').disabled = false;
			document.getElementById('oerf-bEditionBP').collapsed = (oerf_etatBon=='N');
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oerf_chargerPdfBL() {
  try {

		var qLangueDefaut = new QueryHttp("Facturation/Commun/getLangueDefaut.tmpl");
		qLangueDefaut.setParam("Type_Doc", "BL");
		qLangueDefaut.setParam("Doc_Id", oerf_bonId);
		var result = qLangueDefaut.execute();
		oerf_langueDefaut = result.responseXML.documentElement.getAttribute("Langue_Id");

		oerf_aLangues.setParam("Selection", oerf_langueDefaut);
		oerf_aLangues.initTree(oerf_initLangue);

  } catch (e) {
    recup_erreur(e);
  }
}


function oerf_initLangue() {
	try {

		document.getElementById('oerf-langueDefaut').value = oerf_langueDefaut;
		oerf_editerBon();

	} catch (e) {
		recup_erreur(e);
	}
}


function oerf_editerBP() {
	try {

		document.getElementById("oerf-barEdition").collapsed = true;
		document.getElementById('oerf-pdfBonLivraison').setAttribute("src", "");
		document.getElementById("bRetourExpedition").collapsed = false;
		document.getElementById('oerf-bEnvoyer').collapsed = true;
		document.getElementById("oerf-deckBonLivraison").selectedIndex = 1;

		var oerf_qGenPdf = new QueryHttp("Facturation/Retours_Fournisseurs/pdfBonPreparation.tmpl");
		oerf_qGenPdf.setParam('Bon_Id', oerf_bonId);

		var result = oerf_qGenPdf.execute();
		var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');

		document.getElementById('oerf-pdfBonLivraison').setAttribute("src", page);

	} catch (e) {
		recup_erreur(e);
	}
}


function oerf_editerBon() {
	try {

		document.getElementById("oerf-barEdition").collapsed = false;
		document.getElementById('oerf-pdfBonLivraison').setAttribute("src", "");
		document.getElementById("bRetourExpedition").collapsed = false;
		document.getElementById('oerf-bEnvoyer').collapsed = false;
		document.getElementById("oerf-deckBonLivraison").selectedIndex = 1;

		var langue = document.getElementById('oerf-langueDefaut').value;
		var editBP = document.getElementById('oerf-chkEditBP').checked;

		var oerf_qGenPdf = new QueryHttp("Facturation/Retours_Fournisseurs/pdfBonLivraison.tmpl");
		oerf_qGenPdf.setParam('Bon_Id', oerf_bonId);
	  oerf_qGenPdf.setParam("Edit_BP", editBP);
	  oerf_qGenPdf.setParam('Langue_Id', langue);

		var result = oerf_qGenPdf.execute();
		var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');

		document.getElementById('oerf-pdfBonLivraison').setAttribute("src", page);

	} catch (e) {
		recup_erreur(e);
	}
}


function oerf_generateBP() {
  try {

		if (oerf_aArticlesBL.nbLignes()<=0) {
			showWarning("L'exp\u00E9dition ne contient aucune ligne !");
		}
		else {
			var isValid = true;

			if (oerf_actSuiviLot && isValid) {
				var qChkLot = new QueryHttp("Facturation/Retours_Fournisseurs/checkNumLotBL.tmpl");
				qChkLot.setParam("Bon_Id", oerf_bonId);
				var resultLot = qChkLot.execute();
				var errorsLot = new Errors(resultLot);
				if (errorsLot.hasNext()) {
					isValid = false;
					errorsLot.show();
				}
			}
			if (isValid && window.confirm("Confirmez-vous la g\u00E9n\u00E9ration du bon de pr\u00E9paration ?")) {

				var qValider = new QueryHttp("Facturation/Retours_Fournisseurs/validBonLivraison.tmpl");
				qValider.setParam('Bon_Id', oerf_bonId);
				var result = qValider.execute();

				var errors = new Errors(result);

				if (errors.hasNext()) {
					errors.show();
				}
				else {
					oerf_chargerBon();
					oerf_editerBP();
				}
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oerf_annulerBon() {
  try {

		if (window.confirm("Confirmez-vous l'annulation de l'exp\u00E9dition ?")) {

			var qCancel = new QueryHttp("Facturation/Retours_Fournisseurs/cancelBonLivraison.tmpl");
			qCancel.setParam('Bon_Id', oerf_bonId);
			qCancel.execute();

			showMessage("L'exp\u00E9dition a \u00E9t\u00E9 annul\u00E9e");

			oerf_chargerBon();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oerf_choisirMentions() {
  try {

  	var ok = true;

  	if (oerf_mode=="C") {
			ok = oerf_enregistrerBon(true);
		}

		if (ok) {
			var url = "chrome://opensi/content/facturation/user/commun/popup-mentionsDocument.xul";
	    window.openDialog(url,'','chrome,modal,centerscreen', "BLR", oerf_bonId, false);
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function oerf_initVersion() {
	try {

		oerf_aVersions.setParam("Bon_Id", oerf_bonId);
		oerf_aVersions.initTree();

	} catch (e) {
		recup_erreur(e);
	}
}


function oerf_selectLigneBL()  {
	try {

		if (oerf_aArticlesBL.isSelected()) {
			document.getElementById('oerf-nbPieces').value = oerf_aArticlesBL.getSelectedCellText('oerf-colNbPiecesBL');
			document.getElementById('oerf-quantite').value = oerf_aArticlesBL.getSelectedCellText('oerf-colQuantiteBL');
			document.getElementById('oerf-numLot').value = "";
			document.getElementById('oerf-datePeremption').value = "";
			document.getElementById('oerf-bEnlever').disabled = false;
			document.getElementById('oerf-bAjouter').disabled = true;
			document.getElementById('oerf-bConsultSerieLigne').disabled = false;
			oerf_aArticlesRF.clearSelection();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oerf_selectLigneRF() {
	try {

		if (oerf_aArticlesRF.isSelected()) {
			document.getElementById('oerf-nbPieces').value = oerf_aArticlesRF.getSelectedCellText('oerf-colNbPiecesRF');
			document.getElementById('oerf-quantite').value = oerf_aArticlesRF.getSelectedCellText('oerf-colQuantiteRF');
			document.getElementById('oerf-numLot').value = "";
			document.getElementById('oerf-datePeremption').value = "";
			document.getElementById('oerf-bAjouter').disabled = false;
			document.getElementById('oerf-bEnlever').disabled = true;
			oerf_aArticlesBL.clearSelection();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oerf_checkNumSerieLigne(ligneId, isSuiviSerie, quantite) {
	try {

		if (oerf_actSuiviSerie) {
			var qNbSerie = new QueryHttp("Facturation/Retours_Fournisseurs/getNbNumSerieLigneBL.tmpl");
			qNbSerie.setParam("Ligne_Id", ligneId);
			var resNS = qNbSerie.execute();
			var nb = parseIntBis(resNS.responseXML.documentElement.getAttribute("Nombre"));
			if ((isSuiviSerie && nb!=quantite) || nb>quantite) {
				var url = "chrome://opensi/content/facturation/user/commun/popup-numSerie.xul";
		    window.openDialog(url,'','chrome,modal,centerscreen', "S", "BLR", ligneId, oerf_depotId);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oerf_consulterNumSerie()  {
	try {

		if (oerf_aArticlesBL.isSelected()) {
			var ligneId = oerf_aArticlesBL.getSelectedCellText('oerf-colLigneIdBL');
			var mode = (oerf_etatBon=="A" || oerf_statutExpedition=="E" || oerf_statutExpedition=="C"?"C":"S");
			var url = "chrome://opensi/content/facturation/user/commun/popup-numSerie.xul";
    	window.openDialog(url,'','chrome,modal,centerscreen', mode, "BLR", ligneId, oerf_depotId);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oerf_checkNumLotLigne(numero, datePeremption, articleId, isSuiviLot, isSuiviDLC) {
	try {

		var ok = true;

		if (oerf_actSuiviLot && !isEmpty(articleId)) {

			if ((isSuiviLot || !isEmpty(datePeremption)) && isEmpty(numero)) {
				ok = false;
				showWarning("N\u00B0 Lot manquant");
			}
			else if (isSuiviDLC && isEmpty(datePeremption)) {
				ok = false;
				showWarning("Date de p\u00E9remption manquante");
			}
			else if (!isEmpty(datePeremption) && !isDate(datePeremption)) {
				ok = false;
				showWarning("Date de p\u00E9remption incorrecte");
			}
		}

		return ok;

	} catch (e) {
		recup_erreur(e);
	}
}


function oerf_pressOnNumLot(ev) {
	try {

		if (ev.keyCode==13 && oerf_aArticlesRF.isSelected()) {
			var articleId = oerf_aArticlesRF.getSelectedCellText('oerf-colArticleIdRF');
			var numero = document.getElementById("oerf-numLot").value;

			var url = "chrome://opensi/content/facturation/user/tracabilite_articles/popup-rechercheLot.xul";
			window.openDialog(url,'','chrome,modal,centerscreen', oerf_retourRechercherLot, articleId, numero, oerf_depotId, null);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oerf_retourRechercherLot(numero, datePeremption) {
	try {

		document.getElementById("oerf-numLot").value = numero;
		document.getElementById("oerf-datePeremption").value = datePeremption;

	} catch (e) {
		recup_erreur(e);
	}
}


function oerf_updateDLC() {
	try {

		if (oerf_aArticlesRF.isSelected()) {
			var numero = document.getElementById("oerf-numLot").value;
			var articleId = oerf_aArticlesRF.getSelectedCellText('oerf-colArticleIdRF');

			if (!isEmpty(numero) && !isEmpty(articleId)) {
				var qGetDLC = new QueryHttp("Facturation/Tracabilite/getDLCNumLot.tmpl");
				qGetDLC.setParam("Article_Id", articleId);
				qGetDLC.setParam("Numero", numero);
				var result = qGetDLC.execute();
				var datePeremption = result.responseXML.documentElement.getAttribute("Date_Peremption");
				if (!isEmpty(datePeremption)) {
					document.getElementById("oerf-datePeremption").value = datePeremption;
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oerf_pressOnNumSerie(ev) {
	try {

		if (ev.keyCode==13) {
			oerf_validerSaisieBySerie();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oerf_validerSaisieBySerie(ligneId) {
	try {

		var listLigneRF = ligneId;

		if (listLigneRF==null) {
			listLigneRF = "";
			var nbLignes = oerf_aArticlesRF.nbLignes();
			for (i=0; i<nbLignes; i++) {
				if (parseFloat(oerf_aArticlesRF.getCellText(i, 'oerf-colQuantiteRF'))>0) {
					listLigneRF += oerf_aArticlesRF.getCellText(i, 'oerf-colLigneIdRF') +",";
				}
			}
		}

		var numSerie = document.getElementById("oerf-numSerie").value;

		if (!isEmpty(numSerie)) {

			var ok = true;
			if (oerf_mode=="C") {
				ok = oerf_enregistrerBon(true);
			}
			if (ok) {
				var qAjouterNumSerie = new QueryHttp('Facturation/Retours_Fournisseurs/addNumSerieBL.tmpl');
				qAjouterNumSerie.setParam("Bon_Id", oerf_bonId);
				qAjouterNumSerie.setParam("Num_Serie", numSerie);
				qAjouterNumSerie.setParam("List_Ligne_RF", listLigneRF);
				var result = qAjouterNumSerie.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
				else {
					var conflit = (result.responseXML.documentElement.getAttribute("Conflit")=="true");
					if (conflit) {
						var listConflit = result.responseXML.documentElement.getAttribute("List_Conflit");
						var url = "chrome://opensi/content/facturation/user/retours_fournisseurs/popup-conflitNumSerieRF.xul";
			      window.openDialog(url,'','chrome,modal,centerscreen', listConflit, oerf_retourChoixConflit);
					}
					else {
						oerf_aArticlesRF.initTree();
						oerf_aArticlesBL.initTree();
						document.getElementById("oerf-numSerie").value = "";
					}
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oerf_retourChoixConflit(ligneId) {
	try {

		oerf_validerSaisieBySerie(ligneId);

	} catch (e) {
		recup_erreur(e);
	}
}


function oerf_clickOnColis(tree, ev) {

	gClipboardHelper.copyString(oerf_aLiensColis.getSelectedCellText("oerf-colNumColis"));

	var col = oerf_aLiensColis.getClickedCol(ev);

	if (col!=null && col.id=="oerf-colNumColis") {
		var lien = oerf_aLiensColis.getSelectedCellValue("oerf-colNumColis");
		if (!isEmpty(lien)) {
			//window.open(lien);
			openInNavigator(lien);
		}
	}
	else if (col!=null && col.id=="oerf-colCTC") {
		window.open(oerf_aLiensColis.getSelectedCellValue("oerf-colCTC"));
	}
}


function oerf_keypressOnColis(ev) {
  try {

		if ((ev.key=='w' || ev.key=='W') && ev.ctrlKey && oerf_aLiensColis.isSelected()) {
			// ctrl + w pour copier l'adresse du lien
			gClipboardHelper.copyString(oerf_aLiensColis.getSelectedCellValue("oerf-colNumColis"));
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function oerf_pressOnColis() {
  try {

		if (oerf_aLiensColis.isSelected()) {
			document.getElementById('oerf-bAnnulerColis').disabled = (oerf_aLiensColis.getSelectedCellText("oerf-colStatut")!="V");
		}
		else {
			document.getElementById('oerf-bAnnulerColis').disabled = true;
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function oerf_annulerColis() {
  try {

		document.getElementById('oerf-bAnnulerColis').disabled = true;

		if (window.confirm("Confirmez-vous l'annulation du colis s\u00E9lectionn\u00E9 ?")) {

			var colisId = oerf_aLiensColis.getSelectedCellText("oerf-colColisId");

			var qCancel = new QueryHttp("Facturation/Retours_Fournisseurs/cancelColis.tmpl");
			qCancel.setParam("Colis_Id", colisId);
			var result = qCancel.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showMessage("Le colis a \u00E9t\u00E9 annul\u00E9");
			}
			oerf_aLiensColis.initTree();
		}
		else {
			document.getElementById('oerf-bAnnulerColis').disabled = false;
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oerf_editerColisageCSV() {
  try {

		if (oerf_aLiensColis.nbLignes()<=0) {
			showWarning("L'exp\u00E9dition ne contient pas de colis");
		}
		else {
			var qEditionCsv = new QueryHttp("Facturation/Retours_Fournisseurs/csvColisageBL.tmpl");
			qEditionCsv.setParam("Bon_Liv_Id", oerf_bonId);

			var result = qEditionCsv.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');
				var file = fileChooser("save", fichier);
				if (file!=null) {
					downloadFile(getDirBuffer()+ fichier, file);
				}
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oerf_editerColisagePDF() {
  try {

		if (oerf_aLiensColis.nbLignes()<=0) {
			showWarning("L'exp\u00E9dition ne contient pas de colis");
		}
		else {
			var qEditionPdf = new QueryHttp("Facturation/Retours_Fournisseurs/pdfColisageBL.tmpl");
			qEditionPdf.setParam("Bon_Liv_Id", oerf_bonId);

			document.getElementById('oerf-deckBonLivraison').selectedIndex = 2;

			var result = qEditionPdf.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
				document.getElementById('oerf-pdfEdition').setAttribute("src", page);

				document.getElementById('bRetourExpedition').collapsed = false;
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oerf_envoyerMail() {
	try {

		var langue = document.getElementById('oerf-langueDefaut').value;
		var editBP = document.getElementById('oerf-chkEditBP').checked;

		var url = "chrome://opensi/content/popup/popup-envoyerMail.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', "BLR", oerf_bonId, langue, editBP);

	} catch (e) {
		recup_erreur(e);
	}
}
