/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");


var aLignesBR = new Arbre("Facturation/Retours_Fournisseurs/list-ligneBRARetourner.tmpl", "lignesBR");

var ligneId;
var actNbPieces;



function init() {
	try {

		actNbPieces = getConfig().isActNbPieces();

		if (!actNbPieces) {
			document.getElementById('colNbPieces').collapsed = true;
			document.getElementById('colNbPieces').setAttribute('ignoreincolumnpicker', true);
		}

		ligneId = window.arguments[0];

		aLignesBR.setParam("Ligne_Id", ligneId);
		aLignesBR.initTree();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnLignesBR(event) {
	try {

		if (event.keyCode==13) {
			valider();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function valider() {
	try {

		if (aLignesBR.isSelected()) {

			var qteRestante = aLignesBR.getSelectedCellText('colQte');
			var nbPiecesrestantes = aLignesBR.getSelectedCellText('colNbPieces');
			var ligneBR = aLignesBR.getSelectedCellText('colLigneId');
			var quantite = aLignesBR.getSelectedCellText('colQuantiteRetour');
			var nbPieces = aLignesBR.getSelectedCellText('colNbPiecesRetour');

			if (quantite>qteRestante) { showWarning("Quantit\u00E9 restante insuffisante"); }
			else if (actNbPieces && nbPieces>nbPiecesrestantes) { showWarning("Nombre de pi\u00E8ces restant insuffisant"); }
			else {
				var qLiaisonBR = new QueryHttp("Facturation/Retours_Fournisseurs/linkLigneRetourFournisseurBR.tmpl");
				qLiaisonBR.setParam("Ligne_Id", ligneId);
				qLiaisonBR.setParam("Ligne_BR", ligneBR);
				qLiaisonBR.execute();

				window.arguments[1]();
				window.close();
			}
		}
		else {
			showWarning("Veuillez s\u00E9lectionner une ligne");
		}

	}	catch (e) {
		recup_erreur(e);
	}
}
