/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");


const gClipboardHelper = Components.classes["@mozilla.org/widget/clipboardhelper;1"].getService(Components.interfaces.nsIClipboardHelper);

var aLangues = new Arbre("ComboListe/combo-langues.tmpl", "langueId");
var aFormatsTransporteur = new Arbre("ComboListe/combo-formatsTransporteur.tmpl", "Format_Id");

var gEtablissementDefaut;
var gDepotDefaut;
var gSiteWeb;
var gSymboleUniteVolume;
var gSymboleUnitePoids;
var gConfig;
var gProfil;
var gEXLBacPrepa;
var gEtapePicking;
var gMWMModePicking;
var gAccMWM;



function init() {
	try {

		gProfil = getProfil();

		gAccMWM = gProfil.isAccMWM();
		gEtablissementDefaut = gProfil.getEtabId();

		var qDepotDefaut = new QueryHttp("Facturation/Commun/getDepotDefautEts.tmpl");
		qDepotDefaut.setParam("Etablissement_Id", gEtablissementDefaut);
		var result = qDepotDefaut.execute();
		gDepotDefaut = result.responseXML.documentElement.getAttribute('Depot_Defaut');

		var qExistEP = new QueryHttp("Facturation/Suivi_Logistique/existEtapePicking.tmpl");
		result = qExistEP.execute();
		gEtapePicking = (result.responseXML.documentElement.getAttribute("Exist")=="true");

		gConfig = getConfig();

		gSiteWeb = gConfig.isECommerce();
		gSymboleUniteVolume = gConfig.getSymboleUniteVolume();
		gSymboleUnitePoids = gConfig.getSymboleUnitePoids();
		gEXLBacPrepa = gConfig.isEXLBacPrepa();
		gMWMModePicking = gConfig.getMWMModePicking();

		aFormatsTransporteur.setParam("Type_Format", "E");
		aFormatsTransporteur.initTree();

		document.getElementById('deck').selectedIndex = 0;

		ooel_initOngletExpeditions();
		oopk_initOngletPicking();
		oope_initOngletPreparations();
		oobl_initOngletLivraisons();

	} catch (e) {
    recup_erreur(e);
  }
}


function retourSuiviLogistique() {
	try {

		document.getElementById('rappelLoi').collapsed = true;
		document.getElementById('pdf').setAttribute("src", "");
		document.getElementById('pdfEtiquettes').setAttribute("src", "");
		document.getElementById('deck').selectedIndex = 0;
		document.getElementById('bRetourSuiviLogistique').collapsed = true;
		document.getElementById('boxParamPDF').collapsed = true;
		document.getElementById('boxEtiquettes').collapsed = true;
		document.getElementById('lblDocExpe').collapsed = true;
		document.getElementById('boxExpTrans').collapsed = true;

	} catch (e) {
		recup_erreur(e);
	}
}


function retourMenuPrincipal() {
	try {

		window.location = "chrome://opensi/content/facturation/user/menu_principal.xul";

	} catch (e) {
    recup_erreur(e);
  }
}
