/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

var oobl_aEtablissements = new Arbre('ComboListe/combo-etablissements.tmpl', 'oobl-etablissement');
var oobl_aDepots = new Arbre('ComboListe/combo-depotsStock.tmpl', 'oobl-depot');
var oobl_aProvenances = new Arbre("ComboListe/combo-sitesWeb.tmpl","oobl-provenance");
var oobl_aModesExpedition = new Arbre("ComboListe/combo-modesExpedition.tmpl","oobl-modeExpedition");
var oobl_aLivraisons = new Arbre("Facturation/Suivi_Logistique/list-bonLivraison.tmpl", "oobl-listeLivraisons");
var oobl_aApercuLigneBL = new Arbre("Facturation/Suivi_Logistique/list-apercuLigneBL.tmpl", "oobl-apercuLigneBL");
var oobl_aApercuColisBL = new Arbre("Facturation/Suivi_Logistique/list-apercuColisBL.tmpl", "oobl-apercuColisBL");
var oobl_qListBL = new QueryHttp("Facturation/Suivi_Logistique/getDataListBL.tmpl");

var oobl_pageCourante;
var oobl_nbPages;

var oobl_currentBonId = "";
var oobl_langueDefaut;



function oobl_initOngletLivraisons() {
	try {

		oobl_aProvenances.initTree();
		oobl_aModesExpedition.initTree();

		oobl_aEtablissements.setParam('Selection', gEtablissementDefaut);
		oobl_aEtablissements.initTree(oobl_initEtablissement);

		if (!gSiteWeb) {
			document.getElementById('oobl-colProvenance').collapsed = true;
			document.getElementById('oobl-colProvenance').setAttribute("ignoreincolumnpicker", true);
		}

		if (!gAccMWM) {
			document.getElementById('oobl-colLastLocalisation').collapsed = true;
			document.getElementById('oobl-colLastLocalisation').setAttribute("ignoreincolumnpicker", true);
		}

		document.getElementById('oobl-boxProvenance').collapsed = !gSiteWeb;

		document.getElementById('oobl-colPoids').setAttribute("label", "Poids th\u00E9orique en "+ gSymboleUnitePoids);
		document.getElementById('oobl-colVolume').setAttribute("label", "Volume en "+ gSymboleUniteVolume);
		document.getElementById("oobl-colVolumeColisAC").setAttribute("label", "Volume ("+ gSymboleUniteVolume +")");

		document.getElementById('oobl-miProvenanceHL').collapsed = !gProfil.isProvenanceHL();

		document.getElementById('oobl-bEtiquetteLigneExpedition').collapsed = isEmpty(gConfig.getEtiquetteLigneExpedition());

	} catch (e) {
		recup_erreur(e);
  }
}


function oobl_initEtablissement() {
	try {

		oobl_aDepots.setParam('Selection', gDepotDefaut);
		oobl_aDepots.initTree(oobl_initCriteres);

	} catch (e) {
		recup_erreur(e);
	}
}


function oobl_initCriteres() {
	try {

		document.getElementById('oobl-numeroBL').value = "";
		document.getElementById('oobl-dateBLDebut').value = "";
		document.getElementById('oobl-dateBLFin').value = "";
		document.getElementById('oobl-numClient').value = "";
		document.getElementById('oobl-denomination').value = "";
		document.getElementById('oobl-etablissement').value = gEtablissementDefaut;
		document.getElementById('oobl-depot').value = gDepotDefaut;
		document.getElementById('oobl-refArticle').value = "";
		document.getElementById('oobl-etatBL').value = "N";
		document.getElementById('oobl-modeExpedition').value = "";
		document.getElementById('oobl-provenance').value = "";
		document.getElementById('oobl-numCommande').value = "";
		document.getElementById('oobl-numTransfert').value = "";
		document.getElementById('oobl-numeroBP').value = "";

	} catch (e) {
		recup_erreur(e);
	}
}


function oobl_listerLivraisons() {
	try {

		var numeroBL = document.getElementById('oobl-numeroBL').value;
		var numClient = document.getElementById('oobl-numClient').value;
		var denomination = document.getElementById('oobl-denomination').value;
		var etatBL = document.getElementById('oobl-etatBL').value;
		var refArticle = document.getElementById('oobl-refArticle').value;
		var etablissement = document.getElementById('oobl-etablissement').value;
		var depot = document.getElementById('oobl-depot').value;
		var provenance = document.getElementById('oobl-provenance').value;
		var dateBLDebut = document.getElementById('oobl-dateBLDebut').value;
		var dateBLFin = document.getElementById('oobl-dateBLFin').value;
		var modeExpedition = document.getElementById('oobl-modeExpedition').value;
		var numCommande = document.getElementById('oobl-numCommande').value;
		var numTransfert = document.getElementById('oobl-numTransfert').value;
		var numeroBP = document.getElementById('oobl-numeroBP').value;
		var nbLignesParPage = document.getElementById('oobl-nbLignesParPage').value;

		if (!isEmpty(dateBLDebut) && !isDate(dateBLDebut)) { showWarning("Date de d\u00E9but incorrecte"); }
		else if (!isEmpty(dateBLFin) && !isDate(dateBLFin)) { showWarning("Date de fin incorrecte"); }
		else if (!isEmpty(dateBLDebut) && !isEmpty(dateBLFin) && !isDateInterval(dateBLDebut, dateBLFin)) { showWarning("Plage de dates incorrecte"); }
		else {

			oobl_pageCourante = 1;
			oobl_nbPages = 1;
			document.getElementById('oobl-pageDeb').value = 1;
			document.getElementById('oobl-pageFin').value = 1;
			document.getElementById('oobl-bPrec').disabled = true;
			document.getElementById('oobl-bSuiv').disabled = true;

			document.getElementById('oobl-listeLivraisons').disabled = true;
			document.getElementById('oobl-bEditionCSV').disabled = true;
			document.getElementById('oobl-bEditionBL').disabled = true;
			document.getElementById('oobl-bEditionOL').disabled = true;
			document.getElementById('oobl-bEditionOL').collapsed = true;
			document.getElementById('oobl-bEditionBL').collapsed = false;
			document.getElementById('oobl-bEtiquetteTransport').disabled = true;
			document.getElementById('oobl-bEtiquetteExpedition').disabled = true;
			document.getElementById('oobl-bEtiquetteLigneExpedition').disabled = true;
			document.getElementById('oobl-numBonLivraisonSelect').value = "";
			document.getElementById('oobl-bAnnulerColis').disabled = true;
			oobl_aApercuLigneBL.deleteTree();
			oobl_aApercuColisBL.deleteTree();
			oobl_aLivraisons.deleteTree();

			oobl_qListBL.setParam("Numero_BL", numeroBL);
			oobl_qListBL.setParam("Num_Client", numClient);
			oobl_qListBL.setParam("Denomination", denomination);
			oobl_qListBL.setParam("Etat_BL", etatBL);
			oobl_qListBL.setParam("Ref_Article", refArticle);
			oobl_qListBL.setParam("Etablissement", etablissement);
			oobl_qListBL.setParam("Depot", depot);
			oobl_qListBL.setParam("Provenance", provenance);
			oobl_qListBL.setParam("Date_BL_Debut", dateBLDebut);
			oobl_qListBL.setParam("Date_BL_Fin", dateBLFin);
			oobl_qListBL.setParam("Mode_Expedition", modeExpedition);
			oobl_qListBL.setParam("Num_Commande", numCommande);
			oobl_qListBL.setParam("Num_Transfert", numTransfert);
			oobl_qListBL.setParam("Numero_BP", numeroBP);
			oobl_qListBL.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
			oobl_qListBL.setParam("Current_Page", oobl_pageCourante);

			var result = oobl_qListBL.execute();

			var contenu = result.responseXML.documentElement;

			oobl_nbPages = contenu.getAttribute("Nb_Pages");
			var listBonId = contenu.getAttribute("List_Bon_Id");

			oobl_aLivraisons.setParam("List_Bon_Id", listBonId);
			oobl_aLivraisons.initTree(oobl_initPagination);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oobl_initPagination() {
	try {

		document.getElementById('oobl-pageDeb').value = oobl_pageCourante;
		document.getElementById('oobl-pageFin').value = (oobl_nbPages>0?oobl_nbPages:1);
		document.getElementById('oobl-bPrec').disabled = (oobl_pageCourante==1);
		document.getElementById('oobl-bSuiv').disabled = (oobl_pageCourante>=oobl_nbPages); // peut se produire si oobl_nbPages=0

		oobl_afterMajPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function oobl_pressOnPagePrec() {
	try {

		oobl_pageCourante--;
		oobl_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function oobl_pressOnPageSuiv() {
	try {

		oobl_pageCourante++;
		oobl_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function oobl_majPagination() {
	try {

		document.getElementById('oobl-pageDeb').value = oobl_pageCourante;
		document.getElementById('oobl-bPrec').disabled = (oobl_pageCourante==1);
		document.getElementById('oobl-bSuiv').disabled = (oobl_pageCourante==oobl_nbPages);

		document.getElementById('oobl-listeLivraisons').disabled = true;
		document.getElementById('oobl-bEditionCSV').disabled = true;
		document.getElementById('oobl-bEditionBL').disabled = true;
		document.getElementById('oobl-bEditionOL').disabled = true;
		document.getElementById('oobl-bEditionOL').collapsed = true;
		document.getElementById('oobl-bEditionBL').collapsed = false;
		document.getElementById('oobl-bEtiquetteTransport').disabled = true;
		document.getElementById('oobl-bEtiquetteExpedition').disabled = true;
		document.getElementById('oobl-bEtiquetteLigneExpedition').disabled = true;
		document.getElementById('oobl-numBonLivraisonSelect').value = "";
		document.getElementById('oobl-bAnnulerColis').disabled = true;
		oobl_aApercuLigneBL.deleteTree();
		oobl_aApercuColisBL.deleteTree();

		oobl_qListBL.setParam("Current_Page", oobl_pageCourante);
		var result = oobl_qListBL.execute();
		var listBonId = result.responseXML.documentElement.getAttribute("List_Bon_Id");

		oobl_aLivraisons.setParam("List_Bon_Id", listBonId);
		oobl_aLivraisons.initTree(oobl_afterMajPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function oobl_afterMajPagination() {
	try {

		document.getElementById('oobl-listeLivraisons').disabled = false;
		document.getElementById('oobl-bEditionCSV').disabled=(oobl_aLivraisons.nbLignes()==0);

	} catch (e) {
		recup_erreur(e);
	}
}


function oobl_selectOnListeLivraisons() {
	try {

		if (oobl_aLivraisons.isSelected()) {
			oobl_currentBonId = oobl_aLivraisons.getSelectedCellText('oobl-colBonId');
			document.getElementById('oobl-numBonLivraisonSelect').value = oobl_aLivraisons.getSelectedCellText("oobl-colNumeroBL");
			document.getElementById('oobl-bAnnulerColis').disabled = true;
			oobl_aApercuLigneBL.setParam("Bon_Liv_Id", oobl_currentBonId);
			oobl_aApercuLigneBL.initTree();
			oobl_aApercuColisBL.setParam("Bon_Liv_Id", oobl_currentBonId);
			oobl_aApercuColisBL.initTree();

			document.getElementById('oobl-bEditionBL').disabled = false;
			document.getElementById('oobl-bEditionOL').disabled = false;
			document.getElementById('oobl-bEditionOL').collapsed = oobl_aLivraisons.getSelectedCellText("oobl-colTypeLivraison")!="L";
			document.getElementById('oobl-bEditionBL').collapsed = oobl_aLivraisons.getSelectedCellText("oobl-colTypeLivraison")=="L";
			document.getElementById('oobl-bEtiquetteExpedition').disabled = (oobl_aLivraisons.getSelectedCellText("oobl-colEtat")!="V" || oobl_aLivraisons.getSelectedCellText("oobl-colSourceType")=="R");
			document.getElementById('oobl-bEtiquetteLigneExpedition').disabled = (oobl_aLivraisons.getSelectedCellText("oobl-colEtat")!="V" || oobl_aLivraisons.getSelectedCellText("oobl-colSourceType")!="C" || oobl_aLivraisons.getSelectedCellText("oobl-colTypeLivraison")!="B");
			document.getElementById('oobl-bEtiquetteTransport').disabled = (oobl_aLivraisons.getSelectedCellText("oobl-colEtat")!="V");
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oobl_pressOnCritere(ev) {
  try {

		if (ev.keyCode==13) {
			oobl_listerLivraisons();
    }

	} catch (e) {
  	recup_erreur(e);
  }
}


function oobl_pressOnEditionCSV() {
	try {

		var numeroBL = document.getElementById('oobl-numeroBL').value;
		var numClient = document.getElementById('oobl-numClient').value;
		var denomination = document.getElementById('oobl-denomination').value;
		var etatBL = document.getElementById('oobl-etatBL').value;
		var refArticle = document.getElementById('oobl-refArticle').value;
		var etablissement = document.getElementById('oobl-etablissement').value;
		var depot = document.getElementById('oobl-depot').value;
		var provenance = document.getElementById('oobl-provenance').value;
		var dateBLDebut = document.getElementById('oobl-dateBLDebut').value;
		var dateBLFin = document.getElementById('oobl-dateBLFin').value;
		var modeExpedition = document.getElementById('oobl-modeExpedition').value;
		var numCommande = document.getElementById('oobl-numCommande').value;
		var numTransfert = document.getElementById('oobl-numTransfert').value;
		var numeroBP = document.getElementById('oobl-numeroBP').value;

		if (!isEmpty(dateBLDebut) && !isDate(dateBLDebut)) { showWarning("Date de d\u00E9but incorrecte"); }
		else if (!isEmpty(dateBLFin) && !isDate(dateBLFin)) { showWarning("Date de fin incorrecte"); }
		else if (!isEmpty(dateBLDebut) && !isEmpty(dateBLFin) && !isDateInterval(dateBLDebut, dateBLFin)) { showWarning("Plage de dates incorrecte"); }
		else {

			var qEditionCSV = new QueryHttp("Facturation/Suivi_Logistique/csvBonLivraison.tmpl");

			qEditionCSV.setParam("Numero_BL", numeroBL);
			qEditionCSV.setParam("Num_Client", numClient);
			qEditionCSV.setParam("Denomination", denomination);
			qEditionCSV.setParam("Etat_BL", etatBL);
			qEditionCSV.setParam("Ref_Article", refArticle);
			qEditionCSV.setParam("Etablissement", etablissement);
			qEditionCSV.setParam("Depot", depot);
			qEditionCSV.setParam("Provenance", provenance);
			qEditionCSV.setParam("Date_BL_Debut", dateBLDebut);
			qEditionCSV.setParam("Date_BL_Fin", dateBLFin);
			qEditionCSV.setParam("Mode_Expedition", modeExpedition);
			qEditionCSV.setParam("Num_Commande", numCommande);
			qEditionCSV.setParam("Num_Transfert", numTransfert);
			qEditionCSV.setParam("Numero_BP", numeroBP);

			var result = qEditionCSV.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');

				var file = fileChooser("save", fichier);
				if (file!=null) {
					downloadFile(getDirBuffer()+ fichier, file);
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oobl_visualiserBL() {
	try {

		if (oobl_aLivraisons.isSelected()) {
			var qLangueDefaut = new QueryHttp("Facturation/Commun/getLangueDefaut.tmpl");
			qLangueDefaut.setParam("Type_Doc", "BL");
			qLangueDefaut.setParam("Doc_Id", oobl_currentBonId);
			var result = qLangueDefaut.execute();
			oobl_langueDefaut = result.responseXML.documentElement.getAttribute("Langue_Id");

			aLangues.setParam("Selection", oobl_langueDefaut);
			aLangues.initTree(oobl_visualiserBL_2);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oobl_visualiserBL_2() {
	try {

		document.getElementById('langueId').value = oobl_langueDefaut;
		oobl_editionBL();

	} catch (e) {
		recup_erreur(e);
	}
}


function oobl_editionBL() {
	try {

		var langueId = document.getElementById('langueId').value;

		var qEditionPDF = new QueryHttp("Facturation/Suivi_Logistique/pdfBonLivraison.tmpl");
		qEditionPDF.setParam('Bon_Id', oobl_currentBonId);
		qEditionPDF.setParam('Langue_Id', langueId);

		document.getElementById('pmbox').collapsed = false;
		document.getElementById('pm').setAttribute('mode', 'undetermined');
		document.getElementById('deck').selectedIndex = 1;

		qEditionPDF.execute(oobl_editionBL_2);

	} catch (e) {
		recup_erreur(e);
	}
}


function oobl_editionBL_2(result) {
	try {

		document.getElementById('pmbox').collapsed = true;
		document.getElementById('pm').setAttribute('mode', 'none');

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
			retourSuiviLogistique();
		}
		else {
			var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
			document.getElementById('pdf').setAttribute("src", page);

			document.getElementById('bRetourSuiviLogistique').collapsed = false;
			document.getElementById('boxParamPDF').collapsed = false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oobl_editionOL() {
	try {

		var qEditionPDF = new QueryHttp("Facturation/Suivi_Logistique/pdfOrdreLivraison.tmpl");
		qEditionPDF.setParam('Bon_Id', oobl_currentBonId);

		document.getElementById('pmbox').collapsed = false;
		document.getElementById('pm').setAttribute('mode', 'undetermined');
		document.getElementById('deck').selectedIndex = 1;

		qEditionPDF.execute(oobl_editionOL_2);

	} catch (e) {
		recup_erreur(e);
	}
}


function oobl_editionOL_2(result) {
	try {

		document.getElementById('pmbox').collapsed = true;
		document.getElementById('pm').setAttribute('mode', 'none');

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
			retourSuiviLogistique();
		}
		else {
			var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
			document.getElementById('pdf').setAttribute("src", page);

			document.getElementById('bRetourSuiviLogistique').collapsed = false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oobl_genererEtiquetteTransport() {
	try {

		document.getElementById('oobl-bEtiquetteTransport').blur();	// scurit pour viter multi appels (zen 26592)

		if (oobl_aLivraisons.isSelected()) {
			var qGen = new QueryHttp("Facturation/Suivi_Logistique/genEtiquetteTransportBL.tmpl");
			qGen.setParam("Bon_Liv_Id", oobl_currentBonId);
			var result = qGen.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showMessage("Une nouvelle demande d'\u00E9tiquette transport a \u00E9t\u00E9 g\u00E9n\u00E9r\u00E9e");
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oobl_editerEtiquetteExpedition() {
	try {

		if (oobl_aLivraisons.isSelected()) {
			var qEtiq = new QueryHttp("Facturation/Affaires/pdfEtiquettes.tmpl");
			qEtiq.setParam("Bon_Liv_Id", oobl_currentBonId);

			document.getElementById('pmbox').collapsed = false;
			document.getElementById('pm').setAttribute('mode', 'undetermined');
			document.getElementById('deck').selectedIndex = 1;

			qEtiq.execute(oobl_editerEtiquetteExpedition_2);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oobl_editerEtiquetteExpedition_2(result) {
	try {

		document.getElementById('pmbox').collapsed = true;
		document.getElementById('pm').setAttribute('mode', 'none');

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
			retourSuiviLogistique();
		}
		else {
			var page = getDirPdf() + result.responseXML.documentElement.getAttribute('fichier');
			document.getElementById('pdf').setAttribute("src", page);

			document.getElementById('bRetourSuiviLogistique').collapsed = false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oobl_editerEtiquetteLigneExpedition() {
	try {

		if (oobl_aLivraisons.isSelected()) {
			var qEdit = new QueryHttp("Facturation/Suivi_Logistique/pdfEtiquetteLigneExpedition.tmpl");
			qEdit.setParam("Bon_Liv_Id", oobl_currentBonId);

			document.getElementById('pmbox').collapsed = false;
			document.getElementById('pm').setAttribute('mode', 'undetermined');
			document.getElementById('deck').selectedIndex = 1;

			qEdit.execute(oobl_editerEtiquetteLigneExpedition_2);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oobl_editerEtiquetteLigneExpedition_2(result) {
	try {

		document.getElementById('pmbox').collapsed = true;
		document.getElementById('pm').setAttribute('mode', 'none');

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
			retourSuiviLogistique();
		}
		else {
			var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
			document.getElementById('pdf').setAttribute("src", page);

			document.getElementById('bRetourSuiviLogistique').collapsed = false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oobl_clickOnColis(tree, ev) {

	gClipboardHelper.copyString(oobl_aApercuColisBL.getSelectedCellText("oobl-colNumColisAC"));

	var col = oobl_aApercuColisBL.getClickedCol(ev);

	if (col!=null && col.id=="oobl-colNumColisAC") {
		var lien = oobl_aApercuColisBL.getSelectedCellValue("oobl-colNumColisAC");
		if (!isEmpty(lien)) {
			//window.open(lien);
			openInNavigator(lien);
		}
	}
	else if (col!=null && col.id=="oobl-colCTCAC") {
		window.open(oobl_aApercuColisBL.getSelectedCellValue("oobl-colCTCAC"));
	}
}


function oobl_keypressOnColis(ev) {
  try {

		if ((ev.key=='w' || ev.key=='W') && ev.ctrlKey && oobl_aApercuColisBL.isSelected()) {
			// ctrl + w pour copier l'adresse du lien
			gClipboardHelper.copyString(oobl_aApercuColisBL.getSelectedCellValue("oobl-colNumColisAC"));
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function oobl_pressOnColis() {
  try {

		if (oobl_aApercuColisBL.isSelected()) {
			document.getElementById('oobl-bAnnulerColis').disabled = (oobl_aApercuColisBL.getSelectedCellText("oobl-colStatutAC")!="V");
		}
		else {
			document.getElementById('oobl-bAnnulerColis').disabled = true;
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function oobl_annulerColis() {
  try {

		document.getElementById('oobl-bAnnulerColis').disabled = true;

		if (window.confirm("Confirmez-vous l'annulation du colis s\u00E9lectionn\u00E9 ?")) {

			var colisId = oobl_aApercuColisBL.getSelectedCellText("oobl-colColisIdAC");

			var qCancel = new QueryHttp("Facturation/Suivi_Logistique/cancelColis.tmpl");
			qCancel.setParam("Colis_Id", colisId);
			var result = qCancel.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showMessage("Le colis a \u00E9t\u00E9 annul\u00E9");
			}
			oobl_aApercuColisBL.initTree();
		}
		else {
			document.getElementById('oobl-bAnnulerColis').disabled = false;
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oobl_rechercherClient() {
	try {

		var url = "chrome://opensi/content/facturation/user/clients/popup-rechercheClient.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', oobl_retourRechercherClient);

	} catch (e) {
		recup_erreur(e);
	}
}


function oobl_retourRechercherClient(numClient) {
	try {

  	document.getElementById('oobl-numClient').value = numClient;
  	oobl_listerLivraisons();

	} catch (e) {
		recup_erreur(e);
	}
}


function oobl_rechercherArticle() {
	try {

		var url = "chrome://opensi/content/facturation/user/articles/popup-rechercheArticle.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', oobl_retourRechercherArticle);

	} catch (e) {
		recup_erreur(e);
	}
}


function oobl_retourRechercherArticle(reference, articleId) {
	try {

  	document.getElementById('oobl-refArticle').value = reference;
  	oobl_listerLivraisons();

	} catch (e) {
		recup_erreur(e);
	}
}
