/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var oe_aPieces = new Arbre("Facturation/Suivi_Reglements_Clients/list-pieceClient.tmpl", "oe-listePieces");
var oe_aEcheances = new Arbre("Facturation/Suivi_Reglements_Clients/list-echeanceClient.tmpl", "oe-listeEcheances");
var oe_aEcheancesFact = new Arbre("Facturation/Suivi_Reglements_Clients/list-echeancePieceClient.tmpl", "oe-listeEcheancesFact");
var oe_aReglements = new Arbre("Facturation/Suivi_Reglements_Clients/list-imputationEcheanceClient.tmpl", "oe-listeReglements");
var oe_aFiltreModesReglements = new Arbre('ComboListe/combo-modesReglement.tmpl', 'oe-filtreModeReglement');
var oe_aBanques = new Arbre('ComboListe/combo-banques.tmpl', 'oe-banqueRemise');
var oe_aClients = new Arbre('Facturation/Suivi_Reglements_Clients/combo-clients.tmpl', 'oe-clientId');
var oe_aBanquesClient = new Arbre('ComboListe/combo-banquesClient.tmpl', 'oe-banqueClient');
var oe_aModesReglements = new Arbre('ComboListe/combo-modesReglement.tmpl', 'oe-modeReglement');
var oe_aEtablissements = new Arbre('ComboListe/combo-etablissements.tmpl', 'oe-etablissement');
var oe_aResponsables = new Arbre("ComboListe/combo-responsables.tmpl","oe-responsable");

var oe_qListEC = new QueryHttp("Facturation/Suivi_Reglements_Clients/getDataListEC.tmpl");
var oe_qListPC = new QueryHttp("Facturation/Suivi_Reglements_Clients/getDataListPC.tmpl");

var oe_chargerModeReg;
var oe_chargerClient;
var oe_chargerDenominationClient;
var oe_selBanqueId = "";
var oe_currentEcheanceId = "";
var oe_tabLoaded = false;

var oe_pageCourante;
var oe_nbPages;



function oe_init() {
  try {

		if (!oe_tabLoaded) {
			oe_tabLoaded = true;

  		document.getElementById('oe-etat').value = "N";
  		document.getElementById('oe-rechDenomination').value = "";
  		document.getElementById('oe-rechNumPiece').value = "";
			document.getElementById('oe-nbLignesParPage').selectedIndex = 0;

 			oe_aFiltreModesReglements.initTree(oe_initFiltreModeReglement);

			if (gReadOnly) {
				document.getElementById('oe-bRegulariserFact').collapsed = true;
				document.getElementById('oe-bDesaffecter').collapsed = true;
				document.getElementById('oe-bEnregistrerReglement').collapsed = true;
			}
		}
		else {
			oe_initListeHaut();
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oe_initFiltreModeReglement() {
	try {

    document.getElementById('oe-filtreModeReglement').selectedIndex = 0;
    oe_aEtablissements.setParam('Selection', etablissementDefaut);
		oe_aEtablissements.initTree(oe_initResponsable);

	} catch (e) {
    recup_erreur(e);
  }
}


function oe_initResponsable() {
	try {

    document.getElementById('oe-responsable').selectedIndex = 0;
    oe_aResponsables.initTree(oe_initEtablissement);

	} catch (e) {
    recup_erreur(e);
  }
}


function oe_initEtablissement() {
	try {

		oe_reinitialiser();

	} catch (e) {
    recup_erreur(e);
  }
}


function oe_chargerClients(selection, denomination) {
	try {
		oe_chargerClient = selection;
		oe_chargerDenominationClient = denomination;
		oe_aClients.setParam("Client_Id", oe_chargerClient);
		oe_aClients.setParam("Echeance_Id", oe_currentEcheanceId);
		oe_aClients.setParam("Type", "EC");
    oe_aClients.initTree(oe_selectClient);
	} catch (e) {
		recup_erreur(e);
	}
}


function oe_chargerBanquesClient() {
	try {
		var clientId = document.getElementById('oe-clientId').value;
		if (isEmpty(clientId) || clientId=="0") {
			oe_aBanquesClient.deleteTree();
			oe_initBanqueClient();
		} else {
			oe_aBanquesClient.setParam("Client_Id", clientId);
			oe_aBanquesClient.initTree(oe_initBanqueClient);
		}
	} catch (e) {
		recup_erreur(e);
	}
}


function oe_initBanqueClient() {
	try {
		document.getElementById('oe-banqueClient').setAttribute("label", "");
		document.getElementById('oe-banqueClient').value = "";
	} catch (e) {
		recup_erreur(e);
	}
}


function oe_chargerBanques(selection) {
	try {

		oe_selBanqueId = selection;
		oe_aBanques.setParam("Selection", oe_selBanqueId);
		oe_aBanques.initTree(oe_initBanque);

	} catch (e) {
		recup_erreur(e);
	}
}


function oe_initBanque() {
  try {

		document.getElementById('oe-banqueRemise').value = oe_selBanqueId;

	} catch (e) {
  	recup_erreur(e);
	}
}


function oe_chargerModesReglements(selection) {
	try {
		oe_chargerModeReg = selection;
		oe_aModesReglements.setParam("Selection", oe_chargerModeReg);
		oe_aModesReglements.initTree(oe_initModeReglement);
	} catch (e) {
		recup_erreur(e);
	}
}


function oe_initModeReglement() {
	try {

    document.getElementById('oe-modeReglement').value=oe_chargerModeReg;

	} catch (e) {
    recup_erreur(e);
  }
}


function oe_nouveauReglement() {
	try {

		oe_currentEcheanceId = "";
		document.getElementById('oe-dateReglement').value = "";
		document.getElementById('oe-echeanceRemise').value = "";
		oe_aBanquesClient.deleteTree();
		oe_initBanqueClient();
		oe_chargerClients("","");
		oe_chargerModesReglements("");
		oe_chargerBanques("");
		document.getElementById('oe-numPiece').value = "";
		document.getElementById('oe-tiersPayeur').value = "";
		document.getElementById('oe-montant').value = "";
		document.getElementById('oe-commentaires').value = "";

	} catch (e) {
    recup_erreur(e);
  }
}


function oe_initListeHaut() {
	try {

		var etat = document.getElementById('oe-etat').value;
		var denomination = document.getElementById('oe-rechDenomination').value;
		var numPiece = document.getElementById('oe-rechNumPiece').value;
		var dateEcheanceDebut = document.getElementById('oe-dateEcheanceDebut').value;
		var dateEcheanceFin = document.getElementById('oe-dateEcheanceFin').value;
		var dateFactureDebut = document.getElementById('oe-dateFactureDebut').value;
		var dateFactureFin = document.getElementById('oe-dateFactureFin').value;
		var modeReglement = document.getElementById('oe-filtreModeReglement').value;
		var numClient = document.getElementById('oe-numClient').value;
		var etablissement = document.getElementById('oe-etablissement').value;
		var responsable = document.getElementById('oe-responsable').value;
		var codeRegroupement = document.getElementById('oe-codeRegroupement').value;
		var dateArrete = document.getElementById('oe-dateArrete').value;
		var nbLignesParPage = document.getElementById('oe-nbLignesParPage').value;

		if (!isEmpty(dateEcheanceDebut) && !isDate(dateEcheanceDebut)) { showWarning("Date d'\u00E9ch\u00E9ance de d\u00E9but incorrecte !"); }
		else if (!isEmpty(dateEcheanceFin) && !isDate(dateEcheanceFin)) { showWarning("Date d'\u00E9ch\u00E9ance de fin incorrecte !"); }
		else if (!isEmpty(dateEcheanceDebut) && !isEmpty(dateEcheanceFin) && !isDateInterval(dateEcheanceDebut, dateEcheanceFin)) { showWarning("La date d'\u00E9ch\u00E9ance de fin doit \u00EAtre sup\u00E9rieure \u00E0 la date de d\u00E9but !"); }
		else if (!isEmpty(dateFactureDebut) && !isDate(dateFactureDebut)) { showWarning("Date de facture de d\u00E9but incorrecte !"); }
		else if (!isEmpty(dateFactureFin) && !isDate(dateFactureFin)) { showWarning("Date de facture de fin incorrecte !"); }
		else if (!isEmpty(dateFactureDebut) && !isEmpty(dateFactureFin) && !isDateInterval(dateFactureDebut, dateFactureFin)) { showWarning("La date de facture de fin doit \u00EAtre sup\u00E9rieure \u00E0 la date de d\u00E9but !"); }
		else if (!isEmpty(dateArrete) && !isDate(dateArrete)) { showWarning("Date d'arr\u00EAt\u00E9 incorrecte"); }
		else {

			oe_pageCourante = 1;
			oe_nbPages = 1;
			document.getElementById('oe-pageDeb').value = 1;
			document.getElementById('oe-pageFin').value = 1;
			document.getElementById('oe-bPrec').disabled = true;
			document.getElementById('oe-bSuiv').disabled = true;

			var modeTraitement = document.getElementById('oe-modeTraitement').value;

			document.getElementById('oe-bDesaffecter').disabled = true;
			document.getElementById('oe-editerPdf').disabled = true;
			document.getElementById('oe-bEditionCsv').disabled = true;
			document.getElementById('oe-listePieces').collapsed = (modeTraitement!="F");
			document.getElementById('oe-grpEcheances').collapsed = (modeTraitement!="F");
			document.getElementById('oe-listeEcheances').collapsed = (modeTraitement=="F");
			document.getElementById('oe-bRegulariser').collapsed = (modeTraitement=="F" || gReadOnly);
			document.getElementById('oe-bSolderEcheances').collapsed = (modeTraitement=="F" || gReadOnly);
			document.getElementById('oe-grpReglements').collapsed = (modeTraitement=="F");
			document.getElementById('oe-bModifierEcheances').collapsed = (modeTraitement=="F" || gReadOnly);

			if (modeTraitement=="F") {
				document.getElementById('oe-listePieces').disabled = true;
				document.getElementById('oe-bRegulariserFact').disabled = true;
				oe_aPieces.deleteTree();
				oe_aEcheancesFact.deleteTree();
			}
			else {
				document.getElementById('oe-listeEcheances').disabled = true;
				document.getElementById('oe-bRegulariser').disabled = true;
				document.getElementById('oe-bModifierEcheances').disabled = true;
				oe_aEcheances.deleteTree();
				oe_aReglements.deleteTree();
			}

			oe_nouveauReglement();

			if (modeTraitement=="F") {
				oe_qListPC.setParam("Num_Client", numClient);
				oe_qListPC.setParam("Denomination", denomination);
				oe_qListPC.setParam("Etat", etat);
				oe_qListPC.setParam("Date_Echeance_Debut", dateEcheanceDebut);
				oe_qListPC.setParam("Date_Echeance_Fin", dateEcheanceFin);
				oe_qListPC.setParam("Date_Facture_Debut", dateFactureDebut);
				oe_qListPC.setParam("Date_Facture_Fin", dateFactureFin);
				oe_qListPC.setParam("Num_Piece", numPiece);
				oe_qListPC.setParam("Mode_Reglement", modeReglement);
				oe_qListPC.setParam("Etablissement", etablissement);
				oe_qListPC.setParam("Responsable", responsable);
				oe_qListPC.setParam("Code_Regroupement", codeRegroupement);
				oe_qListPC.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
				oe_qListPC.setParam("Current_Page", oe_pageCourante);

				var result = oe_qListPC.execute();

				var contenu = result.responseXML.documentElement;

				document.getElementById('oe-totalDu').value = contenu.getAttribute("Total");
				document.getElementById('oe-totalRestantDu').value = contenu.getAttribute("Restant");

				oe_nbPages = contenu.getAttribute("Nb_Pages");
				var listFactureId = contenu.getAttribute("List_Facture_Id");
				var listAcompteId = contenu.getAttribute("List_Acompte_Id");

				oe_aPieces.setParam("List_Facture_Id", listFactureId);
				oe_aPieces.setParam("List_Acompte_Id", listAcompteId);
				oe_aPieces.initTree(oe_initPagination);
			}
			else {
				oe_qListEC.setParam("Num_Client", numClient);
				oe_qListEC.setParam("Denomination", denomination);
				oe_qListEC.setParam("Etat", etat);
				oe_qListEC.setParam("Date_Echeance_Debut", dateEcheanceDebut);
				oe_qListEC.setParam("Date_Echeance_Fin", dateEcheanceFin);
				oe_qListEC.setParam("Date_Facture_Debut", dateFactureDebut);
				oe_qListEC.setParam("Date_Facture_Fin", dateFactureFin);
				oe_qListEC.setParam("Num_Piece", numPiece);
				oe_qListEC.setParam("Mode_Reglement", modeReglement);
				oe_qListEC.setParam("Etablissement", etablissement);
				oe_qListEC.setParam("Responsable", responsable);
				oe_qListEC.setParam("Code_Regroupement", codeRegroupement);
				oe_qListEC.setParam("Date_Arrete", dateArrete);
				oe_qListEC.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
				oe_qListEC.setParam("Current_Page", oe_pageCourante);

				var result = oe_qListEC.execute();

				var contenu = result.responseXML.documentElement;

				document.getElementById('oe-totalDu').value = contenu.getAttribute("Total");
				document.getElementById('oe-totalRestantDu').value = contenu.getAttribute("Restant");

				oe_nbPages = contenu.getAttribute("Nb_Pages");
				var listEcheanceId = contenu.getAttribute("List_Echeance_Id");

				oe_aEcheances.setParam("List_Echeance_Id", listEcheanceId);
				oe_aEcheances.setParam("Date_Arrete", dateArrete);
				oe_aEcheances.initTree(oe_initPagination);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oe_initPagination() {
	try {

		document.getElementById('oe-pageDeb').value = oe_pageCourante;
		document.getElementById('oe-pageFin').value = (oe_nbPages>0?oe_nbPages:1);
		document.getElementById('oe-bPrec').disabled = (oe_pageCourante==1);
		document.getElementById('oe-bSuiv').disabled = (oe_pageCourante>=oe_nbPages); // peut se produire si nbPages=0

		oe_afterMajPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function oe_pressOnPagePrec() {
	try {

		oe_pageCourante--;
		oe_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function oe_pressOnPageSuiv() {
	try {

		oe_pageCourante++;
		oe_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function oe_majPagination() {
	try {

		document.getElementById('oe-pageDeb').value = oe_pageCourante;
		document.getElementById('oe-bPrec').disabled = (oe_pageCourante==1);
		document.getElementById('oe-bSuiv').disabled = (oe_pageCourante==oe_nbPages);

		document.getElementById('oe-bDesaffecter').disabled = true;

		var modeTraitement = document.getElementById('oe-modeTraitement').value;
		if (modeTraitement=="F") {
			document.getElementById('oe-listePieces').disabled = true;
			document.getElementById('oe-bRegulariserFact').disabled = true;
			oe_aEcheancesFact.deleteTree();
		}
		else {
			document.getElementById('oe-listeEcheances').disabled = true;
			document.getElementById('oe-bRegulariser').disabled = true;
			document.getElementById('oe-bModifierEcheances').disabled = true;
			oe_aReglements.deleteTree();
		}

		oe_nouveauReglement();

		if (modeTraitement=="F") {
			oe_qListPC.setParam("Current_Page", oe_pageCourante);
			var result = oe_qListPC.execute();
			var listFactureId = result.responseXML.documentElement.getAttribute("List_Facture_Id");
			var listAcompteId = result.responseXML.documentElement.getAttribute("List_Acompte_Id");

			oe_aPieces.setParam("List_Facture_Id", listFactureId);
			oe_aPieces.setParam("List_Acompte_Id", listAcompteId);
			oe_aPieces.initTree(oe_afterMajPagination);
		}
		else {
			oe_qListEC.setParam("Current_Page", oe_pageCourante);
			var result = oe_qListEC.execute();
			var listEcheanceId = result.responseXML.documentElement.getAttribute("List_Echeance_Id");

			oe_aEcheances.setParam("List_Echeance_Id", listEcheanceId);
			oe_aEcheances.initTree(oe_afterMajPagination);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oe_afterMajPagination() {
	try {

		var modeTraitement = document.getElementById('oe-modeTraitement').value;
		if (modeTraitement=="F") {
			document.getElementById('oe-listePieces').disabled = false;
			document.getElementById('oe-editerPdf').disabled = (oe_aPieces.nbLignes()==0);
			document.getElementById('oe-bEditionCsv').disabled = (oe_aPieces.nbLignes()==0);
		}
		else {
			document.getElementById('oe-listeEcheances').disabled = false;
			document.getElementById('oe-editerPdf').disabled = (oe_aEcheances.nbLignes()==0);
			document.getElementById('oe-bEditionCsv').disabled = (oe_aEcheances.nbLignes()==0);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oe_reinitialiser() {
	try {

		document.getElementById('oe-modeTraitement').value = "F";
		document.getElementById('oe-etat').value = "N";
		document.getElementById('oe-rechDenomination').value = "";
		document.getElementById('oe-rechNumPiece').value = "";
		document.getElementById('oe-dateEcheanceDebut').value = "";
		document.getElementById('oe-dateEcheanceFin').value = "";
		document.getElementById('oe-dateFactureDebut').value = "";
		document.getElementById('oe-dateFactureFin').value = "";
		document.getElementById('oe-filtreModeReglement').selectedIndex = 0;
		document.getElementById('oe-numClient').value = "";
		document.getElementById('oe-etablissement').value = etablissementDefaut;
		document.getElementById('oe-responsable').value = "";
		document.getElementById('oe-codeRegroupement').value = "";
		document.getElementById('oe-dateArrete').value = "";
		oe_manageDateArrete();

		oe_initListeHaut();

	} catch (e) {
		recup_erreur(e);
	}
}


function oe_rechercherClient() {
	try {

		var url = "chrome://opensi/content/facturation/user/clients/popup-rechercheClient.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', oe_retourRechercherClient);

	} catch (e) {
		recup_erreur(e);
	}
}


function oe_retourRechercherClient(codeClient) {
	try {
  	document.getElementById('oe-numClient').value = codeClient;
  	oe_initListeHaut();
	} catch (e) {
		recup_erreur(e);
	}
}


function oe_ajouterClientListe() {
	try {

		var url = "chrome://opensi/content/facturation/user/clients/popup-rechercheClient.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', oe_retourAjouterClientListe);

	} catch (e) {
		recup_erreur(e);
	}
}


function oe_retourAjouterClientListe(numClient, clientId) {
	try {

		oe_chargerClients(clientId, "");

	} catch (e) {
		recup_erreur(e);
	}
}


function oe_onKeyPress(event) {
	try {
		document.getElementById('oe-editerPdf').disabled = true;
		document.getElementById('oe-bEditionCsv').disabled = true;
		if (event.keyCode==13) {
			oe_initListeHaut();
		}
	} catch (e) {
		recup_erreur(e);
	}
}


function oe_manageDateArrete() {
	try {

		if (document.getElementById('oe-etat').value=="N" && document.getElementById('oe-modeTraitement').value=="E") {
			document.getElementById('oe-lblDateArrete').collapsed = false;
			document.getElementById('oe-dateArrete').collapsed = false;
		}
		else {
			document.getElementById('oe-lblDateArrete').collapsed = true;
			document.getElementById('oe-dateArrete').collapsed = true;
			document.getElementById('oe-dateArrete').value = "";
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oe_editerPdf() {
	try {

		document.getElementById('chkDetailEch').checked = false;
		document.getElementById('triEcheances').value = "D";
		document.getElementById('chkSousTotauxEch').checked = true;
		oe_rafraichirPdf();

	} catch (e) {
		recup_erreur(e);
	}
}


function oe_rafraichirPdf() {
	try {
		var etat = document.getElementById('oe-etat').value;
		var denomination = document.getElementById('oe-rechDenomination').value;
		var numPiece = document.getElementById('oe-rechNumPiece').value;
		var dateEcheanceDebut = document.getElementById('oe-dateEcheanceDebut').value;
		var dateEcheanceFin = document.getElementById('oe-dateEcheanceFin').value;
		var dateFactureDebut = document.getElementById('oe-dateFactureDebut').value;
		var dateFactureFin = document.getElementById('oe-dateFactureFin').value;
		var modeReglement = document.getElementById('oe-filtreModeReglement').value;
		var numClient = document.getElementById('oe-numClient').value;
		var modeTraitement = document.getElementById('oe-modeTraitement').value;
		var etablissement = document.getElementById('oe-etablissement').value;
		var responsable = document.getElementById('oe-responsable').value;
		var codeRegroupement = document.getElementById('oe-codeRegroupement').value;
		var dateArrete = document.getElementById('oe-dateArrete').value;

		if (!isEmpty(dateEcheanceDebut) && !isDate(dateEcheanceDebut)) { showWarning("Date d'\u00E9ch\u00E9ance de d\u00E9but incorrecte !"); }
		else if (!isEmpty(dateEcheanceFin) && !isDate(dateEcheanceFin)) { showWarning("Date d'\u00E9ch\u00E9ance de fin incorrecte !"); }
		else if (!isEmpty(dateEcheanceDebut) && !isEmpty(dateEcheanceFin) && !isDateInterval(dateEcheanceDebut, dateEcheanceFin)) { showWarning("La date d'\u00E9ch\u00E9ance de fin doit \u00EAtre sup\u00E9rieure \u00E0 la date de d\u00E9but !"); }
		else if (!isEmpty(dateFactureDebut) && !isDate(dateFactureDebut)) { showWarning("Date de facture de d\u00E9but incorrecte !"); }
		else if (!isEmpty(dateFactureFin) && !isDate(dateFactureFin)) { showWarning("Date de facture de fin incorrecte !"); }
		else if (!isEmpty(dateFactureDebut) && !isEmpty(dateFactureFin) && !isDateInterval(dateFactureDebut, dateFactureFin)) { showWarning("La date de facture de fin doit \u00EAtre sup\u00E9rieure \u00E0 la date de d\u00E9but !"); }
		else if (!isEmpty(dateArrete) && !isDate(dateArrete)) { showWarning("Date d'arr\u00EAt\u00E9 incorrecte"); }
		else {
			var detail = document.getElementById('chkDetailEch').checked;
			var triEcheances = document.getElementById('triEcheances').value;
			var sousTotaux = document.getElementById('chkSousTotauxEch').checked;

			var qGenPdf = new QueryHttp("Facturation/Suivi_Reglements_Clients/pdfListePieces.tmpl");
			qGenPdf.setParam("Type", modeTraitement);
      qGenPdf.setParam("Etat", etat);
      qGenPdf.setParam("Denomination", denomination);
      qGenPdf.setParam("Num_Piece", numPiece);
      qGenPdf.setParam("Date_Echeance_Debut", dateEcheanceDebut);
      qGenPdf.setParam("Date_Echeance_Fin", dateEcheanceFin);
      qGenPdf.setParam("Date_Facture_Debut", dateFactureDebut);
      qGenPdf.setParam("Date_Facture_Fin", dateFactureFin);
      qGenPdf.setParam("Mode_Reglement", modeReglement);
      qGenPdf.setParam("Num_Client", numClient);
			qGenPdf.setParam("Etablissement", etablissement);
			qGenPdf.setParam("Responsable", responsable);
			qGenPdf.setParam("Code_Regroupement", codeRegroupement);
			qGenPdf.setParam("Date_Arrete", dateArrete);
      qGenPdf.setParam("Detail", detail);
      qGenPdf.setParam("Tri", triEcheances);
      qGenPdf.setParam("Sous_Totaux", sousTotaux);
      var result = qGenPdf.execute();
      var page = getDirPdf() + result.responseXML.documentElement.getAttribute('fichier');
			switchPdf(page);
		}
	} catch (e) {
		recup_erreur(e);
	}
}


function oe_selectOnListePieces() {
	try {
		if (oe_aPieces.isSelected()) {
			document.getElementById('oe-listeEcheancesFact').disabled = true;
			var i = oe_aPieces.getCurrentIndex();
			var pieceId = oe_aPieces.getCellText(i, 'oe-colPieceId');
			var typePiece = oe_aPieces.getCellText(i, 'oe-colTypePiece');
			oe_aEcheancesFact.setParam("Piece_Id", pieceId);
			oe_aEcheancesFact.setParam("Type_Piece", typePiece);
			oe_aEcheancesFact.initTree(oe_selectPremiereEcheance);
		}
	} catch (e) {
		recup_erreur(e);
	}
}


function oe_selectPremiereEcheance() {
	try {
		document.getElementById('oe-listeEcheancesFact').disabled = false;
		if (oe_aEcheancesFact.nbLignes()>0) {
			oe_aEcheancesFact.select(0);
			oe_selectOnListeEcheancesFact();
		}
	} catch (e) {
		recup_erreur(e);
	}
}


function oe_selectOnListeEcheancesFact() {
	try {
		if (oe_aEcheancesFact.isSelected()) {
			var i = oe_aEcheancesFact.getCurrentIndex();
			oe_currentEcheanceId = oe_aEcheancesFact.getCellText(i, 'oe-colEcheanceIdFact');

			var clientId = oe_aEcheancesFact.getCellText(i, 'oe-colClientIdFact');
			var denomination = "";
			if (clientId=="") { denomination = oe_aEcheancesFact.getCellText(i, 'oe-colDenominationFact'); }

			oe_chargerClients(clientId, denomination);
			oe_chargerModesReglements(oe_aEcheancesFact.getCellText(i, 'oe-colModeRegIdFact'));
			oe_chargerBanques(oe_aEcheancesFact.getCellText(i, 'oe-colBanqueRemiseFact'));

			document.getElementById('oe-dateReglement').value = getDateCourante();
			document.getElementById('oe-echeanceRemise').value = "";
			document.getElementById('oe-numPiece').value = "";
			document.getElementById('oe-tiersPayeur').value = "";
			document.getElementById('oe-montant').value = oe_aEcheancesFact.getCellText(i, 'oe-colMontantFact');
			document.getElementById('oe-commentaires').value = oe_aEcheancesFact.getCellText(i, 'oe-colCommentairesFact');
			document.getElementById('oe-bRegulariserFact').disabled = (oe_aEcheancesFact.getCellText(i, 'oe-colEtatFact')=="T");
		}
	} catch (e) {
		recup_erreur(e);
	}
}


function oe_selectClient() {
	try {

		if (isEmpty(oe_chargerClient) && isEmpty(oe_chargerDenominationClient)) {
			document.getElementById('oe-clientId').value = "0";
		}
		else {
			var selected = false;
			var i=0;
			var menulist = document.getElementById('oe-clientId');
			var items = menulist.getElementsByTagName("menuitem");
			while (!selected && i<items.length) {
				if (items[i].getAttribute(oe_chargerClient!=""?"value":"label").toUpperCase()==(oe_chargerClient!=""?oe_chargerClient:oe_chargerDenominationClient).toUpperCase()) {
					menulist.selectedIndex = i;
					selected = true;
				}
				i++;
			}
		}

		oe_chargerBanquesClient();

	} catch (e) {
		recup_erreur(e);
	}
}


function oe_pressOnListeEcheancesFact() {
	try {

		if (!gReadOnly && !isEmpty(oe_currentEcheanceId)) {
			var listEcheanceId = new Array();
			listEcheanceId.push(oe_currentEcheanceId);
			var url = "chrome://opensi/content/facturation/user/suivi_reglements_clients/popup-modifierEcheance.xul";
			window.openDialog(url,'','chrome,modal,centerscreen', listEcheanceId, oe_selectOnListePieces);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oe_selectOnListeEcheances() {
	try {

		if (oe_aEcheances.isSelected()) {

			if (oe_aEcheances.nbSelection()==1) {
				var i = oe_aEcheances.getCurrentIndex();
				oe_currentEcheanceId = oe_aEcheances.getCellText(i, 'oe-colEcheanceId');

				var clientId = oe_aEcheances.getCellText(i, 'oe-colClientId');
				var denomination = "";
				if (clientId=="") { denomination = oe_aEcheances.getCellText(i, 'oe-colDenomination'); }

				oe_chargerClients(clientId, denomination);
				oe_chargerModesReglements(oe_aEcheances.getCellText(i, 'oe-colModeRegId'));
				oe_chargerBanques(oe_aEcheances.getCellText(i, 'oe-colBanqueRemise'));

				document.getElementById('oe-dateReglement').value = getDateCourante();
				document.getElementById('oe-echeanceRemise').value = "";
				document.getElementById('oe-numPiece').value = "";
				document.getElementById('oe-tiersPayeur').value = "";
				document.getElementById('oe-montant').value = oe_aEcheances.getCellText(i, 'oe-colMontant');
				document.getElementById('oe-commentaires').value = oe_aEcheances.getCellText(i, 'oe-colCommentaires');
				document.getElementById('oe-bRegulariser').disabled = (oe_aEcheances.getCellText(i, 'oe-colEtat')=="T");
				document.getElementById('oe-bModifierEcheances').disabled = true;

				oe_aReglements.setParam("Echeance_Id", oe_currentEcheanceId);
				oe_aReglements.initTree();
			}
			else {
				document.getElementById('oe-bRegulariser').disabled = true;
				oe_nouveauReglement();
				document.getElementById('oe-bModifierEcheances').disabled = false;
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oe_pressOnListeEcheances() {
	try {

		if (!gReadOnly) {
			oe_modifierEcheance();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oe_modifierEcheance() {
	try {

		if (oe_aEcheances.isSelected()) {

			var listEcheanceId = new Array();

			if (!isEmpty(oe_currentEcheanceId)) {
				listEcheanceId.push(oe_currentEcheanceId);
			}
			else {
				var start = new Object();
				var end = new Object();
				var numRanges = oe_aEcheances.getRangeCount();

				for (var t=0; t<numRanges; t++){
					oe_aEcheances.getRangeAt(t,start,end);
			  	for (var v=start.value; v<=end.value; v++){
		  			listEcheanceId.push(oe_aEcheances.getCellText(v,'oe-colEcheanceId'));
			  	}
				}
			}

			if (listEcheanceId.length>0) {
				var url = "chrome://opensi/content/facturation/user/suivi_reglements_clients/popup-modifierEcheance.xul";
				window.openDialog(url,'','chrome,modal,centerscreen', listEcheanceId, oe_initListeHaut);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oe_selectOnListeReglements() {
	try {

		document.getElementById('oe-bDesaffecter').disabled = !oe_aReglements.isSelected();

	} catch (e) {
		recup_erreur(e);
	}
}


function oe_pressOnDesaffecter() {
	try {

		if (oe_aReglements.isSelected() && window.confirm("Voulez-vous d\u00E9saffecter les imputations s\u00E9lectionn\u00E9es ?")) {

			var qImpAvoir = new QueryHttp("Facturation/Suivi_Reglements_Clients/deleteImputationEcheanceAvoirClient.tmpl");
			var qImpReg = new QueryHttp("Facturation/Suivi_Reglements_Clients/deleteImputationEcheanceReglementClient.tmpl");
			var qRegul = new QueryHttp("Facturation/Suivi_Reglements_Clients/cancelRegularisationEcheanceClient.tmpl");

			for (var i=0; i<oe_aReglements.getRangeCount(); i++) {
				var start = {};
				var end = {};
				oe_aReglements.getRangeAt(i,start,end);

				for (var c=start.value; c<=end.value; c++) {
					var result;

					if (oe_aReglements.getCellText(c, 'oe-colTypeImputation')=="A") {
						qImpAvoir.setParam("Imputation_Id", oe_aReglements.getCellText(c, 'oe-colImputationId'));
						result = qImpAvoir.execute();
					}
					else if (oe_aReglements.getCellText(c, 'oe-colTypeImputation')=="R") {
						qImpReg.setParam("Imputation_Id", oe_aReglements.getCellText(c, 'oe-colImputationId'));
						result = qImpReg.execute();
					}
					else {
						qRegul.setParam("Imputation_Id", oe_aReglements.getCellText(c, 'oe-colImputationId'));
						result = qRegul.execute();
					}

					var errors = new Errors(result);
					if (errors.hasNext()) {
						errors.show();
					}
				}
			}

			oe_initListeHaut();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oe_pressOnRegulariser() {
	try {

		if (oe_currentEcheanceId!="" && window.confirm("Voulez-vous solder cette \u00E9ch\u00E9ance en perte et profit ?")) {

			var qRegulariser = new QueryHttp("Facturation/Suivi_Reglements_Clients/settleEcheanceClient.tmpl");
			qRegulariser.setParam("Echeance_Id", oe_currentEcheanceId);
			var result = qRegulariser.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}

			oe_initListeHaut();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oe_pressOnSolderRestantDu() {
	try {

		var url = "chrome://opensi/content/facturation/user/suivi_reglements_clients/popup-solderEcheances.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', oe_initListeHaut);

	} catch (e) {
		recup_erreur(e);
	}
}


function oe_enregistrerReglement() {
	try {

		var dateReglement = document.getElementById('oe-dateReglement').value;
		var echeanceRemise = document.getElementById('oe-echeanceRemise').value;
		var banqueRemise = document.getElementById('oe-banqueRemise').value;
		var clientId = document.getElementById('oe-clientId').value;
		var tiersPayeur = document.getElementById('oe-tiersPayeur').value;
		var denomination = (isEmpty(clientId)?document.getElementById('oe-clientId').getAttribute("label"):"");
		var banqueClient = document.getElementById('oe-banqueClient').value;
		var modeReglement = document.getElementById('oe-modeReglement').value;
		var numPiece = document.getElementById('oe-numPiece').value;
		var montant = document.getElementById('oe-montant').value;
		var commentaires = document.getElementById('oe-commentaires').value;

		if (isEmpty(dateReglement) || !isDate(dateReglement)) { showWarning("Date incorrecte !"); }
		else if (!isEmpty(echeanceRemise) && !isDate(echeanceRemise)) { showWarning("Date d'\u00E9ch\u00E9ance de remise incorrecte !"); }
		else if (clientId=="0") { showWarning("Veuillez choisir un client !"); }
		else if (banqueClient.length>30) { showWarning("La banque client ne doit pas d\u00E9passer 30 caract\u00E8res !"); }
		else if (modeReglement=="") { showWarning("Veuillez choisir un mode de r\u00E8glement !"); }
		else if (isEmpty(montant) || !isPositive(montant)) { showWarning("Montant incorrect !"); }
		else if (commentaires.length>100) { showWarning("Le commentaire ne doit pas d\u00E9passer 100 caract\u00E8res !"); }
		else {
			document.getElementById('oe-bEnregistrerReglement').disabled = true;

			var qEnregistrer = new QueryHttp("Facturation/Suivi_Reglements_Clients/createReglementClient.tmpl");
			qEnregistrer.setParam("Date_Reglement", dateReglement);
			qEnregistrer.setParam("Echeance_Remise", echeanceRemise);
			qEnregistrer.setParam("Banque_Remise", banqueRemise);
			qEnregistrer.setParam("Client_Id", clientId);
			qEnregistrer.setParam("Tiers_Payeur", tiersPayeur);
			qEnregistrer.setParam("Denomination", denomination);
			qEnregistrer.setParam("Banque_Client", banqueClient);
			qEnregistrer.setParam("Mode_Reglement", modeReglement);
			qEnregistrer.setParam("Num_Piece", numPiece);
			qEnregistrer.setParam("Montant", montant);
			qEnregistrer.setParam("Commentaires", commentaires);

			var result = qEnregistrer.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var reglementId = result.responseXML.documentElement.getAttribute("Reglement_Id");

				var url = "chrome://opensi/content/facturation/user/suivi_reglements_clients/popup-imputationReglement.xul";
				window.openDialog(url,'','chrome,modal,centerscreen', 'R', reglementId, '', true);
			}

			oe_initListeHaut();
			orbt_nouveauRemboursement();
			document.getElementById('oe-bEnregistrerReglement').disabled = false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oe_pressOnEditionCsv() {
	try {

		var etat = document.getElementById('oe-etat').value;
		var denomination = document.getElementById('oe-rechDenomination').value;
		var numPiece = document.getElementById('oe-rechNumPiece').value;
		var dateEcheanceDebut = document.getElementById('oe-dateEcheanceDebut').value;
		var dateEcheanceFin = document.getElementById('oe-dateEcheanceFin').value;
		var dateFactureDebut = document.getElementById('oe-dateFactureDebut').value;
		var dateFactureFin = document.getElementById('oe-dateFactureFin').value;
		var modeReglement = document.getElementById('oe-filtreModeReglement').value;
		var numClient = document.getElementById('oe-numClient').value;
		var etablissement = document.getElementById('oe-etablissement').value;
		var responsable = document.getElementById('oe-responsable').value;
		var codeRegroupement = document.getElementById('oe-codeRegroupement').value;
		var dateArrete = document.getElementById('oe-dateArrete').value;

		if (!isEmpty(dateEcheanceDebut) && !isDate(dateEcheanceDebut)) { showWarning("Date d'\u00E9ch\u00E9ance de d\u00E9but incorrecte !"); }
		else if (!isEmpty(dateEcheanceFin) && !isDate(dateEcheanceFin)) { showWarning("Date d'\u00E9ch\u00E9ance de fin incorrecte !"); }
		else if (!isEmpty(dateEcheanceDebut) && !isEmpty(dateEcheanceFin) && !isDateInterval(dateEcheanceDebut, dateEcheanceFin)) { showWarning("La date d'\u00E9ch\u00E9ance de fin doit \u00EAtre sup\u00E9rieure \u00E0 la date de d\u00E9but !"); }
		else if (!isEmpty(dateFactureDebut) && !isDate(dateFactureDebut)) { showWarning("Date de facture de d\u00E9but incorrecte !"); }
		else if (!isEmpty(dateFactureFin) && !isDate(dateFactureFin)) { showWarning("Date de facture de fin incorrecte !"); }
		else if (!isEmpty(dateFactureDebut) && !isEmpty(dateFactureFin) && !isDateInterval(dateFactureDebut, dateFactureFin)) { showWarning("La date de facture de fin doit \u00EAtre sup\u00E9rieure \u00E0 la date de d\u00E9but !"); }
		else if (!isEmpty(dateArrete) && !isDate(dateArrete)) { showWarning("Date d'arr\u00EAt\u00E9 incorrecte"); }
		else {

			var modeTraitement = document.getElementById('oe-modeTraitement').value;

			var qEditionCsv = new QueryHttp("Facturation/Suivi_Reglements_Clients/"+ (modeTraitement=="F"?"csvPieceClient.tmpl":"csvEcheanceClient.tmpl"));

			qEditionCsv.setParam("Num_Client", numClient);
			qEditionCsv.setParam("Denomination", denomination);
			qEditionCsv.setParam("Etat", etat);
			qEditionCsv.setParam("Date_Echeance_Debut", dateEcheanceDebut);
			qEditionCsv.setParam("Date_Echeance_Fin", dateEcheanceFin);
			qEditionCsv.setParam("Date_Facture_Debut", dateFactureDebut);
			qEditionCsv.setParam("Date_Facture_Fin", dateFactureFin);
			qEditionCsv.setParam("Num_Piece", numPiece);
			qEditionCsv.setParam("Mode_Reglement", modeReglement);
			qEditionCsv.setParam("Etablissement", etablissement);
			qEditionCsv.setParam("Responsable", responsable);
			qEditionCsv.setParam("Code_Regroupement", codeRegroupement);
			qEditionCsv.setParam("Date_Arrete", dateArrete);

			var result = qEditionCsv.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');

				var file = fileChooser("save", fichier);
				if (file!=null) {
					downloadFile(getDirBuffer()+ fichier, file);
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}
