/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var org_aReglements = new Arbre("Facturation/Suivi_Reglements_Clients/list-reglementClient.tmpl", "org-listeReglements");
var org_aImputations = new Arbre("Facturation/Suivi_Reglements_Clients/list-imputationReglementClient.tmpl", "org-listeEcheances");
var org_aFiltreModesReglements = new Arbre('ComboListe/combo-modesReglement.tmpl', 'org-filtreModeReglement');
var org_aBanques = new Arbre('ComboListe/combo-banques.tmpl', 'org-banqueRemise');
var org_aFiltreBanquesRemise = new Arbre('ComboListe/combo-banques.tmpl', 'org-filtreBanqueRemise');
var org_aClients = new Arbre('Facturation/Suivi_Reglements_Clients/combo-clients.tmpl', 'org-clientId');
var org_aBanquesClient = new Arbre('ComboListe/combo-banquesClient.tmpl', 'org-banqueClient');
var org_aModesReglements = new Arbre('ComboListe/combo-modesReglement.tmpl', 'org-modeReglement');
var org_aEtablissements = new Arbre('ComboListe/combo-etablissements.tmpl', 'org-etablissement');

var org_qListRC = new QueryHttp("Facturation/Suivi_Reglements_Clients/getDataListRC.tmpl");

var org_chargerModeReg;
var org_chargerBanqueClient = "";
var org_chargerClient;
var org_chargerDenominationClient;
var org_selBanqueId = "";
var org_currentReglementId;
var org_currentType;
var org_tabLoaded = false;

var org_pageCourante;
var org_nbPages;



function org_init() {
  try {

		if (!org_tabLoaded) {
			org_tabLoaded = true;

  		document.getElementById('org-etat').value = "N";
			document.getElementById('org-statut').value = "V";
  		document.getElementById('org-rechDenomination').value = "";
  		document.getElementById('org-rechNumPiece').value = "";
			document.getElementById('org-nbLignesParPage').selectedIndex = 0;
  		org_aFiltreModesReglements.initTree(org_initFiltreModeReglement);

			if (gReadOnly) {
				document.getElementById('org-bRegulariser').collapsed = true;
				document.getElementById('org-bSolderEcheances').collapsed = true;
				document.getElementById('org-bAffecterRegl').collapsed = true;
				document.getElementById('org-bImportReglements').collapsed = true;
				document.getElementById('org-bDesaffecter').collapsed = true;
				document.getElementById('org-buttons').collapsed = true;
			}
		}
		else {
			org_initListeReglements();
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function org_initFiltreModeReglement() {
	try {

		document.getElementById('org-filtreModeReglement').selectedIndex = 0;
		org_aFiltreBanquesRemise.initTree(org_initFiltreBanqueRemise);

	} catch (e) {
		recup_erreur(e);
	}
}


function org_initFiltreBanqueRemise() {
	try {

    document.getElementById('org-filtreBanqueRemise').selectedIndex = 0;
		org_aEtablissements.setParam('Selection', etablissementDefaut);
		org_aEtablissements.initTree(org_initEtablissement);

	} catch (e) {
    recup_erreur(e);
  }
}


function org_initEtablissement() {
	try {

		document.getElementById('org-etablissement').value = etablissementDefaut;
		org_initListeReglements();

	} catch (e) {
    recup_erreur(e);
  }
}


function org_chargerClients(selection, denomination) {
	try {
		org_chargerClient = selection;
		org_chargerDenominationClient = denomination;
		org_aClients.setParam("Client_Id", selection);
		org_aClients.setParam("Reglement_Id", org_currentReglementId);
		org_aClients.setParam("Type", "RG");
    org_aClients.initTree(org_selectClient);
	} catch (e) {
		recup_erreur(e);
	}
}


function org_chargerBanquesClient() {
	try {
		var clientId = document.getElementById('org-clientId').value;
		if (isEmpty(clientId) || clientId=="0") {
			org_aBanquesClient.deleteTree();
			org_initBanqueClient();
		} else {
			org_aBanquesClient.setParam("Client_Id", clientId);
			org_aBanquesClient.initTree(org_initBanqueClient);
		}
	} catch (e) {
		recup_erreur(e);
	}
}


function org_initBanqueClient() {
	try {
		document.getElementById('org-banqueClient').setAttribute("label", org_chargerBanqueClient);
		document.getElementById('org-banqueClient').value = org_chargerBanqueClient;
	} catch (e) {
		recup_erreur(e);
	}
}


function org_chargerBanques(selection) {
	try {

		org_selBanqueId = selection;
		org_aBanques.setParam("Selection", org_selBanqueId);
		org_aBanques.initTree(org_initBanque);

	} catch (e) {
		recup_erreur(e);
	}
}


function org_initBanque() {
  try {

		document.getElementById('org-banqueRemise').value = org_selBanqueId;

	} catch (e) {
  	recup_erreur(e);
	}
}


function org_chargerModesReglements(selection) {
	try {
		org_chargerModeReg = selection;
		org_aModesReglements.setParam("Selection", org_chargerModeReg);
		org_aModesReglements.initTree(org_initModeReglement);
	} catch (e) {
		recup_erreur(e);
	}
}


function org_initModeReglement() {
	try {

    document.getElementById('org-modeReglement').value=org_chargerModeReg;

	} catch (e) {
    recup_erreur(e);
  }
}


function org_initListeReglements() {
	try {

		var numClient = document.getElementById('org-numClient').value;
		var dateDebut = document.getElementById('org-dateDebut').value;
		var dateFin = document.getElementById('org-dateFin').value;
		var etat = document.getElementById('org-etat').value;
		var statut = document.getElementById('org-statut').value;
		var denomination = document.getElementById('org-rechDenomination').value;
		var numPiece = document.getElementById('org-rechNumPiece').value;
		var modeReglement = document.getElementById('org-filtreModeReglement').value;
		var etablissement = document.getElementById('org-etablissement').value;
		var banqueRemise = document.getElementById('org-filtreBanqueRemise').value;
		var codeRegroupement = document.getElementById('org-codeRegroupement').value;
		var montant = document.getElementById('org-rechMontant').value;
		var nbLignesParPage = document.getElementById('org-nbLignesParPage').value;

		if (!isEmpty(dateDebut) && !isDate(dateDebut)) { showWarning("Date de d\u00E9but incorrecte !"); }
		else if (!isEmpty(dateFin) && !isDate(dateFin)) { showWarning("Date de fin incorrecte !"); }
		else if (!isEmpty(dateDebut) && !isEmpty(dateFin) && !isDateInterval(dateDebut, dateFin)) { showWarning("La date de fin doit \u00EAtre sup\u00E9rieure \u00E0 la date de d\u00E9but !"); }
		else if (!isEmpty(montant) && !isPositive(montant)) { showWarning("Montant incorrect"); }
		else {

			org_pageCourante = 1;
			org_nbPages = 1;
			document.getElementById('org-pageDeb').value = 1;
			document.getElementById('org-pageFin').value = 1;
			document.getElementById('org-bPrec').disabled = true;
			document.getElementById('org-bSuiv').disabled = true;

			document.getElementById('org-bDesaffecter').disabled = true;
			document.getElementById('org-bAffecterRegl').disabled = true;
			document.getElementById('org-bEditerPdf').disabled = true;
			document.getElementById('org-bEditionCsv').disabled = true;
			document.getElementById('org-listeReglements').disabled = true;

			org_aReglements.deleteTree();
			org_aImputations.deleteTree();
			org_nouveauReglement();

			org_qListRC.setParam("Num_Client", numClient);
			org_qListRC.setParam("Denomination", denomination);
			org_qListRC.setParam("Etat", etat);
			org_qListRC.setParam("Statut", statut);
			org_qListRC.setParam("Date_Debut", dateDebut);
			org_qListRC.setParam("Date_Fin", dateFin);
			org_qListRC.setParam("Num_Piece", numPiece);
			org_qListRC.setParam("Mode_Reglement", modeReglement);
			org_qListRC.setParam("Etablissement", etablissement);
			org_qListRC.setParam("Banque_Remise", banqueRemise);
			org_qListRC.setParam("Code_Regroupement", codeRegroupement);
			org_qListRC.setParam("Montant", montant);
			org_qListRC.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
			org_qListRC.setParam("Current_Page", org_pageCourante);

			var result = org_qListRC.execute();

			var contenu = result.responseXML.documentElement;

			document.getElementById('org-totalReglement').value = contenu.getAttribute("Total");
			document.getElementById('org-totalRestant').value = contenu.getAttribute("Restant");

			org_nbPages = contenu.getAttribute("Nb_Pages");
			var listReglementId = contenu.getAttribute("List_Reglement_Id");
			var listAvoirId = contenu.getAttribute("List_Avoir_Id");

			org_aReglements.setParam("List_Reglement_Id", listReglementId);
			org_aReglements.setParam("List_Avoir_Id", listAvoirId);
			org_aReglements.initTree(org_initPagination);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function org_initPagination() {
	try {

		document.getElementById('org-pageDeb').value = org_pageCourante;
		document.getElementById('org-pageFin').value = (org_nbPages>0?org_nbPages:1);
		document.getElementById('org-bPrec').disabled = (org_pageCourante==1);
		document.getElementById('org-bSuiv').disabled = (org_pageCourante>=org_nbPages); // peut se produire si nbPages=0

		org_afterMajPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function org_pressOnPagePrec() {
	try {

		org_pageCourante--;
		org_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function org_pressOnPageSuiv() {
	try {

		org_pageCourante++;
		org_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function org_majPagination() {
	try {

		document.getElementById('org-pageDeb').value = org_pageCourante;
		document.getElementById('org-bPrec').disabled = (org_pageCourante==1);
		document.getElementById('org-bSuiv').disabled = (org_pageCourante==org_nbPages);

		document.getElementById('org-listeReglements').disabled = true;
		document.getElementById('org-bDesaffecter').disabled = true;
		org_aImputations.deleteTree();
		org_nouveauReglement();

		org_qListRC.setParam("Current_Page", org_pageCourante);
		var result = org_qListRC.execute();
		var listReglementId = result.responseXML.documentElement.getAttribute("List_Reglement_Id");
		var listAvoirId = result.responseXML.documentElement.getAttribute("List_Avoir_Id");

		org_aReglements.setParam("List_Reglement_Id", listReglementId);
		org_aReglements.setParam("List_Avoir_Id", listAvoirId);
		org_aReglements.initTree(org_afterMajPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function org_afterMajPagination() {
	try {

		document.getElementById('org-listeReglements').disabled = false;
		document.getElementById('org-bEditerPdf').disabled = (org_aReglements.nbLignes()==0);
		document.getElementById('org-bEditionCsv').disabled = (org_aReglements.nbLignes()==0);
		document.getElementById('org-bAffecterRegl').disabled = false;

	} catch (e) {
		recup_erreur(e);
	}
}


function org_reinitialiser() {
	try {

		document.getElementById('org-numClient').value = "";
		document.getElementById('org-dateDebut').value = "";
		document.getElementById('org-dateFin').value = "";
		document.getElementById('org-etat').value = "N";
		document.getElementById('org-statut').value = "V";
		document.getElementById('org-rechDenomination').value = "";
		document.getElementById('org-rechNumPiece').value = "";
		document.getElementById('org-filtreModeReglement').selectedIndex = 0;
		document.getElementById('org-filtreBanqueRemise').value = "";
		document.getElementById('org-etablissement').value = etablissementDefaut;
		document.getElementById('org-codeRegroupement').value = "";
		document.getElementById('org-rechMontant').value = "";

		org_initListeReglements();

	} catch (e) {
		recup_erreur(e);
	}
}


function org_rechercherClient() {
	try {

		var url = "chrome://opensi/content/facturation/user/clients/popup-rechercheClient.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', org_retourRechercherClient);

	} catch (e) {
		recup_erreur(e);
	}
}


function org_retourRechercherClient(codeClient) {
	try {

  	document.getElementById('org-numClient').value = codeClient;
  	org_initListeReglements();

	} catch (e) {
		recup_erreur(e);
	}
}


function org_ajouterClientListe() {
	try {

		var url = "chrome://opensi/content/facturation/user/clients/popup-rechercheClient.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', org_retourAjouterClientListe);

	} catch (e) {
		recup_erreur(e);
	}
}


function org_retourAjouterClientListe(numClient, clientId) {
	try {
		org_chargerClients(clientId, "");
	} catch (e) {
		recup_erreur(e);
	}
}


function org_onKeyPress(event) {
	try {
		document.getElementById('org-bEditerPdf').disabled = true;
		document.getElementById('org-bEditionCsv').disabled = true;
		if (event.keyCode==13) {
			org_initListeReglements();
		}
	} catch (e) {
		recup_erreur(e);
	}
}


function org_selectOnListeReglements() {
	try {

		if (org_aReglements.isSelected()) {
			var i = org_aReglements.getCurrentIndex();
			org_currentReglementId = org_aReglements.getCellText(i, 'org-colReglementId');
			org_currentType = org_aReglements.getCellText(i, 'org-colType');
			org_aImputations.setParam("Reglement_Id", org_currentReglementId);
			org_aImputations.setParam("Type", org_currentType);
			org_aImputations.initTree();
			document.getElementById('org-bRegulariser').disabled = (org_aReglements.getCellText(i, 'org-colEtat')=="T");

			var typeSuppression = org_aReglements.getCellText(i, 'org-colTypeSuppression');
			// 0 -> aucune interaction possible ; 1 -> suppression possible ; 2 -> annulation possible ; 3 -> rejet de prlvement
			document.getElementById('org-bSupprimer').disabled = (org_currentType=="A" || typeSuppression!="1");
			document.getElementById('org-bSupprimer').collapsed = (org_currentType=="A" || typeSuppression=="2" || typeSuppression=="3");
			document.getElementById('org-bAnnuler').collapsed = (org_currentType=="A" || typeSuppression!="2");
			document.getElementById('org-bRejet').collapsed = (org_currentType=="A" || typeSuppression!="3");

			if (org_currentType=="A") {
				org_chargerBanqueClient = "";
				org_chargerModesReglements("");
				org_chargerBanques("");
				document.getElementById('org-dateReglement').value = "";
				document.getElementById('org-echeanceRemise').value = "";
				org_chargerClients("","");
				document.getElementById('org-montant').value = "";
				document.getElementById('org-commentaires').value = "";
				document.getElementById('org-numPiece').value = "";
				document.getElementById('org-tiersPayeur').value = "";
				document.getElementById('org-dateReglement').disabled = true;
				document.getElementById('org-echeanceRemise').disabled = true;
				document.getElementById('org-banqueRemise').disabled = true;
				document.getElementById('org-clientId').disabled = true;
				document.getElementById('org-bRechClient').disabled = true;
				document.getElementById('org-banqueClient').disabled = true;
				document.getElementById('org-modeReglement').disabled = true;
				document.getElementById('org-numPiece').disabled = true;
				document.getElementById('org-tiersPayeur').disabled = true;
				document.getElementById('org-montant').disabled = true;
				document.getElementById('org-commentaires').disabled = true;
				document.getElementById('org-bEnregistrerReglement').disabled = true;
			}
			else {
				org_chargerBanqueClient = org_aReglements.getCellText(i, 'org-colBanqueClient');

				var clientId = org_aReglements.getCellText(i, 'org-colClientId');
				var denomination = "";
				if (clientId=="") { denomination = org_aReglements.getCellText(i, 'org-colDenomination'); }

				org_chargerClients(clientId, denomination);
				org_chargerModesReglements(org_aReglements.getCellText(i, 'org-colModeRegId'));
				org_chargerBanques(org_aReglements.getCellText(i, 'org-colBanqueRemise'));

				document.getElementById('org-dateReglement').value = org_aReglements.getCellText(i, 'org-colDateReglement');
				document.getElementById('org-echeanceRemise').value = org_aReglements.getCellText(i, 'org-colEcheanceRemise');
				document.getElementById('org-montant').value = org_aReglements.getCellText(i, 'org-colMontant');
				document.getElementById('org-commentaires').value = org_aReglements.getCellText(i, 'org-colCommentaires');
				document.getElementById('org-numPiece').value = org_aReglements.getCellText(i, 'org-colNumPiece');
				document.getElementById('org-tiersPayeur').value = org_aReglements.getCellText(i, 'org-colTiersPayeur');

				var typeModification = org_aReglements.getCellText(i, 'org-colTypeModification');
				// 0 -> aucune interaction possible ; 1 -> modification totale possible ; 2 -> modification possible sauf pour le montant
				document.getElementById('org-dateReglement').disabled = (typeModification=="0");
				document.getElementById('org-echeanceRemise').disabled = (typeModification=="0");
				document.getElementById('org-banqueRemise').disabled = (typeModification=="0");
				document.getElementById('org-clientId').disabled = (typeModification!="1");
				document.getElementById('org-bRechClient').disabled = (typeModification!="1");
				document.getElementById('org-banqueClient').disabled = (typeModification=="0");
				document.getElementById('org-modeReglement').disabled = (typeModification=="0");
				document.getElementById('org-numPiece').disabled = (typeModification=="0");
				document.getElementById('org-tiersPayeur').disabled = (typeModification=="0");
				document.getElementById('org-montant').disabled = (typeModification!="1");
				document.getElementById('org-commentaires').disabled = (typeModification=="0");
				document.getElementById('org-bEnregistrerReglement').disabled = (typeModification=="0");
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function org_pressOnListeReglements() {
	try {

		if (!gReadOnly && !isEmpty(org_currentReglementId) && org_aReglements.getSelectedCellText('org-colStatut')!="A") {
			var url = "chrome://opensi/content/facturation/user/suivi_reglements_clients/popup-imputationReglement.xul";
			window.openDialog(url,'','chrome,modal,centerscreen', org_currentType, org_currentReglementId, org_initListeReglements, false);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function org_selectOnListeImputations() {
	try {

		document.getElementById('org-bDesaffecter').disabled = !org_aImputations.isSelected();

	} catch (e) {
		recup_erreur(e);
	}
}


function org_pressOnDesaffecter() {
	try {

		if (org_aImputations.isSelected() && window.confirm("Voulez-vous d\u00E9saffecter les imputations s\u00E9lectionn\u00E9es ?")) {

			var qImpEchAvoir = new QueryHttp("Facturation/Suivi_Reglements_Clients/deleteImputationEcheanceAvoirClient.tmpl");
			var qImpEchReg = new QueryHttp("Facturation/Suivi_Reglements_Clients/deleteImputationEcheanceReglementClient.tmpl");

			var qImpRbtAvoir = new QueryHttp("Facturation/Suivi_Reglements_Clients/deleteImputationAvoirRemboursementClient.tmpl");
			var qImpRbtReg = new QueryHttp("Facturation/Suivi_Reglements_Clients/deleteImputationReglementRemboursementClient.tmpl");

			var qRegulAvoir = new QueryHttp("Facturation/Suivi_Reglements_Clients/cancelRegularisationAvoirClient.tmpl");
			var qRegulReg = new QueryHttp("Facturation/Suivi_Reglements_Clients/cancelRegularisationReglementClient.tmpl");

			for (var i=0; i<org_aImputations.getRangeCount(); i++) {
				var start = {};
				var end = {};
				org_aImputations.getRangeAt(i,start,end);

				for (var c=start.value; c<=end.value; c++) {
					var result;

					if (org_currentType=="A" && org_aImputations.getCellText(c, 'org-colTypeImputation')=="R") {
						qRegulAvoir.setParam("Imputation_Id", org_aImputations.getCellText(c, 'org-colImputationId'));
						result = qRegulAvoir.execute();
					}
					else if (org_currentType=="A" && org_aImputations.getCellText(c, 'org-colTypeImputation')=="RB") {
						qImpRbtAvoir.setParam("Imputation_Id", org_aImputations.getCellText(c, 'org-colImputationId'));
						result = qImpRbtAvoir.execute();
					}
					else if (org_currentType=="A") {
						qImpEchAvoir.setParam("Imputation_Id", org_aImputations.getCellText(c, 'org-colImputationId'));
						result = qImpEchAvoir.execute();
					}
					else if (org_currentType=="R" && org_aImputations.getCellText(c, 'org-colTypeImputation')=="R") {
						qRegulReg.setParam("Imputation_Id", org_aImputations.getCellText(c, 'org-colImputationId'));
						result = qRegulReg.execute();
					}
					else if (org_currentType=="R" && org_aImputations.getCellText(c, 'org-colTypeImputation')=="RB") {
						qImpRbtReg.setParam("Imputation_Id", org_aImputations.getCellText(c, 'org-colImputationId'));
						result = qImpRbtReg.execute();
					}
					else if (org_currentType=="R") {
						qImpEchReg.setParam("Imputation_Id", org_aImputations.getCellText(c, 'org-colImputationId'));
						result = qImpEchReg.execute();
					}

					var errors = new Errors(result);
					if (errors.hasNext()) {
						errors.show();
					}
				}
			}

			org_initListeReglements();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function org_selectClient() {
	try {

		if (isEmpty(org_chargerClient) && isEmpty(org_chargerDenominationClient)) {
			document.getElementById('org-clientId').value = "0";
		}
		else {
			var selected = false;
			var i=0;
			var menulist = document.getElementById('org-clientId');
			var items = menulist.getElementsByTagName("menuitem");
			while (!selected && i<items.length) {
				if (items[i].getAttribute(org_chargerClient!=""?"value":"label").toUpperCase()==(org_chargerClient!=""?org_chargerClient:org_chargerDenominationClient).toUpperCase()) {
					menulist.selectedIndex = i;
					selected = true;
				}
				i++;
			}
		}

		org_chargerBanquesClient();

	} catch (e) {
		recup_erreur(e);
	}
}


function org_affecterReglements() {
	try {

		document.getElementById('org-bAffecterRegl').disabled = true;
		var url = "chrome://opensi/content/facturation/user/suivi_reglements_clients/popup-imputationReglement.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', 'B', '', '', false);
		org_initListeReglements();

	} catch (e) {
		recup_erreur(e);
	}
}


function org_importerReglements() {
	try {

		var url = "chrome://opensi/content/facturation/user/suivi_reglements_clients/popup-importReglements.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', org_initListeReglements);

	} catch (e) {
		recup_erreur(e);
	}
}


function org_pressOnRegulariser() {
	try {

		var message = "Voulez-vous solder "+ (org_currentType=="R"?"ce r\u00E8glement":"cet avoir") + " en perte et profit ?";
		if (window.confirm(message)) {

			var qRegulariser;

			if (org_currentType=="R") {
				qRegulariser = new QueryHttp("Facturation/Suivi_Reglements_Clients/settleReglementClient.tmpl");
				qRegulariser.setParam("Reglement_Id", org_currentReglementId);
			}
			else {
				qRegulariser = new QueryHttp("Facturation/Suivi_Reglements_Clients/settleAvoirClient.tmpl");
				qRegulariser.setParam("Avoir_Id", org_currentReglementId);
			}

			var result = qRegulariser.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}

			org_initListeReglements();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function org_pressOnSolderRestantDu() {
	try {

		var url = "chrome://opensi/content/facturation/user/suivi_reglements_clients/popup-solderReglements.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', org_initListeReglements);

	} catch (e) {
		recup_erreur(e);
	}
}


function org_nouveauReglement() {
	try {
		if (org_aReglements.isSelected()) {
			org_aReglements.clearSelection();
			org_aImputations.deleteTree();
		}
		document.getElementById('org-bRegulariser').disabled = true;
		document.getElementById('org-bSupprimer').disabled = true;
		document.getElementById('org-bSupprimer').collapsed = false;
		document.getElementById('org-bAnnuler').collapsed = true;
		org_currentReglementId = "";
		org_currentType = "";

		org_chargerBanqueClient = "";
		document.getElementById('org-dateReglement').value = "";
		document.getElementById('org-echeanceRemise').value = "";
		org_aBanquesClient.deleteTree();
		org_chargerClients("","");
		org_chargerModesReglements("");
		org_chargerBanques("");
		document.getElementById('org-numPiece').value = "";
		document.getElementById('org-tiersPayeur').value = "";
		document.getElementById('org-montant').value = "";
		document.getElementById('org-commentaires').value = "";
		document.getElementById('org-dateReglement').disabled = false;
		document.getElementById('org-echeanceRemise').disabled = false;
		document.getElementById('org-banqueRemise').disabled = false;
		document.getElementById('org-clientId').disabled = false;
		document.getElementById('org-banqueClient').disabled = false;
		document.getElementById('org-modeReglement').disabled = false;
		document.getElementById('org-numPiece').disabled = false;
		document.getElementById('org-tiersPayeur').disabled = false;
		document.getElementById('org-montant').disabled = false;
		document.getElementById('org-commentaires').disabled = false;
		document.getElementById('org-bEnregistrerReglement').disabled = false;
		document.getElementById('org-bRechClient').disabled = false;
	} catch (e) {
		recup_erreur(e);
	}
}


function org_enregistrerReglement() {
	try {

		var dateReglement = document.getElementById('org-dateReglement').value;
		var echeanceRemise = document.getElementById('org-echeanceRemise').value;
		var banqueRemise = document.getElementById('org-banqueRemise').value;
		var clientId = document.getElementById('org-clientId').value;
		var tiersPayeur = document.getElementById('org-tiersPayeur').value;
		var denomination = (isEmpty(clientId)?document.getElementById('org-clientId').getAttribute("label"):"");
		var banqueClient = document.getElementById('org-banqueClient').value;
		var modeReglement = document.getElementById('org-modeReglement').value;
		var numPiece = document.getElementById('org-numPiece').value;
		var montant = document.getElementById('org-montant').value;
		var commentaires = document.getElementById('org-commentaires').value;

		if (isEmpty(dateReglement) || !isDate(dateReglement)) { showWarning("Date incorrecte !"); }
		else if (!isEmpty(echeanceRemise) && !isDate(echeanceRemise)) { showWarning("Date d'\u00E9ch\u00E9ance de remise incorrecte !"); }
		else if (clientId=="0") { showWarning("Veuillez choisir un client !"); }
		else if (banqueClient.length>30) { showWarning("La banque client ne doit pas d\u00E9passer 30 caract\u00E8res !"); }
		else if (modeReglement=="") { showWarning("Veuillez choisir un mode de r\u00E8glement !"); }
		else if (isEmpty(montant) || !isPositive(montant)) { showWarning("Montant incorrect !"); }
		else if (commentaires.length>100) { showWarning("Le commentaire ne doit pas d\u00E9passer 100 caract\u00E8res !"); }
		else {

			var qEnregistrer;
			if (org_currentReglementId!="" && org_currentType=="R") {
				qEnregistrer = new QueryHttp("Facturation/Suivi_Reglements_Clients/updateReglementClient.tmpl");
				qEnregistrer.setParam("Reglement_Id", org_currentReglementId);
			} else {
				qEnregistrer = new QueryHttp("Facturation/Suivi_Reglements_Clients/createReglementClient.tmpl");
			}
			qEnregistrer.setParam("Date_Reglement", dateReglement);
			qEnregistrer.setParam("Echeance_Remise", echeanceRemise);
			qEnregistrer.setParam("Banque_Remise", banqueRemise);
			qEnregistrer.setParam("Client_Id", clientId);
			qEnregistrer.setParam("Denomination", denomination);
			qEnregistrer.setParam("Banque_Client", banqueClient);
			qEnregistrer.setParam("Mode_Reglement", modeReglement);
			qEnregistrer.setParam("Num_Piece", numPiece);
			qEnregistrer.setParam("Tiers_Payeur", tiersPayeur);
			if (!document.getElementById('org-montant').disabled) { qEnregistrer.setParam("Montant", montant); }
			qEnregistrer.setParam("Commentaires", commentaires);

			var result = qEnregistrer.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else if (org_currentReglementId=="" || org_currentType!="R") {
				var reglementId = result.responseXML.documentElement.getAttribute("Reglement_Id");

				var url = "chrome://opensi/content/facturation/user/suivi_reglements_clients/popup-imputationReglement.xul";
				window.openDialog(url,'','chrome,modal,centerscreen', 'R', reglementId, '', true);
			}

			org_initListeReglements();
			orbt_nouveauRemboursement();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function org_pressOnSupprimer() {
	try {

		if (org_currentReglementId != "" && window.confirm("Voulez-vous supprimer le r\u00E8glement s\u00E9lectionn\u00E9 ?")) {
			var qDelete = new QueryHttp("Facturation/Suivi_Reglements_Clients/deleteReglementClient.tmpl");
			qDelete.setParam("Reglement_Id", org_currentReglementId);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showWarning("Le r\u00E8glement a \u00E9t\u00E9 supprim\u00E9");
				org_initListeReglements();
				orbt_nouveauRemboursement();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function org_pressOnAnnuler() {
	try {

		if (org_currentReglementId != "" && window.confirm("Voulez-vous annuler le r\u00E8glement s\u00E9lectionn\u00E9 ?")) {

			var url = "chrome://opensi/content/facturation/user/suivi_reglements_clients/popup-choixMotifAnnulation.xul";
			window.openDialog(url,'','chrome,modal,centerscreen', org_retourAnnulerReglement, org_currentReglementId);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function org_retourAnnulerReglement() {
	try {

		showWarning("Le r\u00E8glement a \u00E9t\u00E9 annul\u00E9");
		org_initListeReglements();
		orbt_nouveauRemboursement();

	} catch (e) {
		recup_erreur(e);
	}
}


function org_editerPdf() {
	try {
		document.getElementById('chkDetailReg').checked = false;
		document.getElementById('triReglements').value = "Date";
		document.getElementById('chkSousTotauxReg').checked = true;
		org_rafraichirPdf();
	} catch (e) {
		recup_erreur(e);
	}
}


function org_rafraichirPdf() {
	try {

		var numClient = document.getElementById('org-numClient').value;
		var dateDebut = document.getElementById('org-dateDebut').value;
		var dateFin = document.getElementById('org-dateFin').value;
		var etat = document.getElementById('org-etat').value;
		var denomination = document.getElementById('org-rechDenomination').value;
		var numPiece = document.getElementById('org-rechNumPiece').value;
		var modeReglement = document.getElementById('org-filtreModeReglement').value;
		var banqueRemise = document.getElementById('org-filtreBanqueRemise').value;
		var etablissement = document.getElementById('org-etablissement').value;
		var codeRegroupement = document.getElementById('org-codeRegroupement').value;
		var montant = document.getElementById('org-rechMontant').value;

		if (!isEmpty(dateDebut) && !isDate(dateDebut)) { showWarning("Date de d\u00E9but incorrecte !"); }
		else if (!isEmpty(dateFin) && !isDate(dateFin)) { showWarning("Date de fin incorrecte !"); }
		else if (!isEmpty(dateDebut) && !isEmpty(dateFin) && !isDateInterval(dateDebut, dateFin)) { showWarning("La date de fin doit \u00EAtre sup\u00E9rieure \u00E0 la date de d\u00E9but !"); }
		else if (!isEmpty(montant) && !isPositive(montant)) { showWarning("Montant incorrect"); }
		else {
			var detail = document.getElementById('chkDetailReg').checked;
			var triReglements = document.getElementById('triReglements').value;
			var sousTotaux = document.getElementById('chkSousTotauxReg').checked;

			var qGenPdf = new QueryHttp("Facturation/Suivi_Reglements_Clients/pdfListeReglements.tmpl");
			qGenPdf.setParam("Etat", etat);
			qGenPdf.setParam("Denomination", denomination);
			qGenPdf.setParam("Num_Piece", numPiece);
      qGenPdf.setParam("Date_Debut", dateDebut);
      qGenPdf.setParam("Date_Fin", dateFin);
      qGenPdf.setParam("Mode_Reglement", modeReglement);
      qGenPdf.setParam("Num_Client", numClient);
			qGenPdf.setParam("Etablissement", etablissement);
			qGenPdf.setParam("Banque_Remise", banqueRemise);
			qGenPdf.setParam("Code_Regroupement", codeRegroupement);
			qGenPdf.setParam("Montant", montant);
      qGenPdf.setParam("Detail", detail);
      qGenPdf.setParam("Tri", triReglements);
      qGenPdf.setParam("Sous_Totaux", sousTotaux);
      var result = qGenPdf.execute();
      var page = getDirPdf() + result.responseXML.documentElement.getAttribute('fichier');
			switchPdf(page);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function org_pressOnEditionCsv() {
	try {

		var numClient = document.getElementById('org-numClient').value;
		var dateDebut = document.getElementById('org-dateDebut').value;
		var dateFin = document.getElementById('org-dateFin').value;
		var etat = document.getElementById('org-etat').value;
		var statut = document.getElementById('org-statut').value;
		var denomination = document.getElementById('org-rechDenomination').value;
		var numPiece = document.getElementById('org-rechNumPiece').value;
		var modeReglement = document.getElementById('org-filtreModeReglement').value;
		var banqueRemise = document.getElementById('org-filtreBanqueRemise').value;
		var etablissement = document.getElementById('org-etablissement').value;
		var codeRegroupement = document.getElementById('org-codeRegroupement').value;
		var montant = document.getElementById('org-rechMontant').value;

		if (!isEmpty(dateDebut) && !isDate(dateDebut)) { showWarning("Date de d\u00E9but incorrecte !"); }
		else if (!isEmpty(dateFin) && !isDate(dateFin)) { showWarning("Date de fin incorrecte !"); }
		else if (!isEmpty(dateDebut) && !isEmpty(dateFin) && !isDateInterval(dateDebut, dateFin)) { showWarning("La date de fin doit \u00EAtre sup\u00E9rieure \u00E0 la date de d\u00E9but !"); }
		else if (!isEmpty(montant) && !isPositive(montant)) { showWarning("Montant incorrect"); }
		else {

			var qEditionCsv = new QueryHttp("Facturation/Suivi_Reglements_Clients/csvReglementClient.tmpl");

			qEditionCsv.setParam("Num_Client", numClient);
			qEditionCsv.setParam("Denomination", denomination);
			qEditionCsv.setParam("Etat", etat);
			qEditionCsv.setParam("Statut", statut);
			qEditionCsv.setParam("Date_Debut", dateDebut);
			qEditionCsv.setParam("Date_Fin", dateFin);
			qEditionCsv.setParam("Num_Piece", numPiece);
			qEditionCsv.setParam("Mode_Reglement", modeReglement);
			qEditionCsv.setParam("Banque_Remise", banqueRemise);
			qEditionCsv.setParam("Etablissement", etablissement);
			qEditionCsv.setParam("Code_Regroupement", codeRegroupement);
			qEditionCsv.setParam("Montant", montant);

			var result = qEditionCsv.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');

				var file = fileChooser("save", fichier);
				if (file!=null) {
					downloadFile(getDirBuffer()+ fichier, file);
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}
