/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var orbt_aRemboursements = new Arbre("Facturation/Suivi_Reglements_Clients/list-remboursementClient.tmpl", "orbt-listeRemboursements");
var orbt_aImputations = new Arbre("Facturation/Suivi_Reglements_Clients/list-imputationRemboursementClient.tmpl", "orbt-listeReglements");
var orbt_aBanques = new Arbre('ComboListe/combo-banques.tmpl', 'orbt-banqueRetrait');
var orbt_aMotifs = new Arbre('ComboListe/combo-motifsRemboursement.tmpl', 'orbt-motif');
var orbt_aClients = new Arbre('Facturation/Suivi_Reglements_Clients/combo-clients.tmpl', 'orbt-clientId');
var orbt_aModesReglements = new Arbre('ComboListe/combo-modesReglement.tmpl', 'orbt-modeReglement');
var orbt_aEtablissements = new Arbre('ComboListe/combo-etablissements.tmpl', 'orbt-etablissement');

var orbt_qListRB = new QueryHttp("Facturation/Suivi_Reglements_Clients/getDataListRB.tmpl");

var orbt_chargerModeReg;
var orbt_chargerClient;
var orbt_chargerDenominationClient;
var orbt_selBanqueId = "";
var orbt_currentRemboursementId;
var orbt_currentMotifId;
var orbt_tabLoaded = false;

var orbt_pageCourante;
var orbt_nbPages = 1;



function orbt_init() {
  try {

		if (!orbt_tabLoaded) {
			orbt_tabLoaded = true;

  		document.getElementById('orbt-etat').value = "N";
			orbt_aEtablissements.setParam('Selection', etablissementDefaut);
			orbt_aEtablissements.initTree(orbt_initEtablissement);

			if (gReadOnly) {
				document.getElementById('orbt-bAffecterRemb').collapsed = true;
				document.getElementById('orbt-bImportRemboursements').collapsed = true;
				document.getElementById('orbt-bDesaffecter').collapsed = true;
				document.getElementById('orbt-buttons').collapsed = true;
			}
		}
		else {
			orbt_initListeRemboursements();
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function orbt_initEtablissement() {
	try {

		document.getElementById('orbt-etablissement').value = etablissementDefaut;
		orbt_initListeRemboursements();

	} catch (e) {
    recup_erreur(e);
  }
}


function orbt_initMotifInitial() {
	try {
    document.getElementById('orbt-motif').selectedIndex = 0;
	} catch (e) {
    recup_erreur(e);
  }
}

function orbt_initMotif() {
	try {
    document.getElementById('orbt-motif').value = orbt_currentMotifId;
	} catch (e) {
    recup_erreur(e);
  }
}


function orbt_chargerClients(selection, denomination) {
	try {
		orbt_chargerClient = selection;
		orbt_chargerDenominationClient = denomination;
		orbt_aClients.setParam("Client_Id", selection);
		orbt_aClients.setParam("Remboursement_Id", orbt_currentRemboursementId);
		orbt_aClients.setParam("Type", "RB");
    orbt_aClients.initTree(orbt_selectClient);
	} catch (e) {
		recup_erreur(e);
	}
}


function orbt_chargerBanques(selection) {
	try {

		orbt_selBanqueId = selection;
		orbt_aBanques.setParam("Selection", orbt_selBanqueId);
		orbt_aBanques.initTree(orbt_initBanque);

	} catch (e) {
		recup_erreur(e);
	}
}


function orbt_initBanque() {
  try {

		document.getElementById('orbt-banqueRetrait').value = orbt_selBanqueId;

	} catch (e) {
  	recup_erreur(e);
	}
}


function orbt_chargerModesReglements(selection) {
	try {
		orbt_chargerModeReg = selection;
		orbt_aModesReglements.setParam("Selection", orbt_chargerModeReg);
		orbt_aModesReglements.initTree(orbt_initModeReglement);
	} catch (e) {
		recup_erreur(e);
	}
}


function orbt_initModeReglement() {
	try {

    document.getElementById('orbt-modeReglement').value=orbt_chargerModeReg;

	} catch (e) {
    recup_erreur(e);
  }
}


function orbt_initListeRemboursements() {
	try {

		var numClient = document.getElementById('orbt-numClient').value;
		var dateDebut = document.getElementById('orbt-dateDebut').value;
		var dateFin = document.getElementById('orbt-dateFin').value;
		var etat = document.getElementById('orbt-etat').value;
		var statut = document.getElementById('orbt-statut').value;
		var etablissement = document.getElementById('orbt-etablissement').value;
		var montant = document.getElementById('orbt-rechMontant').value;
		var nbLignesParPage = document.getElementById('orbt-nbLignesParPage').value;

		if (!isEmpty(dateDebut) && !isDate(dateDebut)) { showWarning("Date de d\u00E9but incorrecte !"); }
		else if (!isEmpty(dateFin) && !isDate(dateFin)) { showWarning("Date de fin incorrecte !"); }
		else if (!isEmpty(dateDebut) && !isEmpty(dateFin) && !isDateInterval(dateDebut, dateFin)) { showWarning("La date de fin doit \u00EAtre sup\u00E9rieure \u00E0 la date de d\u00E9but !"); }
		else if (!isEmpty(montant) && !isPositive(montant)) { showWarning("Montant incorrect"); }
		else {

			orbt_pageCourante = 1;
			orbt_nbPages = 1;
			document.getElementById('orbt-pageDeb').value = 1;
			document.getElementById('orbt-pageFin').value = 1;
			document.getElementById('orbt-bPrec').disabled = true;
			document.getElementById('orbt-bSuiv').disabled = true;

			document.getElementById('orbt-bEditionCsv').disabled = true;
			document.getElementById('orbt-bDesaffecter').disabled = true;
			document.getElementById('orbt-bAffecterRemb').disabled = true;
			document.getElementById('orbt-listeRemboursements').disabled = true;

			orbt_aRemboursements.deleteTree();
			orbt_aImputations.deleteTree();
			orbt_nouveauRemboursement();

			orbt_qListRB.setParam("Num_Client", numClient);
			orbt_qListRB.setParam("Etat", etat);
			orbt_qListRB.setParam("Statut", statut);
			orbt_qListRB.setParam("Date_Debut", dateDebut);
			orbt_qListRB.setParam("Date_Fin", dateFin);
			orbt_qListRB.setParam("Etablissement", etablissement);
			orbt_qListRB.setParam("Montant", montant);
			orbt_qListRB.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
			orbt_qListRB.setParam("Current_Page", orbt_pageCourante);

			var result = orbt_qListRB.execute();

			var contenu = result.responseXML.documentElement;

			document.getElementById('orbt-totalRemboursement').value = contenu.getAttribute("Total");
			document.getElementById('orbt-totalRestant').value = contenu.getAttribute("Restant");

			orbt_nbPages = contenu.getAttribute("Nb_Pages");
			var listRemboursementId = contenu.getAttribute("List_Remboursement_Id");

			orbt_aRemboursements.setParam("List_Remboursement_Id", listRemboursementId);
			orbt_aRemboursements.initTree(orbt_initPagination);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function orbt_initPagination() {
	try {

		document.getElementById('orbt-pageDeb').value = orbt_pageCourante;
		document.getElementById('orbt-pageFin').value = (orbt_nbPages>0?orbt_nbPages:1);
		document.getElementById('orbt-bPrec').disabled = (orbt_pageCourante==1);
		document.getElementById('orbt-bSuiv').disabled = (orbt_pageCourante>=orbt_nbPages); // peut se produire si nbPages=0

		orbt_afterMajPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function orbt_pressOnPagePrec() {
	try {

		orbt_pageCourante--;
		orbt_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function orbt_pressOnPageSuiv() {
	try {

		orbt_pageCourante++;
		orbt_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function orbt_majPagination() {
	try {

		document.getElementById('orbt-pageDeb').value = orbt_pageCourante;
		document.getElementById('orbt-bPrec').disabled = (orbt_pageCourante==1);
		document.getElementById('orbt-bSuiv').disabled = (orbt_pageCourante==orbt_nbPages);

		document.getElementById('orbt-listeRemboursements').disabled = true;
		document.getElementById('orbt-bDesaffecter').disabled = true;
		orbt_aImputations.deleteTree();
		orbt_nouveauRemboursement();

		orbt_qListRB.setParam("Current_Page", orbt_pageCourante);
		var result = orbt_qListRB.execute();
		var listRemboursementId = result.responseXML.documentElement.getAttribute("List_Remboursement_Id");

		orbt_aRemboursements.setParam("List_Remboursement_Id", listRemboursementId);
		orbt_aRemboursements.initTree(orbt_afterMajPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function orbt_afterMajPagination() {
	try {

		document.getElementById('orbt-bEditionCsv').disabled = (orbt_aRemboursements.nbLignes()==0);
		document.getElementById('orbt-listeRemboursements').disabled = false;
		document.getElementById('orbt-bAffecterRemb').disabled = false;

	} catch (e) {
		recup_erreur(e);
	}
}


function orbt_reinitialiser() {
	try {

		document.getElementById('orbt-numClient').value = "";
		document.getElementById('orbt-dateDebut').value = "";
		document.getElementById('orbt-dateFin').value = "";
		document.getElementById('orbt-etat').value = "N";
		document.getElementById('orbt-statut').value = "";
		document.getElementById('orbt-rechMontant').value = "";
		document.getElementById('orbt-etablissement').value = etablissementDefaut;

		orbt_initListeRemboursements();

	} catch (e) {
		recup_erreur(e);
	}
}


function orbt_rechercherClient() {
	try {

		var url = "chrome://opensi/content/facturation/user/clients/popup-rechercheClient.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', orbt_retourRechercherClient);

	} catch (e) {
		recup_erreur(e);
	}
}


function orbt_retourRechercherClient(codeClient) {
	try {
  	document.getElementById('orbt-numClient').value = codeClient;
  	orbt_initListeRemboursements();
	} catch (e) {
		recup_erreur(e);
	}
}


function orbt_ajouterClientListe() {
	try {

		var url = "chrome://opensi/content/facturation/user/clients/popup-rechercheClient.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', orbt_retourAjouterClientListe);

	} catch (e) {
		recup_erreur(e);
	}
}


function orbt_retourAjouterClientListe(numClient, clientId) {
	try {
		orbt_chargerClients(clientId, "");
	} catch (e) {
		recup_erreur(e);
	}
}


function orbt_onKeyPress(event) {
	try {
		document.getElementById('orbt-bEditionCsv').disabled = true;
		if (event.keyCode==13) {
			orbt_initListeRemboursements();
		}
	} catch (e) {
		recup_erreur(e);
	}
}


function orbt_selectOnListeRemboursements() {
	try {

		if (orbt_aRemboursements.isSelected()) {
			var i = orbt_aRemboursements.getCurrentIndex();
			orbt_currentRemboursementId = orbt_aRemboursements.getCellText(i, 'orbt-colRemboursementId');
			orbt_currentMotifId = orbt_aRemboursements.getCellText(i, 'orbt-colMotif');
			orbt_aImputations.setParam("Remboursement_Id", orbt_currentRemboursementId);
			orbt_aImputations.initTree();

			document.getElementById('orbt-bEditerPdf').disabled = (orbt_aRemboursements.getCellText(i, 'orbt-colLettreEditable')=="false");

			var typeSuppression = orbt_aRemboursements.getCellText(i, 'orbt-colTypeSuppression');
			// 0 -> aucune interaction possible ; 1 -> suppression possible ; 2 -> annulation possible
			document.getElementById('orbt-bSupprimer').disabled = (typeSuppression!="1");
			document.getElementById('orbt-bSupprimer').collapsed = (typeSuppression=="2");
			document.getElementById('orbt-bAnnuler').collapsed = (typeSuppression!="2");
			document.getElementById('orbt-bValider').collapsed = orbt_aRemboursements.getCellText(i, 'orbt-colStatut')!="E";

			var clientId = orbt_aRemboursements.getCellText(i, 'orbt-colClientId');
			var denomination = "";
			if (clientId=="") { denomination = orbt_aRemboursements.getCellText(i, 'orbt-colDenomination'); }

			orbt_chargerClients(clientId, denomination);
			orbt_chargerModesReglements(orbt_aRemboursements.getCellText(i, 'orbt-colModeRegId'));
			orbt_chargerBanques(orbt_aRemboursements.getCellText(i, 'orbt-colBanqueId'));
			document.getElementById('orbt-dateRemboursement').value = orbt_aRemboursements.getCellText(i, 'orbt-colDateRemboursement');
			document.getElementById('orbt-montant').value = orbt_aRemboursements.getCellText(i, 'orbt-colMontant');
			document.getElementById('orbt-commentaires').value = orbt_aRemboursements.getCellText(i, 'orbt-colCommentaires');
			document.getElementById('orbt-numPiece').value = orbt_aRemboursements.getCellText(i, 'orbt-colNumPiece');

			var typeModification = orbt_aRemboursements.getCellText(i, 'orbt-colTypeModification');
			// 0 -> aucune interaction possible ; 1 -> modification totale possible ; 2 -> modification possible sauf pour le montant
			document.getElementById('orbt-dateRemboursement').disabled = (typeModification=="0");
			document.getElementById('orbt-banqueRetrait').disabled = (typeModification=="0");
			document.getElementById('orbt-motif').disabled = (typeModification=="0");
			document.getElementById('orbt-clientId').disabled = (typeModification!="1");
			document.getElementById('orbt-bRechClient').disabled = (typeModification!="1");
			document.getElementById('orbt-modeReglement').disabled = (typeModification=="0");
			document.getElementById('orbt-numPiece').disabled = (typeModification=="0");
			document.getElementById('orbt-montant').disabled = (typeModification!="1");
			document.getElementById('orbt-commentaires').disabled = (typeModification=="0");
			document.getElementById('orbt-bEnregistrerRemboursement').disabled = (typeModification=="0");
			document.getElementById('orbt-attente').collapsed = true;
			orbt_aMotifs.setParam("Type_Tiers", "C");
			orbt_aMotifs.setParam("Selection", orbt_currentMotifId);
	    orbt_aMotifs.initTree(orbt_initMotif);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function orbt_pressOnListeRemboursements() {
	try {

		if (!gReadOnly && !isEmpty(orbt_currentRemboursementId)) {
			var url = "chrome://opensi/content/facturation/user/suivi_reglements_clients/popup-imputationRemboursement.xul";
			window.openDialog(url,'','chrome,modal,centerscreen', 'R', orbt_currentRemboursementId, orbt_initListeRemboursements, false);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function orbt_selectOnListeImputations() {
	try {
		document.getElementById('orbt-bDesaffecter').disabled = !orbt_aImputations.isSelected();
	} catch (e) {
		recup_erreur(e);
	}
}


function orbt_pressOnDesaffecter() {
	try {

		if (orbt_aImputations.isSelected() && window.confirm("Voulez-vous d\u00E9saffecter les imputations s\u00E9lectionn\u00E9es ?")) {

			var qImpAvoir = new QueryHttp("Facturation/Suivi_Reglements_Clients/deleteImputationAvoirRemboursementClient.tmpl");
			var qImpReg = new QueryHttp("Facturation/Suivi_Reglements_Clients/deleteImputationReglementRemboursementClient.tmpl");

			for (var i=0; i<orbt_aImputations.getRangeCount(); i++) {
				var start = {};
				var end = {};
				orbt_aImputations.getRangeAt(i,start,end);

				for (var c=start.value; c<=end.value; c++) {
					var result;

					if (orbt_aImputations.getCellText(c, 'orbt-colType')=="A") {
						qImpAvoir.setParam("Imputation_Id", orbt_aImputations.getCellText(c, 'orbt-colImputationId'));
						result = qImpAvoir.execute();
					}
					else {
						qImpReg.setParam("Imputation_Id", orbt_aImputations.getCellText(c, 'orbt-colImputationId'));
						result = qImpReg.execute();
					}

					var errors = new Errors(result);
					if (errors.hasNext()) {
						errors.show();
					}
				}
			}

			orbt_initListeRemboursements();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function orbt_selectClient() {
	try {

		if (isEmpty(orbt_chargerClient) && isEmpty(orbt_chargerDenominationClient)) {
			document.getElementById('orbt-clientId').value = "0";
		}
		else {
			var selected = false;
			var i=0;
			var menulist = document.getElementById('orbt-clientId');
			var items = menulist.getElementsByTagName("menuitem");
			while (!selected && i<items.length) {
				if (items[i].getAttribute(orbt_chargerClient!=""?"value":"label").toUpperCase()==(orbt_chargerClient!=""?orbt_chargerClient:orbt_chargerDenominationClient).toUpperCase()) {
					menulist.selectedIndex = i;
					selected = true;
				}
				i++;
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function orbt_affecterRemboursements() {
	try {

		document.getElementById('orbt-bAffecterRemb').disabled = true;
		var url = "chrome://opensi/content/facturation/user/suivi_reglements_clients/popup-imputationRemboursement.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', 'B', '', '', false);
		orbt_initListeRemboursements();

	} catch (e) {
		recup_erreur(e);
	}
}


function orbt_importerRemboursements() {
	try {

		var url = "chrome://opensi/content/facturation/user/suivi_reglements_clients/popup-importRemboursements.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', orbt_initListeRemboursements);

	} catch (e) {
		recup_erreur(e);
	}
}


function orbt_nouveauRemboursement() {
	try {
		if (orbt_aRemboursements.isSelected()) {
			orbt_aRemboursements.clearSelection();
			orbt_aImputations.deleteTree();
		}
		orbt_currentRemboursementId = "";
		document.getElementById('orbt-bSupprimer').disabled = true;
		document.getElementById('orbt-bSupprimer').collapsed = false;
		document.getElementById('orbt-bAnnuler').collapsed = true;
		document.getElementById('orbt-bEditerPdf').disabled = true;
		document.getElementById('orbt-bValider').collapsed = true;

		document.getElementById('orbt-dateRemboursement').value = "";
		document.getElementById('orbt-motif').selectedIndex = 0;
		orbt_chargerClients("","");
		orbt_chargerModesReglements("");
		orbt_chargerBanques("");
		document.getElementById('orbt-numPiece').value = "";
		document.getElementById('orbt-montant').value = "";
		document.getElementById('orbt-commentaires').value = "";
		document.getElementById('orbt-dateRemboursement').disabled = false;
		document.getElementById('orbt-banqueRetrait').disabled = false;
		document.getElementById('orbt-motif').disabled = false;
		document.getElementById('orbt-clientId').disabled = false;
		document.getElementById('orbt-bRechClient').disabled = false;
		document.getElementById('orbt-modeReglement').disabled = false;
		document.getElementById('orbt-numPiece').disabled = false;
		document.getElementById('orbt-montant').disabled = false;
		document.getElementById('orbt-commentaires').disabled = false;
		document.getElementById('orbt-bEnregistrerRemboursement').disabled = false;
		document.getElementById('orbt-attente').checked = false;
		document.getElementById('orbt-attente').collapsed = false;

		orbt_aMotifs.clearParams();
		orbt_aMotifs.setParam("Type_Tiers", "C");
    orbt_aMotifs.initTree(orbt_initMotifInitial);

	} catch (e) {
		recup_erreur(e);
	}
}


function orbt_enregistrerRemboursement() {
	try {

		var dateRemboursement = document.getElementById('orbt-dateRemboursement').value;
		var banqueRetrait = document.getElementById('orbt-banqueRetrait').value;
		var motif = document.getElementById('orbt-motif').value;
		var clientId = document.getElementById('orbt-clientId').value;
		var denomination = (isEmpty(clientId)?document.getElementById('orbt-clientId').getAttribute("label"):"");
		var modeReglement = document.getElementById('orbt-modeReglement').value;
		var numPiece = document.getElementById('orbt-numPiece').value;
		var montant = document.getElementById('orbt-montant').value;
		var commentaires = document.getElementById('orbt-commentaires').value;
		var attente = document.getElementById('orbt-attente').checked;

		if (isEmpty(dateRemboursement) || !isDate(dateRemboursement)) { showWarning("Date incorrecte !"); }
		else if (banqueRetrait=="") { showWarning("Veuillez choisir une banque de retrait !"); }
		else if (motif=="") { showWarning("Veuillez choisir un motif !"); }
		else if (clientId=="0") { showWarning("Veuillez choisir un client !"); }
		else if (isEmpty(montant) || !isPositive(montant)) { showWarning("Montant incorrect !"); }
		else if (commentaires.length>100) { showWarning("Le commentaire ne doit pas d\u00E9passer 100 caract\u00E8res !"); }
		else {
			var qSave;

			if (orbt_currentRemboursementId!="") {
				qSave = new QueryHttp("Facturation/Suivi_Reglements_Clients/updateRemboursementClient.tmpl");
				qSave.setParam("Remboursement_Id", orbt_currentRemboursementId);
			}
			else {
				qSave = new QueryHttp("Facturation/Suivi_Reglements_Clients/createRemboursementClient.tmpl");
			}
			qSave.setParam("Date_Remboursement", dateRemboursement);
			qSave.setParam("Banque_Retrait", banqueRetrait);
			qSave.setParam("Motif", motif);
			qSave.setParam("Client_Id", clientId);
			qSave.setParam("Denomination", denomination);
			qSave.setParam("Mode_Reglement", modeReglement);
			qSave.setParam("Num_Piece", numPiece);
			if (!document.getElementById('orbt-montant').disabled) { qSave.setParam("Montant", montant); }
			qSave.setParam("Commentaires", commentaires);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else if (orbt_currentRemboursementId=="") {
				var remboursementId = result.responseXML.documentElement.getAttribute("Remboursement_Id");

				if (!attente) {
					orbt_currentRemboursementId = remboursementId;
					orbt_validerRemboursement();
				}

				var url = "chrome://opensi/content/facturation/user/suivi_reglements_clients/popup-imputationRemboursement.xul";
				window.openDialog(url,'','chrome,modal,centerscreen', 'R', remboursementId, '', true);
			}

			orbt_initListeRemboursements();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function orbt_validerRemboursement() {
	try {

		var qValid = new QueryHttp("Facturation/Suivi_Reglements_Clients/validRemboursementClient.tmpl");
		qValid.setParam("Remboursement_Id", orbt_currentRemboursementId);
		var result = qValid.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}

		orbt_initListeRemboursements();

	} catch (e) {
		recup_erreur(e);
	}
}


function orbt_pressOnSupprimer() {
	try {

		if (orbt_currentRemboursementId != "" && window.confirm("Voulez-vous supprimer le remboursement s\u00E9lectionn\u00E9 ?")) {
			var qSupprimer = new QueryHttp("Facturation/Suivi_Reglements_Clients/deleteRemboursementClient.tmpl");
			qSupprimer.setParam("Remboursement_Id", orbt_currentRemboursementId);
			var result = qSupprimer.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showWarning("Le remboursement a \u00E9t\u00E9 supprim\u00E9");
				orbt_initListeRemboursements();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function orbt_pressOnAnnuler() {
	try {

		if (orbt_currentRemboursementId != "" && window.confirm("Voulez-vous annuler le remboursement s\u00E9lectionn\u00E9 ?")) {
			var qAnnuler = new QueryHttp("Facturation/Suivi_Reglements_Clients/cancelRemboursementClient.tmpl");
			qAnnuler.setParam("Remboursement_Id", orbt_currentRemboursementId);
			var result = qAnnuler.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showWarning("Le remboursement a \u00E9t\u00E9 annul\u00E9");
				orbt_initListeRemboursements();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function orbt_editerPdf() {
	try {

		if (!isEmpty(orbt_currentRemboursementId)) {
			var url = "chrome://opensi/content/facturation/user/suivi_reglements_clients/popup-adresseRemboursement.xul";
			window.openDialog(url,'','chrome,modal,centerscreen', orbt_currentRemboursementId, orbt_retourChoixAdresse);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function orbt_retourChoixAdresse(denomination, adresse1, adresse2, adresse3, codePostal, ville, codePays) {
	try {
		var qGenPdf = new QueryHttp("Facturation/Suivi_Reglements_Clients/pdfLettreRemboursement.tmpl");
    qGenPdf.setParam("Remboursement_Id", orbt_currentRemboursementId);
    qGenPdf.setParam("Denomination", denomination);
    qGenPdf.setParam("Adresse_1", adresse1);
    qGenPdf.setParam("Adresse_2", adresse2);
    qGenPdf.setParam("Adresse_3", adresse3);
    qGenPdf.setParam("Code_Postal", codePostal);
    qGenPdf.setParam("Ville", ville);
    qGenPdf.setParam("Code_Pays", codePays);
    var result = qGenPdf.execute();
    var page = getDirPdf() + result.responseXML.documentElement.getAttribute('fichier');
		switchPdf(page);
	} catch (e) {
		recup_erreur(e);
	}
}


function orbt_pressOnEditionCsv() {
	try {

		var numClient = document.getElementById('orbt-numClient').value;
		var dateDebut = document.getElementById('orbt-dateDebut').value;
		var dateFin = document.getElementById('orbt-dateFin').value;
		var etat = document.getElementById('orbt-etat').value;
		var statut = document.getElementById('orbt-statut').value;
		var etablissement = document.getElementById('orbt-etablissement').value;
		var montant = document.getElementById('orbt-rechMontant').value;

		if (!isEmpty(dateDebut) && !isDate(dateDebut)) { showWarning("Date de d\u00E9but incorrecte !"); }
		else if (!isEmpty(dateFin) && !isDate(dateFin)) { showWarning("Date de fin incorrecte !"); }
		else if (!isEmpty(dateDebut) && !isEmpty(dateFin) && !isDateInterval(dateDebut, dateFin)) { showWarning("La date de fin doit \u00EAtre sup\u00E9rieure \u00E0 la date de d\u00E9but !"); }
		else if (!isEmpty(montant) && !isPositive(montant)) { showWarning("Montant incorrect"); }
		else {

			var qEditionCsv = new QueryHttp("Facturation/Suivi_Reglements_Clients/csvRemboursementClient.tmpl");

			qEditionCsv.setParam("Num_Client", numClient);
			qEditionCsv.setParam("Etat", etat);
			qEditionCsv.setParam("Statut", statut);
			qEditionCsv.setParam("Date_Debut", dateDebut);
			qEditionCsv.setParam("Date_Fin", dateFin);
			qEditionCsv.setParam("Etablissement", etablissement);
			qEditionCsv.setParam("Montant", montant);

			var result = qEditionCsv.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');

				var file = fileChooser("save", fichier);
				if (file!=null) {
					downloadFile(getDirBuffer()+ fichier, file);
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}
