/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");


var reglementId;



function init() {
  try {

		reglementId = window.arguments[1];

		document.getElementById('dateAnnulation').value = getDateCourante();

		var aMotifsAnnulation = new Arbre('ComboListe/combo-motifsAnnulationReglement.tmpl', 'motifAnnulation');
		aMotifsAnnulation.setParam("Type_Tiers", "C");
		aMotifsAnnulation.initTree();

  } catch (e) {
    recup_erreur(e);
  }
}


function annulerReglement() {
	try {

		var motifAnnulation = document.getElementById('motifAnnulation').value;
		var dateAnnulation = document.getElementById('dateAnnulation').value;

		if (isEmpty(dateAnnulation) || !isDate(dateAnnulation)) {
			showWarning("Date d'annulation incorrecte");
		}
		else if (isEmpty(motifAnnulation)) {
			showWarning("Veuillez s\u00E9lectionner un motif d'annulation");
		}
		else {
			var qCancel = new QueryHttp("Facturation/Suivi_Reglements_Clients/cancelReglementClient.tmpl");
			qCancel.setParam("Reglement_Id", reglementId);
			qCancel.setParam("Motif_Annulation", motifAnnulation);
			qCancel.setParam("Date_Annulation", dateAnnulation);
			var result = qCancel.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				window.arguments[0]();
	  		window.close();
			}
		}

	} catch (e) {
	  recup_erreur(e);
	}
}
