/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

/*
	Arguments du popup :
		- 0 : Fonction de retour
*/

jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");

var importFile;
var clientId = "";



function init() {
	try {

		document.getElementById('bRechClient').disabled = true;
		document.getElementById('modeReglement').disabled = true;

		var aBanquesRetrait = new Arbre('ComboListe/combo-banques.tmpl', 'banqueRetrait');
		aBanquesRetrait.initTree();

		var aMotifsRemboursement = new Arbre('ComboListe/combo-motifsRemboursement.tmpl', 'motif');
		aMotifsRemboursement.setParam("Type_Tiers", "C");
		aMotifsRemboursement.initTree();

		var aModesReglement = new Arbre('ComboListe/combo-modesReglement.tmpl', 'modeReglement');
		aModesReglement.initTree();

	} catch (e) {
		recup_erreur(e);
	}
}


function searchFile() {
	try {

		var file = fileChooser("open");
		if (file!=null) {
			importFile = file;
			document.getElementById("pathFile").value = file.path;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function importerFichier() {
	try {

		var banqueRetrait = document.getElementById('banqueRetrait').value;
		var motif = document.getElementById('motif').value;
		var modeReglement = document.getElementById('modeReglement').value;
		var optionNumClient = document.getElementById('optionNumClient').value;
		var optionModeReglement = document.getElementById('optionModeReglement').value;

		if (isEmpty(banqueRetrait)) {
			showWarning("Veuillez s\u00E9lectionner une banque de retrait");
		}
		else if (isEmpty(motif)) {
			showWarning("Veuillez s\u00E9lectionner un motif de remboursement");
		}
		else if (optionNumClient=="U" && isEmpty(clientId)) {
			showWarning("Veuillez s\u00E9lectionner un client");
		}
		else if (optionModeReglement=="U" && isEmpty(modeReglement)) {
			showWarning("Veuillez s\u00E9lectionner un mode de r\u00E8glement");
		}
		else if (importFile==null) {
			showWarning("Veuillez s\u00E9lectionner un fichier \u00E0 importer");
		}
		else {
			var extension = getFileExtension(importFile.leafName).toLowerCase();

			if (!isEmpty(extension) && extension!="csv" && extension!="txt") {
				showWarning("Format de fichier incorrect (formats accept\u00E9s : *.csv, *.txt)");
			}
			else if (checkUploadFile(importFile)) {

				uploadFile(importFile);

	   		var qImport = new QueryHttp("Facturation/Suivi_Reglements_Clients/importRemboursementClient.tmpl");
	   		qImport.setParam("Fichier", importFile.leafName);
				qImport.setParam("Banque_Retrait", banqueRetrait);
				qImport.setParam("Motif", motif);
				qImport.setParam("Client_Id", clientId);
				qImport.setParam("Mode_Reglement", modeReglement);

	   		var result = qImport.execute();

	   		var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
				else {
					var nbLines = result.responseXML.documentElement.getElementsByTagName("erreurs").length;

					if (nbLines==0) {
						showMessage("Import termin\u00E9 avec succ\u00E8s : "+ result.responseXML.documentElement.getAttribute('Nb_Lines_OK') +" lignes import\u00E9es");
					}
					else {
						var rapport = result.responseXML.documentElement.getAttribute('Fichier_Rapport');

						var messages = new Array();
						var lines = new Array();
						var cells = new Array();

						for (var j=0; j<nbLines; j++) {
							var erreur = result.responseXML.documentElement.getElementsByTagName('erreurs')[j];
							messages[j] = erreur.getAttribute("Message");
							lines[j] = erreur.getAttribute("Ligne");
							cells[j] = erreur.getAttribute("Cellule");
						}

						window.openDialog("chrome://opensi/content/facturation/user/csv/popup-rapportErreurs.xul",'','chrome,modal,centerscreen', lines, cells, messages, rapport);
					}
				}

		   	window.arguments[0]();
		   	window.close();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function changeOptionNumClient() {
	try {

		if (document.getElementById('optionNumClient').value=="C") {
			clientId = "";
			document.getElementById('numClient').value = "";
			document.getElementById('bRechClient').disabled = true;
		}
		else {
			document.getElementById('bRechClient').disabled = false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function changeOptionModeReglement() {
	try {

		if (document.getElementById('optionModeReglement').value=="C") {
			document.getElementById('modeReglement').value = "";
			document.getElementById('modeReglement').disabled = true;
		}
		else {
			document.getElementById('modeReglement').disabled = false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function rechercherClient() {
	try {

		var url = "chrome://opensi/content/facturation/user/clients/popup-rechercheClient.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', retourRechercherClient);

	} catch (e) {
		recup_erreur(e);
	}
}


function retourRechercherClient(numClient, pClientId) {
	try {

  	document.getElementById('numClient').value = numClient;
		clientId = pClientId;

	} catch (e) {
		recup_erreur(e);
	}
}
