/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/
/*
 * Arguments :
 * 0 -> Type (R -> rglement ; A -> Avoir ; B -> Boucle)
 * 1 -> Id (du rglement ou de l'avoir)
 */


jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/formatter.js");

var aEcheances = new Arbre("Facturation/Suivi_Reglements_Clients/list-affectationEcheance.tmpl", "listeEcheances");

var pieceId;
var modeRegId = "";
var montantTotal = 0;
var montantImpute = 0;
var montantRestant = 0;
var boucler;
var creation;
var clientId;

var listeReglements = "";
var listeAvoirs = "";
var currentIndex = 0;
var typePiece;
var validationOk = false;
var avoirAffCde;

var nf = new NumberFormat("0.00", false);


function init() {
	try {

		window.parent.addEventListener("close",alertExit,false);
		window.resizeTo(1040,750);
		typePiece = window.arguments[0];
		pieceId = window.arguments[1];
		boucler = (typePiece=="B");
		creation = window.arguments[3];

		if (boucler) {
			var qListePieces = new QueryHttp("Facturation/Suivi_Reglements_Clients/getListReglementAImputer.tmpl");
			var result = qListePieces.execute();
			listeReglements = result.responseXML.documentElement.getAttribute("List_Reglement_Id");
			listeAvoirs = result.responseXML.documentElement.getAttribute("List_Avoir_Id");

			if (isEmpty(listeReglements) && isEmpty(listeAvoirs)) {
				showWarning("Il n'y a aucune \u00E9ch\u00E9ance \u00E0 imputer.");
				window.close();
			}
			else {
				var reg=new RegExp("[,]+", "g");
				if (listeReglements.length>0) {
					listeReglements = listeReglements.split(reg);
					pieceId = listeReglements[0];
					typePiece = "R";

					if (listeAvoirs.length>0) { listeAvoirs = listeAvoirs.split(reg); }
				} else if (listeAvoirs.length>0) {
					listeAvoirs = listeAvoirs.split(reg);
					pieceId = listeAvoirs[0];
					typePiece = "A";
				}
				currentIndex++;
				reinitialiser();
			}
		}
		else {
			reinitialiser();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function reinitialiser() {
	try {

		if (typePiece=="R") {
			var qReglement = new QueryHttp("Facturation/Suivi_Reglements_Clients/loadReglementClient.tmpl");
			qReglement.setParam("Reglement_Id", pieceId);
			var result = qReglement.execute();

			clientId = result.responseXML.documentElement.getAttribute("Client_Id");
			modeRegId = result.responseXML.documentElement.getAttribute("Mode_Reg_Id");
			montantTotal = parseFloat(result.responseXML.documentElement.getAttribute("Montant_Restant"));
			document.getElementById('typePiece').value = "R\u00E8glement";
			document.getElementById('modeReglement').value = result.responseXML.documentElement.getAttribute("Mode_Reglement");
			document.getElementById('datePiece').value = result.responseXML.documentElement.getAttribute("Date_Reglement");
			document.getElementById('numPiece').value = result.responseXML.documentElement.getAttribute("Num_Piece");
			document.getElementById('numClient').value = result.responseXML.documentElement.getAttribute("Num_Client");
			document.getElementById('raisonSociale').value = result.responseXML.documentElement.getAttribute("Denomination");
		}
		else if (typePiece=="A") {
			var qAvoir = new QueryHttp("Facturation/Suivi_Reglements_Clients/loadAvoirClient.tmpl");
			qAvoir.setParam("Avoir_Id", pieceId);
			var result = qAvoir.execute();

			clientId = result.responseXML.documentElement.getAttribute("Client_Id");
			modeRegId = "";
			montantTotal = parseFloat(result.responseXML.documentElement.getAttribute("Montant_Restant"));
			document.getElementById('typePiece').value = "Avoir";
			document.getElementById('modeReglement').value = "";
			document.getElementById('datePiece').value = result.responseXML.documentElement.getAttribute("Date_Avoir");
			document.getElementById('numPiece').value = result.responseXML.documentElement.getAttribute("Num_Piece");
			document.getElementById('numClient').value = result.responseXML.documentElement.getAttribute("Num_Client");
			document.getElementById('raisonSociale').value = result.responseXML.documentElement.getAttribute("Denomination");
			avoirAffCde = !isEmpty(result.responseXML.documentElement.getAttribute("Commande_Id"));
		}

		if (isEmpty(clientId)) {
			document.getElementById('regroupement').checked = false;
			document.getElementById('regroupement').collapsed = true;
		}
		else {
			document.getElementById('regroupement').collapsed = false;
		}

		var regroupement = document.getElementById('regroupement').checked;

		if (regroupement) {
			document.getElementById('colNumClient').collapsed = false;
			document.getElementById('colDenomination').collapsed = false;
			document.getElementById('colNumClient').removeAttribute("ignoreincolumnpicker");
			document.getElementById('colDenomination').removeAttribute("ignoreincolumnpicker");
		}
		else {
			document.getElementById('colNumClient').collapsed = true;
			document.getElementById('colDenomination').collapsed = true;
			document.getElementById('colNumClient').setAttribute("ignoreincolumnpicker", true);
			document.getElementById('colDenomination').setAttribute("ignoreincolumnpicker", true);
		}

		document.getElementById("nouveauMontant").value = "";
		document.getElementById("montantTotal").value = nf.format(montantTotal);

		document.getElementById('lblModeReglement').collapsed=(typePiece!="R");
		document.getElementById('modeReglement').collapsed=(typePiece!="R");

		document.getElementById('bIgnorer').collapsed=!boucler;
		document.getElementById('bValider').setAttribute("tooltiptext", !boucler?"valider et quitter":"valider et passer \u00E0 l'imputation suivante");
		document.getElementById('bValider').disabled=true;

		aEcheances.setParam("Client_Id", clientId);
		aEcheances.setParam("Denomination", document.getElementById('raisonSociale').value);
		aEcheances.setParam("Mode_Reg_Id", modeRegId);
		aEcheances.setParam("Montant", montantTotal);
		aEcheances.setParam("Type_Piece", typePiece);
		aEcheances.setParam("Regroupement", regroupement);
		aEcheances.initTree(initListeEcheances);

	} catch (e) {
		recup_erreur(e);
	}
}


function initListeEcheances() {
	try {

		calculTotaux();

		if (aEcheances.nbLignes()==0) {
			if (boucler) {
				imputationSuivante();
			}
			else {
				var regroupement = document.getElementById('regroupement').checked;
				if (regroupement || isEmpty(clientId)) {
					showWarning("Il n'y a aucune \u00E9ch\u00E9ance \u00E0 imputer.");
					window.close();
				}
				else {
					document.getElementById('regroupement').checked = true;
					reinitialiser();
				}
			}
		}
		else {
			checkValidationPossible();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function clickOnRegroupement() {
	try {

		reinitialiser();

	} catch (e) {
		recup_erreur(e);
	}
}


function calculTotaux() {
	try {

		montantImpute = 0;
		var modeRegEgal = true;

		for (var i=0; i<aEcheances.nbLignes(); i++) {
			if (aEcheances.getCellValue(i, "colSelEcheance")=="true") {
				montantImpute += parseFloat(aEcheances.getCellText(i, "colMontantImpute"));
				if (typePiece=="R" && modeRegEgal && modeRegId!=aEcheances.getCellText(i, "colModeRegId")) {
					modeRegEgal = false;
				}
			}
		}

		montantImpute = parseFloat(nf.format(montantImpute));
		montantRestant = montantTotal - montantImpute;

		document.getElementById("montantImpute").value = nf.format(montantImpute);
		document.getElementById("montantRestant").value = nf.format(montantRestant);

		document.getElementById("lblMontantRestant").style.color = (montantRestant==0?"green":"red");
		document.getElementById("montantRestant").style.color = (montantRestant==0?"green":"red");

		document.getElementById("lblCheckModeReg").value = (typePiece=="A" || modeRegEgal?"":"Attention : les modes de r\u00E8glements sont diff\u00E9rents !");

	} catch (e) {
		recup_erreur(e);
	}
}


function checkValidationPossible() {
	try {

		var existeCoche = false;
		var i = 0;

		while (i<aEcheances.nbLignes() && !existeCoche) {
			if (aEcheances.getCellValue(i, "colSelEcheance")=="true" && parseFloat(aEcheances.getCellText(i, "colMontantImpute"))>0) {
				existeCoche = true;
			}
			i++;
		}

		document.getElementById('bValider').disabled = (!existeCoche);

	} catch (e) {
		recup_erreur(e);
	}
}


function changeSelEcheance(i) {
	try {

		if (aEcheances.getCellValue(i, "colSelEcheance")=="true") {
			var montantRestant = parseFloat(aEcheances.getCellText(i, "colMontantRestant"));
			var totalRestant = parseFloat(document.getElementById("montantRestant").value);

			var montant = totalRestant<=montantRestant?totalRestant:montantRestant;
			if (montant<0) {
				montant = 0;
			}

			aEcheances.setCellText(i, "colMontantImpute", nf.format(montant));
		}
		else {
			aEcheances.setCellText(i, "colMontantImpute", nf.format(0));
			aEcheances.setCellValue(i, "colSelEcheance", false);
		}

		checkValidationPossible();
		calculTotaux();

	} catch (e) {
		recup_erreur(e);
	}
}


function clickOnEcheance(ev) {
	try {

		var col = aEcheances.getClickedCol(ev);

		if (col!=null && col.id=="colSelEcheance") {
			changeSelEcheance(aEcheances.getClickedRowIndex(ev));
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function selectOnListeEcheances() {
	try {

		if (aEcheances.isSelected()) {
			document.getElementById("nouveauMontant").value = aEcheances.getSelectedCellText("colMontantImpute");
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnListeEcheances(ev) {
	try {

		if (ev.keyCode==32 && aEcheances.isSelected()) {
			aEcheances.setSelectedCellValue("colSelEcheance", aEcheances.getSelectedCellValue("colSelEcheance")=="false");

			changeSelEcheance(aEcheances.getCurrentIndex());

			document.getElementById("nouveauMontant").value = aEcheances.getSelectedCellText("colMontantImpute");
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function toutDecocher() {
	try {

		for (var i=0; i<aEcheances.nbLignes(); i++) {
			aEcheances.setCellValue(i, "colSelEcheance", false);
			aEcheances.setCellText(i, "colMontantImpute", nf.format(0));
		}

		checkValidationPossible();
		calculTotaux();

	} catch (e) {
		recup_erreur(e);
	}
}


function onKeyPress(e) {
	try {

		if (e.keyCode==13) {
		 	changerMontant();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function changerMontant() {
	try {

		var montant = document.getElementById("nouveauMontant").value;

		if (!aEcheances.isSelected()) { showWarning("Veuillez s\u00E9lectionner une \u00E9ch\u00E9ance !"); }
		else if (!isPositiveOrNull(montant)) { showWarning("Montant incorrect !"); }
		else {
			montant = parseFloat(montant);
			var montantRestant = parseFloat(aEcheances.getSelectedCellText("colMontantRestant"));
			if (montant > montantRestant) { showWarning("Le montant doit \u00EAtre inf\u00E9rieur au montant restant !"); }
			else {
				aEcheances.setSelectedCellText("colMontantImpute", nf.format(montant));
				aEcheances.setSelectedCellValue("colSelEcheance", isPositive(montant));
				aEcheances.clearSelection();
				document.getElementById("nouveauMontant").value = "";

				calculTotaux();
				checkValidationPossible();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function verifierMontantMax() {
	try {

		var continuer = true;
		var i = 0;

		while (i<aEcheances.nbLignes() && continuer) {
			if (aEcheances.getCellValue(i, "colSelEcheance")=="true") {
				var impute = parseFloat(aEcheances.getSelectedCellText("colMontantImpute"));
				var restant = parseFloat(aEcheances.getSelectedCellText("colMontantRestant"));
				if (impute != restant) {
					continuer = false;
				}
			}
			else {
				continuer = false;
			}
			i++;
		}

		return continuer;

	} catch (e) {
		recup_erreur(e);
	}
}


function imputationSuivante() {
	try {

		if (boucler) {
			if (typePiece=="R" && currentIndex==listeReglements.length) {
				currentIndex = 0;
				typePiece = "A";
			}
			if (typePiece=="A" && currentIndex==listeAvoirs.length) {
				majListeParente();
			}
			else {
				if (typePiece=="R") {
					pieceId = listeReglements[currentIndex];
				} else {
					pieceId = listeAvoirs[currentIndex];
				}
				currentIndex++;

				reinitialiser();
			}
		}
		else {
			majListeParente();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function majListeParente() {
	try {

		if (validationOk && (window.arguments[2]!="")) { window.arguments[2](); }
		window.close();

	} catch (e) {
		recup_erreur(e);
	}
}


function valider() {
	try {

		var ok = false;
		if (montantRestant > 0) {
			if (verifierMontantMax()) {
				ok = window.confirm("Un surplus sera cr\u00E9\u00E9 ! Etes-vous s\u00FBr de vouloir continuer ?");
			} else {
				ok = true;
			}
		}
		else if (montantRestant < 0) {
			if (typePiece=="R") { showWarning("Vous ne pouvez pas affecter plus que le montant du r\u00E8glement !"); }
			else if (typePiece=="A") { showWarning("Vous ne pouvez pas affecter plus que le montant de l'avoir !"); }
		}
		else {
			ok = true;
		}

		if (ok && typePiece=="A" && avoirAffCde) {
			ok = window.confirm("L'avoir est affect\u00E9 \u00E0 une commande, \u00EAtes-vous s\u00FBr de vouloir continuer ?");
		}

		if (ok) {
			document.getElementById('bValider').disabled = true;
			document.getElementById('bIgnorer').disabled = true;
			document.getElementById('bQuitter').disabled = true;

			var qAffecterReglement;
			if (typePiece=="R") {
				qAffecterReglement = new QueryHttp("Facturation/Suivi_Reglements_Clients/imputeEcheanceByReglement.tmpl");
				qAffecterReglement.setParam("Reglement_Id", pieceId);
			}
			else {
				qAffecterReglement = new QueryHttp("Facturation/Suivi_Reglements_Clients/imputeEcheanceByAvoir.tmpl");
				qAffecterReglement.setParam("Avoir_Id", pieceId);
			}

			for (var i=0; i<aEcheances.nbLignes(); i++) {
				if (aEcheances.getCellValue(i, "colSelEcheance")=="true") {
					qAffecterReglement.setParam("Echeance_Id", aEcheances.getCellText(i, "colEcheanceId"));
					qAffecterReglement.setParam("Montant_Imputation", aEcheances.getCellText(i, "colMontantImpute"));
					var result = qAffecterReglement.execute();

					var errors = new Errors(result);
					if (errors.hasNext()) {
						errors.show();
					}
				}
			}

			validationOk = true;
			imputationSuivante();

			document.getElementById('bValider').disabled = false;
			document.getElementById('bIgnorer').disabled = false;
			document.getElementById('bQuitter').disabled = false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function quitter() {
	try {

		if (!creation || window.confirm("Attention, le r\u00E8glement a \u00E9t\u00E9 cr\u00E9\u00E9 mais pas encore imput\u00E9.\nVoulez-vous vraiment quitter ?")) {
			window.close();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function alertExit() {
	try {

		if (creation) { showWarning("Attention, le r\u00E8glement a \u00E9t\u00E9 cr\u00E9\u00E9 mais pas encore imput\u00E9."); }

	} catch (e) {
		recup_erreur(e);
	}
}


function desinit() {
	try {

		window.parent.removeEventListener("close",alertExit,false);

	} catch (e) {
  	recup_erreur(e);
  }
}
