/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");


var aEcheances = new Arbre("Facturation/Suivi_Reglements_Clients/list-echeanceASolder.tmpl", "listeEcheances");


function init() {
	try {

		window.resizeTo(1200,600);
		reinitialiser();

	} catch (e) {
		recup_erreur(e);
	}
}


function reinitialiser() {
	try {

		document.getElementById('nbCentimes').value = "1";
		rafraichirListeEcheances();

	} catch (e) {
		recup_erreur(e);
	}
}


function rafraichirListeEcheances() {
	try {

		var nbCentimes = document.getElementById('nbCentimes').value;
		if (isEmpty(nbCentimes) || !isPositiveInteger(nbCentimes)) { showWarning("Le nombre de centimes est invalide !"); }
		else {
			document.getElementById('nbCentimes').disabled = true;
			document.getElementById('bValider').disabled = true;
			document.getElementById('listeEcheances').disabled = true;
			aEcheances.setParam("Nb_Centimes", nbCentimes);
			aEcheances.initTree(initListeEcheances);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function initListeEcheances() {
	try {

		var liste = document.getElementById("listeEcheances");
		document.getElementById('nbCentimes').disabled = false;
		document.getElementById('bValider').disabled = (liste.getRowCount()==0);
		document.getElementById('listeEcheances').disabled = false;

	} catch (e) {
		recup_erreur(e);
	}
}


function onKeyPress(event) {
	try {
		if (event.keyCode==13) {
			rafraichirListeEcheances();
		}
	} catch (e) {
		recup_erreur(e);
	}
}


function toutCocher(b) {
	try {
		
		var liste = document.getElementById("listeEcheances");
		
		for (var i=0; i<liste.getRowCount(); i++) {
			liste.getItemAtIndex(i).getElementsByTagName("listcell").item(0).setAttribute("checked", b);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function testCheck(listitem) {
	try {
		var cks = listitem.getElementsByTagName("listcell");
		if (cks.item(0).getAttribute("checked")=="false") {
			cks.item(0).setAttribute("checked","true");
		} else {
			cks.item(0).setAttribute("checked","false");
		}
	} catch (e) {
		recup_erreur(e);
	}
}


function valider() {
	try {
		var liste = document.getElementById("listeEcheances");
		var listeEcheances = "";
		var nombreElements = liste.getRowCount();
		for (var i=0; i<nombreElements; i++) {
			if (liste.getItemAtIndex(i).getElementsByTagName("listcell").item(0).getAttribute("checked")=="true") {
				listeEcheances += liste.getItemAtIndex(i).value +",";
			}
		}

		if (isEmpty(listeEcheances)) { showWarning("Veuillez cocher au moins une \u00E9ch\u00E9ance !"); }
		else if (window.confirm("Voulez-vous solder les \u00E9ch\u00E9ances s\u00E9lectionn\u00E9es en perte et profit ?")) {
			var qSolderEcheances = new QueryHttp("Facturation/Suivi_Reglements_Clients/settleEcheancesLot.tmpl");
			qSolderEcheances.setParam("List_Echeance_Id", listeEcheances);
			var result = qSolderEcheances.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}

			window.arguments[0]();
			window.close();
		}
	} catch (e) {
		recup_erreur(e);
	}
}
