/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");


var aReglements = new Arbre("Facturation/Suivi_Reglements_Clients/list-reglementASolder.tmpl", "listeReglements");


function init() {
	try {

		window.resizeTo(1200,600);
		reinitialiser();

	} catch (e) {
		recup_erreur(e);
	}
}


function reinitialiser() {
	try {

		document.getElementById('nbCentimes').value = "1";
		rafraichirListeReglements();

	} catch (e) {
		recup_erreur(e);
	}
}


function rafraichirListeReglements() {
	try {

		var nbCentimes = document.getElementById('nbCentimes').value;
		if (isEmpty(nbCentimes) || !isPositiveInteger(nbCentimes)) { showWarning("Le nombre de centimes est invalide !"); }
		else {
			document.getElementById('nbCentimes').disabled = true;
			document.getElementById('bValider').disabled = true;
			document.getElementById('listeReglements').disabled = true;

			aReglements.setParam("Nb_Centimes", nbCentimes);
			aReglements.initTree(initListeReglements);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function initListeReglements() {
	try {

		var liste = document.getElementById("listeReglements");
		document.getElementById('nbCentimes').disabled = false;
		document.getElementById('bValider').disabled = (liste.getRowCount()==0);
		document.getElementById('listeReglements').disabled = false;

	} catch (e) {
		recup_erreur(e);
	}
}


function onKeyPress(event) {
	try {
		if (event.keyCode==13) {
			rafraichirListeReglements();
		}
	} catch (e) {
		recup_erreur(e);
	}
}


function toutCocher(b) {
	try {
		
		var liste = document.getElementById("listeReglements");
		
		for (var i=0; i<liste.getRowCount(); i++) {
			liste.getItemAtIndex(i).getElementsByTagName("listcell").item(0).setAttribute("checked", b);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function testCheck(listitem) {
	try {
		var cks = listitem.getElementsByTagName("listcell");
		if (cks.item(0).getAttribute("checked")=="false") {
			cks.item(0).setAttribute("checked","true");
		} else {
			cks.item(0).setAttribute("checked","false");
		}
	} catch (e) {
		recup_erreur(e);
	}
}


function valider() {
	try {

		var liste = document.getElementById("listeReglements");
		var listeReglements = "";
		var listeAvoirs = "";

		var nombreElements = liste.getRowCount();
		for (var i=0; i<nombreElements; i++) {
			if (liste.getItemAtIndex(i).getElementsByTagName("listcell").item(0).getAttribute("checked")=="true") {
				if (liste.getItemAtIndex(i).getElementsByTagName("listcell").item(9).getAttribute("label")=="R") {
					listeReglements += liste.getItemAtIndex(i).value +",";
				}
				else {
					listeAvoirs += liste.getItemAtIndex(i).value +",";
				}
			}
		}

		if (isEmpty(listeReglements) && isEmpty(listeAvoirs)) { showWarning("Veuillez cocher au moins un r\u00E8glement !"); }
		else if (window.confirm("Voulez-vous solder les r\u00E8glements s\u00E9lectionn\u00E9s en perte et profit ?")) {

			if (!isEmpty(listeReglements)) {
				var qSolderReglements = new QueryHttp("Facturation/Suivi_Reglements_Clients/settleReglementsLot.tmpl");
				qSolderReglements.setParam("List_Reglement_Id", listeReglements);
				var result = qSolderReglements.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
			}

			if (!isEmpty(listeAvoirs)) {
				var qSolderAvoirs = new QueryHttp("Facturation/Suivi_Reglements_Clients/settleAvoirsLot.tmpl");
				qSolderAvoirs.setParam("List_Avoir_Id", listeAvoirs);
				var result = qSolderAvoirs.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
			}

			window.arguments[0]();
			window.close();
		}

	} catch (e) {
		recup_erreur(e);
	}
}
