/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/formatter.js");


var nf = new NumberFormat("0.##", false);

var etablissementDefaut;



function init() {
  try {

		etablissementDefaut = getProfil().getEtabId();

		document.getElementById('deck').selectedIndex = 0;
  	document.getElementById('onglets').selectedIndex = 0;

  	oe_init();
  	org_init();
  	orbt_init();

	} catch (e) {
    recup_erreur(e);
  }
}


function switchPdf(page) {
	try {

		document.getElementById('pdf').setAttribute('src', page);
		document.getElementById('deck').selectedIndex = 1;
		document.getElementById('bRetourReglementsFournisseurs').collapsed = false;

		if (document.getElementById('onglets').selectedIndex==0) {
			document.getElementById('boxEcheances').collapsed = false;
		}
		else if (document.getElementById('onglets').selectedIndex==1) {
			document.getElementById('boxReglements').collapsed = false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function switchPdfWidthError(errors) {
	try {

		document.getElementById('pdf').setAttribute('src', '');
		document.getElementById('deck').selectedIndex = 1;
		document.getElementById('bRetourReglementsFournisseurs').collapsed = false;

		if (document.getElementById('onglets').selectedIndex==0) {
			document.getElementById('boxEcheances').collapsed = false;
		}
		else if (document.getElementById('onglets').selectedIndex==1) {
			document.getElementById('boxReglements').collapsed = false;
		}

		errors.show();

	} catch (e) {
		recup_erreur(e);
	}
}


function retourSuiviReglements() {
	try {

		if (document.getElementById('onglets').selectedIndex==5) {
			or_init();
		}

		document.getElementById('deck').selectedIndex = 0;
		document.getElementById('bRetourReglementsFournisseurs').collapsed = true;
		document.getElementById('pdf').setAttribute('src', '');
		document.getElementById('boxEcheances').collapsed = true;
		document.getElementById('boxReglements').collapsed = true;

	} catch (e) {
		recup_erreur(e);
	}
}


function retourMenuPrincipal() {
	try {

		window.location = "chrome://opensi/content/facturation/user/menu_principal.xul";

	} catch (e) {
    recup_erreur(e);
  }
}
