/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var oe_aPieces = new Arbre("Facturation/Suivi_Reglements_Fournisseurs/list-pieceFournisseur.tmpl", "oe-listePieces");
var oe_aEcheances = new Arbre("Facturation/Suivi_Reglements_Fournisseurs/list-echeanceFournisseur.tmpl", "oe-listeEcheances");
var oe_aEcheancesFact = new Arbre("Facturation/Suivi_Reglements_Fournisseurs/list-echeancePieceFournisseur.tmpl", "oe-listeEcheancesFact");
var oe_aReglements = new Arbre("Facturation/Suivi_Reglements_Fournisseurs/list-imputationEcheanceFournisseur.tmpl", "oe-listeReglements");
var oe_aFiltreModesReglements = new Arbre('ComboListe/combo-modesReglement.tmpl', 'oe-filtreModeReglement');
var oe_aBanques = new Arbre('ComboListe/combo-banques.tmpl', 'oe-banqueRetrait');
var oe_aFournisseurs = new Arbre('Facturation/Suivi_Reglements_Fournisseurs/combo-fournisseurs.tmpl', 'oe-fournisseurId');
var oe_aBanquesFournisseur = new Arbre('ComboListe/combo-banquesFournisseur.tmpl', 'oe-banqueFournisseur');
var oe_aModesReglements = new Arbre('ComboListe/combo-modesReglement.tmpl', 'oe-modeReglement');
var oe_aEtablissements = new Arbre('ComboListe/combo-etablissements.tmpl', 'oe-etablissement');

var oe_qListEF = new QueryHttp("Facturation/Suivi_Reglements_Fournisseurs/getDataListEF.tmpl");
var oe_qListPF = new QueryHttp("Facturation/Suivi_Reglements_Fournisseurs/getDataListPF.tmpl");

var oe_chargerModeReg;
var oe_chargerFournisseur;
var oe_chargerDenominationFournisseur;
var oe_selBanqueId = "";
var oe_currentEcheanceId = "";

var oe_pageCourante;
var oe_nbPages;
var oe_typeEdition = "E"; // E = chancier normal; P = chancier prvisionnel



function oe_init() {
  try {

    oe_initListeHaut();
  	document.getElementById('oe-etat').value = "N";
  	document.getElementById('oe-rechDenomination').value = "";
  	document.getElementById('oe-rechNumPiece').value = "";
		document.getElementById('oe-nbLignesParPage').selectedIndex = 0;
		oe_aFiltreModesReglements.initTree(oe_initFiltreModeReglement);

		var aFamilles = new Arbre('ComboListe/combo-famillesFournisseur.tmpl', 'oe-famille');
		aFamilles.initTree();

	} catch (e) {
  	recup_erreur(e);
	}
}


function oe_initFiltreModeReglement() {
	try {

		document.getElementById('oe-filtreModeReglement').selectedIndex = 0;
    oe_aEtablissements.setParam('Selection', etablissementDefaut);
		oe_aEtablissements.initTree(oe_initEtablissement);

	} catch (e) {
    recup_erreur(e);
  }
}


function oe_initEtablissement() {
	try {

		document.getElementById('oe-etablissement').value = etablissementDefaut;
		oe_initListeHaut();

	} catch (e) {
    recup_erreur(e);
  }
}


function oe_chargerFournisseurs(selection, denomination) {
	try {

		oe_chargerFournisseur = selection;
		oe_chargerDenominationFournisseur = denomination;
		oe_aFournisseurs.setParam("Fournisseur_Id", oe_chargerFournisseur);
		oe_aFournisseurs.setParam("Echeance_Id", oe_currentEcheanceId);
		oe_aFournisseurs.setParam("Type", "EC");
    oe_aFournisseurs.initTree(oe_selectFournisseur);

	} catch (e) {
		recup_erreur(e);
	}
}


function oe_chargerBanquesFournisseur() {
	try {
		var fournisseurId = document.getElementById('oe-fournisseurId').value;
		if (isEmpty(fournisseurId) || fournisseurId=="0") {
			oe_aBanquesFournisseur.deleteTree();
			oe_initBanqueFournisseur();
		} else {
			oe_aBanquesFournisseur.setParam("Fournisseur_Id", fournisseurId);
			oe_aBanquesFournisseur.initTree(oe_initBanqueFournisseur);
		}
	} catch (e) {
		recup_erreur(e);
	}
}


function oe_initBanqueFournisseur() {
	try {
		document.getElementById('oe-banqueFournisseur').setAttribute("label", "");
		document.getElementById('oe-banqueFournisseur').value = "";
	} catch (e) {
		recup_erreur(e);
	}
}


function oe_chargerBanques(selection) {
	try {

		oe_selBanqueId = selection;
		oe_aBanques.setParam("Selection", oe_selBanqueId);
		oe_aBanques.initTree(oe_initBanque);

	} catch (e) {
		recup_erreur(e);
	}
}


function oe_initBanque() {
  try {

		document.getElementById('oe-banqueRetrait').value = oe_selBanqueId;

	} catch (e) {
  	recup_erreur(e);
	}
}


function oe_chargerModesReglements(selection) {
	try {
		oe_chargerModeReg = selection;
		oe_aModesReglements.setParam("Selection", oe_chargerModeReg);
		oe_aModesReglements.initTree(oe_initModeReglement);
	} catch (e) {
		recup_erreur(e);
	}
}


function oe_initModeReglement() {
	try {

		document.getElementById('oe-modeReglement').value = oe_chargerModeReg;

	} catch (e) {
    recup_erreur(e);
  }
}


function oe_nouveauReglement() {
	try {

		oe_currentEcheanceId = "";
		document.getElementById('oe-dateReglement').value = "";
		oe_aBanquesFournisseur.deleteTree();
		oe_initBanqueFournisseur();
		oe_chargerFournisseurs("","");
		oe_chargerModesReglements("");
		oe_chargerBanques("");
		document.getElementById('oe-numPiece').value = "";
		document.getElementById('oe-montant').value = "";
		document.getElementById('oe-commentaires').value = "";

	} catch (e) {
    recup_erreur(e);
  }
}


function oe_initListeHaut() {
	try {

		var etat = document.getElementById('oe-etat').value;
		var denomination = document.getElementById('oe-rechDenomination').value;
		var numPiece = document.getElementById('oe-rechNumPiece').value;
		var dateDebut = document.getElementById('oe-dateDebut').value;
		var dateFin = document.getElementById('oe-dateFin').value;
		var dateFactureDebut = document.getElementById('oe-dateFactureDebut').value;
		var dateFactureFin = document.getElementById('oe-dateFactureFin').value;
		var modeReglement = document.getElementById('oe-filtreModeReglement').value;
		var numFournisseur = document.getElementById('oe-numFournisseur').value;
		var etablissement = document.getElementById('oe-etablissement').value;
		var famille = document.getElementById('oe-famille').value;
		var nbLignesParPage = document.getElementById('oe-nbLignesParPage').value;

		if (!isEmpty(dateDebut) && !isDate(dateDebut)) { showWarning("Date de d\u00E9but incorrecte !"); }
		else if (!isEmpty(dateFin) && !isDate(dateFin)) { showWarning("Date de fin incorrecte !"); }
		else if (!isEmpty(dateDebut) && !isEmpty(dateFin) && !isDateInterval(dateDebut, dateFin)) { showWarning("La date de fin doit \u00EAtre sup\u00E9rieure \u00E0 la date de d\u00E9but !"); }
		else if (!isEmpty(dateFactureDebut) && !isDate(dateFactureDebut)) { showWarning("Date de facture de d\u00E9but incorrecte"); }
		else if (!isEmpty(dateFactureFin) && !isDate(dateFactureFin)) { showWarning("Date de facture de fin incorrecte"); }
		else if (!isEmpty(dateFactureDebut) && !isEmpty(dateFactureFin) && !isDateInterval(dateFactureDebut, dateFactureFin)) { showWarning("La date de facture de fin doit \u00EAtre sup\u00E9rieure \u00E0 la date de d\u00E9but"); }
		else {

			oe_pageCourante = 1;
			oe_nbPages = 1;
			document.getElementById('oe-pageDeb').value = 1;
			document.getElementById('oe-pageFin').value = 1;
			document.getElementById('oe-bPrec').disabled = true;
			document.getElementById('oe-bSuiv').disabled = true;

			var modeTraitement = document.getElementById('oe-modeTraitement').value;

			document.getElementById('oe-bDesaffecter').disabled = true;
			document.getElementById('oe-editerPdf').disabled = true;
			document.getElementById('oe-bEditionCsv').disabled = true;
			document.getElementById('oe-editerPrevPdf').disabled = true;
			document.getElementById('oe-listePieces').collapsed = (modeTraitement!="F");
			document.getElementById('oe-grpEcheances').collapsed = (modeTraitement!="F");
			document.getElementById('oe-listeEcheances').collapsed = (modeTraitement=="F");
			document.getElementById('oe-bRegulariser').collapsed = (modeTraitement=="F");
			document.getElementById('oe-grpReglements').collapsed = (modeTraitement=="F");
			document.getElementById('oe-bModifierEcheances').collapsed = (modeTraitement=="F");

			if (modeTraitement=="F") {
				document.getElementById('oe-listePieces').disabled = true;
				document.getElementById('oe-bRegulariserFact').disabled = true;
				oe_aPieces.deleteTree();
				oe_aEcheancesFact.deleteTree();
			}
			else {
				document.getElementById('oe-listeEcheances').disabled = true;
				document.getElementById('oe-bRegulariser').disabled = true;
				document.getElementById('oe-bModifierEcheances').disabled = true;
				oe_aEcheances.deleteTree();
				oe_aReglements.deleteTree();
			}

			oe_nouveauReglement();

			if (modeTraitement=="F") {
				oe_qListPF.setParam("Num_Fournisseur", numFournisseur);
				oe_qListPF.setParam("Denomination", denomination);
				oe_qListPF.setParam("Etat", etat);
				oe_qListPF.setParam("Date_Debut", dateDebut);
				oe_qListPF.setParam("Date_Fin", dateFin);
				oe_qListPF.setParam("Date_Facture_Debut", dateFactureDebut);
				oe_qListPF.setParam("Date_Facture_Fin", dateFactureFin);
				oe_qListPF.setParam("Num_Piece", numPiece);
				oe_qListPF.setParam("Mode_Reglement", modeReglement);
				oe_qListPF.setParam("Etablissement", etablissement);
				oe_qListPF.setParam("Famille", famille);
				oe_qListPF.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
				oe_qListPF.setParam("Current_Page", oe_pageCourante);

				var result = oe_qListPF.execute();

				var contenu = result.responseXML.documentElement;

				document.getElementById('oe-totalDu').value = contenu.getAttribute("Total");
				document.getElementById('oe-totalRestantDu').value = contenu.getAttribute("Restant");

				oe_nbPages = contenu.getAttribute("Nb_Pages");
				var listFactureId = contenu.getAttribute("List_Facture_Id");
				var listAcompteId = contenu.getAttribute("List_Acompte_Id");

				oe_aPieces.setParam("List_Facture_Id", listFactureId);
				oe_aPieces.setParam("List_Acompte_Id", listAcompteId);
				oe_aPieces.initTree(oe_initPagination);
			}
			else {
				oe_qListEF.setParam("Num_Fournisseur", numFournisseur);
				oe_qListEF.setParam("Denomination", denomination);
				oe_qListEF.setParam("Etat", etat);
				oe_qListEF.setParam("Date_Debut", dateDebut);
				oe_qListEF.setParam("Date_Fin", dateFin);
				oe_qListEF.setParam("Date_Facture_Debut", dateFactureDebut);
				oe_qListEF.setParam("Date_Facture_Fin", dateFactureFin);
				oe_qListEF.setParam("Num_Piece", numPiece);
				oe_qListEF.setParam("Mode_Reglement", modeReglement);
				oe_qListEF.setParam("Etablissement", etablissement);
				oe_qListEF.setParam("Famille", famille);
				oe_qListEF.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
				oe_qListEF.setParam("Current_Page", oe_pageCourante);

				var result = oe_qListEF.execute();

				var contenu = result.responseXML.documentElement;

				document.getElementById('oe-totalDu').value = contenu.getAttribute("Total");
				document.getElementById('oe-totalRestantDu').value = contenu.getAttribute("Restant");

				oe_nbPages = contenu.getAttribute("Nb_Pages");
				var listEcheanceId = contenu.getAttribute("List_Echeance_Id");

				oe_aEcheances.setParam("List_Echeance_Id", listEcheanceId);
				oe_aEcheances.initTree(oe_initPagination);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oe_initPagination() {
	try {

		document.getElementById('oe-pageDeb').value = oe_pageCourante;
		document.getElementById('oe-pageFin').value = (oe_nbPages>0?oe_nbPages:1);
		document.getElementById('oe-bPrec').disabled = (oe_pageCourante==1);
		document.getElementById('oe-bSuiv').disabled = (oe_pageCourante>=oe_nbPages); // peut se produire si nbPages=0

		oe_afterMajPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function oe_pressOnPagePrec() {
	try {
		oe_pageCourante--;
		oe_majPagination();
	} catch (e) {
		recup_erreur(e);
	}
}


function oe_pressOnPageSuiv() {
	try {
		oe_pageCourante++;
		oe_majPagination();
	} catch (e) {
		recup_erreur(e);
	}
}


function oe_majPagination() {
	try {

		document.getElementById('oe-pageDeb').value = oe_pageCourante;
		document.getElementById('oe-bPrec').disabled = (oe_pageCourante==1);
		document.getElementById('oe-bSuiv').disabled = (oe_pageCourante==oe_nbPages);

		document.getElementById('oe-bDesaffecter').disabled = true;

		var modeTraitement = document.getElementById('oe-modeTraitement').value;
		if (modeTraitement=="F") {
			document.getElementById('oe-listePieces').disabled = true;
			document.getElementById('oe-bRegulariserFact').disabled = true;
			oe_aEcheancesFact.deleteTree();
		} else {
			document.getElementById('oe-listeEcheances').disabled = true;
			document.getElementById('oe-bRegulariser').disabled = true;
			document.getElementById('oe-bModifierEcheances').disabled = true;
			oe_aReglements.deleteTree();
		}

		oe_nouveauReglement();

		if (modeTraitement=="F") {
			oe_qListPF.setParam("Current_Page", oe_pageCourante);
			var result = oe_qListPF.execute();
			var listFactureId = result.responseXML.documentElement.getAttribute("List_Facture_Id");
			var listAcompteId = result.responseXML.documentElement.getAttribute("List_Acompte_Id");

			oe_aPieces.setParam("List_Facture_Id", listFactureId);
			oe_aPieces.setParam("List_Acompte_Id", listAcompteId);
			oe_aPieces.initTree(oe_afterMajPagination);
		}
		else {
			oe_qListEF.setParam("Current_Page", oe_pageCourante);
			var result = oe_qListEF.execute();
			var listEcheanceId = result.responseXML.documentElement.getAttribute("List_Echeance_Id");

			oe_aEcheances.setParam("List_Echeance_Id", listEcheanceId);
			oe_aEcheances.initTree(oe_afterMajPagination);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oe_afterMajPagination() {
	try {

		var modeTraitement = document.getElementById('oe-modeTraitement').value;
		if (modeTraitement=="F") {
			document.getElementById('oe-listePieces').disabled = false;
			document.getElementById('oe-editerPdf').disabled = (oe_aPieces.nbLignes()==0);
			document.getElementById('oe-bEditionCsv').disabled = (oe_aPieces.nbLignes()==0);
		}
		else {
			document.getElementById('oe-listeEcheances').disabled = false;
			document.getElementById('oe-editerPdf').disabled = (oe_aEcheances.nbLignes()==0);
			document.getElementById('oe-bEditionCsv').disabled = (oe_aEcheances.nbLignes()==0);
		}
		document.getElementById('oe-editerPrevPdf').disabled = false;

	} catch (e) {
		recup_erreur(e);
	}
}


function oe_reinitialiser() {
	try {

		document.getElementById('oe-dateDebut').value = "";
		document.getElementById('oe-dateFin').value = "";
		document.getElementById('oe-dateFactureDebut').value = "";
		document.getElementById('oe-dateFactureFin').value = "";
		document.getElementById('oe-filtreModeReglement').selectedIndex = 0;
		document.getElementById('oe-numFournisseur').value = "";
		document.getElementById('oe-rechDenomination').value = "";
		document.getElementById('oe-rechNumPiece').value = "";
		document.getElementById('oe-etat').value = "N";
		document.getElementById('oe-modeTraitement').value = "F";
		document.getElementById('oe-famille').value = "";

		oe_initListeHaut();

	} catch (e) {
		recup_erreur(e);
	}
}


function oe_rechercherFournisseur() {
	try {

		var url = "chrome://opensi/content/facturation/user/fournisseurs/popup-rechercheFournisseur.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', oe_retourRechercherFournisseur);

	} catch (e) {
		recup_erreur(e);
	}
}


function oe_retourRechercherFournisseur(codeFournisseur) {
	try {
  	document.getElementById('oe-numFournisseur').value = codeFournisseur;
  	oe_initListeHaut();
	} catch (e) {
		recup_erreur(e);
	}
}


function oe_ajouterFournisseurListe() {
	try {

		var url = "chrome://opensi/content/facturation/user/fournisseurs/popup-rechercheFournisseur.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', oe_retourAjouterFournisseurListe);

	} catch (e) {
		recup_erreur(e);
	}
}


function oe_retourAjouterFournisseurListe(numFournisseur, fournisseurId) {
	try {

		oe_chargerFournisseurs(fournisseurId, "");

	} catch (e) {
		recup_erreur(e);
	}
}


function oe_onKeyPress(event) {
	try {
		document.getElementById('oe-editerPdf').disabled = true;
		document.getElementById('oe-bEditionCsv').disabled = true;
		if (event.keyCode==13) {
			oe_initListeHaut();
		}
	} catch (e) {
		recup_erreur(e);
	}
}


function oe_editerPdf() {
	try {
		oe_typeEdition = "E";
		document.getElementById('boxDebutEcheance').collapsed = true;
		document.getElementById('chkDetailEch').checked = false;
		document.getElementById('chkDetailEch').collapsed = false;
		document.getElementById('triEcheances').value = "Date";
		document.getElementById('chkSousTotauxEch').checked = true;
		oe_rafraichirPdf();
	} catch (e) {
		recup_erreur(e);
	}
}


function oe_rafraichirPdf() {
	try {

		if (oe_typeEdition == "P") { oe_rafraichirPrevPdf(); }
		else {
			var etat = document.getElementById('oe-etat').value;
			var denomination = document.getElementById('oe-rechDenomination').value;
			var numPiece = document.getElementById('oe-rechNumPiece').value;
			var dateDebut = document.getElementById('oe-dateDebut').value;
			var dateFin = document.getElementById('oe-dateFin').value;
			var dateFactureDebut = document.getElementById('oe-dateFactureDebut').value;
			var dateFactureFin = document.getElementById('oe-dateFactureFin').value;
			var modeReglement = document.getElementById('oe-filtreModeReglement').value;
			var numFournisseur = document.getElementById('oe-numFournisseur').value;
			var modeTraitement = document.getElementById('oe-modeTraitement').value;
			var etablissement = document.getElementById('oe-etablissement').value;
			var famille = document.getElementById('oe-famille').value;

			if (!isEmpty(dateDebut) && !isDate(dateDebut)) { showWarning("Date de d\u00E9but incorrecte !"); }
			else if (!isEmpty(dateFin) && !isDate(dateFin)) { showWarning("Date de fin incorrecte !"); }
			else if (!isEmpty(dateDebut) && !isEmpty(dateFin) && !isDateInterval(dateDebut, dateFin)) { showWarning("La date de fin doit \u00EAtre sup\u00E9rieure \u00E0 la date de d\u00E9but !"); }
			else if (!isEmpty(dateFactureDebut) && !isDate(dateFactureDebut)) { showWarning("Date de facture de d\u00E9but incorrecte"); }
			else if (!isEmpty(dateFactureFin) && !isDate(dateFactureFin)) { showWarning("Date de facture de fin incorrecte"); }
			else if (!isEmpty(dateFactureDebut) && !isEmpty(dateFactureFin) && !isDateInterval(dateFactureDebut, dateFactureFin)) { showWarning("La date de facture de fin doit \u00EAtre sup\u00E9rieure \u00E0 la date de d\u00E9but"); }
			else {
				var detail = document.getElementById('chkDetailEch').checked;
				var triEcheances = document.getElementById('triEcheances').value;
				var sousTotaux = document.getElementById('chkSousTotauxEch').checked;

				var qGenPdf = new QueryHttp("Facturation/Suivi_Reglements_Fournisseurs/pdfListePieces.tmpl");
				qGenPdf.setParam("Type", modeTraitement);
	      qGenPdf.setParam("Etat", etat);
	      qGenPdf.setParam("Denomination", denomination);
	      qGenPdf.setParam("Num_Piece", numPiece);
	      qGenPdf.setParam("Date_Debut", dateDebut);
	      qGenPdf.setParam("Date_Fin", dateFin);
      	qGenPdf.setParam("Date_Facture_Debut", dateFactureDebut);
      	qGenPdf.setParam("Date_Facture_Fin", dateFactureFin);
	      qGenPdf.setParam("Mode_Reglement", modeReglement);
	      qGenPdf.setParam("Num_Fournisseur", numFournisseur);
				qGenPdf.setParam("Etablissement", etablissement);
	      qGenPdf.setParam("Famille", famille);
	      qGenPdf.setParam("Detail", detail);
	      qGenPdf.setParam("Tri", triEcheances);
	      qGenPdf.setParam("Sous_Totaux", sousTotaux);
	      var result = qGenPdf.execute();
	      var page = getDirPdf() + result.responseXML.documentElement.getAttribute('fichier');
				switchPdf(page);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oe_selectOnListePieces() {
	try {
		if (oe_aPieces.isSelected()) {
			document.getElementById('oe-listeEcheancesFact').disabled = true;
			var i = oe_aPieces.getCurrentIndex();
			var pieceId = oe_aPieces.getCellText(i, 'oe-colPieceId');
			var typePiece = oe_aPieces.getCellText(i, 'oe-colTypePiece');
			oe_aEcheancesFact.setParam("Piece_Id", pieceId);
			oe_aEcheancesFact.setParam("Type_Piece", typePiece);
			oe_aEcheancesFact.initTree(oe_selectPremiereEcheance);
		}
	} catch (e) {
		recup_erreur(e);
	}
}


function oe_selectPremiereEcheance() {
	try {
		document.getElementById('oe-listeEcheancesFact').disabled = false;
		if (oe_aEcheancesFact.nbLignes()>0) {
			oe_aEcheancesFact.select(0);
			oe_selectOnListeEcheancesFact();
		}
	} catch (e) {
		recup_erreur(e);
	}
}


function oe_selectOnListeEcheancesFact() {
	try {
		if (oe_aEcheancesFact.isSelected()) {
			var i = oe_aEcheancesFact.getCurrentIndex();
			oe_currentEcheanceId = oe_aEcheancesFact.getCellText(i, 'oe-colEcheanceIdFact');

			var fournisseurId = oe_aEcheancesFact.getCellText(i, 'oe-colFournisseurIdFact');
			var denomination = "";
			if (fournisseurId=="") { denomination = oe_aEcheancesFact.getCellText(i, 'oe-colDenominationFact'); }

			oe_chargerFournisseurs(fournisseurId, denomination);
			oe_chargerModesReglements(oe_aEcheancesFact.getCellText(i, 'oe-colModeRegIdFact'));
			oe_chargerBanques(oe_aEcheancesFact.getCellText(i, 'oe-colBanqueRetraitFact'));

			document.getElementById('oe-dateReglement').value =  getDateCourante();
			document.getElementById('oe-numPiece').value = "";
			document.getElementById('oe-montant').value = oe_aEcheancesFact.getCellText(i, 'oe-colMontantFact');
			document.getElementById('oe-commentaires').value = oe_aEcheancesFact.getCellText(i, 'oe-colCommentairesFact');
			document.getElementById('oe-bRegulariserFact').disabled = (oe_aEcheancesFact.getCellText(i, 'oe-colEtatFact')=="T");
		}
	} catch (e) {
		recup_erreur(e);
	}
}


function oe_selectFournisseur() {
	try {

		if (isEmpty(oe_chargerFournisseur) && isEmpty(oe_chargerDenominationFournisseur)) {
			document.getElementById('oe-fournisseurId').value = "0";
		}
		else {
			var selected = false;
			var i=0;
			var menulist = document.getElementById('oe-fournisseurId');
			var items = menulist.getElementsByTagName("menuitem");
			while (!selected && i<items.length) {
				if (items[i].getAttribute(oe_chargerFournisseur!=""?"value":"label").toUpperCase()==(oe_chargerFournisseur!=""?oe_chargerFournisseur:oe_chargerDenominationFournisseur).toUpperCase()) {
					menulist.selectedIndex = i;
					selected = true;
				}
				i++;
			}
		}

		oe_chargerBanquesFournisseur();

	} catch (e) {
		recup_erreur(e);
	}
}


function oe_selectOnListeEcheances() {
	try {

		if (oe_aEcheances.isSelected()) {

			if (oe_aEcheances.nbSelection()==1) {
				var i = oe_aEcheances.getCurrentIndex();
				oe_currentEcheanceId = oe_aEcheances.getCellText(i, 'oe-colEcheanceId');

				var fournisseurId = oe_aEcheances.getCellText(i, 'oe-colFournisseurId');
				var denomination = "";
				if (fournisseurId=="") { denomination = oe_aEcheances.getCellText(i, 'oe-colDenomination'); }

				oe_chargerFournisseurs(fournisseurId, denomination);
				oe_chargerModesReglements(oe_aEcheances.getCellText(i, 'oe-colModeRegId'));
				oe_chargerBanques(oe_aEcheances.getCellText(i, 'oe-colBanqueRetrait'));

				document.getElementById('oe-dateReglement').value = oe_aEcheances.getCellText(i, 'oe-colDateEcheance');
				document.getElementById('oe-numPiece').value = "";
				document.getElementById('oe-montant').value = oe_aEcheances.getCellText(i, 'oe-colMontant');
				document.getElementById('oe-commentaires').value = oe_aEcheances.getCellText(i, 'oe-colCommentaires');
				document.getElementById('oe-bRegulariser').disabled = (oe_aEcheances.getCellText(i, 'oe-colEtat')=="T");
				document.getElementById('oe-bModifierEcheances').disabled = true;

				oe_aReglements.setParam("Echeance_Id", oe_currentEcheanceId);
				oe_aReglements.initTree();
			}
			else {
				document.getElementById('oe-bRegulariser').disabled = true;
				oe_nouveauReglement();
				document.getElementById('oe-bModifierEcheances').disabled = false;
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oe_selectOnListeReglements() {
	try {
		document.getElementById('oe-bDesaffecter').disabled = !oe_aReglements.isSelected();
	} catch (e) {
		recup_erreur(e);
	}
}


function oe_pressOnDesaffecter() {
	try {

		if (oe_aReglements.isSelected() && window.confirm("Voulez-vous d\u00E9saffecter les imputations s\u00E9lectionn\u00E9es ?")) {

			var qImpAvoir = new QueryHttp("Facturation/Suivi_Reglements_Fournisseurs/deleteImputationEcheanceAvoirFournisseur.tmpl");
			var qImpReg = new QueryHttp("Facturation/Suivi_Reglements_Fournisseurs/deleteImputationEcheanceReglementFournisseur.tmpl");
			var qRegul = new QueryHttp("Facturation/Suivi_Reglements_Fournisseurs/cancelRegularisationEcheanceFournisseur.tmpl");

			for (var i=0; i<oe_aReglements.getRangeCount(); i++) {
				var start = {};
				var end = {};
				oe_aReglements.getRangeAt(i,start,end);

				for (var c=start.value; c<=end.value; c++) {
					var result;

					if (oe_aReglements.getCellText(c, 'oe-colTypeImputation')=="A") {
						qImpAvoir.setParam("Imputation_Id", oe_aReglements.getCellText(c, 'oe-colImputationId'));
						result = qImpAvoir.execute();
					}
					else if (oe_aReglements.getCellText(c, 'oe-colTypeImputation')=="R") {
						qImpReg.setParam("Imputation_Id", oe_aReglements.getCellText(c, 'oe-colImputationId'));
						result = qImpReg.execute();
					}
					else {
						qRegul.setParam("Imputation_Id", oe_aReglements.getCellText(c, 'oe-colImputationId'));
						result = qRegul.execute();
					}

					var errors = new Errors(result);
					if (errors.hasNext()) {
						errors.show();
					}
				}
			}

			oe_initListeHaut();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oe_pressOnRegulariser() {
	try {

		if (oe_currentEcheanceId!="" && window.confirm("Voulez-vous solder cette \u00E9ch\u00E9ance en perte et profit ?")) {

			var qRegulariser = new QueryHttp("Facturation/Suivi_Reglements_Fournisseurs/settleEcheanceFournisseur.tmpl");
			qRegulariser.setParam("Echeance_Id", oe_currentEcheanceId);
			var result = qRegulariser.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}

			oe_initListeHaut();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oe_pressOnSolderRestantDu() {
	try {

		var url = "chrome://opensi/content/facturation/user/suivi_reglements_fournisseurs/popup-solderEcheances.xul?"+ cookie();
		window.openDialog(url,'','chrome,modal,centerscreen',oe_initListeHaut);

	} catch (e) {
		recup_erreur(e);
	}
}


function oe_enregistrerReglement() {
	try {

		var dateReglement = document.getElementById('oe-dateReglement').value;
		var banqueRetrait = document.getElementById('oe-banqueRetrait').value;
		var fournisseurId = document.getElementById('oe-fournisseurId').value;
		var denomination = (isEmpty(fournisseurId)?document.getElementById('oe-fournisseurId').getAttribute("label"):"");
		var banqueFournisseur = document.getElementById('oe-banqueFournisseur').value;
		var modeReglement = document.getElementById('oe-modeReglement').value;
		var numPiece = document.getElementById('oe-numPiece').value;
		var montant = document.getElementById('oe-montant').value;
		var commentaires = document.getElementById('oe-commentaires').value;

		if (isEmpty(dateReglement) || !isDate(dateReglement)) { showWarning("Date incorrecte !"); }
		else if (fournisseurId=="0") { showWarning("Veuillez choisir un fournisseur !"); }
		else if (modeReglement=="") { showWarning("Veuillez choisir un mode de r\u00E8glement !"); }
		else if (banqueFournisseur.length>30) { showWarning("La banque fournisseur ne doit pas d\u00E9passer 30 caract\u00E8res !"); }
		else if (isEmpty(montant) || !isPositive(montant)) { showWarning("Montant incorrect !"); }
		else if (commentaires.length>100) { showWarning("Le commentaire ne doit pas d\u00E9passer 100 caract\u00E8res !"); }
		else if (isEmpty(banqueRetrait)) { showWarning("Veuillez choisir une banque de retrait"); }
		else {

			var qEnregistrer = new QueryHttp("Facturation/Suivi_Reglements_Fournisseurs/createReglementFournisseur.tmpl");
			qEnregistrer.setParam("Date_Reglement", dateReglement);
			qEnregistrer.setParam("Banque_Retrait", banqueRetrait);
			qEnregistrer.setParam("Fournisseur_Id", fournisseurId);
			qEnregistrer.setParam("Denomination", denomination);
			qEnregistrer.setParam("Banque_Fournisseur", banqueFournisseur);
			qEnregistrer.setParam("Mode_Reglement", modeReglement);
			qEnregistrer.setParam("Num_Piece", numPiece);
			qEnregistrer.setParam("Montant", montant);
			qEnregistrer.setParam("Commentaires", commentaires);
			var result = qEnregistrer.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var reglementId = result.responseXML.documentElement.getAttribute("Reglement_Id");

				var url = "chrome://opensi/content/facturation/user/suivi_reglements_fournisseurs/popup-imputationReglement.xul?"+ cookie();
				window.openDialog(url,'','chrome,modal,centerscreen','R',reglementId,'', true);
			}

			oe_initListeHaut();
			orbt_nouveauRemboursement();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oe_editerPrevPdf() {
	try {
		oe_typeEdition = "P";
		document.getElementById('chkDetailEch').collapsed = true;
		document.getElementById('triEcheances').value = "Date";
		document.getElementById('chkSousTotauxEch').checked = true;
		document.getElementById('dateDebEcheance').value = getDateCourante();
		document.getElementById('boxDebutEcheance').collapsed = false;
		oe_rafraichirPrevPdf();
	} catch (e) {
		recup_erreur(e);
	}
}


function oe_rafraichirPrevPdf() {
	try {

		var triEcheances = document.getElementById('triEcheances').value;
		var sousTotaux = document.getElementById('chkSousTotauxEch').checked;
		var dateDebEcheance = document.getElementById('dateDebEcheance').value;

		if (isEmpty(dateDebEcheance) || !isDate(dateDebEcheance)) { showWarning("Veuillez saisir une date d'\u00E9ch\u00E9ance valide !"); }
		else {
			var qGenPdf = new QueryHttp("Facturation/Suivi_Reglements_Fournisseurs/pdfEcheancierPrevisionnel.tmpl");
	    qGenPdf.setParam("Tri", triEcheances);
	    qGenPdf.setParam("Sous_Totaux", sousTotaux);
	    qGenPdf.setParam("Echeance_Debut", dateDebEcheance);
	    var result = qGenPdf.execute();
	    var errors = new Errors(result);
			if (errors.hasNext()) {
				switchPdfWidthError(errors);
			} else {
				var page = getDirPdf() + result.responseXML.documentElement.getAttribute('fichier');
				switchPdf(page);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oe_pressOnDateDebEcheance(event) {
	try {
		if (event.keyCode==13) {
			oe_rafraichirPrevPdf();
		}
	} catch (e) {
		recup_erreur(e);
	}
}


function oe_pressOnListeEcheances() {
	try {

		oe_modifierEcheance();

	} catch (e) {
		recup_erreur(e);
	}
}


function oe_pressOnListeEcheancesFact() {
	try {

		if (!isEmpty(oe_currentEcheanceId)) {
			var listEcheanceId = new Array();
			listEcheanceId.push(oe_currentEcheanceId);
			var url = "chrome://opensi/content/facturation/user/suivi_reglements_fournisseurs/popup-modifierEcheance.xul";
			window.openDialog(url,'','chrome,modal,centerscreen', listEcheanceId, oe_selectOnListePieces);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oe_modifierEcheance() {
	try {

		if (oe_aEcheances.isSelected()) {

			var listEcheanceId = new Array();

			if (!isEmpty(oe_currentEcheanceId)) {
				listEcheanceId.push(oe_currentEcheanceId);
			}
			else {
				var start = new Object();
				var end = new Object();
				var numRanges = oe_aEcheances.getRangeCount();

				for (var t=0; t<numRanges; t++){
					oe_aEcheances.getRangeAt(t,start,end);
			  	for (var v=start.value; v<=end.value; v++){
		  			listEcheanceId.push(oe_aEcheances.getCellText(v,'oe-colEcheanceId'));
			  	}
				}
			}

			if (listEcheanceId.length>0) {
				var url = "chrome://opensi/content/facturation/user/suivi_reglements_fournisseurs/popup-modifierEcheance.xul";
				window.openDialog(url,'','chrome,modal,centerscreen', listEcheanceId, oe_initListeHaut);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oe_pressOnEditionCsv() {
	try {

		var etat = document.getElementById('oe-etat').value;
		var denomination = document.getElementById('oe-rechDenomination').value;
		var numPiece = document.getElementById('oe-rechNumPiece').value;
		var dateDebut = document.getElementById('oe-dateDebut').value;
		var dateFin = document.getElementById('oe-dateFin').value;
		var dateFactureDebut = document.getElementById('oe-dateFactureDebut').value;
		var dateFactureFin = document.getElementById('oe-dateFactureFin').value;
		var modeReglement = document.getElementById('oe-filtreModeReglement').value;
		var numFournisseur = document.getElementById('oe-numFournisseur').value;
		var etablissement = document.getElementById('oe-etablissement').value;
		var famille = document.getElementById('oe-famille').value;

		if (!isEmpty(dateDebut) && !isDate(dateDebut)) { showWarning("Date de d\u00E9but incorrecte !"); }
		else if (!isEmpty(dateFin) && !isDate(dateFin)) { showWarning("Date de fin incorrecte !"); }
		else if (!isEmpty(dateDebut) && !isEmpty(dateFin) && !isDateInterval(dateDebut, dateFin)) { showWarning("La date de fin doit \u00EAtre sup\u00E9rieure \u00E0 la date de d\u00E9but !"); }
		else if (!isEmpty(dateFactureDebut) && !isDate(dateFactureDebut)) { showWarning("Date de facture de d\u00E9but incorrecte"); }
		else if (!isEmpty(dateFactureFin) && !isDate(dateFactureFin)) { showWarning("Date de facture de fin incorrecte"); }
		else if (!isEmpty(dateFactureDebut) && !isEmpty(dateFactureFin) && !isDateInterval(dateFactureDebut, dateFactureFin)) { showWarning("La date de facture de fin doit \u00EAtre sup\u00E9rieure \u00E0 la date de d\u00E9but"); }
		else {

			var modeTraitement = document.getElementById('oe-modeTraitement').value;

			var qEditionCsv = new QueryHttp("Facturation/Suivi_Reglements_Fournisseurs/"+ (modeTraitement=="F"?"csvPieceFournisseur.tmpl":"csvEcheanceFournisseur.tmpl"));

			qEditionCsv.setParam("Num_Fournisseur", numFournisseur);
			qEditionCsv.setParam("Denomination", denomination);
			qEditionCsv.setParam("Etat", etat);
			qEditionCsv.setParam("Date_Debut", dateDebut);
			qEditionCsv.setParam("Date_Fin", dateFin);
			qEditionCsv.setParam("Date_Facture_Debut", dateFactureDebut);
			qEditionCsv.setParam("Date_Facture_Fin", dateFactureFin);
			qEditionCsv.setParam("Num_Piece", numPiece);
			qEditionCsv.setParam("Mode_Reglement", modeReglement);
			qEditionCsv.setParam("Etablissement", etablissement);
			qEditionCsv.setParam("Famille", famille);

			var result = qEditionCsv.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');

				var file = fileChooser("save", fichier);
				if (file!=null) {
					downloadFile(getDirBuffer()+ fichier, file);
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}
